/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.openide.util.lookup.AbstractLookup;

public final class InstanceContent
extends AbstractLookup.Content {
    public InstanceContent() {
    }

    public InstanceContent(Executor notifyIn) {
        super(notifyIn);
    }

    public final void add(Object inst) {
        this.addPair(new SimpleItem<Object>(inst));
    }

    public final <T, R> void add(T inst, Convertor<T, R> conv) {
        this.addPair(new ConvertingItem<T, R>(inst, conv));
    }

    public final void remove(Object inst) {
        this.removePair(new SimpleItem<Object>(inst));
    }

    public final <T, R> void remove(T inst, Convertor<T, R> conv) {
        this.removePair(new ConvertingItem<T, R>(inst, conv));
    }

    public final <T, R> void set(Collection<T> col, Convertor<T, R> conv) {
        ArrayList<AbstractLookup.Pair> l = new ArrayList<AbstractLookup.Pair>(col.size());
        Iterator<T> it = col.iterator();
        if (conv == null) {
            while (it.hasNext()) {
                l.add(new SimpleItem<T>(it.next()));
            }
        } else {
            while (it.hasNext()) {
                l.add(new ConvertingItem<T, R>(it.next(), conv));
            }
        }
        this.setPairs(l);
    }

    static final class ConvertingItem<T, R>
    extends AbstractLookup.Pair<R> {
        private T obj;
        private WeakReference<R> ref;
        private Convertor<? super T, R> conv;

        public ConvertingItem(T obj, Convertor<? super T, R> conv) {
            this.obj = obj;
            this.conv = conv;
        }

        @Override
        public boolean instanceOf(Class<?> c) {
            return c.isAssignableFrom(this.getType());
        }

        private R getConverted() {
            if (this.ref == null) {
                return null;
            }
            return (R)this.ref.get();
        }

        @Override
        public synchronized R getInstance() {
            R converted = this.getConverted();
            if (converted == null) {
                converted = this.conv.convert(this.obj);
                this.ref = new WeakReference<R>(converted);
            }
            return converted;
        }

        public boolean equals(Object o) {
            if (o instanceof ConvertingItem) {
                return this.obj.equals(((ConvertingItem)o).obj);
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        @Override
        public String getId() {
            return this.conv.id(this.obj);
        }

        @Override
        public String getDisplayName() {
            return this.conv.displayName(this.obj);
        }

        @Override
        protected boolean creatorOf(Object obj) {
            if (this.conv == null) {
                return obj == this.obj;
            }
            return obj == this.getConverted();
        }

        @Override
        public Class<? extends R> getType() {
            R converted = this.getConverted();
            if (converted == null) {
                return this.conv.type(this.obj);
            }
            return converted.getClass();
        }
    }

    public static interface Convertor<T, R> {
        public R convert(T var1);

        public Class<? extends R> type(T var1);

        public String id(T var1);

        public String displayName(T var1);
    }

    static final class SimpleItem<T>
    extends AbstractLookup.Pair<T> {
        private T obj;

        public SimpleItem(T obj) {
            if (obj == null) {
                throw new NullPointerException();
            }
            this.obj = obj;
        }

        @Override
        public boolean instanceOf(Class<?> c) {
            return c.isInstance(this.obj);
        }

        @Override
        public T getInstance() {
            return this.obj;
        }

        public boolean equals(Object o) {
            if (o instanceof SimpleItem) {
                return this.obj.equals(((SimpleItem)o).obj);
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        @Override
        public String getId() {
            return "IL[" + this.obj.toString();
        }

        @Override
        public String getDisplayName() {
            return this.obj.toString();
        }

        @Override
        protected boolean creatorOf(Object obj) {
            return obj == null ? null == this.obj : obj.equals(this.obj);
        }

        @Override
        public Class<? extends T> getType() {
            return this.obj.getClass();
        }
    }
}

