/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.model.node;

import org.gephi.graph.api.ElementProperties;
import org.gephi.graph.api.Node;
import org.gephi.lib.gleem.linalg.Vecf;
import org.gephi.visualization.model.Model;
import org.gephi.visualization.model.TextModel;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.octree.Octant;

public abstract class NodeModel
implements Model,
TextModel {
    protected final Node node;
    protected float cameraDistance;
    protected float[] dragDistance;
    protected Octant octant;
    protected int octantId;
    protected boolean selected;
    protected boolean highlight;
    public int markTime;
    public boolean mark;
    protected EdgeModel[] edges;
    protected int edgeLength;
    protected static final long ONEOVERPHI = 106039L;

    public NodeModel(Node node) {
        this.node = node;
        this.dragDistance = new float[2];
        this.selected = false;
        this.mark = false;
        this.markTime = 0;
        this.edges = new EdgeModel[0];
    }

    public int octreePosition(float centerX, float centerY, float centerZ, float size) {
        int index = 0;
        if (this.node.y() < centerY) {
            index += 4;
        }
        if (this.node.z() > centerZ) {
            index += 2;
        }
        if (this.node.x() < centerX) {
            ++index;
        }
        return index;
    }

    public boolean isInOctreeLeaf(Octant leaf) {
        return !(Math.abs(this.node.x() - leaf.getPosX()) > leaf.getSize() / 2.0f) && !(Math.abs(this.node.y() - leaf.getPosY()) > leaf.getSize() / 2.0f) && !(Math.abs(this.node.z() - leaf.getPosZ()) > leaf.getSize() / 2.0f);
    }

    public abstract boolean selectionTest(Vecf var1, float var2);

    public abstract float getCollisionDistance(double var1);

    public Node getNode() {
        return this.node;
    }

    public void setCameraDistance(float cameraDistance) {
        this.cameraDistance = cameraDistance;
    }

    public float getCameraDistance() {
        return this.cameraDistance;
    }

    public float getX() {
        return this.node.x();
    }

    public float getY() {
        return this.node.y();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public Octant getOctant() {
        return this.octant;
    }

    public void setOctant(Octant octant) {
        this.octant = octant;
    }

    public void setOctantId(int octantId) {
        this.octantId = octantId;
    }

    public int getOctantId() {
        return this.octantId;
    }

    @Override
    public boolean hasCustomTextColor() {
        return this.node.getTextProperties().getAlpha() > 0.0f;
    }

    @Override
    public void setText(String text) {
        this.node.getTextProperties().setText(text);
    }

    @Override
    public float getTextWidth() {
        return this.node.getTextProperties().getWidth();
    }

    @Override
    public float getTextHeight() {
        return this.node.getTextProperties().getWidth();
    }

    @Override
    public String getText() {
        return this.node.getTextProperties().getText();
    }

    @Override
    public float getTextSize() {
        return this.node.getTextProperties().getSize();
    }

    @Override
    public float getTextR() {
        return this.node.getTextProperties().getR();
    }

    @Override
    public float getTextG() {
        return this.node.getTextProperties().getG();
    }

    @Override
    public float getTextB() {
        return this.node.getTextProperties().getB();
    }

    @Override
    public float getTextAlpha() {
        return this.node.getTextProperties().getAlpha();
    }

    @Override
    public boolean isTextVisible() {
        return this.node.getTextProperties().isVisible();
    }

    @Override
    public ElementProperties getElementProperties() {
        return this.node;
    }

    public float[] getDragDistanceFromMouse() {
        return this.dragDistance;
    }

    public void addEdge(EdgeModel model) {
        int id = this.edgeLength++;
        this.growEdges(id);
        this.edges[id] = model;
        if (model.getSourceModel() == this) {
            model.setOctantSourceId(id);
        } else {
            model.setOctantTargetId(id);
        }
    }

    public void removeEdge(EdgeModel model) {
        int id = model.getSourceModel() == this ? model.getOctantSourceId() : model.getOctantTargetId();
        this.edges[id] = null;
    }

    public EdgeModel[] getEdges() {
        return this.edges;
    }

    private void growEdges(int index) {
        if (index >= this.edges.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)this.edges.length >>> 16, (long)(index + 1)), Integer.MAX_VALUE);
            EdgeModel[] t = new EdgeModel[newLength];
            System.arraycopy(this.edges, 0, t, 0, this.edges.length);
            this.edges = t;
        }
    }
}

