/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.diagnostic.Logger;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathMacroMap {
    private static final Logger LOG = Logger.getInstance(PathMacroMap.class);

    public abstract String substitute(String var1, boolean var2);

    public final String substitute(String text, boolean caseSensitive, boolean recursively) {
        return recursively ? this.substituteRecursively(text, caseSensitive) : this.substitute(text, caseSensitive);
    }

    public final void substitute(@NotNull Element e, boolean caseSensitive) {
        if (e == null) {
            PathMacroMap.$$$reportNull$$$0(0);
        }
        this.substitute(e, caseSensitive, false);
    }

    public final void substitute(@NotNull Element element, boolean caseSensitive, boolean recursively, @Nullable PathMacroFilter filter) {
        if (element == null) {
            PathMacroMap.$$$reportNull$$$0(1);
        }
        if (filter != null && filter.skipPathMacros(element)) {
            return;
        }
        for (Content child : element.getContent()) {
            if (child instanceof Element) {
                this.substitute((Element)child, caseSensitive, recursively, filter);
                continue;
            }
            if (child instanceof Text) {
                String newText;
                Text t = (Text)child;
                String oldText = t.getText();
                if (oldText == (newText = recursively ? this.substituteRecursively(oldText, caseSensitive) : this.substitute(oldText, caseSensitive))) continue;
                t.setText(newText);
                continue;
            }
            if (child instanceof Comment) continue;
            LOG.error("Wrong content: " + child.getClass());
        }
        if (!element.hasAttributes()) {
            return;
        }
        for (Attribute attribute : element.getAttributes()) {
            if (filter != null && filter.skipPathMacros(attribute)) continue;
            String newValue = this.getAttributeValue(attribute, filter, caseSensitive, recursively);
            if (attribute.getValue() == newValue) continue;
            attribute.setValue(newValue);
        }
    }

    public String getAttributeValue(@NotNull Attribute attribute, @Nullable PathMacroFilter filter, boolean caseSensitive, boolean recursively) {
        if (attribute == null) {
            PathMacroMap.$$$reportNull$$$0(2);
        }
        String oldValue = attribute.getValue();
        if (recursively || filter != null && filter.recursePathMacros(attribute)) {
            return this.substituteRecursively(oldValue, caseSensitive);
        }
        return this.substitute(oldValue, caseSensitive);
    }

    public final void substitute(@NotNull Element e, boolean caseSensitive, boolean recursively) {
        if (e == null) {
            PathMacroMap.$$$reportNull$$$0(3);
        }
        this.substitute(e, caseSensitive, recursively, null);
    }

    @NotNull
    public String substituteRecursively(@NotNull String text, boolean caseSensitive) {
        if (text == null) {
            PathMacroMap.$$$reportNull$$$0(4);
        }
        String string = this.substitute(text, caseSensitive);
        if (string == null) {
            PathMacroMap.$$$reportNull$$$0(5);
        }
        return string;
    }

    public abstract int hashCode();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/PathMacroMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/PathMacroMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteRecursively";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteRecursively";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

