/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListCompletionContributor;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.NewEditChangelistPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListChooserPanel
extends JPanel {
    private final MyEditorComboBox myExistingListsCombo;
    private final NewEditChangelistPanel myListPanel;
    private final NullableConsumer<? super String> myOkEnabledListener;
    private final Project myProject;
    private String myLastTypedDescription;
    private boolean myNewNameSuggested;
    @Nullable
    private ChangeListData myData;

    public ChangeListChooserPanel(Project project, @NotNull NullableConsumer<? super String> okEnabledListener) {
        if (okEnabledListener == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myNewNameSuggested = false;
        this.myProject = project;
        this.myExistingListsCombo = new MyEditorComboBox();
        this.myExistingListsCombo.setEditable(true);
        this.myExistingListsCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<ChangeList>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ChangeList> list, ChangeList value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value != null) {
                    this.append(value.getName(), value instanceof LocalChangeList && ((LocalChangeList)value).isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$1", "customizeCellRenderer"));
            }
        });
        this.myListPanel = new NewEditChangelistPanel(this.myProject){

            @Override
            protected NewEditChangelistPanel.ComponentWithTextFieldWrapper createComponentWithTextField(Project project) {
                return new NewEditChangelistPanel.ComponentWithTextFieldWrapper((Component)((Object)ChangeListChooserPanel.this.myExistingListsCombo)){

                    @Override
                    @NotNull
                    public EditorTextField getEditorTextField() {
                        EditorTextField editorTextField = ChangeListChooserPanel.this.myExistingListsCombo.getEditorTextField();
                        if (editorTextField == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return editorTextField;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$2$1", "getEditorTextField"));
                    }
                };
            }

            @Override
            protected void nameChanged(String errorMessage) {
                ApplicationManager.getApplication().invokeLater(() -> ChangeListChooserPanel.this.updateDescription(), ModalityState.current());
                ChangeListChooserPanel.this.myOkEnabledListener.consume((Object)errorMessage);
            }

            @Override
            public void init(LocalChangeList initial) {
                super.init(initial);
                this.myDescriptionTextArea.addFocusListener((FocusListener)new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        super.focusLost(e);
                        if (ChangeListChooserPanel.this.getExistingChangelistByName(ChangeListChooserPanel.this.myListPanel.getChangeListName()) == null) {
                            ChangeListChooserPanel.this.myLastTypedDescription = ChangeListChooserPanel.this.myListPanel.getDescription();
                        }
                    }
                });
            }

            @Override
            protected void nameChangedImpl(Project project, LocalChangeList initial) {
                this.nameChanged(StringUtil.isEmptyOrSpaces((String)this.getChangeListName()) ? "Cannot create new changelist with empty name." : null);
            }
        };
        this.myOkEnabledListener = okEnabledListener;
        this.add((Component)this.myListPanel, "Center");
    }

    public void init() {
        this.myListPanel.init(null);
    }

    public void setChangeLists(Collection<? extends ChangeList> changeLists) {
        this.myExistingListsCombo.setModel(new DefaultComboBoxModel<ChangeList>(changeLists.toArray(new ChangeList[0])));
    }

    public void setSuggestedName(@NotNull String name) {
        if (name == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(1);
        }
        this.setSuggestedName(name, null);
    }

    public void setSuggestedName(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        LocalChangeList changelistByName = this.getExistingChangelistByName(name);
        if (changelistByName != null) {
            this.myExistingListsCombo.setSelectedItem(changelistByName);
        } else {
            this.myNewNameSuggested = true;
            this.myExistingListsCombo.insertItemAt(LocalChangeList.createEmptyChangeList((Project)this.myProject, (String)name), 0);
            if (StringUtil.isEmptyOrSpaces((String)this.myLastTypedDescription)) {
                this.myLastTypedDescription = comment;
            }
            if (VcsConfiguration.getInstance((Project)this.myProject).PRESELECT_EXISTING_CHANGELIST) {
                this.selectActiveChangeListIfExist();
            } else {
                this.myListPanel.setChangeListName(name);
            }
        }
        this.updateDescription();
    }

    private void selectActiveChangeListIfExist() {
        this.myExistingListsCombo.setSelectedItem(ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList());
    }

    public void setData(@Nullable ChangeListData data) {
        this.myData = data;
    }

    public void updateEnabled() {
        if (this.myProject != null) {
            this.myListPanel.nameChangedImpl(this.myProject, null);
        }
    }

    @Nullable
    public LocalChangeList getSelectedList(Project project) {
        String changeListName;
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        LocalChangeList localChangeList = manager.findChangeList(changeListName = this.myListPanel.getChangeListName());
        if (localChangeList == null) {
            localChangeList = ((ChangeListManagerEx)manager).addChangeList(changeListName, this.myListPanel.getDescription(), this.myData);
            this.myListPanel.changelistCreatedOrChanged(localChangeList);
        } else {
            manager.editComment(changeListName, this.myListPanel.getDescription());
        }
        this.rememberSettings(project, localChangeList.isDefault(), this.myListPanel.getMakeActiveCheckBox().isSelected());
        if (this.myListPanel.getMakeActiveCheckBox().isSelected()) {
            manager.setDefaultChangeList(localChangeList);
        }
        return localChangeList;
    }

    private void rememberSettings(@NotNull Project project, boolean activeListSelected, boolean setActive) {
        if (project == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(3);
        }
        if (this.myNewNameSuggested) {
            VcsConfiguration.getInstance((Project)project).PRESELECT_EXISTING_CHANGELIST = activeListSelected;
        }
        VcsConfiguration.getInstance((Project)project).MAKE_NEW_CHANGELIST_ACTIVE = setActive;
    }

    public void setDefaultSelection(ChangeList defaultSelection) {
        if (defaultSelection == null) {
            this.selectActiveChangeListIfExist();
        } else {
            this.myExistingListsCombo.setSelectedItem(defaultSelection);
        }
        this.updateDescription();
        this.updateEnabled();
    }

    private void updateDescription() {
        String newText;
        LocalChangeList list = this.getExistingChangelistByName(this.myListPanel.getChangeListName());
        String string = newText = list != null ? list.getComment() : this.myLastTypedDescription;
        if (!StringUtil.equals((CharSequence)this.myListPanel.getDescription(), (CharSequence)newText)) {
            this.myListPanel.setDescription(newText);
        }
    }

    private LocalChangeList getExistingChangelistByName(@NotNull String changeListName) {
        if (changeListName == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(4);
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
        return manager.findChangeList(changeListName);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExistingListsCombo.getEditorTextField();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okEnabledListener";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuggestedName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "rememberSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getExistingChangelistByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyEditorComboBox
    extends ComboBox<ChangeList> {
        private static final int PREF_WIDTH = 200;
        private final LanguageTextField myEditorTextField;

        MyEditorComboBox() {
            super(200);
            JBColor fg = new JBColor(46397, 7054941);
            JBColor bg = new JBColor(15465713, 3226418);
            TextIcon icon = new TextIcon("New", (Color)fg, (Color)bg, JBUIScale.scale((int)2));
            icon.setFont(RelativeFont.TINY.derive(this.getFont()));
            icon.setRound(JBUIScale.scale((int)4));
            JLabel label = new JLabel((Icon)icon);
            final JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(true);
            panel2.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)1, (int)4));
            panel2.add((Component)label, "Center");
            this.myEditorTextField = new LanguageTextField((Language)PlainTextLanguage.INSTANCE, ChangeListChooserPanel.this.myProject, "");
            this.myEditorTextField.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    String changeListName;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    panel2.setVisible(!StringUtil.isEmptyOrSpaces((String)(changeListName = e.getDocument().getText())) && ChangeListChooserPanel.this.getExistingChangelistByName(changeListName) == null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$MyEditorComboBox$1", "documentChanged"));
                }
            });
            ((Document)ObjectUtils.assertNotNull((Object)this.myEditorTextField.getDocument())).putUserData(ChangeListCompletionContributor.COMBO_BOX_KEY, (Object)this);
            ComboBoxCompositeEditor compositeEditor = new ComboBoxCompositeEditor((JComponent)this.myEditorTextField, new JComponent[]{panel2});
            this.myEditorTextField.addSettingsProvider(editor -> {
                Color editorBackgroundColor = editor.getBackgroundColor();
                panel2.setBackground(editorBackgroundColor);
                compositeEditor.setBackground(editorBackgroundColor);
            });
            this.setEditor((ComboBoxEditor)compositeEditor);
        }

        @NotNull
        private EditorTextField getEditorTextField() {
            LanguageTextField languageTextField = this.myEditorTextField;
            if (languageTextField == null) {
                MyEditorComboBox.$$$reportNull$$$0(0);
            }
            return languageTextField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$MyEditorComboBox", "getEditorTextField"));
        }
    }
}

