/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.FixedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrequentEventDetector {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diagnostic.FrequentEventDetector");
    private long myStartedCounting;
    private final AtomicInteger myEventsPosted;
    private final AtomicInteger myLastTraceId;
    private final Map<String, Integer> myRecentTraces;
    private final int myEventCountThreshold;
    private final int myTimeSpanMs;
    private final Level myLevel;
    private static AtomicInteger disableRequests = new AtomicInteger();

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs) {
        this(eventCountThreshold, timeSpanMs, Level.INFO);
    }

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs, @NotNull Level level) {
        if (level == null) {
            FrequentEventDetector.$$$reportNull$$$0(0);
        }
        this.myStartedCounting = System.currentTimeMillis();
        this.myEventsPosted = new AtomicInteger();
        this.myLastTraceId = new AtomicInteger();
        this.myRecentTraces = new FixedHashMap<String, Integer>(50);
        this.myEventCountThreshold = eventCountThreshold;
        this.myTimeSpanMs = timeSpanMs;
        this.myLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getMessageOnEvent(@NotNull Object event) {
        if (event == null) {
            FrequentEventDetector.$$$reportNull$$$0(1);
        }
        if (disableRequests.get() != 0) {
            return null;
        }
        if (this.myEventsPosted.incrementAndGet() > this.myEventCountThreshold) {
            boolean shouldLog = false;
            AtomicInteger atomicInteger = this.myEventsPosted;
            synchronized (atomicInteger) {
                if (this.myEventsPosted.get() > this.myEventCountThreshold) {
                    long timeNow = System.currentTimeMillis();
                    shouldLog = timeNow - this.myStartedCounting < (long)this.myTimeSpanMs;
                    this.myEventsPosted.set(0);
                    this.myStartedCounting = timeNow;
                }
            }
            if (shouldLog) {
                int traceId;
                boolean logTrace;
                String trace = ExceptionUtil.getThrowableText(new Throwable());
                AtomicInteger atomicInteger2 = this.myEventsPosted;
                synchronized (atomicInteger2) {
                    Integer existingTraceId = this.myRecentTraces.get(trace);
                    boolean bl = logTrace = existingTraceId == null;
                    if (logTrace) {
                        traceId = this.myLastTraceId.incrementAndGet();
                        this.myRecentTraces.put(trace, traceId);
                    } else {
                        traceId = existingTraceId;
                    }
                }
                return "Too many events posted, #" + traceId + ". Event: " + event + (logTrace ? "\n" + trace : "");
            }
        }
        return null;
    }

    public void logMessage(@NotNull String message) {
        if (message == null) {
            FrequentEventDetector.$$$reportNull$$$0(2);
        }
        if (this.myLevel == Level.INFO) {
            LOG.info(message);
        } else if (this.myLevel == Level.WARN) {
            LOG.warn(message);
        } else {
            LOG.error(message);
        }
    }

    public void eventHappened(@NotNull Object event) {
        String message;
        if (event == null) {
            FrequentEventDetector.$$$reportNull$$$0(3);
        }
        if ((message = this.getMessageOnEvent(event)) != null) {
            this.logMessage(message);
        }
    }

    public static void disableUntil(@NotNull Disposable reenable) {
        if (reenable == null) {
            FrequentEventDetector.$$$reportNull$$$0(4);
        }
        disableRequests.incrementAndGet();
        Disposer.register(reenable, () -> disableRequests.decrementAndGet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reenable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diagnostic/FrequentEventDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMessageOnEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "logMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "eventHappened";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "disableUntil";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

