/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.StartUpMeasurer;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActivityImpl
implements Activity {
    private final String name;
    private String description;
    private final String thread;
    private final long start;
    private long end;
    private final ActivityImpl parent;
    @Nullable
    private final StartUpMeasurer.Level level;
    @Nullable
    private final ParallelActivity parallelActivity;
    @Nullable
    private final String myPluginId;

    ActivityImpl(@Nullable String name, @Nullable String description, @Nullable StartUpMeasurer.Level level, @Nullable String pluginId) {
        this(name, description, System.nanoTime(), null, level, null, pluginId);
    }

    @NotNull
    static ActivityImpl createParallelActivity(@NotNull ParallelActivity parallelActivity, @NotNull String name) {
        if (parallelActivity == null) {
            ActivityImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ActivityImpl.$$$reportNull$$$0(1);
        }
        ActivityImpl activityImpl = new ActivityImpl(name, null, System.nanoTime(), null, null, parallelActivity, null);
        if (activityImpl == null) {
            ActivityImpl.$$$reportNull$$$0(2);
        }
        return activityImpl;
    }

    ActivityImpl(@Nullable String name, @Nullable String description, long start, @Nullable ActivityImpl parent, @Nullable StartUpMeasurer.Level level, @Nullable ParallelActivity parallelActivity, @Nullable String pluginId) {
        this.name = name;
        this.description = description == null || description.isEmpty() ? null : description;
        this.start = start;
        this.parent = parent;
        this.level = level;
        this.parallelActivity = parallelActivity;
        this.myPluginId = pluginId;
        this.thread = Thread.currentThread().getName();
    }

    @NotNull
    public String getThread() {
        String string = this.thread;
        if (string == null) {
            ActivityImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public ActivityImpl getParent() {
        return this.parent;
    }

    @Nullable
    public StartUpMeasurer.Level getLevel() {
        return this.level;
    }

    @Nullable
    public ParallelActivity getParallelActivity() {
        return this.parallelActivity;
    }

    @Override
    @NotNull
    public ActivityImpl startChild(@NotNull String name) {
        if (name == null) {
            ActivityImpl.$$$reportNull$$$0(4);
        }
        ActivityImpl activityImpl = new ActivityImpl(name, null, System.nanoTime(), this, null, null, this.myPluginId);
        if (activityImpl == null) {
            ActivityImpl.$$$reportNull$$$0(5);
        }
        return activityImpl;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            ActivityImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getPluginId() {
        return this.myPluginId;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    void setEnd(long end) {
        assert (this.end == 0L);
        this.end = end;
    }

    @Override
    public void end(@Nullable String description) {
        if (description != null) {
            this.description = description;
        }
        assert (this.end == 0L);
        this.end = System.nanoTime();
        StartUpMeasurer.add(this);
    }

    @Override
    @NotNull
    public Activity endAndStart(@NotNull String name) {
        if (name == null) {
            ActivityImpl.$$$reportNull$$$0(7);
        }
        this.end();
        ActivityImpl activityImpl = new ActivityImpl(name, null, this.end, this.parent, null, this.parallelActivity, this.myPluginId);
        if (activityImpl == null) {
            ActivityImpl.$$$reportNull$$$0(8);
        }
        return activityImpl;
    }

    public String toString() {
        return "ActivityImpl(name=" + this.name + ", start=" + TimeUnit.NANOSECONDS.toMillis(this.start) + ", end=" + TimeUnit.NANOSECONDS.toMillis(this.start) + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parallelActivity";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/ActivityImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/ActivityImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createParallelActivity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThread";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "startChild";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "endAndStart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createParallelActivity";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "endAndStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

