/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OctalEscapeInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Octal escape" == null) {
            OctalEscapeInspection.$$$reportNull$$$0(0);
        }
        return "Octal escape";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OctalEscapeInspection.$$$reportNull$$$0(1);
        }
        OctalEscapeVisitor octalEscapeVisitor = new OctalEscapeVisitor(holder);
        if (octalEscapeVisitor == null) {
            OctalEscapeInspection.$$$reportNull$$$0(2);
        }
        return octalEscapeVisitor;
    }

    static String buildReplacementText(RegExpChar aChar) {
        int value = aChar.getValue();
        String hex = Integer.toHexString(value);
        return (hex.length() == 1 ? "\\x0" : "\\x") + hex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/OctalEscapeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/OctalEscapeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithHexEscapeFix
    implements LocalQuickFix {
        private final String myHex;

        ReplaceWithHexEscapeFix(String hex) {
            this.myHex = hex;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with '" + this.myHex + '\'';
            if (string == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with hexadecimal escape" == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(1);
            }
            return "Replace with hexadecimal escape";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor2.getPsiElement()) instanceof RegExpChar)) {
                return;
            }
            RegExpReplacementUtil.replaceInContext(element, OctalEscapeInspection.buildReplacementText((RegExpChar)element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/OctalEscapeInspection$ReplaceWithHexEscapeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/OctalEscapeInspection$ReplaceWithHexEscapeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OctalEscapeVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        OctalEscapeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            if (ch.getType() != RegExpChar.Type.OCT) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, "Octal escape <code>#ref</code> in RegExp", new LocalQuickFix[]{new ReplaceWithHexEscapeFix(OctalEscapeInspection.buildReplacementText(ch))});
        }
    }
}

