/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.indexing.ID;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class IndexInfrastructure {
    private static final boolean ourUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private static final String STUB_VERSIONS = ".versions";
    private static final String PERSISTENT_INDEX_DIRECTORY_NAME = ".persistent";
    private static final boolean ourDoParallelIndicesInitialization = SystemProperties.getBooleanProperty((String)"idea.parallel.indices.initialization", (boolean)false);
    public static final boolean ourDoAsyncIndicesInitialization = SystemProperties.getBooleanProperty((String)"idea.async.indices.initialization", (boolean)true);
    private static final ExecutorService ourGenesisExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"IndexInfrastructure Pool");

    private IndexInfrastructure() {
    }

    @NotNull
    public static File getVersionFile(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(0);
        }
        File file2 = new File(IndexInfrastructure.getIndexDirectory(indexName, true), indexName + ".ver");
        if (file2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @NotNull
    public static File getStorageFile(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(2);
        }
        File file2 = new File(IndexInfrastructure.getIndexRootDir(indexName), indexName.getName());
        if (file2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @NotNull
    public static File getInputIndexStorageFile(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(4);
        }
        File file2 = new File(IndexInfrastructure.getIndexRootDir(indexName), indexName + "_inputs");
        if (file2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(5);
        }
        return file2;
    }

    @NotNull
    public static File getIndexRootDir(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(6);
        }
        File file2 = IndexInfrastructure.getIndexDirectory(indexName, false);
        if (file2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(7);
        }
        return file2;
    }

    public static File getPersistentIndexRoot() {
        File indexDir = new File(PathManager.getIndexRoot() + File.separator + PERSISTENT_INDEX_DIRECTORY_NAME);
        indexDir.mkdirs();
        return indexDir;
    }

    @NotNull
    public static File getPersistentIndexRootDir(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(8);
        }
        File file2 = IndexInfrastructure.getIndexDirectory(indexName, false, PERSISTENT_INDEX_DIRECTORY_NAME);
        if (file2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(9);
        }
        return file2;
    }

    @NotNull
    private static File getIndexDirectory(@NotNull ID<?, ?> indexName, boolean forVersion) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(10);
        }
        File file2 = IndexInfrastructure.getIndexDirectory(indexName, forVersion, "");
        if (file2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(11);
        }
        return file2;
    }

    @NotNull
    private static File getIndexDirectory(@NotNull ID<?, ?> indexName, boolean forVersion, String relativePath) {
        File indexDir;
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(12);
        }
        String dirName = StringUtil.toLowerCase((String)indexName.getName());
        if (indexName instanceof StubIndexKey) {
            indexDir = new File(IndexInfrastructure.getIndexDirectory(StubUpdatingIndex.INDEX_ID, false, relativePath), forVersion ? STUB_VERSIONS : dirName);
        } else {
            if (relativePath.length() > 0) {
                relativePath = File.separator + relativePath;
            }
            indexDir = new File(PathManager.getIndexRoot() + relativePath, dirName);
        }
        indexDir.mkdirs();
        File file2 = indexDir;
        if (file2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(13);
        }
        return file2;
    }

    @Nullable
    public static VirtualFile findFileById(@NotNull PersistentFS fs, int id) {
        VirtualFile testFile;
        if (fs == null) {
            IndexInfrastructure.$$$reportNull$$$0(14);
        }
        if (ourUnitTestMode && (testFile = IndexInfrastructure.findTestFile(id)) != null) {
            return testFile;
        }
        return fs.findFileById(id);
    }

    @Nullable
    public static VirtualFile findFileByIdIfCached(@NotNull PersistentFS fs, int id) {
        VirtualFile testFile;
        if (fs == null) {
            IndexInfrastructure.$$$reportNull$$$0(15);
        }
        if (ourUnitTestMode && (testFile = IndexInfrastructure.findTestFile(id)) != null) {
            return testFile;
        }
        return fs.findFileByIdIfCached(id);
    }

    @Nullable
    private static VirtualFile findTestFile(int id) {
        return DummyFileSystem.getInstance().findById(id);
    }

    public static <T> Future<T> submitGenesisTask(Callable<T> action2) {
        return ourGenesisExecutor.submit(action2);
    }

    public static boolean hasIndices() {
        return !SystemProperties.is((String)"idea.skip.indices.initialization");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexInfrastructure";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexInfrastructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputIndexStorageFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRootDir";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentIndexRootDir";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStorageFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInputIndexStorageFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndexRootDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPersistentIndexRootDir";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndexDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findFileById";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIdIfCached";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DataInitialization<T>
    implements Callable<T> {
        private final List<ThrowableRunnable> myNestedInitializationTasks = new ArrayList<ThrowableRunnable>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T call() throws Exception {
            long started = System.nanoTime();
            try {
                this.prepare();
                this.runParallelNestedInitializationTasks();
                T t = this.finish();
                return t;
            }
            finally {
                Logger.getInstance((String)this.getClass().getName()).info("Initialization done:" + (System.nanoTime() - started) / 1000000L);
            }
        }

        protected T finish() {
            return null;
        }

        protected void prepare() {
        }

        protected abstract void onThrowable(@NotNull Throwable var1);

        protected void addNestedInitializationTask(ThrowableRunnable nestedInitializationTask) {
            this.myNestedInitializationTasks.add(nestedInitializationTask);
        }

        private void runParallelNestedInitializationTasks() throws InterruptedException {
            int numberOfTasksToExecute = this.myNestedInitializationTasks.size();
            if (numberOfTasksToExecute == 0) {
                return;
            }
            CountDownLatch proceedLatch = new CountDownLatch(numberOfTasksToExecute);
            if (ourDoParallelIndicesInitialization) {
                ExecutorService taskExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"IndexInfrastructure.DataInitialization.RunParallelNestedInitializationTasks", (Executor)PooledThreadExecutor.INSTANCE, (int)CacheUpdateRunner.indexingThreadCount());
                for (ThrowableRunnable callable : this.myNestedInitializationTasks) {
                    taskExecutor.execute(() -> this.executeNestedInitializationTask(callable, proceedLatch));
                }
                proceedLatch.await();
                taskExecutor.shutdown();
            } else {
                for (ThrowableRunnable callable : this.myNestedInitializationTasks) {
                    this.executeNestedInitializationTask(callable, proceedLatch);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeNestedInitializationTask(ThrowableRunnable callable, CountDownLatch proceedLatch) {
            Application app = ApplicationManager.getApplication();
            try {
                if (app.isDisposed()) {
                    return;
                }
                callable.run();
            }
            catch (Throwable t) {
                this.onThrowable(t);
            }
            finally {
                proceedLatch.countDown();
            }
        }
    }
}

