/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatConstants;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFormatterFacade {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade");
    private static final String WRAP_LINE_COMMAND_NAME = "AutoWrapLongLine";
    public static final Key<Boolean> WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY = new Key("WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY");
    private final CodeStyleSettings mySettings;
    private final FormatterTagHandler myTagHandler;
    private final int myRightMargin;
    private final boolean myCanChangeWhitespaceOnly;
    private boolean myReformatContext;

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language) {
        this(settings, language, false);
    }

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language, boolean canChangeWhitespaceOnly) {
        this.mySettings = settings;
        this.myTagHandler = new FormatterTagHandler(settings);
        this.myRightMargin = this.mySettings.getRightMargin(language);
        this.myCanChangeWhitespaceOnly = canChangeWhitespaceOnly;
    }

    public void setReformatContext(boolean value) {
        this.myReformatContext = value;
    }

    public ASTNode processElement(ASTNode element) {
        TextRange range2 = element.getTextRange();
        return this.processRange(element, range2.getStartOffset(), range2.getEndOffset());
    }

    public ASTNode processRange(ASTNode element, int startOffset, int endOffset) {
        return this.doProcessRange(element, startOffset, endOffset, null);
    }

    public ASTNode processRange(@NotNull ASTNode element, @NotNull RangeMarker rangeMarker) {
        if (element == null) {
            CodeFormatterFacade.$$$reportNull$$$0(0);
        }
        if (rangeMarker == null) {
            CodeFormatterFacade.$$$reportNull$$$0(1);
        }
        return this.doProcessRange(element, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), rangeMarker);
    }

    private ASTNode doProcessRange(ASTNode element, int startOffset, int endOffset, @Nullable RangeMarker rangeMarker) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(element);
        assert (psiElement != null);
        PsiFile file2 = psiElement.getContainingFile();
        Document document = file2.getViewProvider().getDocument();
        Object elementToFormat = document instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2) : psiElement;
        PsiFile fileToFormat = elementToFormat.getContainingFile();
        FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)fileToFormat);
        if (builder2 != null) {
            if (rangeMarker == null && document != null && endOffset < document.getTextLength()) {
                rangeMarker = document.createRangeMarker(startOffset, endOffset);
            }
            TextRange range2 = this.preprocess(element, TextRange.create((int)startOffset, (int)endOffset));
            if (document instanceof DocumentWindow) {
                DocumentWindow documentWindow = (DocumentWindow)document;
                range2 = documentWindow.injectedToHost(range2);
            }
            FormattingModel model2 = CoreFormatterUtil.buildModel(builder2, elementToFormat, range2, this.mySettings, FormattingMode.REFORMAT);
            if (file2.getTextLength() > 0) {
                try {
                    FormatterEx.getInstanceEx().format(model2, this.mySettings, this.mySettings.getIndentOptionsByFile(fileToFormat, range2), new FormatTextRanges(range2, true));
                    this.wrapLongLinesIfNecessary(file2, document, startOffset, endOffset);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (!psiElement.isValid()) {
                if (rangeMarker != null) {
                    PsiElement at = file2.findElementAt(rangeMarker.getStartOffset());
                    PsiElement result2 = PsiTreeUtil.getParentOfType((PsiElement)at, psiElement.getClass(), (boolean)false);
                    assert (result2 != null);
                    rangeMarker.dispose();
                    return result2.getNode();
                }
                assert (false);
            }
        }
        if (rangeMarker != null) {
            rangeMarker.dispose();
        }
        return element;
    }

    public void processText(@NotNull PsiFile file2, FormatTextRanges ranges2, boolean doPostponedFormatting) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(2);
        }
        Project project = file2.getProject();
        Document document = file2.getViewProvider().getDocument();
        List<FormatTextRange> textRanges = ranges2.getRanges();
        if (document instanceof DocumentWindow) {
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
            DocumentWindow documentWindow = (DocumentWindow)document;
            for (FormatTextRange range2 : textRanges) {
                range2.setTextRange(documentWindow.injectedToHost(range2.getTextRange()));
            }
            document = documentWindow.getDelegate();
        }
        FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)file2);
        Language contextLanguage = file2.getLanguage();
        if (builder2 != null && file2.getTextLength() > 0) {
            LOG.assertTrue(document != null);
            try {
                FileViewProvider viewProvider = file2.getViewProvider();
                PsiElement startElement = viewProvider.findElementAt(textRanges.get(0).getTextRange().getStartOffset(), contextLanguage);
                PsiElement endElement = viewProvider.findElementAt(textRanges.get(textRanges.size() - 1).getTextRange().getEndOffset() - 1, contextLanguage);
                PsiElement commonParent = startElement != null && endElement != null ? PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement) : null;
                ASTNode node = null;
                if (commonParent != null) {
                    node = commonParent.getNode();
                }
                if (node == null) {
                    node = file2.getNode();
                }
                for (FormatTextRange range3 : ranges2.getRanges()) {
                    TextRange rangeToUse = this.preprocess(node, range3.getTextRange());
                    range3.setTextRange(rangeToUse);
                }
                if (doPostponedFormatting) {
                    RangeMarker[] markers = new RangeMarker[textRanges.size()];
                    int i = 0;
                    for (FormatTextRange formatTextRange : textRanges) {
                        TextRange textRange = formatTextRange.getTextRange();
                        int start2 = textRange.getStartOffset();
                        int end = textRange.getEndOffset();
                        if (start2 < 0 || end <= start2 || end > document.getTextLength()) continue;
                        markers[i] = document.createRangeMarker(textRange);
                        markers[i].setGreedyToLeft(true);
                        markers[i].setGreedyToRight(true);
                        ++i;
                    }
                    PostprocessReformattingAspect component = (PostprocessReformattingAspect)file2.getProject().getComponent(PostprocessReformattingAspect.class);
                    FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
                    component.doPostponedFormatting(file2.getViewProvider());
                    i = 0;
                    for (FormatTextRange range5 : textRanges) {
                        RangeMarker marker = markers[i];
                        if (marker != null) {
                            range5.setTextRange(TextRange.create((Segment)marker));
                            marker.dispose();
                        }
                        ++i;
                    }
                }
                if (FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get().booleanValue()) {
                    return;
                }
                TextRange formattingModelRange = CodeFormatterFacade.uniteFormatRanges(textRanges, file2.getTextRange());
                FormattingModel originalModel = CoreFormatterUtil.buildModel(builder2, (PsiElement)file2, formattingModelRange, this.mySettings, FormattingMode.REFORMAT);
                DocumentBasedFormattingModel model2 = new DocumentBasedFormattingModel(originalModel, document, project, this.mySettings, file2.getFileType(), file2);
                FormatterEx formatterEx = FormatterEx.getInstanceEx();
                if (CodeStyleManager.getInstance((Project)project).isSequentialProcessingAllowed()) {
                    formatterEx.setProgressTask(new FormattingProgressTask(project, file2, document));
                }
                CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptionsByFile(file2, textRanges.size() == 1 ? textRanges.get(0).getTextRange() : null);
                formatterEx.format((FormattingModel)model2, this.mySettings, indentOptions, ranges2, this.myReformatContext);
                for (FormatTextRange range6 : textRanges) {
                    TextRange textRange = range6.getTextRange();
                    this.wrapLongLinesIfNecessary(file2, document, textRange.getStartOffset(), textRange.getEndOffset());
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    private static TextRange uniteFormatRanges(@NotNull Iterable<FormatTextRange> ranges2, @NotNull TextRange defaultRange) {
        if (ranges2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(3);
        }
        if (defaultRange == null) {
            CodeFormatterFacade.$$$reportNull$$$0(4);
        }
        TextRange resultRange = null;
        for (FormatTextRange formatRange : ranges2) {
            TextRange textRange = formatRange.getTextRange();
            if (resultRange == null) {
                resultRange = textRange;
                continue;
            }
            resultRange = resultRange.union(textRange);
        }
        TextRange textRange = resultRange != null ? resultRange : defaultRange;
        if (textRange == null) {
            CodeFormatterFacade.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private TextRange preprocess(@NotNull ASTNode node, @NotNull TextRange range2) {
        if (node == null) {
            CodeFormatterFacade.$$$reportNull$$$0(6);
        }
        if (range2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(7);
        }
        TextRange result2 = range2;
        PsiElement psi = node.getPsi();
        if (!psi.isValid()) {
            return result2;
        }
        PsiFile file2 = psi.getContainingFile();
        LinkedHashSet<TextRange> injectedFileRangesSet = new LinkedHashSet<TextRange>();
        if (!psi.getProject().isDefault()) {
            List injectedDocuments = InjectedLanguageManager.getInstance((Project)file2.getProject()).getCachedInjectedDocumentsInRange(file2, file2.getTextRange());
            if (!injectedDocuments.isEmpty()) {
                for (DocumentWindow injectedDocument : injectedDocuments) {
                    injectedFileRangesSet.add(TextRange.from((int)injectedDocument.injectedToHost(0), (int)injectedDocument.getTextLength()));
                }
            } else {
                Collection<PsiLanguageInjectionHost> injectionHosts = CodeFormatterFacade.collectInjectionHosts(file2, range2);
                PsiLanguageInjectionHost.InjectedPsiVisitor visitor = (injectedPsi, places) -> {
                    for (PsiLanguageInjectionHost.Shred place : places) {
                        Segment rangeMarker = place.getHostRangeMarker();
                        injectedFileRangesSet.add(TextRange.create((int)rangeMarker.getStartOffset(), (int)rangeMarker.getEndOffset()));
                    }
                };
                Iterator iterator = injectionHosts.iterator();
                while (iterator.hasNext()) {
                    PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)iterator.next();
                    InjectedLanguageManager.getInstance((Project)file2.getProject()).enumerate((PsiElement)host, visitor);
                }
            }
        }
        if (!injectedFileRangesSet.isEmpty()) {
            ArrayList ranges2 = ContainerUtilRt.newArrayList(injectedFileRangesSet);
            Collections.reverse(ranges2);
            for (TextRange injectedFileRange : ranges2) {
                TextRange initialInjectedRange;
                PsiFile injected;
                int startHostOffset = injectedFileRange.getStartOffset();
                int endHostOffset = injectedFileRange.getEndOffset();
                if (startHostOffset < range2.getStartOffset() || endHostOffset > range2.getEndOffset() || (injected = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, startHostOffset)) == null) continue;
                int startInjectedOffset = range2.getStartOffset() > startHostOffset ? startHostOffset - range2.getStartOffset() : 0;
                int endInjectedOffset = injected.getTextLength();
                if (range2.getEndOffset() < endHostOffset) {
                    endInjectedOffset -= endHostOffset - range2.getEndOffset();
                }
                TextRange injectedRange = initialInjectedRange = TextRange.create((int)startInjectedOffset, (int)endInjectedOffset);
                for (PreFormatProcessor processor2 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                    if (!processor2.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                    injectedRange = processor2.process((ASTNode)injected.getNode(), injectedRange);
                }
                if ((initialInjectedRange.getStartOffset() <= injectedRange.getStartOffset() || initialInjectedRange.getStartOffset() <= 0) && (initialInjectedRange.getEndOffset() >= injectedRange.getEndOffset() || initialInjectedRange.getEndOffset() >= injected.getTextLength())) continue;
                range2 = TextRange.create((int)(range2.getStartOffset() + injectedRange.getStartOffset() - initialInjectedRange.getStartOffset()), (int)(range2.getEndOffset() + initialInjectedRange.getEndOffset() - injectedRange.getEndOffset()));
            }
        }
        if (!this.mySettings.FORMATTER_TAGS_ENABLED) {
            for (PreFormatProcessor processor3 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor3.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                result2 = processor3.process(node, result2);
            }
        } else {
            result2 = this.preprocessEnabledRanges(node, result2);
        }
        return result2;
    }

    private TextRange preprocessEnabledRanges(@NotNull ASTNode node, @NotNull TextRange range2) {
        if (node == null) {
            CodeFormatterFacade.$$$reportNull$$$0(8);
        }
        if (range2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(9);
        }
        TextRange result2 = TextRange.create((int)range2.getStartOffset(), (int)range2.getEndOffset());
        List<TextRange> enabledRanges = this.myTagHandler.getEnabledRanges(node, result2);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PreFormatProcessor processor2 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor2.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                TextRange processedRange = processor2.process(node, enabledRange);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
        result2 = result2.grown(delta);
        return result2;
    }

    @NotNull
    private static Collection<PsiLanguageInjectionHost> collectInjectionHosts(@NotNull PsiFile file2, @NotNull TextRange range2) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(10);
        }
        if (range2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(11);
        }
        Stack<PsiElement> toProcess = new Stack<PsiElement>();
        for (PsiElement e = file2.findElementAt(range2.getStartOffset()); e != null && e.getTextRange().getStartOffset() < range2.getEndOffset(); e = e.getNextSibling()) {
            toProcess.push(e);
        }
        if (toProcess.isEmpty()) {
            Set<PsiLanguageInjectionHost> set = Collections.emptySet();
            if (set == null) {
                CodeFormatterFacade.$$$reportNull$$$0(12);
            }
            return set;
        }
        HashSet<PsiLanguageInjectionHost> result2 = null;
        while (!toProcess.isEmpty()) {
            PsiElement e = (PsiElement)toProcess.pop();
            if (e instanceof PsiLanguageInjectionHost) {
                if (result2 == null) {
                    result2 = new HashSet<PsiLanguageInjectionHost>();
                }
                result2.add((PsiLanguageInjectionHost)e);
                continue;
            }
            for (PsiElement child2 = e.getFirstChild(); child2 != null && e.getTextRange().getStartOffset() < range2.getEndOffset(); child2 = child2.getNextSibling()) {
                toProcess.push(child2);
            }
        }
        Set<PsiLanguageInjectionHost> set = result2 == null ? Collections.emptySet() : result2;
        if (set == null) {
            CodeFormatterFacade.$$$reportNull$$$0(13);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapLongLinesIfNecessary(@NotNull PsiFile file2, @Nullable Document document, int startOffset, int endOffset) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(14);
        }
        if (!this.mySettings.getCommonSettings((Language)file2.getLanguage()).WRAP_LONG_LINES || PostprocessReformattingAspect.getInstance(file2.getProject()).isViewProviderLocked(file2.getViewProvider()) || document == null) {
            return;
        }
        FormatterTagHandler formatterTagHandler = new FormatterTagHandler(CodeStyle.getSettings((PsiFile)file2));
        List<TextRange> enabledRanges = formatterTagHandler.getEnabledRanges((ASTNode)file2.getNode(), new TextRange(startOffset, endOffset));
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        if ((vFile == null || vFile instanceof LightVirtualFile) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Editor editor = PsiUtilBase.findEditor((PsiElement)file2);
        EditorFactory editorFactory = null;
        if (editor == null) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            editorFactory = EditorFactory.getInstance();
            editor = editorFactory.createEditor(document, file2.getProject(), file2.getVirtualFile(), false);
        }
        try {
            Editor editorToUse = editor;
            ApplicationManager.getApplication().runWriteAction(() -> {
                CaretModel caretModel = editorToUse.getCaretModel();
                int caretOffset = caretModel.getOffset();
                RangeMarker caretMarker = editorToUse.getDocument().createRangeMarker(caretOffset, caretOffset);
                this.doWrapLongLinesIfNecessary(editorToUse, file2.getProject(), editorToUse.getDocument(), startOffset, endOffset, enabledRanges);
                if (caretMarker.isValid() && caretModel.getOffset() != caretMarker.getStartOffset()) {
                    caretModel.moveToOffset(caretMarker.getStartOffset());
                }
            });
        }
        finally {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            if (documentManager.isUncommited(document)) {
                documentManager.commitDocument(document);
            }
            if (editorFactory != null) {
                editorFactory.releaseEditor(editor);
            }
        }
    }

    public void doWrapLongLinesIfNecessary(@NotNull Editor editor, @NotNull Project project, @NotNull Document document, int startOffset, int endOffset, List<? extends TextRange> enabledRanges) {
        if (editor == null) {
            CodeFormatterFacade.$$$reportNull$$$0(15);
        }
        if (project == null) {
            CodeFormatterFacade.$$$reportNull$$$0(16);
        }
        if (document == null) {
            CodeFormatterFacade.$$$reportNull$$$0(17);
        }
        int startOffsetToUse = Math.min(document.getTextLength(), Math.max(0, startOffset));
        int endOffsetToUse = Math.min(document.getTextLength(), Math.max(0, endOffset));
        LineWrapPositionStrategy strategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor(editor);
        CharSequence text2 = document.getCharsSequence();
        int startLine = document.getLineNumber(startOffsetToUse);
        int endLine = document.getLineNumber(Math.max(0, endOffsetToUse - 1));
        int maxLine = Math.min(document.getLineCount(), endLine + 1);
        int tabSize = EditorUtil.getTabSize(editor);
        if (tabSize <= 0) {
            tabSize = 1;
        }
        int spaceSize = EditorUtil.getSpaceWidth(0, editor);
        int[] shifts = new int[2];
        int cumulativeShift = 0;
        for (int line2 = startLine; line2 < maxLine; ++line2) {
            int preferredWrapPosition;
            int startLineOffset = document.getLineStartOffset(line2);
            int endLineOffset = document.getLineEndOffset(line2);
            if (!CodeFormatterFacade.canWrapLine(Math.max(startOffsetToUse, startLineOffset), Math.min(endOffsetToUse, endLineOffset), cumulativeShift, enabledRanges) || (preferredWrapPosition = this.calculatePreferredWrapPosition(editor, text2, tabSize, spaceSize, startLineOffset, endLineOffset, endOffsetToUse)) < 0 || preferredWrapPosition >= endLineOffset) continue;
            if (preferredWrapPosition >= endOffsetToUse) {
                return;
            }
            int wrapOffset = strategy.calculateWrapPosition(document, editor.getProject(), Math.max(startLineOffset, startOffsetToUse), Math.min(endLineOffset, endOffsetToUse), preferredWrapPosition, false, false);
            if (wrapOffset < 0 || CharArrayUtil.shiftBackward((CharSequence)text2, (int)startLineOffset, (int)(wrapOffset - 1), (String)" \t") < startLineOffset) continue;
            editor.getCaretModel().moveToOffset(wrapOffset);
            CodeFormatterFacade.emulateEnter(editor, project, shifts);
            if (shifts[1] - 1 >= wrapOffset - startLineOffset) {
                document.deleteString(wrapOffset, wrapOffset + shifts[1]);
                continue;
            }
            maxLine += shifts[0];
            endOffsetToUse += shifts[1];
            cumulativeShift += shifts[1];
        }
    }

    private static boolean canWrapLine(int startOffset, int endOffset, int offsetShift, @NotNull List<? extends TextRange> enabledRanges) {
        if (enabledRanges == null) {
            CodeFormatterFacade.$$$reportNull$$$0(18);
        }
        for (TextRange textRange : enabledRanges) {
            if (!textRange.containsOffset(startOffset - offsetShift) || !textRange.containsOffset(endOffset - offsetShift)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void emulateEnter(@NotNull Editor editor, @NotNull Project project, int[] shifts) {
        if (editor == null) {
            CodeFormatterFacade.$$$reportNull$$$0(19);
        }
        if (project == null) {
            CodeFormatterFacade.$$$reportNull$$$0(20);
        }
        DataContext dataContext = CodeFormatterFacade.prepareContext(editor.getComponent(), project);
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int startSelectionOffset = 0;
        int endSelectionOffset = 0;
        boolean restoreSelection = selectionModel.hasSelection();
        if (restoreSelection) {
            startSelectionOffset = selectionModel.getSelectionStart();
            endSelectionOffset = selectionModel.getSelectionEnd();
            selectionModel.removeSelection();
        }
        int textLengthBeforeWrap = document.getTextLength();
        int lineCountBeforeWrap = document.getLineCount();
        DataManager.getInstance().saveInDataContext(dataContext, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, (Object)true);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            Runnable command = () -> EditorActionManager.getInstance().getActionHandler("EditorEnter").execute(editor, dataContext);
            if (commandProcessor.getCurrentCommand() == null) {
                commandProcessor.executeCommand(editor.getProject(), command, WRAP_LINE_COMMAND_NAME, null);
            } else {
                command.run();
            }
        }
        finally {
            DataManager.getInstance().saveInDataContext(dataContext, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, null);
        }
        int symbolsDiff = document.getTextLength() - textLengthBeforeWrap;
        if (restoreSelection) {
            int newSelectionStart = startSelectionOffset;
            int newSelectionEnd = endSelectionOffset;
            if (startSelectionOffset >= caretOffset) {
                newSelectionStart += symbolsDiff;
            }
            if (endSelectionOffset >= caretOffset) {
                newSelectionEnd += symbolsDiff;
            }
            selectionModel.setSelection(newSelectionStart, newSelectionEnd);
        }
        shifts[0] = document.getLineCount() - lineCountBeforeWrap;
        shifts[1] = symbolsDiff;
    }

    private int calculatePreferredWrapPosition(@NotNull Editor editor, @NotNull CharSequence text2, int tabSize, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset) {
        if (editor == null) {
            CodeFormatterFacade.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(22);
        }
        boolean hasTabs = false;
        boolean canOptimize = true;
        boolean hasNonSpaceSymbols = false;
        block4: for (int i = startLineOffset; i < Math.min(endLineOffset, targetRangeEndOffset); ++i) {
            char c2 = text2.charAt(i);
            switch (c2) {
                case '\t': {
                    hasTabs = true;
                    if (hasNonSpaceSymbols) {
                        canOptimize = false;
                        break block4;
                    }
                }
                case ' ': {
                    continue block4;
                }
                default: {
                    hasNonSpaceSymbols = true;
                }
            }
        }
        int reservedWidthInColumns = FormatConstants.getReservedLineWrapWidthInColumns(editor);
        if (!hasTabs) {
            return this.wrapPositionForTextWithoutTabs(startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns);
        }
        if (canOptimize) {
            return this.wrapPositionForTabbedTextWithOptimization(text2, tabSize, startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns);
        }
        return this.wrapPositionForTabbedTextWithoutOptimization(editor, text2, spaceSize, startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns);
    }

    private int wrapPositionForTextWithoutTabs(int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns) {
        if (Math.min(endLineOffset, targetRangeEndOffset) - startLineOffset > this.myRightMargin) {
            return startLineOffset + this.myRightMargin - reservedWidthInColumns;
        }
        return -1;
    }

    private int wrapPositionForTabbedTextWithOptimization(@NotNull CharSequence text2, int tabSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns) {
        if (text2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(23);
        }
        int width = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i = startLineOffset; i < Math.min(endLineOffset, targetRangeEndOffset); ++i) {
            int symbolWidth;
            char c2 = text2.charAt(i);
            int n = symbolWidth = c2 == '\t' ? tabSize - width % tabSize : 1;
            if (width + symbolWidth + reservedWidthInColumns >= this.myRightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i >= reservedWidthInColumns) {
                result2 = i - 1;
            }
            if (width + symbolWidth >= this.myRightMargin) {
                wrapLine = true;
                break;
            }
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    private int wrapPositionForTabbedTextWithoutOptimization(@NotNull Editor editor, @NotNull CharSequence text2, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns) {
        if (editor == null) {
            CodeFormatterFacade.$$$reportNull$$$0(24);
        }
        if (text2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(25);
        }
        int width = 0;
        int x = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i = startLineOffset; i < Math.min(endLineOffset, targetRangeEndOffset); ++i) {
            int symbolWidth;
            int newX;
            char c2 = text2.charAt(i);
            if (c2 == '\t') {
                newX = EditorUtil.nextTabStop(x, editor);
                int diffInPixels = newX - x;
                symbolWidth = diffInPixels / spaceSize;
                if (diffInPixels % spaceSize > 0) {
                    ++symbolWidth;
                }
            } else {
                newX = x + EditorUtil.charWidth(c2, 0, editor);
                symbolWidth = 1;
            }
            if (width + symbolWidth + reservedWidthInColumns >= this.myRightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i >= reservedWidthInColumns) {
                result2 = i - 1;
            }
            if (width + symbolWidth >= this.myRightMargin) {
                wrapLine = true;
                break;
            }
            x = newX;
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    @NotNull
    private static DataContext prepareContext(@NotNull Component component, final @NotNull Project project) {
        if (component == null) {
            CodeFormatterFacade.$$$reportNull$$$0(26);
        }
        if (project == null) {
            CodeFormatterFacade.$$$reportNull$$$0(27);
        }
        final DataContext baseDataContext = DataManager.getInstance().getDataContext(component);
        DelegatingDataContext delegatingDataContext = new DelegatingDataContext(baseDataContext){

            @Override
            public Object getData(@NotNull @NonNls String dataId) {
                Object result2;
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((result2 = baseDataContext.getData(dataId)) == null && CommonDataKeys.PROJECT.is(dataId)) {
                    result2 = project;
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade$1", "getData"));
            }
        };
        if (delegatingDataContext == null) {
            CodeFormatterFacade.$$$reportNull$$$0(28);
        }
        return delegatingDataContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultRange";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledRanges";
                break;
            }
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteFormatRanges";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInjectionHosts";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processRange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uniteFormatRanges";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 28: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnabledRanges";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectInjectionHosts";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrapLongLinesIfNecessary";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doWrapLongLinesIfNecessary";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canWrapLine";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "emulateEnter";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calculatePreferredWrapPosition";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wrapPositionForTabbedTextWithOptimization";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "wrapPositionForTabbedTextWithoutOptimization";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "prepareContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegatingDataContext
    implements DataContext,
    UserDataHolder {
        private final DataContext myDataContextDelegate;
        private final UserDataHolder myDataHolderDelegate;

        DelegatingDataContext(DataContext delegate) {
            this.myDataContextDelegate = delegate;
            this.myDataHolderDelegate = delegate instanceof UserDataHolder ? (UserDataHolder)delegate : null;
        }

        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                DelegatingDataContext.$$$reportNull$$$0(0);
            }
            return this.myDataContextDelegate.getData(dataId);
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                DelegatingDataContext.$$$reportNull$$$0(1);
            }
            return (T)(this.myDataHolderDelegate == null ? null : this.myDataHolderDelegate.getUserData(key));
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                DelegatingDataContext.$$$reportNull$$$0(2);
            }
            if (this.myDataHolderDelegate != null) {
                this.myDataHolderDelegate.putUserData(key, value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade$DelegatingDataContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

