/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorActionPlan;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import sun.awt.image.SunVolatileImage;

class ImmediatePainter {
    private static final int DEBUG_PAUSE_DURATION = 1000;
    static final RegistryValue ENABLED = Registry.get((String)"editor.zero.latency.rendering");
    static final RegistryValue DOUBLE_BUFFERING = Registry.get((String)"editor.zero.latency.rendering.double.buffering");
    private static final RegistryValue PIPELINE_FLUSH = Registry.get((String)"editor.zero.latency.rendering.pipeline.flush");
    private static final RegistryValue DEBUG = Registry.get((String)"editor.zero.latency.rendering.debug");
    private final EditorImpl myEditor;
    private Image myImage;

    ImmediatePainter(EditorImpl editor) {
        this.myEditor = editor;
        Disposer.register((Disposable)editor.getDisposable(), () -> {
            if (this.myImage != null) {
                this.myImage.flush();
            }
        });
    }

    boolean paint(Graphics g, EditorActionPlan plan) {
        if (ENABLED.asBoolean() && ImmediatePainter.canPaintImmediately(this.myEditor)) {
            if (plan.getCaretShift() != 1) {
                return false;
            }
            List<EditorActionPlan.Replacement> replacements = plan.getReplacements();
            if (replacements.size() != 1) {
                return false;
            }
            EditorActionPlan.Replacement replacement = replacements.get(0);
            if (replacement.getText().length() != 1) {
                return false;
            }
            int caretOffset = replacement.getBegin();
            char c2 = replacement.getText().charAt(0);
            this.paintImmediately(g, caretOffset, c2);
            return true;
        }
        return false;
    }

    private static boolean canPaintImmediately(EditorImpl editor) {
        CaretModelImpl caretModel = editor.getCaretModel();
        Caret caret = caretModel.getPrimaryCaret();
        DocumentEx document = editor.getDocument();
        return document instanceof DocumentImpl && editor.getHighlighter() instanceof LexerEditorHighlighter && !(editor.getComponent().getParent() instanceof EditorTextField) && editor.myView.getTopOverhang() <= 0 && editor.myView.getBottomOverhang() <= 0 && !editor.getSelectionModel().hasSelection() && caretModel.getCaretCount() == 1 && !ImmediatePainter.isInVirtualSpace(editor, caret) && !ImmediatePainter.isInsertion(document, caret.getOffset()) && !caret.isAtRtlLocation() && !caret.isAtBidiRunBoundary();
    }

    private static boolean isInVirtualSpace(Editor editor, Caret caret) {
        return caret.getLogicalPosition().compareTo(editor.offsetToLogicalPosition(caret.getOffset())) != 0;
    }

    private static boolean isInsertion(Document document, int offset) {
        return offset < document.getTextLength() && document.getCharsSequence().charAt(offset) != '\n';
    }

    private void paintImmediately(Graphics g, int offset, char c2) {
        int caretWidth;
        EditorImpl editor = this.myEditor;
        DocumentEx document = editor.getDocument();
        LexerEditorHighlighter highlighter = (LexerEditorHighlighter)this.myEditor.getHighlighter();
        EditorSettings settings = editor.getSettings();
        boolean isBlockCursor = editor.isInsertMode() == settings.isBlockCursor();
        int lineHeight = editor.getLineHeight();
        int ascent = editor.getAscent();
        int topOverhang = editor.myView.getTopOverhang();
        int bottomOverhang = editor.myView.getBottomOverhang();
        char c1 = offset == 0 ? (char)' ' : (char)document.getCharsSequence().charAt(offset - 1);
        List<TextAttributes> attributes = highlighter.getAttributesForPreviousAndTypedChars(document, offset, c2);
        ImmediatePainter.updateAttributes(editor, offset, attributes);
        TextAttributes attributes1 = attributes.get(0);
        TextAttributes attributes2 = attributes.get(1);
        if (!ImmediatePainter.canRender(attributes1) || !ImmediatePainter.canRender(attributes2)) {
            return;
        }
        FontLayoutService fontLayoutService = FontLayoutService.getInstance();
        float width1 = fontLayoutService.charWidth2D(editor.getFontMetrics(attributes1.getFontType()), c1);
        float width2 = fontLayoutService.charWidth2D(editor.getFontMetrics(attributes2.getFontType()), c2);
        Font font1 = EditorUtil.fontForChar(c1, attributes1.getFontType(), editor).getFont();
        Font font2 = EditorUtil.fontForChar(c1, attributes2.getFontType(), editor).getFont();
        Point2D p2 = editor.offsetToPoint2D(offset);
        float p2x = (float)p2.getX();
        int p2y = (int)p2.getY();
        int width1i = (int)p2x - (int)(p2x - width1);
        int width2i = (int)(p2x + width2) - (int)p2x;
        CaretImpl caret = editor.getCaretModel().getPrimaryCaret();
        int n = caretWidth = isBlockCursor ? editor.getCaretLocations((boolean)false)[0].myWidth : JBUIScale.scale((int)caret.getVisualAttributes().getWidth(settings.getLineCursorWidth()));
        float caretShift = isBlockCursor ? 0.0f : (caretWidth == 1 ? 0.0f : 1.0f / JBUIScale.sysScale((Graphics2D)((Graphics2D)g)));
        Rectangle2D.Float caretRectangle = new Rectangle2D.Float((float)((int)(p2x + width2)) - caretShift, p2y - topOverhang, caretWidth, lineHeight + topOverhang + bottomOverhang);
        Rectangle rectangle1 = new Rectangle((int)(p2x - width1), p2y, width1i, lineHeight);
        Rectangle rectangle2 = new Rectangle((int)p2x, p2y, (int)((float)(width2i + caretWidth) - caretShift), lineHeight);
        Consumer painter = graphics -> {
            EditorUIUtil.setupAntialiasing(graphics);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, editor.myFractionalMetricsHintValue);
            ImmediatePainter.fillRect(graphics, rectangle2, attributes2.getBackgroundColor());
            ImmediatePainter.drawChar(graphics, c2, p2x, p2y + ascent, font2, attributes2.getForegroundColor());
            ImmediatePainter.fillRect(graphics, caretRectangle, ImmediatePainter.getCaretColor(editor));
            ImmediatePainter.fillRect(graphics, rectangle1, attributes1.getBackgroundColor());
            ImmediatePainter.drawChar(graphics, c1, p2x - width1, p2y + ascent, font1, attributes1.getForegroundColor());
        };
        Shape originalClip = g.getClip();
        g.setClip(new Rectangle2D.Float((float)((int)p2x) - caretShift, p2y, width2i + caretWidth, lineHeight));
        if (DOUBLE_BUFFERING.asBoolean()) {
            this.paintWithDoubleBuffering(g, (Consumer<? super Graphics>)painter);
        } else {
            painter.consume((Object)g);
        }
        g.setClip(originalClip);
        if (PIPELINE_FLUSH.asBoolean()) {
            Toolkit.getDefaultToolkit().sync();
        }
        if (DEBUG.asBoolean()) {
            ImmediatePainter.pause();
        }
    }

    private static boolean canRender(TextAttributes attributes) {
        return attributes.getEffectType() != EffectType.BOXED || attributes.getEffectColor() == null;
    }

    private void paintWithDoubleBuffering(Graphics graphics, Consumer<? super Graphics> painter) {
        Rectangle bounds2 = graphics.getClipBounds();
        this.createOrUpdateImageBuffer(this.myEditor.getComponent(), bounds2.getSize());
        UIUtil.useSafely((Graphics)this.myImage.getGraphics(), imageGraphics -> {
            imageGraphics.translate(-bounds2.x, -bounds2.y);
            painter.consume(imageGraphics);
        });
        graphics.drawImage(this.myImage, bounds2.x, bounds2.y, null);
    }

    private void createOrUpdateImageBuffer(JComponent component, Dimension size) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myImage == null || !ImmediatePainter.isLargeEnough(this.myImage, size)) {
                this.myImage = UIUtil.createImage((int)size.width, (int)size.height, (int)2);
            }
        } else if (this.myImage == null) {
            this.myImage = component.createVolatileImage(size.width, size.height);
        } else if (!ImmediatePainter.isLargeEnough(this.myImage, size) || !ImmediatePainter.isImageValid((VolatileImage)this.myImage, component)) {
            this.myImage.flush();
            this.myImage = component.createVolatileImage(size.width, size.height);
        }
    }

    private static boolean isLargeEnough(Image image, Dimension size) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width == -1 || height == -1) {
            throw new IllegalArgumentException("Image size is undefined");
        }
        return width >= size.width && height >= size.height;
    }

    private static boolean isImageValid(VolatileImage image, Component component) {
        GraphicsConfiguration imageConfig;
        GraphicsConfiguration componentConfig = component.getGraphicsConfiguration();
        if (SystemInfo.isWindows && image instanceof SunVolatileImage && (imageConfig = ((SunVolatileImage)image).getGraphicsConfig()) != null && componentConfig != null && imageConfig.getDevice() != componentConfig.getDevice()) {
            return false;
        }
        return image.validate(componentConfig) != 2;
    }

    private static void fillRect(Graphics g, Rectangle2D r, Color color) {
        g.setColor(color);
        ((Graphics2D)g).fill(r);
    }

    private static void drawChar(Graphics g, char c2, float x, float y, Font font, Color color) {
        g.setFont(font);
        g.setColor(color);
        ((Graphics2D)g).drawString(String.valueOf(c2), x, y);
    }

    private static Color getCaretColor(Editor editor) {
        Color overriddenColor = editor.getCaretModel().getPrimaryCaret().getVisualAttributes().getColor();
        if (overriddenColor != null) {
            return overriddenColor;
        }
        Color caretColor = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        return caretColor == null ? new JBColor((Color)Gray._0, (Color)Gray._255) : caretColor;
    }

    private static void updateAttributes(EditorImpl editor, int offset, List<? extends TextAttributes> attributes) {
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        Processor processor2 = highlighter -> {
            boolean isLineHighlighter;
            if (!highlighter.isValid()) {
                return true;
            }
            boolean bl = isLineHighlighter = highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE;
            if (isLineHighlighter || highlighter.getStartOffset() < offset) {
                list1.add(highlighter);
            }
            if (isLineHighlighter || highlighter.getEndOffset() > offset || highlighter.getEndOffset() == offset && highlighter.isGreedyToRight()) {
                list2.add(highlighter);
            }
            return true;
        };
        editor.getFilteredDocumentMarkupModel().processRangeHighlightersOverlappingWith(Math.max(0, offset - 1), offset, (Processor<? super RangeHighlighterEx>)processor2);
        editor.getMarkupModel().processRangeHighlightersOverlappingWith(Math.max(0, offset - 1), offset, (Processor<? super RangeHighlighterEx>)processor2);
        ImmediatePainter.updateAttributes(editor, attributes.get(0), list1);
        ImmediatePainter.updateAttributes(editor, attributes.get(1), list2);
    }

    private static void updateAttributes(EditorImpl editor, TextAttributes attributes, List<? extends RangeHighlighterEx> highlighters) {
        if (highlighters.size() > 1) {
            ContainerUtil.quickSort(highlighters, IterationState.BY_LAYER_THEN_ATTRIBUTES);
        }
        TextAttributes syntax = attributes;
        TextAttributes caretRow = editor.getCaretModel().getTextAttributes();
        int size = highlighters.size();
        for (int i = 0; i < size; ++i) {
            RangeHighlighterEx highlighter = highlighters.get(i);
            if (highlighter.getTextAttributes() != TextAttributes.ERASE_MARKER) continue;
            syntax = null;
        }
        ArrayList<TextAttributes> cachedAttributes = new ArrayList<TextAttributes>();
        for (int i = 0; i < size; ++i) {
            TextAttributes textAttributes;
            RangeHighlighterEx highlighter = highlighters.get(i);
            if (caretRow != null && highlighter.getLayer() < 2000) {
                cachedAttributes.add(caretRow);
                caretRow = null;
            }
            if (syntax != null && highlighter.getLayer() < 1000) {
                cachedAttributes.add(syntax);
                syntax = null;
            }
            if ((textAttributes = highlighter.getTextAttributes()) == null || textAttributes == TextAttributes.ERASE_MARKER) continue;
            cachedAttributes.add(textAttributes);
        }
        if (caretRow != null) {
            cachedAttributes.add(caretRow);
        }
        if (syntax != null) {
            cachedAttributes.add(syntax);
        }
        Color foreground = null;
        Color background = null;
        Color effect = null;
        EffectType effectType = null;
        int fontType = 0;
        for (int i = 0; i < cachedAttributes.size(); ++i) {
            TextAttributes attrs = (TextAttributes)cachedAttributes.get(i);
            if (foreground == null) {
                foreground = attrs.getForegroundColor();
            }
            if (background == null) {
                background = attrs.getBackgroundColor();
            }
            if (fontType == 0) {
                fontType = attrs.getFontType();
            }
            if (effect != null) continue;
            effect = attrs.getEffectColor();
            effectType = attrs.getEffectType();
        }
        if (foreground == null) {
            foreground = editor.getForegroundColor();
        }
        if (background == null) {
            background = editor.getBackgroundColor();
        }
        if (effectType == null) {
            effectType = EffectType.BOXED;
        }
        TextAttributes defaultAttributes = editor.getColorsScheme().getAttributes(HighlighterColors.TEXT);
        if (fontType == 0) {
            fontType = defaultAttributes == null ? 0 : defaultAttributes.getFontType();
        }
        attributes.setAttributes(foreground, background, effect, null, effectType, fontType);
    }

    private static void pause() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

