/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.startUpPerformanceReporter.ServiceReporterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.util.containers.ObjectLongHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010!\n\u0002\b\u0005\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a`\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001c0\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0017H\u0002\u001a\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a(\u0010!\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001aL\u0010#\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0%0$2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001c0\u001eH\u0002\u001a(\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006*"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "activityNameToJsonFieldName", "", "name", "compareTime", "", "o1", "Lcom/intellij/diagnostic/ActivityImpl;", "o2", "isSubItem", "", "item", "itemIndex", "list", "", "normalizeThreadName", "writeActivities", "", "activities", "offset", "", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "fieldName", "ownDurations", "Lcom/intellij/util/containers/ObjectLongHashMap;", "pluginCostMap", "", "measureThreshold", "writeIcons", "writeItemTimeInfo", "duration", "writeParallelActivities", "", "", "startTime", "writeUnknown", "start", "end", "intellij.platform.ide.impl"})
public final class StartUpPerformanceReporterKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final void writeParallelActivities(Map<String, ? extends List<ActivityImpl>> activities, long startTime, JsonGenerator writer, Map<String, ObjectLongHashMap<String>> pluginCostMap) {
        ObjectLongHashMap ownDurations = new ObjectLongHashMap();
        for (String name : CollectionsKt.sorted((Iterable)activities.keySet())) {
            ownDurations.clear();
            List list2 = (List)MapsKt.getValue(activities, (Object)name);
            StartUpPerformanceReporter.Companion.sortItems(list2);
            if (StringsKt.endsWith$default((String)name, (String)"Component", (boolean)false, (int)2, null)) {
                ServiceReporterKt.computeOwnTime(list2, (ObjectLongHashMap<ActivityImpl>)ownDurations);
            }
            long measureThreshold = Intrinsics.areEqual((Object)name, (Object)ParallelActivity.PREPARE_APP_INIT.getJsonName()) || Intrinsics.areEqual((Object)name, (Object)ParallelActivity.REOPENING_EDITOR.getJsonName()) ? -1L : ParallelActivity.MEASURE_THRESHOLD;
            StartUpPerformanceReporterKt.writeActivities(list2, startTime, writer, StartUpPerformanceReporterKt.activityNameToJsonFieldName(name), (ObjectLongHashMap<ActivityImpl>)ownDurations, pluginCostMap, measureThreshold);
        }
    }

    private static final String activityNameToJsonFieldName(String name) {
        String string;
        if (StringsKt.last((CharSequence)name) == 'y') {
            String string2 = name;
            int n = 0;
            int n2 = name.length() - 1;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            string = stringBuilder.append(string5).append("ies").toString();
        } else {
            String string6 = name;
            int n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string7 = string6;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
            String string9 = string8;
            string = stringBuilder.append(string9).append('s').toString();
        }
        return string;
    }

    private static final void writeActivities(List<ActivityImpl> activities, long offset, JsonGenerator writer, String fieldName, ObjectLongHashMap<ActivityImpl> ownDurations, Map<String, ObjectLongHashMap<String>> pluginCostMap, long measureThreshold) {
        if (activities.isEmpty()) {
            return;
        }
        JsonGenerator $this$array$iv = writer;
        boolean $i$f$array = false;
        String string = fieldName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it$iv = string2;
            boolean bl3 = false;
            $this$array$iv.writeFieldName(it$iv);
        }
        $this$array$iv.writeStartArray();
        boolean bl = false;
        long skippedDuration = 0L;
        for (ActivityImpl item : activities) {
            long duration;
            long computedOwnDuration = ownDurations.get((Object)item);
            long l = duration = computedOwnDuration == -1L ? item.getEnd() - item.getStart() : computedOwnDuration;
            if (duration <= measureThreshold) {
                skippedDuration += duration;
                continue;
            }
            if (item.getPluginId() != null) {
                String string3;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string3;
                boolean bl6 = false;
                Object object = item.getParallelActivity();
                if (object == null || (object = object.name()) == null) {
                    object = "unknown";
                }
                StartUpMeasurer.doAddPluginCost((String)it, (String)object, (long)duration, pluginCostMap);
            }
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl7 = false;
            writer.writeStringField("name", item.getName());
            StartUpPerformanceReporterKt.writeItemTimeInfo(item, duration, offset, writer);
            $this$obj$iv.writeEndObject();
        }
        if (skippedDuration > 0L) {
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl8 = false;
            writer.writeStringField("name", "Other");
            writer.writeNumberField("duration", TimeUnit.NANOSECONDS.toMillis(skippedDuration));
            writer.writeNumberField("start", TimeUnit.NANOSECONDS.toMillis(((ActivityImpl)CollectionsKt.last(activities)).getStart() - offset));
            writer.writeNumberField("end", TimeUnit.NANOSECONDS.toMillis(((ActivityImpl)CollectionsKt.last(activities)).getEnd() - offset));
            $this$obj$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    static /* synthetic */ void writeActivities$default(List list2, long l, JsonGenerator jsonGenerator, String string, ObjectLongHashMap objectLongHashMap, Map map2, long l2, int n, Object object) {
        if ((n & 0x40) != 0) {
            l2 = ParallelActivity.MEASURE_THRESHOLD;
        }
        StartUpPerformanceReporterKt.writeActivities(list2, l, jsonGenerator, string, (ObjectLongHashMap<ActivityImpl>)objectLongHashMap, map2, l2);
    }

    private static final void writeItemTimeInfo(ActivityImpl item, long duration, long offset, JsonGenerator writer) {
        writer.writeNumberField("duration", TimeUnit.NANOSECONDS.toMillis(duration));
        writer.writeNumberField("start", TimeUnit.NANOSECONDS.toMillis(item.getStart() - offset));
        writer.writeNumberField("end", TimeUnit.NANOSECONDS.toMillis(item.getEnd() - offset));
        String string = item.getThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"item.thread");
        writer.writeStringField("thread", StartUpPerformanceReporterKt.normalizeThreadName(string));
        if (item.getPluginId() != null) {
            writer.writeStringField("plugin", item.getPluginId());
        }
    }

    private static final String normalizeThreadName(String name) {
        return StringsKt.startsWith$default((String)name, (String)"AWT-EventQueue-", (boolean)false, (int)2, null) ? "edt" : (StringsKt.startsWith$default((String)name, (String)"Idea Main Thread", (boolean)false, (int)2, null) ? "idea main" : (StringsKt.startsWith$default((String)name, (String)"ApplicationImpl pooled thread ", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)name, (String)"ApplicationImpl pooled thread ", (String)"pooled ", (boolean)false, (int)4, null) : name));
    }

    private static final boolean isSubItem(ActivityImpl item, int itemIndex, List<ActivityImpl> list2) {
        ActivityImpl prevItem;
        if (item.getParent() != null) {
            return true;
        }
        int index = itemIndex;
        do {
            if ((ActivityImpl)CollectionsKt.getOrNull(list2, (int)(--index)) != null) continue;
            return false;
        } while (prevItem.getEnd() < item.getEnd());
        return true;
    }

    private static final long writeUnknown(JsonGenerator writer, long start2, long end, long offset) {
        long duration = end - start2;
        long durationInMs = TimeUnit.NANOSECONDS.toMillis(duration);
        if (durationInMs <= 1L) {
            return 0L;
        }
        JsonGenerator $this$obj$iv = writer;
        String fieldName$iv = null;
        boolean $i$f$obj = false;
        $this$obj$iv.writeStartObject();
        boolean bl = false;
        writer.writeStringField("name", "unknown");
        writer.writeNumberField("duration", durationInMs);
        writer.writeNumberField("start", TimeUnit.NANOSECONDS.toMillis(start2 - offset));
        writer.writeNumberField("end", TimeUnit.NANOSECONDS.toMillis(end - offset));
        $this$obj$iv.writeEndObject();
        return duration;
    }

    private static final int compareTime(ActivityImpl o1, ActivityImpl o2) {
        return o1.getStart() > o2.getStart() ? 1 : (o1.getStart() < o2.getStart() ? -1 : (o1.getEnd() > o2.getEnd() ? -1 : (o1.getEnd() < o2.getEnd() ? 1 : 0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeIcons(JsonGenerator writer) {
        void $this$obj$iv;
        boolean bl;
        String string;
        Function1<List<? extends IconLoadMeasurer>, Unit> $fun$writeStats$1 = new Function1<List<? extends IconLoadMeasurer>, Unit>(writer){
            final /* synthetic */ JsonGenerator $writer;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<IconLoadMeasurer> infoList) {
                void $this$obj$iv;
                Intrinsics.checkParameterIsNotNull(infoList, (String)"infoList");
                JsonGenerator jsonGenerator = this.$writer;
                String string = infoList.get(0).getType().name();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String fieldName$iv = string3;
                boolean $i$f$obj = false;
                String string4 = fieldName$iv;
                if (string4 != null) {
                    String string5 = string4;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String it$iv = string5;
                    boolean bl4 = false;
                    $this$obj$iv.writeFieldName(it$iv);
                }
                $this$obj$iv.writeStartObject();
                boolean bl5 = false;
                this.$writer.writeNumberField("count", infoList.get(0).getCounter());
                this.$writer.writeNumberField("loading", TimeUnit.NANOSECONDS.toMillis(infoList.get(0).getTotalTime()));
                this.$writer.writeNumberField("decoding", TimeUnit.NANOSECONDS.toMillis(infoList.get(1).getTotalTime()));
                $this$obj$iv.writeEndObject();
            }
            {
                this.$writer = jsonGenerator;
                super(1);
            }
        };
        boolean bl2 = false;
        LinkedHashMap map2 = new LinkedHashMap();
        for (IconLoadMeasurer stat : IconLoadMeasurer.getStats()) {
            Object object;
            String key$iv;
            void $this$getOrPut$iv;
            Map map3 = map2;
            IconLoadMeasurer iconLoadMeasurer = stat;
            Intrinsics.checkExpressionValueIsNotNull((Object)iconLoadMeasurer, (String)"stat");
            string = iconLoadMeasurer.getType().name();
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                boolean bl4 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(stat);
        }
        JsonGenerator stat = writer;
        String fieldName$iv = "icons";
        boolean $i$f$obj = false;
        string = fieldName$iv;
        bl = false;
        boolean bl5 = false;
        String it$iv = string;
        boolean bl6 = false;
        $this$obj$iv.writeFieldName(it$iv);
        $this$obj$iv.writeStartObject();
        boolean bl7 = false;
        Iterator iterator = map2.values().iterator();
        while (iterator.hasNext()) {
            List infoList;
            List list2 = infoList = (List)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"infoList");
            $fun$writeStats$1.invoke((List<IconLoadMeasurer>)list2);
        }
        $this$obj$iv.writeEndObject();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StartUpMeasurer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$writeIcons(JsonGenerator writer) {
        StartUpPerformanceReporterKt.writeIcons(writer);
    }

    public static final /* synthetic */ long access$writeUnknown(JsonGenerator writer, long start2, long end, long offset) {
        return StartUpPerformanceReporterKt.writeUnknown(writer, start2, end, offset);
    }

    public static final /* synthetic */ boolean access$isSubItem(ActivityImpl item, int itemIndex, List list2) {
        return StartUpPerformanceReporterKt.isSubItem(item, itemIndex, list2);
    }

    public static final /* synthetic */ void access$writeItemTimeInfo(ActivityImpl item, long duration, long offset, JsonGenerator writer) {
        StartUpPerformanceReporterKt.writeItemTimeInfo(item, duration, offset, writer);
    }

    public static final /* synthetic */ void access$writeParallelActivities(Map activities, long startTime, JsonGenerator writer, Map pluginCostMap) {
        StartUpPerformanceReporterKt.writeParallelActivities(activities, startTime, writer, pluginCostMap);
    }

    public static final /* synthetic */ int access$compareTime(ActivityImpl o1, ActivityImpl o2) {
        return StartUpPerformanceReporterKt.compareTime(o1, o2);
    }
}

