/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0006H\u0016R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/codeInsight/hints/presentation/TextInlayPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "width", "", "height", "text", "", "yBaseline", "fontProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/colors/EditorFontType;", "Ljava/awt/Font;", "(IILjava/lang/String;ILkotlin/jvm/functions/Function1;)V", "getFontProvider", "()Lkotlin/jvm/functions/Function1;", "getHeight", "()I", "setHeight", "(I)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getWidth", "setWidth", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "intellij.platform.lang.impl"})
public final class TextInlayPresentation
extends BasePresentation {
    private int width;
    private int height;
    @NotNull
    private String text;
    private int yBaseline;
    @NotNull
    private final Function1<EditorFontType, Font> fontProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Object savedHint = g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
        try {
            Color foreground = attributes.getForegroundColor();
            if (foreground != null) {
                EditorFontType editorFontType;
                switch (attributes.getFontType()) {
                    case 1: {
                        editorFontType = EditorFontType.BOLD;
                        break;
                    }
                    case 2: {
                        editorFontType = EditorFontType.ITALIC;
                        break;
                    }
                    default: {
                        editorFontType = EditorFontType.PLAIN;
                    }
                }
                EditorFontType fontType = editorFontType;
                g.setFont((Font)this.fontProvider.invoke((Object)fontType));
                g.setColor(foreground);
                g.drawString(this.text, 0, this.yBaseline);
            }
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
        }
    }

    @NotNull
    public String toString() {
        return this.text;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.text = string;
    }

    @NotNull
    public final Function1<EditorFontType, Font> getFontProvider() {
        return this.fontProvider;
    }

    public TextInlayPresentation(int width, int height, @NotNull String text2, int yBaseline, @NotNull Function1<? super EditorFontType, ? extends Font> fontProvider) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull(fontProvider, (String)"fontProvider");
        this.width = width;
        this.height = height;
        this.text = text2;
        this.yBaseline = yBaseline;
        this.fontProvider = fontProvider;
    }
}

