/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class UnixPythonSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] NAMES = new String[]{"jython", "pypy"};
    public static final UnixPythonSdkFlavor INSTANCE = new UnixPythonSdkFlavor();

    private UnixPythonSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths(@Nullable Module module2) {
        HashSet<String> candidates = new HashSet<String>();
        UnixPythonSdkFlavor.collectUnixPythons("/usr/bin", candidates);
        return candidates;
    }

    public static void collectUnixPythons(String path, Set<? super String> candidates) {
        VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(path);
        if (rootDir != null) {
            VirtualFile[] suspects;
            if (rootDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootDir).markDirty();
            }
            rootDir.refresh(true, false);
            block0: for (VirtualFile child : suspects = rootDir.getChildren()) {
                if (child.isDirectory()) continue;
                String childName = StringUtil.toLowerCase((String)child.getName());
                for (String name : NAMES) {
                    if (!childName.startsWith(name) && !PYTHON_RE.matcher(childName).matches()) continue;
                    String childPath = child.getPath();
                    if (childName.endsWith("-config") || childName.startsWith("pythonw") || childName.endsWith("m")) continue block0;
                    candidates.add(childPath);
                    continue block0;
                }
            }
        }
    }
}

