/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySourcePosition;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLocalPositionConverter
implements PyPositionConverter {
    private static final String[] EGG_EXTENSIONS = new String[]{".egg", ".zip"};

    @NotNull
    public PySourcePosition create(@NotNull String file, int line2) {
        if (file == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(0);
        }
        PySourcePosition pySourcePosition = this.convertPythonToFrame(file, line2);
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(1);
        }
        return pySourcePosition;
    }

    @NotNull
    public PySourcePosition convertPythonToFrame(@NotNull String filePath, int line2) {
        File file;
        if (filePath == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(2);
        }
        if ((file = new File(filePath)).exists()) {
            PyLocalSourcePosition pyLocalSourcePosition = new PyLocalSourcePosition(file.getPath(), line2);
            if (pyLocalSourcePosition == null) {
                PyLocalPositionConverter.$$$reportNull$$$0(3);
            }
            return pyLocalSourcePosition;
        }
        PyRemoteSourcePosition pyRemoteSourcePosition = new PyRemoteSourcePosition(filePath, line2);
        if (pyRemoteSourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(4);
        }
        return pyRemoteSourcePosition;
    }

    @NotNull
    public PySourcePosition convertFrameToPython(@NotNull PySourcePosition position) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(5);
        }
        PySourcePosition pySourcePosition = position;
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(6);
        }
        return pySourcePosition;
    }

    @NotNull
    public PySourcePosition convertToPython(@NotNull XSourcePosition position) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(7);
        }
        PySourcePosition pySourcePosition = this.convertToPython(PyLocalPositionConverter.convertFilePath(position.getFile().getPath()), PyLocalPositionConverter.convertLocalLineToRemote(position.getFile(), position.getLine()));
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(8);
        }
        return pySourcePosition;
    }

    @NotNull
    protected PySourcePosition convertToPython(@NotNull String filePath, int line2) {
        if (filePath == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(9);
        }
        PyLocalSourcePosition pyLocalSourcePosition = new PyLocalSourcePosition(filePath, line2);
        if (pyLocalSourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(10);
        }
        return pyLocalSourcePosition;
    }

    protected static int convertLocalLineToRemote(VirtualFile file, int l) {
        return (Integer)ReadAction.compute(() -> {
            int line2 = l;
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document != null) {
                while (PyDebugSupportUtils.isContinuationLine(document, line2)) {
                    ++line2;
                }
            }
            return line2 + 1;
        });
    }

    @Nullable
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, String frameName) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(11);
        }
        return PyLocalPositionConverter.createXSourcePosition(this.getVirtualFile(position.getFile()), position.getLine());
    }

    public PySignature convertSignature(PySignature signature) {
        return signature;
    }

    public VirtualFile getVirtualFile(String path) {
        VirtualFile vFile = this.getLocalFileSystem().findFileByPath(path);
        if (vFile == null) {
            vFile = this.findEggEntry(path);
        }
        return vFile;
    }

    protected VirtualFileSystem getLocalFileSystem() {
        return LocalFileSystem.getInstance();
    }

    private VirtualFile findEggEntry(String file) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file.indexOf(ext = stringArray[i])) == -1; ++i) {
        }
        if (ind != -1) {
            String jarPath = file.substring(0, ind + 4);
            VirtualFile jarFile = this.getLocalFileSystem().findFileByPath(jarPath);
            if (jarFile != null) {
                String innerPath = file.substring(ind + 4);
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
                if (jarRoot != null) {
                    return jarRoot.findFileByRelativePath(innerPath);
                }
            }
        }
        return null;
    }

    private static String convertFilePath(String file) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file.indexOf((ext = stringArray[i]) + "!")) == -1; ++i) {
        }
        if (ind != -1) {
            return file.substring(0, ind + 4) + file.substring(ind + 5);
        }
        return file;
    }

    private static String winNormCase(String file) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file.indexOf(ext = stringArray[i])) == -1; ++i) {
        }
        if (ind != -1) {
            return StringUtil.toLowerCase((String)file.substring(0, ind + 4)) + file.substring(ind + 4);
        }
        return StringUtil.toLowerCase((String)file);
    }

    @Nullable
    public static XSourcePosition createXSourcePosition(@Nullable VirtualFile vFile, int line2) {
        if (vFile != null) {
            return XDebuggerUtil.getInstance().createPosition(vFile, PyLocalPositionConverter.convertRemoteLineToLocal(vFile, line2));
        }
        return null;
    }

    private static int convertRemoteLineToLocal(VirtualFile vFile, int line2) {
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(vFile));
        --line2;
        if (document != null) {
            while (PyDebugSupportUtils.isContinuationLine(document, line2 - 1)) {
                --line2;
            }
        }
        return line2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPythonToFrame";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFrameToPython";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPython";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertPythonToFrame";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertFrameToPython";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertToPython";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertFromPython";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PyRemoteSourcePosition
    extends PySourcePosition {
        public PyRemoteSourcePosition(String file, int line2) {
            super(file, line2);
        }

        protected String normalize(@Nullable String file) {
            if (file == null) {
                return null;
            }
            if (SystemInfo.isWindows && PyRemoteSourcePosition.isWindowsPath((String)file)) {
                file = PyLocalPositionConverter.winNormCase(file);
            }
            return super.normalize(file);
        }
    }

    protected static class PyLocalSourcePosition
    extends PySourcePosition {
        public PyLocalSourcePosition(String file, int line2) {
            super(file, line2);
        }

        protected String normalize(@Nullable String file) {
            if (file == null) {
                return null;
            }
            if (SystemInfo.isWindows) {
                file = PyLocalPositionConverter.winNormCase(file);
            }
            return super.normalize(file);
        }
    }
}

