/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.util.LinkedList;
import org.jsampler.CC;

public class SessionViewConfig {
    private final LinkedList<ChannelConfig> channelConfigs = new LinkedList();
    private final LinkedList<DeviceConfig> midiDeviceConfigs = new LinkedList();
    private final LinkedList<DeviceConfig> audioDeviceConfigs = new LinkedList();

    public SessionViewConfig(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("[channel]".equals(string)) {
                this.channelConfigs.add(this.parseChannel(stringArray, i + 1));
                continue;
            }
            if ("[MIDI device]".equals(string)) {
                this.midiDeviceConfigs.add(this.parseDevice(stringArray, i + 1));
                continue;
            }
            if (!"[audio device]".equals(string)) continue;
            this.audioDeviceConfigs.add(this.parseDevice(stringArray, i + 1));
        }
    }

    public ChannelConfig pollChannelConfig() {
        return this.channelConfigs.poll();
    }

    public DeviceConfig pollMidiDeviceConfig() {
        return this.midiDeviceConfigs.poll();
    }

    public DeviceConfig pollAudioDeviceConfig() {
        return this.audioDeviceConfigs.poll();
    }

    private ChannelConfig parseChannel(String[] stringArray, int n) {
        ChannelConfig channelConfig = new ChannelConfig();
        for (int i = n; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].startsWith("[")) {
                return channelConfig;
            }
            if (stringArray[i].startsWith("channelLane = ")) {
                string = stringArray[i].substring("channelLane = ".length());
                if (string.isEmpty()) continue;
                try {
                    channelConfig.channelsPanel = Integer.parseInt(string) - 1;
                }
                catch (Exception exception) {
                    CC.getLogger().info("Uknown channel lane: " + string);
                }
                continue;
            }
            if (stringArray[i].startsWith("channelsPanel = ")) {
                string = stringArray[i].substring("channelsPanel = ".length());
                if (string.isEmpty()) continue;
                try {
                    channelConfig.channelsPanel = Integer.parseInt(string) - 1;
                }
                catch (Exception exception) {
                    CC.getLogger().info("Uknown channel lane: " + string);
                }
                continue;
            }
            if (stringArray[i].startsWith("viewType = ")) {
                string = stringArray[i].substring("viewType = ".length());
                if ("SMALL".equals(string)) {
                    channelConfig.type = ChannelConfig.Type.SMALL;
                    continue;
                }
                if ("NORMAL".equals(string)) {
                    channelConfig.type = ChannelConfig.Type.NORMAL;
                    continue;
                }
                CC.getLogger().info("Uknown channel view: " + string);
                continue;
            }
            if (!stringArray[i].startsWith("expanded = ")) continue;
            string = stringArray[i].substring("expanded = ".length());
            channelConfig.expanded = Boolean.parseBoolean(string);
        }
        return channelConfig;
    }

    private DeviceConfig parseDevice(String[] stringArray, int n) {
        DeviceConfig deviceConfig = new DeviceConfig();
        for (int i = n; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("[")) {
                return deviceConfig;
            }
            if (!stringArray[i].startsWith("expanded = ")) continue;
            String string = stringArray[i].substring("expanded = ".length());
            deviceConfig.expanded = Boolean.parseBoolean(string);
        }
        return deviceConfig;
    }

    public static class DeviceConfig {
        public boolean expanded = false;
    }

    public static class ChannelConfig {
        public int channelsPanel = 0;
        public Type type = Type.NORMAL;
        public boolean expanded = false;

        public static enum Type {
            SMALL,
            NORMAL;

        }
    }
}

