// Generated by gmmproc 2.54.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_AUDIOINFO_H
#define _GSTREAMERMM_AUDIOINFO_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/audio/audio-info.h>
#include <gstreamermm/audioformat.h>
#include <gstreamermm/audioringbuffer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GstAudioInfo GstAudioInfo; }
#endif

namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var AudioFlags AUDIO_FLAG_NONE
 * No valid flag.
 * 
 *  @var AudioFlags AUDIO_FLAG_UNPOSITIONED
 * The position array explicitly
 * contains unpositioned channels.
 * 
 *  @enum AudioFlags
 * 
 * Extra audio flags
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%AudioFlags operator|(AudioFlags, AudioFlags)</tt><br>
 * <tt>%AudioFlags operator&(AudioFlags, AudioFlags)</tt><br>
 * <tt>%AudioFlags operator^(AudioFlags, AudioFlags)</tt><br>
 * <tt>%AudioFlags operator~(AudioFlags)</tt><br>
 * <tt>%AudioFlags& operator|=(AudioFlags&, AudioFlags)</tt><br>
 * <tt>%AudioFlags& operator&=(AudioFlags&, AudioFlags)</tt><br>
 * <tt>%AudioFlags& operator^=(AudioFlags&, AudioFlags)</tt><br>
 */
enum AudioFlags
{
  AUDIO_FLAG_NONE = 0x0,
  AUDIO_FLAG_UNPOSITIONED = (1 << 0)
};

/** @ingroup gstreamermmEnums */
inline AudioFlags operator|(AudioFlags lhs, AudioFlags rhs)
  { return static_cast<AudioFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline AudioFlags operator&(AudioFlags lhs, AudioFlags rhs)
  { return static_cast<AudioFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline AudioFlags operator^(AudioFlags lhs, AudioFlags rhs)
  { return static_cast<AudioFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline AudioFlags operator~(AudioFlags flags)
  { return static_cast<AudioFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline AudioFlags& operator|=(AudioFlags& lhs, AudioFlags rhs)
  { return (lhs = static_cast<AudioFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline AudioFlags& operator&=(AudioFlags& lhs, AudioFlags rhs)
  { return (lhs = static_cast<AudioFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline AudioFlags& operator^=(AudioFlags& lhs, AudioFlags rhs)
  { return (lhs = static_cast<AudioFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::AudioFlags> : public Glib::Value_Flags<Gst::AudioFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var AudioLayout AUDIO_LAYOUT_INTERLEAVED
 * Interleaved audio.
 * 
 *  @var AudioLayout AUDIO_LAYOUT_NON_INTERLEAVED
 * Non-interleaved audio.
 * 
 *  @enum AudioLayout
 * 
 * Layout of the audio samples for the different channels.
 *
 * @ingroup gstreamermmEnums
 */
enum AudioLayout
{
  AUDIO_LAYOUT_INTERLEAVED,
  AUDIO_LAYOUT_NON_INTERLEAVED
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::AudioLayout> : public Glib::Value_Enum<Gst::AudioLayout>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


class Caps;

/** Information describing audio properties. This information can be filled
 * in from Gst::Caps with from_caps() or Gst::AudioInfo() constructor.
 *
 * Last reviewed on 2016-04-23 (1.8.0).
 */
class AudioInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = AudioInfo;
  using BaseObjectType = GstAudioInfo;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  AudioInfo();

  explicit AudioInfo(GstAudioInfo* gobject, bool make_a_copy = true);

  AudioInfo(const AudioInfo& other);
  AudioInfo& operator=(const AudioInfo& other);

  AudioInfo(AudioInfo&& other) noexcept;
  AudioInfo& operator=(AudioInfo&& other) noexcept;

  ~AudioInfo() noexcept;

  void swap(AudioInfo& other) noexcept;

  ///Provides access to the underlying C instance.
  GstAudioInfo*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GstAudioInfo* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GstAudioInfo* gobj_copy() const;

protected:
  GstAudioInfo* gobject_;

private:

  
public:

  /** Create AudioInfo from @a caps.
   *
   * @param caps A Gst::Caps.
   *
   * @throw std::runtime_error if @a caps could not be parsed.
   */
  AudioInfo(const Glib::RefPtr<const Gst::Caps>& caps);

  
  /** Compares two Gst::AudioInfo and returns whether they are equal or not
   * 
   * @param other A Gst::AudioInfo.
   * @return <tt>true</tt> if @a info and @a other are equal, else <tt>false</tt>.
   */
  bool is_equal(const Gst::AudioInfo& other) const;

  
  /** Initialize @a info with default values.
   */
  void init();

  
  /** Parse @a caps and update @a info.
   * 
   * @param caps A Gst::Caps.
   * @return <tt>true</tt> if @a caps could be parsed.
   */
  bool from_caps(const Glib::RefPtr<const Gst::Caps>& caps);
  
  /** Convert the values of @a info into a Gst::Caps.
   * 
   * @return The new Gst::Caps containing the
   * info of @a info.
   */
  Glib::RefPtr<Gst::Caps> to_caps() const;

  
  /** Converts among various Gst::Format types.  This function handles
   * GST_FORMAT_BYTES, GST_FORMAT_TIME, and GST_FORMAT_DEFAULT.  For
   * raw audio, GST_FORMAT_DEFAULT corresponds to audio frames.  This
   * function can be used to handle pad queries of the type GST_QUERY_CONVERT.
   * 
   * @newin{1,8}
   * 
   * @param fmt Gst::Format of the @a src_val.
   * @param src_val Value to convert.
   * @param dest_fmt Gst::Format of the @a dest_val.
   * @param dest_val Pointer to destination value.
   * @return <tt>true</tt> if the conversion was successful.
   */
  bool convert(Gst::Format fmt, gint64 src_val, Gst::Format dest_fmt, gint64& dest_val) const;

 
  /** Set the default info for the audio info of @a format and @a rate and @a channels.
   * 
   * @note This initializes @a info first, no values are preserved.
   * 
   * @newin{1,8}
   * 
   * @param format The format.
   * @param rate The samplerate.
   * @param channels The number of channels.
   * @param position The channel positions.
   */
  void set_format(Gst::AudioFormat format, int rate, int channels, const Gst::AudioChannelPosition * position);

  Gst::AudioFlags get_flags() const;
  void set_flags(const Gst::AudioFlags& value);

  Gst::AudioLayout get_layout() const;
  void set_layout(const Gst::AudioLayout& value);

  int get_rate() const;
  void set_rate(const int& value);

  int get_channels() const;
  void set_channels(const int& value);

  int get_bpf() const;
  void set_bpf(const int& value);

  const Gst::AudioFormatInfo get_finfo() const;


};

}


namespace Gst
{

/** @relates Gst::AudioInfo
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(AudioInfo& lhs, AudioInfo& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Gst

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::AudioInfo
 */
Gst::AudioInfo wrap(GstAudioInfo* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gst::AudioInfo> : public Glib::Value_Boxed<Gst::AudioInfo>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GSTREAMERMM_AUDIOINFO_H */

