/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import com.sun.security.auth.UnixPrincipal;
import com.sun.security.auth.module.UnixSystem;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class UnixLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> sharedState;
    private Map<String, ?> options;
    private boolean debug = true;
    private UnixSystem ss;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UnixPrincipal userPrincipal;
    private UnixNumericUserPrincipal UIDPrincipal;
    private UnixNumericGroupPrincipal GIDPrincipal;
    private LinkedList<UnixNumericGroupPrincipal> supplementaryGroups = new LinkedList();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    @Override
    public boolean login() throws LoginException {
        int i;
        long[] unixGroups = null;
        this.ss = new UnixSystem();
        if (this.ss == null) {
            this.succeeded = false;
            throw new FailedLoginException("Failed in attempt to import the underlying system identity information");
        }
        this.userPrincipal = new UnixPrincipal(this.ss.getUsername());
        this.UIDPrincipal = new UnixNumericUserPrincipal(this.ss.getUid());
        this.GIDPrincipal = new UnixNumericGroupPrincipal(this.ss.getGid(), true);
        if (this.ss.getGroups() != null && this.ss.getGroups().length > 0) {
            unixGroups = this.ss.getGroups();
            for (i = 0; i < unixGroups.length; ++i) {
                UnixNumericGroupPrincipal ngp = new UnixNumericGroupPrincipal(unixGroups[i], false);
                if (ngp.getName().equals(this.GIDPrincipal.getName())) continue;
                this.supplementaryGroups.add(ngp);
            }
        }
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: succeeded importing info: ");
            System.out.println("\t\t\tuid = " + this.ss.getUid());
            System.out.println("\t\t\tgid = " + this.ss.getGid());
            unixGroups = this.ss.getGroups();
            for (i = 0; i < unixGroups.length; ++i) {
                System.out.println("\t\t\tsupp gid = " + unixGroups[i]);
            }
        }
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[UnixLoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("commit Failed: Subject is Readonly");
        }
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.UIDPrincipal)) {
            this.subject.getPrincipals().add(this.UIDPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.GIDPrincipal)) {
            this.subject.getPrincipals().add(this.GIDPrincipal);
        }
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            if (this.subject.getPrincipals().contains(this.supplementaryGroups.get(i))) continue;
            this.subject.getPrincipals().add(this.supplementaryGroups.get(i));
        }
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: added UnixPrincipal,");
            System.out.println("\t\t\t\tUnixNumericUserPrincipal,");
            System.out.println("\t\t\t\tUnixNumericGroupPrincipal(s),");
            System.out.println("\t\t\t to Subject");
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.ss = null;
            this.userPrincipal = null;
            this.UIDPrincipal = null;
            this.GIDPrincipal = null;
            this.supplementaryGroups = new LinkedList();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("logout Failed: Subject is Readonly");
        }
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrincipals().remove(this.UIDPrincipal);
        this.subject.getPrincipals().remove(this.GIDPrincipal);
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            this.subject.getPrincipals().remove(this.supplementaryGroups.get(i));
        }
        this.ss = null;
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        this.UIDPrincipal = null;
        this.GIDPrincipal = null;
        this.supplementaryGroups = new LinkedList();
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: logged out Subject");
        }
        return true;
    }
}

