/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnectionBuilder;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

@Deprecated
public class GithubConnection {
    private static final Logger LOG = GithubUtil.LOG;
    @Nullable
    private GithubAccount myAccount;
    @NotNull
    private final String myApiURL;
    @NotNull
    private final CloseableHttpClient myClient;
    private final boolean myReusable;
    private volatile HttpUriRequest myRequest;
    private volatile boolean myAborted;

    public GithubConnection(@NotNull GithubAuthData auth, boolean reusable) {
        if (auth == null) {
            GithubConnection.$$$reportNull$$$0(0);
        }
        this.myApiURL = GithubUrlUtil.getApiUrl(auth.getHost());
        this.myClient = new GithubConnectionBuilder(auth, this.myApiURL).createClient();
        this.myReusable = reusable;
    }

    @Nullable
    public JsonElement getRequest(@NotNull String path, Header ... headers) throws IOException {
        if (path == null) {
            GithubConnection.$$$reportNull$$$0(1);
        }
        if (headers == null) {
            GithubConnection.$$$reportNull$$$0(2);
        }
        return this.request(path, null, Arrays.asList(headers), HttpVerb.GET).getJsonElement();
    }

    @Nullable
    public JsonElement postRequest(@NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        if (path == null) {
            GithubConnection.$$$reportNull$$$0(3);
        }
        if (headers == null) {
            GithubConnection.$$$reportNull$$$0(4);
        }
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.POST).getJsonElement();
    }

    @Nullable
    public JsonElement patchRequest(@NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        if (path == null) {
            GithubConnection.$$$reportNull$$$0(5);
        }
        if (headers == null) {
            GithubConnection.$$$reportNull$$$0(6);
        }
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.PATCH).getJsonElement();
    }

    @Nullable
    public JsonElement deleteRequest(@NotNull String path, Header ... headers) throws IOException {
        if (path == null) {
            GithubConnection.$$$reportNull$$$0(7);
        }
        if (headers == null) {
            GithubConnection.$$$reportNull$$$0(8);
        }
        return this.request(path, null, Arrays.asList(headers), HttpVerb.DELETE).getJsonElement();
    }

    @NotNull
    public Header[] headRequest(@NotNull String path, Header ... headers) throws IOException {
        if (path == null) {
            GithubConnection.$$$reportNull$$$0(9);
        }
        if (headers == null) {
            GithubConnection.$$$reportNull$$$0(10);
        }
        Header[] headerArray = this.request(path, null, Arrays.asList(headers), HttpVerb.HEAD).getHeaders();
        if (headerArray == null) {
            GithubConnection.$$$reportNull$$$0(11);
        }
        return headerArray;
    }

    @Nullable
    public GithubAccount getAccount() {
        return this.myAccount;
    }

    public void setAccount(@NotNull GithubAccount account) {
        if (account == null) {
            GithubConnection.$$$reportNull$$$0(12);
        }
        this.myAccount = account;
    }

    @NotNull
    String getApiURL() {
        String string = this.myApiURL;
        if (string == null) {
            GithubConnection.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void abort() {
        if (this.myAborted) {
            return;
        }
        this.myAborted = true;
        HttpUriRequest request = this.myRequest;
        if (request != null) {
            request.abort();
        }
    }

    public void close() throws IOException {
        this.myClient.close();
    }

    @NotNull
    private ResponsePage request(@NotNull String path, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        if (path == null) {
            GithubConnection.$$$reportNull$$$0(14);
        }
        if (headers == null) {
            GithubConnection.$$$reportNull$$$0(15);
        }
        if (verb == null) {
            GithubConnection.$$$reportNull$$$0(16);
        }
        ResponsePage responsePage = this.doRequest(this.myApiURL + path, requestBody, headers, verb);
        if (responsePage == null) {
            GithubConnection.$$$reportNull$$$0(17);
        }
        return responsePage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ResponsePage doRequest(@NotNull String uri, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        ResponsePage responsePage;
        CloseableHttpResponse response;
        block28: {
            ResponsePage responsePage2;
            block27: {
                ResponsePage responsePage3;
                block26: {
                    if (uri == null) {
                        GithubConnection.$$$reportNull$$$0(18);
                    }
                    if (headers == null) {
                        GithubConnection.$$$reportNull$$$0(19);
                    }
                    if (verb == null) {
                        GithubConnection.$$$reportNull$$$0(20);
                    }
                    if (this.myAborted) {
                        throw new GithubOperationCanceledException();
                    }
                    if (EventQueue.isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.warn("Network operation in EDT");
                    }
                    response = null;
                    try {
                        response = this.doREST(uri, requestBody, headers, verb);
                        if (this.myAborted) {
                            throw new GithubOperationCanceledException();
                        }
                        GithubConnection.checkStatusCode(response, requestBody);
                        HttpEntity entity = response.getEntity();
                        if (entity == null) {
                            ResponsePage responsePage4 = this.createResponse(response);
                            responsePage3 = responsePage4;
                            break block26;
                        }
                        JsonElement ret = GithubConnection.parseResponse(entity.getContent());
                        if (ret.isJsonNull()) {
                            ResponsePage responsePage5 = this.createResponse(response);
                            responsePage2 = responsePage5;
                            break block27;
                        }
                        String nextPage = null;
                        Header pageHeader = response.getFirstHeader("Link");
                        if (pageHeader != null) {
                            for (HeaderElement element : pageHeader.getElements()) {
                                NameValuePair rel = element.getParameterByName("rel");
                                if (rel == null || !"next".equals(rel.getValue())) continue;
                                String urlString = element.toString();
                                int begin = urlString.indexOf(60);
                                int end = urlString.lastIndexOf(62);
                                if (begin == -1 || end == -1) {
                                    LOG.error("Invalid 'Link' header", new String[]{"{" + pageHeader.toString() + "}"});
                                    break;
                                }
                                nextPage = urlString.substring(begin + 1, end);
                                break;
                            }
                        }
                        ResponsePage responsePage6 = this.createResponse(ret, nextPage, response);
                        responsePage = responsePage6;
                        break block28;
                    }
                    catch (SSLHandshakeException e) {
                        if (e.getCause() instanceof CertificateException) {
                            LOG.info("Host SSL certificate is not trusted", (Throwable)e);
                            throw new GithubOperationCanceledException("Host SSL certificate is not trusted", e);
                        }
                        throw e;
                    }
                    catch (IOException e) {
                        if (this.myAborted) {
                            throw new GithubOperationCanceledException("Operation canceled", e);
                        }
                        throw e;
                    }
                }
                if (responsePage3 == null) {
                    GithubConnection.$$$reportNull$$$0(21);
                }
                return responsePage3;
            }
            if (responsePage2 == null) {
                GithubConnection.$$$reportNull$$$0(22);
            }
            return responsePage2;
        }
        if (responsePage == null) {
            GithubConnection.$$$reportNull$$$0(23);
        }
        return responsePage;
        finally {
            this.myRequest = null;
            if (response != null) {
                response.close();
            }
            if (!this.myReusable) {
                this.myClient.close();
            }
        }
    }

    @NotNull
    private CloseableHttpResponse doREST(@NotNull String uri, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        HttpPost request;
        if (uri == null) {
            GithubConnection.$$$reportNull$$$0(24);
        }
        if (headers == null) {
            GithubConnection.$$$reportNull$$$0(25);
        }
        if (verb == null) {
            GithubConnection.$$$reportNull$$$0(26);
        }
        switch (verb) {
            case POST: {
                request = new HttpPost(uri);
                if (requestBody == null) break;
                request.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case PATCH: {
                request = new HttpPatch(uri);
                if (requestBody == null) break;
                ((HttpPatch)request).setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case GET: {
                request = new HttpGet(uri);
                break;
            }
            case DELETE: {
                request = new HttpDelete(uri);
                break;
            }
            case HEAD: {
                request = new HttpHead(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown HttpVerb: " + verb.toString());
            }
        }
        for (Header header : headers) {
            request.addHeader(header);
        }
        this.myRequest = request;
        CloseableHttpResponse closeableHttpResponse = this.myClient.execute((HttpUriRequest)request);
        if (closeableHttpResponse == null) {
            GithubConnection.$$$reportNull$$$0(27);
        }
        return closeableHttpResponse;
    }

    private static void checkStatusCode(@NotNull CloseableHttpResponse response, @Nullable String body2) throws IOException {
        if (response == null) {
            GithubConnection.$$$reportNull$$$0(28);
        }
        int code = response.getStatusLine().getStatusCode();
        switch (code) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                return;
            }
            case 401: 
            case 402: 
            case 403: {
                GithubStatusCodeException error = GithubConnection.getStatusCodeException(response);
                Header headerOTP = response.getFirstHeader("X-GitHub-OTP");
                if (headerOTP != null) {
                    for (HeaderElement element : headerOTP.getElements()) {
                        if (!"required".equals(element.getName())) continue;
                        throw new GithubTwoFactorAuthenticationException(error.getMessage());
                    }
                }
                if (error.getError() != null && error.getError().containsReasonMessage("API rate limit exceeded")) {
                    throw new GithubRateLimitExceededException(error.getMessage());
                }
                throw new GithubAuthenticationException("Request response: " + error.getMessage());
            }
            case 400: 
            case 422: {
                LOG.info("body message:" + body2);
                throw GithubConnection.getStatusCodeException(response);
            }
        }
        throw GithubConnection.getStatusCodeException(response);
    }

    @NotNull
    private static GithubStatusCodeException getStatusCodeException(@NotNull CloseableHttpResponse response) {
        String reason;
        int statusCode;
        block4: {
            GithubStatusCodeException githubStatusCodeException;
            block5: {
                if (response == null) {
                    GithubConnection.$$$reportNull$$$0(29);
                }
                StatusLine statusLine = response.getStatusLine();
                statusCode = statusLine.getStatusCode();
                reason = statusCode + " " + statusLine.getReasonPhrase();
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) break block4;
                    GithubErrorMessage error = GithubApiUtil.fromJson(GithubConnection.parseResponse(entity.getContent()), GithubErrorMessage.class);
                    String message = reason + " - " + error.getMessage();
                    githubStatusCodeException = new GithubStatusCodeException(message, error, statusCode);
                    if (githubStatusCodeException != null) break block5;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
                GithubConnection.$$$reportNull$$$0(30);
            }
            return githubStatusCodeException;
        }
        GithubStatusCodeException githubStatusCodeException = new GithubStatusCodeException(reason, statusCode);
        if (githubStatusCodeException == null) {
            GithubConnection.$$$reportNull$$$0(31);
        }
        return githubStatusCodeException;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static JsonElement parseResponse(@NotNull InputStream githubResponse) throws IOException {
        if (githubResponse == null) {
            GithubConnection.$$$reportNull$$$0(32);
        }
        InputStreamReader reader = new InputStreamReader(githubResponse, StandardCharsets.UTF_8);
        Throwable throwable = null;
        JsonElement jsonElement = new JsonParser().parse((Reader)reader);
        JsonElement jsonElement2 = jsonElement;
        if (jsonElement2 == null) {
            GithubConnection.$$$reportNull$$$0(33);
        }
        return jsonElement2;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
            {
                catch (JsonParseException jse) {
                    throw new GithubJsonException("Couldn't parse GitHub response", jse);
                }
            }
        }
    }

    private ResponsePage createResponse(@NotNull CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (response == null) {
            GithubConnection.$$$reportNull$$$0(34);
        }
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(null, null, response.getAllHeaders());
    }

    private ResponsePage createResponse(@NotNull JsonElement ret, @Nullable String path, @NotNull CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (ret == null) {
            GithubConnection.$$$reportNull$$$0(35);
        }
        if (response == null) {
            GithubConnection.$$$reportNull$$$0(36);
        }
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(ret, path, response.getAllHeaders());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auth";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/api/GithubConnection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "account";
                break;
            }
            case 16: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verb";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 28: 
            case 29: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "githubResponse";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ret";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/api/GithubConnection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "headRequest";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiURL";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "request";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doRequest";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "doREST";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusCodeException";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "parseResponse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRequest";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "postRequest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "patchRequest";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteRequest";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "headRequest";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setAccount";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doRequest";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doREST";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkStatusCode";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getStatusCodeException";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parseResponse";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createResponse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PagedRequest<T> {
        @NotNull
        public List<T> next(@NotNull GithubConnection var1) throws IOException;

        public boolean hasNext();

        @NotNull
        default public List<T> getAll(@NotNull GithubConnection connection) throws IOException {
            if (connection == null) {
                PagedRequest.$$$reportNull$$$0(0);
            }
            ArrayList<T> result = new ArrayList<T>();
            while (this.hasNext()) {
                result.addAll(this.next(connection));
            }
            ArrayList<T> arrayList = result;
            if (arrayList == null) {
                PagedRequest.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/api/GithubConnection$PagedRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/api/GithubConnection$PagedRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAll";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getAll";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ResponsePage {
        @Nullable
        private final JsonElement myResponse;
        @Nullable
        private final String myNextPage;
        @NotNull
        private final Header[] myHeaders;

        ResponsePage(@Nullable JsonElement response, @Nullable String next, @NotNull Header[] headers) {
            if (headers == null) {
                ResponsePage.$$$reportNull$$$0(0);
            }
            this.myResponse = response;
            this.myNextPage = next;
            this.myHeaders = headers;
        }

        @Nullable
        public JsonElement getJsonElement() {
            return this.myResponse;
        }

        @Nullable
        public String getNextPage() {
            return this.myNextPage;
        }

        @NotNull
        public Header[] getHeaders() {
            if (this.myHeaders == null) {
                ResponsePage.$$$reportNull$$$0(1);
            }
            return this.myHeaders;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/api/GithubConnection$ResponsePage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/api/GithubConnection$ResponsePage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SingleValuePagedRequest<T>
    extends PagedRequestBase<T> {
        @NotNull
        private final Class<? extends T> myType;

        public SingleValuePagedRequest(@NotNull String path, @NotNull Class<? extends T> type, Header ... headers) {
            if (path == null) {
                SingleValuePagedRequest.$$$reportNull$$$0(0);
            }
            if (type == null) {
                SingleValuePagedRequest.$$$reportNull$$$0(1);
            }
            if (headers == null) {
                SingleValuePagedRequest.$$$reportNull$$$0(2);
            }
            super(path, headers);
            this.myType = type;
        }

        @Override
        protected List<T> parse(@NotNull JsonElement response) throws IOException {
            if (response == null) {
                SingleValuePagedRequest.$$$reportNull$$$0(3);
            }
            T result = GithubApiUtil.fromJson(response, this.myType);
            return Collections.singletonList(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headers";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "response";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/github/api/GithubConnection$SingleValuePagedRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ArrayPagedRequest<T>
    extends PagedRequestBase<T> {
        @NotNull
        private final Class<? extends T[]> myTypeArray;

        public ArrayPagedRequest(@NotNull String path, @NotNull Class<? extends T[]> typeArray, Header ... headers) {
            if (path == null) {
                ArrayPagedRequest.$$$reportNull$$$0(0);
            }
            if (typeArray == null) {
                ArrayPagedRequest.$$$reportNull$$$0(1);
            }
            if (headers == null) {
                ArrayPagedRequest.$$$reportNull$$$0(2);
            }
            super(path, headers);
            this.myTypeArray = typeArray;
        }

        @Override
        protected List<T> parse(@NotNull JsonElement response) throws IOException {
            if (response == null) {
                ArrayPagedRequest.$$$reportNull$$$0(3);
            }
            if (!response.isJsonArray()) {
                throw new GithubJsonException("Wrong json type: expected JsonArray", new Exception(response.toString()));
            }
            T[] result = GithubApiUtil.fromJson((JsonElement)response.getAsJsonArray(), this.myTypeArray);
            return Arrays.asList(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeArray";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headers";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "response";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/github/api/GithubConnection$ArrayPagedRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class PagedRequestBase<T>
    implements PagedRequest<T> {
        @NotNull
        private final String myPath;
        @NotNull
        private final Collection<Header> myHeaders;
        private boolean myFirstRequest;
        @Nullable
        private String myNextPage;

        public PagedRequestBase(@NotNull String path, Header ... headers) {
            if (path == null) {
                PagedRequestBase.$$$reportNull$$$0(0);
            }
            if (headers == null) {
                PagedRequestBase.$$$reportNull$$$0(1);
            }
            this.myFirstRequest = true;
            this.myPath = path;
            this.myHeaders = Arrays.asList(headers);
        }

        @Override
        @NotNull
        public List<T> next(@NotNull GithubConnection connection) throws IOException {
            String url;
            if (connection == null) {
                PagedRequestBase.$$$reportNull$$$0(2);
            }
            if (this.myFirstRequest) {
                url = connection.getApiURL() + this.myPath;
                this.myFirstRequest = false;
            } else {
                if (this.myNextPage == null) {
                    throw new NoSuchElementException();
                }
                url = this.myNextPage;
                this.myNextPage = null;
            }
            ResponsePage response = connection.doRequest(url, null, this.myHeaders, HttpVerb.GET);
            this.myNextPage = response.getNextPage();
            if (response.getJsonElement() == null) {
                throw new GithubConfusingException("Empty response");
            }
            List<T> list = this.parse(response.getJsonElement());
            if (list == null) {
                PagedRequestBase.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public boolean hasNext() {
            return this.myFirstRequest || this.myNextPage != null;
        }

        protected abstract List<T> parse(@NotNull JsonElement var1) throws IOException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/api/GithubConnection$PagedRequestBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/api/GithubConnection$PagedRequestBase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "next";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "next";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum HttpVerb {
        GET,
        POST,
        DELETE,
        HEAD,
        PATCH;

    }
}

