/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import java.util.Collection;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptimizeImportsBeforeCheckinHandler
extends CheckinHandler
implements CheckinMetaHandler {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.optimize.imports.before.commit", (Object[])new Object[0]);
    protected final Project myProject;
    private final CheckinProjectPanel myPanel;

    public OptimizeImportsBeforeCheckinHandler(Project project, CheckinProjectPanel panel2) {
        this.myProject = project;
        this.myPanel = panel2;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        return new BooleanCommitOption(this.myPanel, VcsBundle.message((String)"checkbox.checkin.options.optimize.imports", (Object[])new Object[0]), true, (Function0<Boolean>)((Function0)() -> this.getSettings().OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT), value -> {
            this.getSettings().OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT = value;
        });
    }

    protected VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    public void runCheckinHandlers(@NotNull Runnable finishAction) {
        if (finishAction == null) {
            OptimizeImportsBeforeCheckinHandler.$$$reportNull$$$0(0);
        }
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        Collection files2 = this.myPanel.getVirtualFiles();
        Runnable performCheckoutAction = () -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            finishAction.run();
        };
        if (configuration.OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT && !DumbService.isDumb((Project)this.myProject)) {
            new OptimizeImportsProcessor(this.myProject, CheckinHandlerUtil.getPsiFiles(this.myProject, files2), COMMAND_NAME, performCheckoutAction).run();
        } else {
            finishAction.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishAction", "com/intellij/openapi/vcs/checkin/OptimizeImportsBeforeCheckinHandler", "runCheckinHandlers"));
    }
}

