/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.Resource;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Loader {
    private final URL myURL;
    private final int myIndex;
    private ClasspathCache.NameFilter myLoadingFilter;

    Loader(URL url, int index) {
        this.myURL = url;
        this.myIndex = index;
    }

    URL getBaseURL() {
        return this.myURL;
    }

    @Nullable
    abstract Resource getResource(String var1);

    @NotNull
    abstract ClasspathCache.LoaderData buildData() throws IOException;

    int getIndex() {
        return this.myIndex;
    }

    boolean containsName(String name, String shortName) {
        if (name == null || name.isEmpty()) {
            return true;
        }
        ClasspathCache.NameFilter filter = this.myLoadingFilter;
        return filter == null || filter.maybeContains(shortName);
    }

    void applyData(ClasspathCache.LoaderData loaderData) {
        this.myLoadingFilter = loaderData.getNameFilter();
    }
}

