/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xml.util.XmlStringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgIncomingCommand;
import org.zmlx.hg4idea.command.HgOutgoingCommand;
import org.zmlx.hg4idea.status.HgChangesetStatus;
import org.zmlx.hg4idea.status.ui.HgHideableWidget;

public class HgRemoteStatusUpdater
implements HgUpdater {
    private final AbstractVcs myVcs;
    private final HgChangesetStatus myIncomingStatus;
    private final HgChangesetStatus myOutgoingStatus;
    private final HgProjectSettings myProjectSettings;
    private final AtomicBoolean myUpdateStarted;
    private MessageBusConnection busConnection;
    private ScheduledFuture<?> changesUpdaterScheduledFuture;

    public HgRemoteStatusUpdater(@NotNull HgVcs vcs, HgChangesetStatus incomingStatus, HgChangesetStatus outgoingStatus, HgProjectSettings projectSettings) {
        if (vcs == null) {
            HgRemoteStatusUpdater.$$$reportNull$$$0(0);
        }
        this.myUpdateStarted = new AtomicBoolean();
        this.myVcs = vcs;
        this.myIncomingStatus = incomingStatus;
        this.myOutgoingStatus = outgoingStatus;
        this.myProjectSettings = projectSettings;
    }

    public void update(Project project) {
        this.update(project, null);
    }

    @Override
    public void update(final Project project, final @Nullable VirtualFile root) {
        if (!this.isCheckingEnabled() || this.myUpdateStarted.get()) {
            return;
        }
        this.myUpdateStarted.set(true);
        ApplicationManager.getApplication().invokeLater(() -> new Task.Backgroundable(project, HgRemoteStatusUpdater.getProgressTitle(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                VirtualFile[] virtualFileArray;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                if (root != null) {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = root;
                } else {
                    virtualFileArray = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs(HgRemoteStatusUpdater.this.myVcs);
                }
                VirtualFile[] roots = virtualFileArray;
                HgRemoteStatusUpdater.this.updateChangesStatusSynchronously(project, roots, HgRemoteStatusUpdater.this.myIncomingStatus, true);
                HgRemoteStatusUpdater.this.updateChangesStatusSynchronously(project, roots, HgRemoteStatusUpdater.this.myOutgoingStatus, false);
                ((HgHideableWidget)BackgroundTaskUtil.syncPublisher((Project)project, HgVcs.INCOMING_OUTGOING_CHECK_TOPIC)).update();
                indicator.stop();
                HgRemoteStatusUpdater.this.myUpdateStarted.set(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/status/HgRemoteStatusUpdater$1", "run"));
            }
        }.queue());
    }

    public void activate() {
        this.busConnection = this.myVcs.getProject().getMessageBus().connect();
        this.busConnection.subscribe(HgVcs.REMOTE_TOPIC, (Object)this);
        int checkIntervalSeconds = HgGlobalSettings.getIncomingCheckIntervalSeconds();
        this.changesUpdaterScheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.update(this.myVcs.getProject()), 5L, checkIntervalSeconds, TimeUnit.SECONDS);
    }

    public void deactivate() {
        this.busConnection.disconnect();
        if (this.changesUpdaterScheduledFuture != null) {
            this.changesUpdaterScheduledFuture.cancel(true);
        }
    }

    private void updateChangesStatusSynchronously(Project project, VirtualFile[] roots, HgChangesetStatus status, boolean incoming) {
        if (!this.myProjectSettings.isCheckIncomingOutgoing()) {
            return;
        }
        LinkedList<HgRevisionNumber> changesets = new LinkedList<HgRevisionNumber>();
        for (VirtualFile root : roots) {
            if (incoming) {
                changesets.addAll(new HgIncomingCommand(project).executeInCurrentThread(root));
                continue;
            }
            changesets.addAll(new HgOutgoingCommand(project).executeInCurrentThread(root));
        }
        status.setChanges(changesets.size(), new ChangesetFormatter(status, changesets));
    }

    private static String getProgressTitle() {
        return "Checking Incoming and Outgoing Changes";
    }

    protected boolean isCheckingEnabled() {
        return this.myProjectSettings.isCheckIncomingOutgoing();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/zmlx/hg4idea/status/HgRemoteStatusUpdater", "<init>"));
    }

    private static final class ChangesetFormatter
    implements HgChangesetStatus.ChangesetWriter {
        private final String string;

        private ChangesetFormatter(HgChangesetStatus status, List<HgRevisionNumber> changesets) {
            StringBuilder builder = new StringBuilder();
            builder.append("<b>").append(status.getStatusName()).append(" changesets</b>:<br>");
            for (HgRevisionNumber revisionNumber : changesets) {
                builder.append(revisionNumber.asString()).append(" ").append(revisionNumber.getCommitMessage()).append(" (").append(revisionNumber.getAuthor()).append(")<br>");
            }
            this.string = XmlStringUtil.wrapInHtml((CharSequence)builder);
        }

        @Override
        public String asString() {
            return this.string;
        }
    }
}

