/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.LoadingPhase;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.HeadlessDataManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.Main;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.RegistryKeyBean;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.ui.IconManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaTestApplication
implements Disposable {
    private static volatile IdeaTestApplication ourInstance;
    private static volatile RuntimeException bootstrapError;
    private static volatile boolean isBootstrappingAppNow;

    private IdeaTestApplication() {
    }

    public void setDataProvider(@Nullable DataProvider provider) {
        IdeaTestApplication.getDataManager().setTestDataProvider(provider);
    }

    public void setDataProvider(@Nullable DataProvider provider, Disposable parentDisposable) {
        IdeaTestApplication.getDataManager().setTestDataProvider(provider, parentDisposable);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            IdeaTestApplication.$$$reportNull$$$0(0);
        }
        return IdeaTestApplication.getDataManager().getDataContext().getData(dataId);
    }

    private static HeadlessDataManager getDataManager() {
        return (HeadlessDataManager)ApplicationManager.getApplication().getComponent(DataManager.class);
    }

    public static IdeaTestApplication getInstance() {
        return IdeaTestApplication.getInstance(null);
    }

    public static IdeaTestApplication getInstance(@Nullable String configPath) {
        IdeaTestApplication instance2 = ourInstance;
        if (instance2 == null) {
            try {
                instance2 = IdeaTestApplication.createInstance(configPath);
            }
            catch (RuntimeException e) {
                bootstrapError = e;
                isBootstrappingAppNow = false;
                throw e;
            }
        }
        return instance2;
    }

    @NotNull
    private static synchronized IdeaTestApplication createInstance(@Nullable String configPath) {
        if (ourInstance != null) {
            IdeaTestApplication ideaTestApplication = ourInstance;
            if (ideaTestApplication == null) {
                IdeaTestApplication.$$$reportNull$$$0(1);
            }
            return ideaTestApplication;
        }
        if (bootstrapError != null) {
            throw bootstrapError;
        }
        if (isBootstrappingAppNow) {
            throw new IllegalStateException("App bootstrap is already in process");
        }
        isBootstrappingAppNow = true;
        PlatformTestCase.doAutodetectPlatformPrefix();
        String[] args = new String[]{"inspect", "", "", ""};
        Main.setFlags((String[])args);
        assert (Main.isHeadless());
        assert (Main.isCommandLine());
        PluginManagerCore.isUnitTestMode = true;
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        Future<List> loadedPluginFuture = AppExecutorUtil.getAppExecutorService().submit(() -> PluginManagerCore.getLoadedPlugins());
        ApplicationImpl.patchSystem();
        ApplicationImpl app = new ApplicationImpl(true, true, true, true, "idea");
        IconManager.activate();
        List loadedPlugins = null;
        try {
            loadedPlugins = loadedPluginFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            ExceptionUtil.rethrow((Throwable)(e.getCause() == null ? e : e.getCause()));
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
        }
        ApplicationImpl.registerMessageBusListeners((Application)app, (List)loadedPlugins, (boolean)true);
        app.registerComponents(loadedPlugins);
        RegistryKeyBean.addKeysFromPlugins();
        app.load(configPath, null);
        LoadingPhase.setCurrentPhase((LoadingPhase)LoadingPhase.FRAME_SHOWN);
        isBootstrappingAppNow = false;
        IdeaTestApplication ideaTestApplication = ourInstance = new IdeaTestApplication();
        if (ideaTestApplication == null) {
            IdeaTestApplication.$$$reportNull$$$0(2);
        }
        return ideaTestApplication;
    }

    public void dispose() {
        IdeaTestApplication.disposeInstance();
    }

    private static synchronized void disposeInstance() {
        if (ourInstance != null) {
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                Disposer.dispose((Disposable)application);
            }
            ourInstance = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/IdeaTestApplication";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/IdeaTestApplication";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

