/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Consumer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.sdk.CredentialsTypeExChecker;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageUtil {
    public static final String SETUPTOOLS = "setuptools";
    public static final String PIP = "pip";
    public static final String DISTRIBUTE = "distribute";
    private static final Logger LOG = Logger.getInstance(PyPackageUtil.class);
    @NotNull
    private static final String REQUIRES = "requires";
    @NotNull
    private static final String INSTALL_REQUIRES = "install_requires";
    @NotNull
    private static final String[] SETUP_PY_REQUIRES_KWARGS_NAMES = new String[]{"requires", "install_requires", "setup_requires", "tests_require"};
    @NotNull
    private static final String DEPENDENCY_LINKS = "dependency_links";

    private PyPackageUtil() {
    }

    public static boolean hasSetupPy(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(0);
        }
        return PyPackageUtil.findSetupPy(module2) != null;
    }

    @Nullable
    public static PyFile findSetupPy(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(1);
        }
        for (VirtualFile root : PyUtil.getSourceRoots(module2)) {
            PsiFile file;
            VirtualFile child = root.findChild("setup.py");
            if (child == null || !((file = PsiManager.getInstance((Project)module2.getProject()).findFile(child)) instanceof PyFile)) continue;
            return (PyFile)file;
        }
        return null;
    }

    public static boolean hasRequirementsTxt(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(2);
        }
        return PyPackageUtil.findRequirementsTxt(module2) != null;
    }

    @Nullable
    public static VirtualFile findRequirementsTxt(@NotNull Module module2) {
        String requirementsPath;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(3);
        }
        if (!(requirementsPath = PyPackageRequirementsSettings.getInstance(module2).getRequirementsPath()).isEmpty()) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(requirementsPath);
            if (file != null) {
                return file;
            }
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)module2);
            for (VirtualFile root : manager.getContentRoots()) {
                VirtualFile fileInRoot = root.findFileByRelativePath(requirementsPath);
                if (fileInRoot == null) continue;
                return fileInRoot;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement findSetupPyInstallRequires(@Nullable PyCallExpression setupCall) {
        if (setupCall == null) {
            return null;
        }
        return StreamEx.of((Object[])new String[]{REQUIRES, INSTALL_REQUIRES}).map(setupCall::getKeywordArgument).map(PyPackageUtil::resolveValue).findFirst(Objects::nonNull).orElse(null);
    }

    @Nullable
    public static List<PyRequirement> findSetupPyRequires(@NotNull Module module2) {
        PyCallExpression setupCall;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(4);
        }
        if ((setupCall = PyPackageUtil.findSetupCall(module2)) == null) {
            return null;
        }
        List<PyRequirement> requirementsFromRequires = PyPackageUtil.getSetupPyRequiresFromArguments(setupCall, SETUP_PY_REQUIRES_KWARGS_NAMES);
        List<PyRequirement> requirementsFromLinks = PyPackageUtil.getSetupPyRequiresFromArguments(setupCall, DEPENDENCY_LINKS);
        return PyPackageUtil.mergeSetupPyRequirements(requirementsFromRequires, requirementsFromLinks);
    }

    @Nullable
    public static Map<String, List<PyRequirement>> findSetupPyExtrasRequire(@NotNull Module module2) {
        PyCallExpression setupCall;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(5);
        }
        if ((setupCall = PyPackageUtil.findSetupCall(module2)) == null) {
            return null;
        }
        PyDictLiteralExpression extrasRequire = PyUtil.as(PyPackageUtil.resolveValue(setupCall.getKeywordArgument("extras_require")), PyDictLiteralExpression.class);
        if (extrasRequire == null) {
            return null;
        }
        HashMap<String, List<PyRequirement>> result = new HashMap<String, List<PyRequirement>>();
        for (PyKeyValueExpression extraRequires : extrasRequire.getElements()) {
            Pair<String, List<PyRequirement>> extraResult = PyPackageUtil.getExtraRequires(extraRequires.getKey(), extraRequires.getValue());
            if (extraResult == null) continue;
            result.put((String)extraResult.first, (List<PyRequirement>)extraResult.second);
        }
        return result;
    }

    @Nullable
    private static Pair<String, List<PyRequirement>> getExtraRequires(@NotNull PyExpression extra, @Nullable PyExpression requires) {
        List<String> requiresValue;
        if (extra == null) {
            PyPackageUtil.$$$reportNull$$$0(6);
        }
        if (extra instanceof PyStringLiteralExpression && (requiresValue = PyPackageUtil.resolveRequiresValue(requires)) != null) {
            return Pair.createNonNull((Object)((PyStringLiteralExpression)extra).getStringValue(), PyRequirementParser.fromText(StringUtil.join(requiresValue, (String)"\n")));
        }
        return null;
    }

    @NotNull
    private static List<PyRequirement> getSetupPyRequiresFromArguments(@NotNull PyCallExpression setupCall, String ... argumentNames) {
        if (setupCall == null) {
            PyPackageUtil.$$$reportNull$$$0(7);
        }
        if (argumentNames == null) {
            PyPackageUtil.$$$reportNull$$$0(8);
        }
        List<PyRequirement> list = PyRequirementParser.fromText(StreamEx.of((Object[])argumentNames).map(setupCall::getKeywordArgument).flatCollection(PyPackageUtil::resolveRequiresValue).joining((CharSequence)"\n"));
        if (list == null) {
            PyPackageUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static List<PyRequirement> mergeSetupPyRequirements(@NotNull List<PyRequirement> requirementsFromRequires, @NotNull List<PyRequirement> requirementsFromLinks) {
        if (requirementsFromRequires == null) {
            PyPackageUtil.$$$reportNull$$$0(10);
        }
        if (requirementsFromLinks == null) {
            PyPackageUtil.$$$reportNull$$$0(11);
        }
        if (!requirementsFromLinks.isEmpty()) {
            Map nameToRequirements = requirementsFromRequires.stream().collect(Collectors.groupingBy(PyRequirement::getName, LinkedHashMap::new, Collectors.toList()));
            for (PyRequirement requirementFromLinks : requirementsFromLinks) {
                nameToRequirements.replace(requirementFromLinks.getName(), Collections.singletonList(requirementFromLinks));
            }
            List list = nameToRequirements.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
            if (list == null) {
                PyPackageUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<PyRequirement> list = requirementsFromRequires;
        if (list == null) {
            PyPackageUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    private static PsiElement resolveValue(@Nullable PyExpression expression) {
        PyExpression elementToAnalyze = PyPsiUtils.flattenParens(expression);
        if (elementToAnalyze instanceof PyReferenceExpression) {
            TypeEvalContext context = TypeEvalContext.deepCodeInsight(elementToAnalyze.getProject());
            PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
            return StreamEx.of(((PyReferenceExpression)elementToAnalyze).multiFollowAssignmentsChain(resolveContext)).map(ResolveResult::getElement).findFirst(Objects::nonNull).map(e -> e instanceof PyExpression ? PyPsiUtils.flattenParens((PyExpression)e) : e).orElse(null);
        }
        return elementToAnalyze;
    }

    @Nullable
    private static List<String> resolveRequiresValue(@Nullable PyExpression expression) {
        PsiElement elementToAnalyze = PyPackageUtil.resolveValue(expression);
        if (elementToAnalyze instanceof PyStringLiteralExpression) {
            return Collections.singletonList(((PyStringLiteralExpression)elementToAnalyze).getStringValue());
        }
        if (elementToAnalyze instanceof PyListLiteralExpression || elementToAnalyze instanceof PyTupleExpression) {
            return StreamEx.of((Object[])((PySequenceExpression)elementToAnalyze).getElements()).map(PyPackageUtil::resolveValue).select(PyStringLiteralExpression.class).map(StringLiteralExpression::getStringValue).toList();
        }
        return null;
    }

    @NotNull
    public static List<String> getPackageNames(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(14);
        }
        ArrayList<String> packageNames = new ArrayList<String>();
        Project project = module2.getProject();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
        if (roots.length == 0) {
            roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        }
        for (VirtualFile root : roots) {
            PyPackageUtil.collectPackageNames(project, root, packageNames);
        }
        ArrayList<String> arrayList = packageNames;
        if (arrayList == null) {
            PyPackageUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static String requirementsToString(@NotNull List<? extends PyRequirement> requirements) {
        if (requirements == null) {
            PyPackageUtil.$$$reportNull$$$0(16);
        }
        String string = StringUtil.join(requirements, requirement -> String.format("'%s'", requirement.getPresentableText()), (String)", ");
        if (string == null) {
            PyPackageUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    private static PyCallExpression findSetupCall(@NotNull PyFile file) {
        if (file == null) {
            PyPackageUtil.$$$reportNull$$$0(18);
        }
        final Ref result = new Ref(null);
        file.acceptChildren(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                PyExpression callee = node.getCallee();
                String name = PyUtil.getReadableRepr((PsiElement)callee, true);
                if ("setup".equals(name)) {
                    result.set((Object)node);
                }
            }

            @Override
            public void visitPyElement(PyElement node) {
                if (!(node instanceof ScopeOwner)) {
                    super.visitPyElement(node);
                }
            }
        });
        return (PyCallExpression)result.get();
    }

    @Nullable
    public static PyCallExpression findSetupCall(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(19);
        }
        return Optional.ofNullable(PyPackageUtil.findSetupPy(module2)).map(PyPackageUtil::findSetupCall).orElse(null);
    }

    private static void collectPackageNames(@NotNull Project project, final @NotNull VirtualFile root, final @NotNull List<String> results) {
        if (project == null) {
            PyPackageUtil.$$$reportNull$$$0(20);
        }
        if (root == null) {
            PyPackageUtil.$$$reportNull$$$0(21);
        }
        if (results == null) {
            PyPackageUtil.$$$reportNull$$$0(22);
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file.equals(root)) {
                    return true;
                }
                if (!fileIndex.isExcluded(file) && file.isDirectory() && file.findChild("__init__.py") != null) {
                    results.add(VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'.'));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/packaging/PyPackageUtil$2", "visitFile"));
            }
        });
    }

    public static boolean packageManagementEnabled(@Nullable Sdk sdk) {
        if (!PythonSdkType.isRemote(sdk)) {
            return true;
        }
        return new CredentialsTypeExChecker(){

            @Override
            protected boolean checkLanguageContribution(PyCredentialsContribution languageContribution) {
                return languageContribution.isPackageManagementEnabled();
            }
        }.withSshContribution(true).withVagrantContribution(true).withWebDeploymentContribution(true).check(sdk);
    }

    @NotNull
    public static List<PyPackage> refreshAndGetPackagesModally(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyPackageUtil.$$$reportNull$$$0(23);
        }
        Application app = ApplicationManager.getApplication();
        assert (!app.isWriteAccessAllowed()) : "This method can't be called on WriteAction because refreshAndGetPackages would be called on AWT thread in this case (see runProcessWithProgressSynchronously) and may lead to freeze";
        Ref packagesRef = Ref.create();
        Throwable callStacktrace = new Throwable();
        LOG.debug("Showing modal progress for collecting installed packages", new Throwable());
        PyUtil.runWithProgress(null, PyBundle.message("sdk.scanning.installed.packages", new Object[0]), true, false, (Consumer<? super ProgressIndicator>)((Consumer)indicator -> {
            indicator.setIndeterminate(true);
            try {
                PyPackageManager manager = PyPackageManager.getInstance(sdk);
                packagesRef.set(manager.refreshAndGetPackages(false));
            }
            catch (ExecutionException e) {
                packagesRef.set(Collections.emptyList());
                e.initCause(callStacktrace);
                LOG.warn((Throwable)e);
            }
        }));
        List list = (List)packagesRef.get();
        if (list == null) {
            PyPackageUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    public static boolean updatePackagesSynchronouslyWithGuard(@NotNull PyPackageManager manager, @NotNull AtomicBoolean isUpdating) {
        if (manager == null) {
            PyPackageUtil.$$$reportNull$$$0(25);
        }
        if (isUpdating == null) {
            PyPackageUtil.$$$reportNull$$$0(26);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (!isUpdating.compareAndSet(false, true)) {
            return false;
        }
        try {
            if (manager instanceof PyPackageManagerImpl) {
                LOG.info("Refreshing installed packages for SDK " + ((PyPackageManagerImpl)manager).getSdk().getHomePath());
            }
            manager.refreshAndGetPackages(true);
        }
        catch (ExecutionException executionException) {
        }
        finally {
            isUpdating.set(false);
        }
        return true;
    }

    @Nullable
    public static PyPackage findPackage(@NotNull List<? extends PyPackage> packages, @NotNull String name) {
        if (packages == null) {
            PyPackageUtil.$$$reportNull$$$0(27);
        }
        if (name == null) {
            PyPackageUtil.$$$reportNull$$$0(28);
        }
        for (PyPackage pyPackage : packages) {
            if (!name.equalsIgnoreCase(pyPackage.getName())) continue;
            return pyPackage;
        }
        return null;
    }

    public static boolean hasManagement(@NotNull List<? extends PyPackage> packages) {
        if (packages == null) {
            PyPackageUtil.$$$reportNull$$$0(29);
        }
        return PyPackageUtil.findPackage(packages, SETUPTOOLS) != null || PyPackageUtil.findPackage(packages, DISTRIBUTE) != null || PyPackageUtil.findPackage(packages, PIP) != null;
    }

    @Nullable
    public static List<PyRequirement> getRequirementsFromTxt(@NotNull Module module2) {
        VirtualFile requirementsTxt;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(30);
        }
        if ((requirementsTxt = PyPackageUtil.findRequirementsTxt(module2)) != null) {
            return PyRequirementParser.fromFile(requirementsTxt);
        }
        return null;
    }

    public static void addRequirementToTxtOrSetupPy(@NotNull Module module2, @NotNull String requirementName, @NotNull LanguageLevel languageLevel) {
        VirtualFile requirementsTxt;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(31);
        }
        if (requirementName == null) {
            PyPackageUtil.$$$reportNull$$$0(32);
        }
        if (languageLevel == null) {
            PyPackageUtil.$$$reportNull$$$0(33);
        }
        if ((requirementsTxt = PyPackageUtil.findRequirementsTxt(module2)) != null && requirementsTxt.isWritable()) {
            Document document = FileDocumentManager.getInstance().getDocument(requirementsTxt);
            if (document != null) {
                document.insertString(0, (CharSequence)(requirementName + "\n"));
            }
            return;
        }
        PyFile setupPy = PyPackageUtil.findSetupPy(module2);
        if (setupPy == null) {
            return;
        }
        PyCallExpression setupCall = PyPackageUtil.findSetupCall(setupPy);
        if (setupCall == null) {
            return;
        }
        PsiElement installRequires = PyPackageUtil.findSetupPyInstallRequires(setupCall);
        if (installRequires != null) {
            PyPackageUtil.addRequirementToInstallRequires(installRequires, requirementName, languageLevel);
        } else {
            PyArgumentList argumentList = setupCall.getArgumentList();
            PyKeywordArgument requiresArg = PyPackageUtil.generateRequiresKwarg(setupPy, requirementName, languageLevel);
            if (argumentList != null && requiresArg != null) {
                argumentList.addArgument(requiresArg);
            }
        }
    }

    private static void addRequirementToInstallRequires(@NotNull PsiElement installRequires, @NotNull String requirementName, @NotNull LanguageLevel languageLevel) {
        if (installRequires == null) {
            PyPackageUtil.$$$reportNull$$$0(34);
        }
        if (requirementName == null) {
            PyPackageUtil.$$$reportNull$$$0(35);
        }
        if (languageLevel == null) {
            PyPackageUtil.$$$reportNull$$$0(36);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(installRequires.getProject());
        PyExpression newRequirement = generator.createExpressionFromText(languageLevel, "'" + requirementName + "'");
        if (installRequires instanceof PyListLiteralExpression) {
            installRequires.add((PsiElement)newRequirement);
        } else if (installRequires instanceof PyTupleExpression) {
            String newInstallRequiresText = StreamEx.of((Object[])((PyTupleExpression)installRequires).getElements()).append((Object)newRequirement).map(PsiElement::getText).joining((CharSequence)",", (CharSequence)"(", (CharSequence)")");
            PyExpression expression = generator.createExpressionFromText(languageLevel, newInstallRequiresText);
            Optional.ofNullable(PyUtil.as(expression, PyParenthesizedExpression.class)).map(PyParenthesizedExpression::getContainedExpression).map(e -> PyUtil.as(e, PyTupleExpression.class)).ifPresent(e -> installRequires.replace((PsiElement)e));
        } else if (installRequires instanceof PyStringLiteralExpression) {
            PyListLiteralExpression newInstallRequires = generator.createListLiteral();
            newInstallRequires.add(installRequires);
            newInstallRequires.add((PsiElement)newRequirement);
            installRequires.replace((PsiElement)newInstallRequires);
        }
    }

    @Nullable
    private static PyKeywordArgument generateRequiresKwarg(@NotNull PyFile setupPy, @NotNull String requirementName, @NotNull LanguageLevel languageLevel) {
        if (setupPy == null) {
            PyPackageUtil.$$$reportNull$$$0(37);
        }
        if (requirementName == null) {
            PyPackageUtil.$$$reportNull$$$0(38);
        }
        if (languageLevel == null) {
            PyPackageUtil.$$$reportNull$$$0(39);
        }
        String keyword = PyPsiUtils.containsImport(setupPy, SETUPTOOLS) ? INSTALL_REQUIRES : REQUIRES;
        String text2 = String.format("foo(%s=['%s'])", keyword, requirementName);
        PyExpression generated = PyElementGenerator.getInstance(setupPy.getProject()).createExpressionFromText(languageLevel, text2);
        if (generated instanceof PyCallExpression) {
            PyCallExpression callExpression = (PyCallExpression)generated;
            return Stream.of(callExpression.getArguments()).filter(PyKeywordArgument.class::isInstance).map(PyKeywordArgument.class::cast).filter(kwarg -> keyword.equals(kwarg.getKeyword())).findFirst().orElse(null);
        }
        return null;
    }

    public static void runOnChangeUnderInterpreterPaths(@NotNull Sdk sdk, final @NotNull Runnable runnable) {
        if (sdk == null) {
            PyPackageUtil.$$$reportNull$$$0(40);
        }
        if (runnable == null) {
            PyPackageUtil.$$$reportNull$$$0(41);
        }
        final Application app = ApplicationManager.getApplication();
        final VirtualFile[] roots = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    4.$$$reportNull$$$0(0);
                }
                block0: for (VFileEvent vFileEvent : events) {
                    VirtualFile file = vFileEvent instanceof VFileCreateEvent ? ((VFileCreateEvent)vFileEvent).getParent() : vFileEvent.getFile();
                    if (file == null) continue;
                    for (VirtualFile root : roots) {
                        if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                        app.executeOnPooledThread(runnable);
                        break block0;
                    }
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/python/packaging/PyPackageUtil$4", "prepareChange"));
            }
        }, (Disposable)app);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupCall";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentNames";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementsFromRequires";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementsFromLinks";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 23: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isUpdating";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementName";
                break;
            }
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installRequires";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupPy";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetupPyRequiresFromArguments";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSetupPyRequirements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "requirementsToString";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackagesModally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasSetupPy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasRequirementsTxt";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRequirementsTxt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPyRequires";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPyExtrasRequire";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtraRequires";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSetupPyRequiresFromArguments";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 24: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mergeSetupPyRequirements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "requirementsToString";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSetupCall";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectPackageNames";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetPackagesModally";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updatePackagesSynchronouslyWithGuard";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasManagement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRequirementsFromTxt";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addRequirementToTxtOrSetupPy";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addRequirementToInstallRequires";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "generateRequiresKwarg";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "runOnChangeUnderInterpreterPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

