/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.codeInsight.imports.ImportFromExistingAction;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoImportQuickFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    private final List<ImportCandidateHolder> myImports;
    private final String myInitialName;
    private final boolean myUseQualifiedImport;
    private final Class<? extends PsiReference> myReferenceType;
    private boolean myExpended;

    public AutoImportQuickFix(@NotNull PsiElement node, @NotNull Class<? extends PsiReference> referenceType, @NotNull String name, boolean qualify) {
        if (node == null) {
            AutoImportQuickFix.$$$reportNull$$$0(0);
        }
        if (referenceType == null) {
            AutoImportQuickFix.$$$reportNull$$$0(1);
        }
        if (name == null) {
            AutoImportQuickFix.$$$reportNull$$$0(2);
        }
        this(node, referenceType, name, qualify, Collections.emptyList());
    }

    private AutoImportQuickFix(@NotNull PsiElement node, @NotNull Class<? extends PsiReference> referenceType, @NotNull String name, boolean qualify, @NotNull Collection<ImportCandidateHolder> candidates) {
        if (node == null) {
            AutoImportQuickFix.$$$reportNull$$$0(3);
        }
        if (referenceType == null) {
            AutoImportQuickFix.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AutoImportQuickFix.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            AutoImportQuickFix.$$$reportNull$$$0(6);
        }
        super(node);
        this.myExpended = false;
        this.myReferenceType = referenceType;
        this.myInitialName = name;
        this.myUseQualifiedImport = qualify;
        this.myImports = new ArrayList<ImportCandidateHolder>(candidates);
    }

    public void addImport(@NotNull PsiElement importable, @NotNull PsiFile file, @Nullable PyImportElement importElement) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(8);
        }
        this.myImports.add(new ImportCandidateHolder(importable, (PsiFileSystemItem)file, importElement, null));
    }

    public void addImport(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file, @Nullable QualifiedName path) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(9);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(10);
        }
        this.myImports.add(new ImportCandidateHolder(importable, file, null, path));
    }

    public void addImport(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file, @Nullable QualifiedName path, @Nullable String asName) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(11);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(12);
        }
        this.myImports.add(new ImportCandidateHolder(importable, file, null, path, asName));
    }

    @NotNull
    public String getText() {
        if (this.myUseQualifiedImport) {
            String string = PyBundle.message("ACT.qualify.with.module", new Object[0]);
            if (string == null) {
                AutoImportQuickFix.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (this.myImports.size() == 1) {
            String string = PyBundle.message("QFIX.auto.import.import.name", this.myImports.get(0).getPresentableText(this.myInitialName));
            if (string == null) {
                AutoImportQuickFix.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = PyBundle.message("QFIX.auto.import.import.this.name", new Object[0]);
        if (string == null) {
            AutoImportQuickFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.auto.import.family", new Object[0]);
        if (string == null) {
            AutoImportQuickFix.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean showHint(Editor editor2) {
        if (!PyCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP || HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true) || this.myImports.isEmpty()) {
            return false;
        }
        PsiElement element = this.getStartElement();
        PyPsiUtils.assertValid(element);
        if (element == null || !element.isValid()) {
            return false;
        }
        PyElement pyElement = PyUtil.as(element, PyElement.class);
        if (pyElement == null || !this.myInitialName.equals(pyElement.getName())) {
            return false;
        }
        PsiReference reference = this.findOriginalReference(element);
        if (reference == null || AutoImportQuickFix.isResolved(reference)) {
            return false;
        }
        if (element instanceof PyQualifiedExpression && ((PyQualifiedExpression)element).isQualified()) {
            return false;
        }
        String message = ShowAutoImportPass.getMessage((this.myImports.size() > 1 ? 1 : 0) != 0, (String)ImportCandidateHolder.getQualifiedName(this.myInitialName, this.myImports.get(0).getPath(), this.myImports.get(0).getImportElement()));
        ImportFromExistingAction action = new ImportFromExistingAction(element, this.myImports, this.myInitialName, this.myUseQualifiedImport, false);
        action.onDone(() -> {
            this.myExpended = true;
        });
        HintManager.getInstance().showQuestionHint(editor2, message, element.getTextOffset(), element.getTextRange().getEndOffset(), (QuestionAction)action);
        return true;
    }

    public boolean isAvailable() {
        PsiElement element = this.getStartElement();
        if (element == null) {
            return false;
        }
        PyPsiUtils.assertValid(element);
        return !this.myExpended && element.isValid() && !this.myImports.isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AutoImportQuickFix.$$$reportNull$$$0(17);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(18);
        }
        if (startElement == null) {
            AutoImportQuickFix.$$$reportNull$$$0(19);
        }
        if (endElement == null) {
            AutoImportQuickFix.$$$reportNull$$$0(20);
        }
        this.invoke(this.getStartElement().getContainingFile());
    }

    public void invoke(PsiFile file) throws IncorrectOperationException {
        PsiElement startElement = this.getStartElement();
        if (startElement == null) {
            return;
        }
        PyPsiUtils.assertValid(startElement);
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiReference reference = this.findOriginalReference(startElement);
        if (reference == null || AutoImportQuickFix.isResolved(reference)) {
            return;
        }
        ImportFromExistingAction action = this.createAction();
        action.execute();
        this.myExpended = true;
    }

    @NotNull
    protected ImportFromExistingAction createAction() {
        ImportFromExistingAction importFromExistingAction = new ImportFromExistingAction(this.getStartElement(), this.myImports, this.myInitialName, this.myUseQualifiedImport, false);
        if (importFromExistingAction == null) {
            AutoImportQuickFix.$$$reportNull$$$0(21);
        }
        return importFromExistingAction;
    }

    public void sortCandidates() {
        Collections.sort(this.myImports);
    }

    @NotNull
    public List<ImportCandidateHolder> getCandidates() {
        List<ImportCandidateHolder> list = Collections.unmodifiableList(this.myImports);
        if (list == null) {
            AutoImportQuickFix.$$$reportNull$$$0(22);
        }
        return list;
    }

    public boolean hasOnlyFunctions() {
        for (ImportCandidateHolder holder : this.myImports) {
            if (holder.getImportable() instanceof PyFunction) continue;
            return false;
        }
        return true;
    }

    public boolean hasProjectImports() {
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.getStartElement().getProject());
        for (ImportCandidateHolder anImport : this.myImports) {
            PsiFileSystemItem importFile = anImport.getFile();
            VirtualFile file = importFile != null ? importFile.getVirtualFile() : null;
            if (file == null || !fileIndex.isInContent(file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public AutoImportQuickFix forLocalImport() {
        AutoImportQuickFix autoImportQuickFix = new AutoImportQuickFix(this.getStartElement(), this.myReferenceType, this.myInitialName, this.myUseQualifiedImport, this.myImports){

            @Override
            @NotNull
            public String getFamilyName() {
                String string = PyBundle.message("QFIX.local.auto.import.family", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getText() {
                String string = PyBundle.message("QFIX.local.auto.import.import.locally", super.getText());
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            protected ImportFromExistingAction createAction() {
                ImportFromExistingAction importFromExistingAction = new ImportFromExistingAction(this.getStartElement(), AutoImportQuickFix.this.myImports, AutoImportQuickFix.this.myInitialName, AutoImportQuickFix.this.myUseQualifiedImport, true);
                if (importFromExistingAction == null) {
                    1.$$$reportNull$$$0(2);
                }
                return importFromExistingAction;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAction";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (autoImportQuickFix == null) {
            AutoImportQuickFix.$$$reportNull$$$0(23);
        }
        return autoImportQuickFix;
    }

    @NotNull
    public String getNameToImport() {
        String string = this.myInitialName;
        if (string == null) {
            AutoImportQuickFix.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static boolean isResolved(@NotNull PsiReference reference) {
        if (reference == null) {
            AutoImportQuickFix.$$$reportNull$$$0(25);
        }
        if (reference instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)reference).multiResolve(false).length > 0;
        }
        return reference.resolve() != null;
    }

    @Nullable
    private PsiReference findOriginalReference(@NotNull PsiElement element) {
        if (element == null) {
            AutoImportQuickFix.$$$reportNull$$$0(26);
        }
        return (PsiReference)ContainerUtil.findInstance((Object[])element.getReferences(), this.myReferenceType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importable";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createAction";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "forLocalImport";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

