/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleToolWindowPanel
extends JBPanelWithEmptyText
implements QuickActionProvider,
DataProvider {
    private JComponent myToolbar;
    private JComponent myContent;
    private final boolean myBorderless;
    protected boolean myVertical;
    private boolean myProvideQuickActions;

    public SimpleToolWindowPanel(boolean vertical) {
        this(vertical, false);
    }

    public SimpleToolWindowPanel(boolean vertical, boolean borderless) {
        this.setLayout(new BorderLayout(vertical ? 0 : 1, vertical ? 1 : 0));
        this.myBorderless = borderless;
        this.myVertical = vertical;
        this.setProvideQuickActions(true);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof Container) {
                    ((Container)child).addContainerListener(this);
                }
                if (SimpleToolWindowPanel.this.myBorderless) {
                    UIUtil.removeScrollBorder((Component)((Object)SimpleToolWindowPanel.this));
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof Container) {
                    ((Container)child).removeContainerListener(this);
                }
            }
        });
    }

    public boolean isVertical() {
        return this.myVertical;
    }

    public void setVertical(boolean vertical) {
        if (this.myVertical == vertical) {
            return;
        }
        this.removeAll();
        this.myVertical = vertical;
        this.setContent(this.myContent);
        this.setToolbar(this.myToolbar);
    }

    public boolean isToolbarVisible() {
        return this.myToolbar != null && this.myToolbar.isVisible();
    }

    @Nullable
    public JComponent getToolbar() {
        return this.myToolbar;
    }

    public void setToolbar(@Nullable JComponent c) {
        if (c == null) {
            this.remove(this.myToolbar);
        }
        this.myToolbar = c;
        if (this.myToolbar instanceof ActionToolbar) {
            ((ActionToolbar)((Object)this.myToolbar)).setOrientation(this.myVertical ? 0 : 1);
        }
        if (c != null) {
            if (this.myVertical) {
                this.add(c, "North");
            } else {
                this.add(c, "West");
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            SimpleToolWindowPanel.$$$reportNull$$$0(0);
        }
        return QuickActionProvider.KEY.is(dataId) && this.myProvideQuickActions ? this : null;
    }

    public SimpleToolWindowPanel setProvideQuickActions(boolean provide) {
        this.myProvideQuickActions = provide;
        return this;
    }

    @Override
    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        JBIterable toolbars = UIUtil.uiTraverser((Component)this.myToolbar).traverse().filter(ActionToolbar.class);
        if (toolbars.size() == 0) {
            List<AnAction> list = Collections.emptyList();
            if (list == null) {
                SimpleToolWindowPanel.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = toolbars.flatten(toolbar -> toolbar.getActions()).toList();
        if (list == null) {
            SimpleToolWindowPanel.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Nullable
    public JComponent getContent() {
        return this.myContent;
    }

    public void setContent(@NotNull JComponent c) {
        if (c == null) {
            SimpleToolWindowPanel.$$$reportNull$$$0(3);
        }
        if (this.myContent != null) {
            this.remove(this.myContent);
        }
        this.myContent = c;
        this.add(c, "Center");
        if (this.myBorderless) {
            UIUtil.removeScrollBorder((Component)c);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myToolbar != null && this.myToolbar.getParent() == this && this.myContent != null && this.myContent.getParent() == this) {
            g.setColor(JBColor.border());
            if (this.myVertical) {
                int y = (int)this.myToolbar.getBounds().getMaxY();
                UIUtil.drawLine((Graphics)g, (int)0, (int)y, (int)this.getWidth(), (int)y);
            } else {
                int x = (int)this.myToolbar.getBounds().getMaxX();
                UIUtil.drawLine((Graphics)g, (int)x, (int)0, (int)x, (int)this.getHeight());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/SimpleToolWindowPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/SimpleToolWindowPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

