/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.util.DocumentUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AfterLineEndInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, AfterLineEndInlayImpl> {
    private static int ourGlobalCounter = 0;
    final int myOrder;

    AfterLineEndInlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, @NotNull R renderer2) {
        if (editor == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer2 == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(1);
        }
        super(editor, offset, relatesToPrecedingText, renderer2);
        this.myOrder = ourGlobalCounter++;
    }

    @Override
    RangeMarkerTree<AfterLineEndInlayImpl> getTree() {
        return this.myEditor.getInlayModel().myAfterLineEndElementsTree;
    }

    @Override
    void doUpdateSize() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels <= 0) {
            throw new IllegalArgumentException("Positive width should be defined for an after-line-end element");
        }
    }

    @Override
    Point getPosition() {
        VisualPosition pos = this.getVisualPosition();
        return this.myEditor.visualPositionToXY(pos);
    }

    @Override
    @Nullable
    public Rectangle getBounds() {
        int targetOffset = DocumentUtil.getLineEndOffset(this.getOffset(), this.myEditor.getDocument());
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(targetOffset)) {
            return null;
        }
        Point pos = this.getPosition();
        return new Rectangle(pos.x, pos.y, this.getWidthInPixels(), this.getHeightInPixels());
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        Inlay.Placement placement = Inlay.Placement.AFTER_LINE_END;
        if (placement == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(2);
        }
        return placement;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        int offset = this.getOffset();
        int logicalLine = this.myEditor.getDocument().getLineNumber(offset);
        int lineEndOffset = this.myEditor.getDocument().getLineEndOffset(logicalLine);
        VisualPosition position = this.myEditor.offsetToVisualPosition(lineEndOffset, true, true);
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(lineEndOffset)) {
            VisualPosition visualPosition = position;
            if (visualPosition == null) {
                AfterLineEndInlayImpl.$$$reportNull$$$0(3);
            }
            return visualPosition;
        }
        List<Inlay> inlays = this.myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
        int order = inlays.indexOf(this);
        VisualPosition visualPosition = new VisualPosition(position.line, position.column + 1 + order);
        if (visualPosition == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(4);
        }
        return visualPosition;
    }

    public int getHeightInPixels() {
        return this.myEditor.getLineHeight();
    }

    @Override
    public String toString() {
        return "[After-line-end inlay, offset=" + this.getOffset() + ", width=" + this.myWidthInPixels + ", renderer=" + this.myRenderer + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/AfterLineEndInlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/AfterLineEndInlayImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlacement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

