/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jdkEx;

import com.intellij.jdkEx.DefDisplayModeEx;
import com.intellij.jdkEx.DefInputEventEx;
import com.intellij.jdkEx.DisplayModeEx;
import com.intellij.jdkEx.InputEventEx;
import com.intellij.jdkEx.JBDisplayModeEx;
import com.intellij.jdkEx.JBInputEventEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.MethodInvocator;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sun.awt.AWTAccessor;

@ApiStatus.Experimental
public class JdkEx {
    @NotNull
    public static InputEventEx getInputEventEx() {
        if (SystemInfo.isJetBrainsJvm) {
            JBInputEventEx jBInputEventEx = new JBInputEventEx();
            if (jBInputEventEx == null) {
                JdkEx.$$$reportNull$$$0(0);
            }
            return jBInputEventEx;
        }
        DefInputEventEx defInputEventEx = new DefInputEventEx();
        if (defInputEventEx == null) {
            JdkEx.$$$reportNull$$$0(1);
        }
        return defInputEventEx;
    }

    public static DisplayModeEx getDisplayModeEx() {
        if (SystemInfo.isJetBrainsJvm) {
            return new JBDisplayModeEx();
        }
        return new DefDisplayModeEx();
    }

    public static boolean isCustomDecorationSupported() {
        if (SystemInfo.isJetBrainsJvm && SystemInfo.isWin10OrNewer) {
            try {
                MethodInvocator invocator = new MethodInvocator(false, Class.forName("java.awt.Window"), "setHasCustomDecoration", new Class[0]);
                return invocator.isAvailable();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setHasCustomDecoration(@NotNull Window window) {
        if (window == null) {
            JdkEx.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isJetBrainsJvm && SystemInfo.isWindows) {
            try {
                MethodInvocator invocator = new MethodInvocator(false, Class.forName("java.awt.Window"), "setHasCustomDecoration", new Class[0]);
                if (invocator.isAvailable()) {
                    invocator.invoke((Object)window, new Object[0]);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void setCustomDecorationHitTestSpots(@NotNull Window window, @NotNull List<Rectangle> spots) {
        if (window == null) {
            JdkEx.$$$reportNull$$$0(3);
        }
        if (spots == null) {
            JdkEx.$$$reportNull$$$0(4);
        }
        if (SystemInfo.isJetBrainsJvm && SystemInfo.isWindows) {
            try {
                MethodInvocator invocator = new MethodInvocator(false, Class.forName("sun.awt.windows.WWindowPeer"), "setCustomDecorationHitTestSpots", new Class[]{List.class});
                if (invocator.isAvailable()) {
                    invocator.invoke(AWTAccessor.getComponentAccessor().getPeer(window), new Object[]{spots});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jdkEx/JdkEx";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputEventEx";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jdkEx/JdkEx";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setHasCustomDecoration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCustomDecorationHitTestSpots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

