/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionResultsViewUtil;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeCellRenderer;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.LevelAndCount;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionTree
extends Tree {
    private static final Logger LOG = Logger.getInstance(InspectionTree.class);
    private final InspectionTreeModel myModel;
    private boolean myQueueUpdate;
    private final OccurenceNavigator myOccurenceNavigator;
    private final InspectionResultsView myView;

    public InspectionTree(@NotNull InspectionResultsView view) {
        if (view == null) {
            InspectionTree.$$$reportNull$$$0(0);
        }
        this.myOccurenceNavigator = new MyOccurrenceNavigator();
        this.myView = view;
        this.myModel = new InspectionTreeModel();
        Disposer.register((Disposable)view, (Disposable)this.myModel);
        this.setModel((TreeModel)((Object)new AsyncTreeModel((TreeModel)((Object)this.myModel), false, view)));
        this.setCellRenderer((TreeCellRenderer)((Object)new InspectionTreeCellRenderer(view)));
        this.setRootVisible(false);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getSelectionModel().addTreeSelectionListener(e -> {
                if (this.isUnderQueueUpdate()) {
                    return;
                }
                if (!this.myView.isDisposed()) {
                    this.myView.syncRightPanel();
                    if (this.myView.isAutoScrollMode()) {
                        OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)this)), (boolean)false);
                    }
                }
            });
            EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 && !InspectionTree.this.myView.isDisposed()) {
                        OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)InspectionTree.this.myView), (boolean)false);
                    }
                }
            });
            TreeUtil.installActions((JTree)((Object)this));
            PopupHandler.installPopupHandler((JComponent)((Object)this), (String)"InspectionToolWindow.TreePopup", (String)"CodeInspection");
            new TreeSpeedSearch(this, (Convertor<? super TreePath, String>)((Convertor)o -> InspectionsConfigTreeComparator.getDisplayTextToSort(o.getLastPathComponent().toString())));
        }
        this.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){
            boolean myAlreadyDone;

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!this.myAlreadyDone && InspectionTree.this.getSelectionCount() == 0) {
                    this.myAlreadyDone = true;
                    EdtInvocationManager.getInstance().invokeLater(() -> {
                        InspectionTree.this.expandPath(new TreePath(InspectionTree.this.myModel.getRoot()));
                        SmartExpander.installOn((JTree)((Object)InspectionTree.this));
                        if (!InspectionTree.this.myView.isDisposed()) {
                            InspectionTree.this.myView.syncRightPanel();
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/ui/InspectionTree$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public InspectionTreeNode getRoot() {
        return this.myModel.getRoot();
    }

    public InspectionTreeModel getInspectionTreeModel() {
        return this.myModel;
    }

    public void setQueueUpdate(boolean queueUpdate) {
        this.myQueueUpdate = queueUpdate;
    }

    public boolean isUnderQueueUpdate() {
        return this.myQueueUpdate;
    }

    public void removeAllNodes() {
        this.myModel.clearTree();
    }

    @Nullable
    public String[] getSelectedGroupPath() {
        TreePath commonPath = TreePathUtil.findCommonAncestor(this.getSelectionPaths());
        if (commonPath == null) {
            return null;
        }
        for (Object n : commonPath.getPath()) {
            if (!(n instanceof InspectionGroupNode)) continue;
            return InspectionTree.getGroupPath((InspectionGroupNode)n);
        }
        return null;
    }

    @Nullable
    public InspectionToolWrapper getSelectedToolWrapper(boolean allowDummy) {
        InspectionProfileImpl profile2 = this.myView.getCurrentProfile();
        String singleToolName = profile2.getSingleTool();
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            if (singleToolName != null) {
                InspectionToolWrapper tool = profile2.getInspectionTool(singleToolName, this.myView.getProject());
                LOG.assertTrue(tool != null);
                return tool;
            }
            return null;
        }
        InspectionToolWrapper resultWrapper = null;
        block0: for (TreePath path : paths) {
            Object[] nodes = path.getPath();
            for (int j = nodes.length - 1; j >= 0; --j) {
                Object node = nodes[j];
                if (node instanceof InspectionGroupNode) {
                    return null;
                }
                InspectionToolWrapper wrapper2 = null;
                if (node instanceof InspectionNode) {
                    wrapper2 = ((InspectionNode)node).getToolWrapper();
                } else if (node instanceof SuppressableInspectionTreeNode) {
                    wrapper2 = ((SuppressableInspectionTreeNode)node).getPresentation().getToolWrapper();
                }
                if (wrapper2 == null || !allowDummy && this.getContext().getPresentation(wrapper2).isDummy()) continue;
                if (resultWrapper == null) {
                    resultWrapper = wrapper2;
                    continue block0;
                }
                if (resultWrapper == wrapper2) continue block0;
                return null;
            }
        }
        if (resultWrapper == null && singleToolName != null) {
            InspectionToolWrapper tool = profile2.getInspectionTool(singleToolName, this.myView.getProject());
            LOG.assertTrue(tool != null);
            return tool;
        }
        return resultWrapper;
    }

    public String getToolTipText(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return null;
        }
        Object lastComponent = path.getLastPathComponent();
        if (!(lastComponent instanceof ProblemDescriptionNode)) {
            return null;
        }
        return ((ProblemDescriptionNode)lastComponent).getToolTipText();
    }

    @Nullable
    public RefEntity getCommonSelectedElement() {
        Object node = this.getCommonSelectedNode();
        return node instanceof RefElementNode ? ((RefElementNode)node).getElement() : null;
    }

    @Nullable
    private Object getCommonSelectedNode() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        Object[][] resolvedPaths = new Object[paths.length][];
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            resolvedPaths[i] = path.getPath();
        }
        Object currentCommonNode = null;
        for (int i = 0; i < resolvedPaths[0].length; ++i) {
            Object currentNode = resolvedPaths[0][i];
            for (int j = 1; j < resolvedPaths.length; ++j) {
                Object o = resolvedPaths[j][i];
                if (o.equals(currentNode)) continue;
                return currentCommonNode;
            }
            currentCommonNode = currentNode;
        }
        return currentCommonNode;
    }

    @NotNull
    public RefEntity[] getSelectedElements() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            InspectionToolWrapper toolWrapper = this.getSelectedToolWrapper(true);
            if (toolWrapper == null) {
                if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
                    InspectionTree.$$$reportNull$$$0(1);
                }
                return RefEntity.EMPTY_ELEMENTS_ARRAY;
            }
            LinkedHashSet result2 = new LinkedHashSet();
            for (TreePath selectionPath : selectionPaths) {
                InspectionTreeNode node = (InspectionTreeNode)selectionPath.getLastPathComponent();
                InspectionTree.addElementsInNode(node, result2);
            }
            RefEntity[] refEntityArray = (RefEntity[])ArrayUtil.reverseArray((Object[])result2.toArray(RefEntity.EMPTY_ELEMENTS_ARRAY));
            if (refEntityArray == null) {
                InspectionTree.$$$reportNull$$$0(2);
            }
            return refEntityArray;
        }
        if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
            InspectionTree.$$$reportNull$$$0(3);
        }
        return RefEntity.EMPTY_ELEMENTS_ARRAY;
    }

    public OccurenceNavigator getOccurenceNavigator() {
        return this.myOccurenceNavigator;
    }

    public void selectNode(InspectionTreeNode node) {
        TreePath path = this.getPathFor(node);
        TreeUtil.selectPath((JTree)((Object)this), (TreePath)path);
    }

    private static void addElementsInNode(InspectionTreeNode node, Set<? super RefEntity> out) {
        RefEntity element;
        if (!node.isValid()) {
            return;
        }
        if (node instanceof RefElementNode) {
            element = ((RefElementNode)node).getElement();
            out.add((RefEntity)element);
        }
        if (node instanceof ProblemDescriptionNode) {
            element = ((ProblemDescriptionNode)node).getElement();
            out.add((RefEntity)element);
        }
        for (InspectionTreeNode inspectionTreeNode : node.getChildren()) {
            InspectionTree.addElementsInNode(inspectionTreeNode, out);
        }
    }

    @NotNull
    public CommonProblemDescriptor[] getAllValidSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, true, null));
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(4);
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public CommonProblemDescriptor[] getSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, false, null));
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(5);
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public List<CommonProblemDescriptor[]> getSelectedDescriptorPacks(boolean sortedByPosition, @Nullable Set<? super VirtualFile> readOnlyFilesSink, boolean allowResolved, TreePath[] paths) {
        if (paths == null) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            paths = this.getSelectionPaths();
        }
        if (paths == null) {
            List<CommonProblemDescriptor[]> list2 = Collections.emptyList();
            if (list2 == null) {
                InspectionTree.$$$reportNull$$$0(6);
            }
            return list2;
        }
        MultiMap parentToChildNode = new MultiMap();
        TreeTraversal.PLAIN_BFS.traversal((Iterable)ContainerUtil.map((Object[])paths, p -> (InspectionTreeNode)p.getLastPathComponent()), n -> this.myModel.getChildren(n)).filter(ProblemDescriptionNode.class).filter(node -> node.getDescriptor() != null && InspectionTree.isNodeValidAndIncluded(node, allowResolved)).consumeEach(node -> {
            Object key = InspectionTree.getVirtualFileOrEntity(node.getElement());
            parentToChildNode.putValue(key, (Object)node.getDescriptor());
        });
        ArrayList<CommonProblemDescriptor[]> descriptors = new ArrayList<CommonProblemDescriptor[]>();
        for (Map.Entry entry : parentToChildNode.entrySet()) {
            Object key = entry.getKey();
            if (readOnlyFilesSink != null && key instanceof VirtualFile && !((VirtualFile)key).isWritable()) {
                readOnlyFilesSink.add((VirtualFile)((VirtualFile)key));
            }
            Stream stream = ((Collection)entry.getValue()).stream();
            if (sortedByPosition) {
                stream = stream.sorted(CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
            }
            descriptors.add((CommonProblemDescriptor[])stream.toArray(arg_0 -> ((ArrayFactory)CommonProblemDescriptor.ARRAY_FACTORY).create(arg_0)));
        }
        ArrayList<CommonProblemDescriptor[]> arrayList = descriptors;
        if (arrayList == null) {
            InspectionTree.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public TreePath[] getSelectionPaths() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return super.getSelectionPaths();
    }

    @NotNull
    InspectionTreeNode getToolProblemsRootNode(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        if (toolWrapper == null) {
            InspectionTree.$$$reportNull$$$0(8);
        }
        if (errorLevel == null) {
            InspectionTree.$$$reportNull$$$0(9);
        }
        InspectionTreeNode parent = this.getToolParentNode(toolWrapper, errorLevel, groupedBySeverity, isSingleInspectionRun);
        if (isSingleInspectionRun) {
            InspectionTreeNode inspectionTreeNode = parent;
            if (inspectionTreeNode == null) {
                InspectionTree.$$$reportNull$$$0(10);
            }
            return inspectionTreeNode;
        }
        InspectionNode inspectionNode = this.myModel.createInspectionNode(toolWrapper, this.myView.getCurrentProfile(), parent);
        if (inspectionNode == null) {
            InspectionTree.$$$reportNull$$$0(11);
        }
        return inspectionNode;
    }

    @NotNull
    private InspectionTreeNode getToolParentNode(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        InspectionTreeNode currentNode;
        if (toolWrapper == null) {
            InspectionTree.$$$reportNull$$$0(12);
        }
        if (errorLevel == null) {
            InspectionTree.$$$reportNull$$$0(13);
        }
        if (!groupedBySeverity && isSingleInspectionRun) {
            InspectionRootNode inspectionRootNode = this.myModel.getRoot();
            if (inspectionRootNode == null) {
                InspectionTree.$$$reportNull$$$0(14);
            }
            return inspectionRootNode;
        }
        InspectionTreeNode inspectionTreeNode = currentNode = groupedBySeverity ? this.myModel.createSeverityGroupNode(this.myView.getCurrentProfile().getProfileManager().getSeverityRegistrar(), errorLevel, this.myModel.getRoot()) : this.myModel.getRoot();
        if (isSingleInspectionRun) {
            InspectionRootNode inspectionRootNode = currentNode;
            if (inspectionRootNode == null) {
                InspectionTree.$$$reportNull$$$0(15);
            }
            return inspectionRootNode;
        }
        String[] groupPath = toolWrapper.getGroupPath();
        if (groupPath.length == 0) {
            LOG.error("groupPath is empty for tool: " + toolWrapper.getShortName() + ", class: " + toolWrapper.getTool().getClass());
        }
        for (String subGroup : groupPath) {
            currentNode = this.myModel.createGroupNode(subGroup, currentNode);
        }
        InspectionRootNode inspectionRootNode = currentNode;
        if (inspectionRootNode == null) {
            InspectionTree.$$$reportNull$$$0(16);
        }
        return inspectionRootNode;
    }

    public boolean areDescriptorNodesSelected() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            if (path.getLastPathComponent() instanceof ProblemDescriptionNode) continue;
            return false;
        }
        return true;
    }

    public int getSelectedProblemCount() {
        int count = 0;
        for (TreePath path : TreeCollector.TreePathRoots.collect((TreePath[])this.getSelectionPaths())) {
            LevelAndCount[] levels;
            for (LevelAndCount level : levels = ((InspectionTreeNode)path.getLastPathComponent()).getProblemLevels()) {
                count += level.getCount();
            }
        }
        return count;
    }

    private static boolean isNodeValidAndIncluded(ProblemDescriptionNode node, boolean allowResolved) {
        return node.isValid() && (allowResolved || !node.isExcluded() && !node.isAlreadySuppressedFromView() && !node.isQuickFixAppliedFromView());
    }

    public void removeSelectedProblems() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath[] selected2 = this.getSelectionPaths();
        if (selected2 == null) {
            return;
        }
        if (!this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS) {
            for (TreePath path : selected2) {
                InspectionTreeNode node = (InspectionTreeNode)path.getLastPathComponent();
                this.myModel.traverse(node).forEach(InspectionTreeNode::dropProblemCountCaches);
            }
            return;
        }
        THashSet processedNodes = new THashSet();
        ArrayList<InspectionTreeNode> toRemove2 = new ArrayList<InspectionTreeNode>();
        ArrayList<TreePath> pathsToSelect = new ArrayList<TreePath>();
        block1: for (TreePath path : selected2) {
            Object[] nodePath = path.getPath();
            for (int i = 1; i < nodePath.length; ++i) {
                InspectionTreeNode node = (InspectionTreeNode)nodePath[i];
                if (!processedNodes.add(node) || !this.shouldDelete(node)) continue;
                toRemove2.add(node);
                TreePath toSelect2 = InspectionTree.getParentPath(path, nodePath.length - i);
                if (toSelect2 == null) continue block1;
                pathsToSelect.add(toSelect2);
                continue block1;
            }
        }
        if (toRemove2.isEmpty()) {
            return;
        }
        THashSet parents = new THashSet();
        for (InspectionTreeNode node : toRemove2) {
            InspectionTreeNode parent = node.getParent();
            if (parent == null) continue;
            this.myModel.remove(node);
            parents.add(parent);
        }
        for (InspectionTreeNode parent : parents) {
            parent.dropProblemCountCaches();
        }
        TreePath commonPath = TreePathUtil.findCommonAncestor(pathsToSelect);
        if (commonPath != null) {
            TreeUtil.selectPath((JTree)((Object)this), (TreePath)commonPath);
        }
        this.revalidate();
        this.repaint();
    }

    private static TreePath getParentPath(TreePath path, int ord) {
        TreePath parent = path;
        for (int j = 0; j < ord; ++j) {
            parent = parent.getParentPath();
        }
        return parent;
    }

    private boolean shouldDelete(InspectionTreeNode node) {
        if (node instanceof RefElementNode) {
            RefElementNode refElementNode = (RefElementNode)node;
            InspectionToolPresentation presentation = refElementNode.getPresentation();
            RefEntity element = refElementNode.getElement();
            if (element == null || presentation.isProblemResolved(element) || presentation.isExcluded(element) || presentation.isSuppressed(element)) {
                return true;
            }
            List<? extends InspectionTreeNode> children2 = node.getChildren();
            return !children2.isEmpty() && children2.stream().allMatch(this::shouldDelete);
        }
        if (node instanceof ProblemDescriptionNode) {
            ProblemDescriptionNode problemDescriptionNode = (ProblemDescriptionNode)node;
            CommonProblemDescriptor descriptor2 = problemDescriptionNode.getDescriptor();
            InspectionToolPresentation presentation = problemDescriptionNode.getPresentation();
            if (descriptor2 == null || presentation.isExcluded(descriptor2) || presentation.isProblemResolved(descriptor2)) {
                return true;
            }
        } else {
            if (node instanceof InspectionGroupNode || node instanceof InspectionSeverityGroupNode || node instanceof InspectionModuleNode || node instanceof InspectionPackageNode) {
                return node.getChildren().stream().allMatch(this::shouldDelete);
            }
            if (node instanceof InspectionNode) {
                InspectionToolPresentation presentation = this.myView.getGlobalInspectionContext().getPresentation(((InspectionNode)node).getToolWrapper());
                SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> problemElements = presentation.getProblemElements();
                if (problemElements.isEmpty()) {
                    return true;
                }
                return problemElements.keys().stream().allMatch(entity -> presentation.isExcluded((RefEntity)entity));
            }
        }
        return false;
    }

    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myView.getGlobalInspectionContext();
        if (globalInspectionContextImpl == null) {
            InspectionTree.$$$reportNull$$$0(17);
        }
        return globalInspectionContextImpl;
    }

    @NotNull
    private static String[] getGroupPath(@NotNull InspectionGroupNode node) {
        InspectionTreeNode parent;
        if (node == null) {
            InspectionTree.$$$reportNull$$$0(18);
        }
        ArrayList<String> path = new ArrayList<String>(2);
        while ((parent = node.getParent()) instanceof InspectionGroupNode) {
            node = (InspectionGroupNode)parent;
            path.add(node.getSubGroup());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(path);
        if (stringArray == null) {
            InspectionTree.$$$reportNull$$$0(19);
        }
        return stringArray;
    }

    @Nullable
    private static Object getVirtualFileOrEntity(@Nullable RefEntity entity) {
        VirtualFile file2;
        SmartPsiElementPointer pointer;
        if (entity instanceof RefElement && (pointer = ((RefElement)entity).getPointer()) != null && (file2 = pointer.getVirtualFile()) != null) {
            return file2;
        }
        return entity;
    }

    private TreePath getPathFor(InspectionTreeNode node) {
        TreePath result2 = TreePathUtil.pathToTreeNode(node);
        Stack s = new Stack();
        for (TreePath current = result2; current != null; current = current.getParentPath()) {
            s.add((Object)current);
        }
        while (!s.isEmpty()) {
            TreePath p = (TreePath)s.pop();
            this.expandPath(p);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorLevel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValidSelectedDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptorPacks";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolProblemsRootNode";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolParentNode";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getToolProblemsRootNode";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getToolParentNode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getGroupPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyOccurrenceNavigator
    implements OccurenceNavigator {
        private MyOccurrenceNavigator() {
        }

        public boolean hasNextOccurence() {
            return this.getNextNode(true) != null;
        }

        public boolean hasPreviousOccurence() {
            return this.getNextNode(false) != null;
        }

        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            InspectionTreeNode node = this.getNextNode(true);
            if (node == null) {
                return null;
            }
            InspectionTree.this.selectNode(node);
            return new OccurenceNavigator.OccurenceInfo(this.createDescriptorForNode(node), -1, -1);
        }

        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            InspectionTreeNode node = this.getNextNode(false);
            InspectionTree.this.selectNode(node);
            return node == null ? null : new OccurenceNavigator.OccurenceInfo(this.createDescriptorForNode(node), -1, -1);
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string = InspectionsBundle.message((String)"inspection.action.go.next", (Object[])new Object[0]);
            if (string == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = InspectionsBundle.message((String)"inspection.action.go.prev", (Object[])new Object[0]);
            if (string == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(1);
            }
            return string;
        }

        private InspectionTreeNode getNextNode(boolean next) {
            InspectionTreeNode node = this.getSelectedNode();
            if (node == null) {
                return null;
            }
            return (InspectionTreeNode)InspectionTree.this.myModel.traverseFrom(node, next).filter(n -> n != node).filter(n -> this.isOccurrenceNode((InspectionTreeNode)n)).first();
        }

        private InspectionTreeNode getSelectedNode() {
            TreePath path = InspectionTree.this.getSelectionPath();
            if (path == null) {
                return null;
            }
            return (InspectionTreeNode)path.getLastPathComponent();
        }

        private boolean isOccurrenceNode(@NotNull InspectionTreeNode node) {
            if (node == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(2);
            }
            if (node.isExcluded()) {
                return false;
            }
            if (node instanceof RefElementNode) {
                RefElementNode refNode = (RefElementNode)node;
                if (this.hasDescriptorUnder(refNode)) {
                    return false;
                }
                RefEntity element = refNode.getElement();
                return element != null && element.isValid();
            }
            return node instanceof ProblemDescriptionNode;
        }

        @Nullable
        private Navigatable createDescriptorForNode(@NotNull InspectionTreeNode node) {
            if (node == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(3);
            }
            if (node.isExcluded()) {
                return null;
            }
            if (node instanceof RefElementNode) {
                RefElementNode refNode = (RefElementNode)node;
                if (this.hasDescriptorUnder(refNode)) {
                    return null;
                }
                RefEntity element = refNode.getElement();
                if (element == null || !element.isValid()) {
                    return null;
                }
                if (element instanceof RefElement) {
                    return this.getOpenFileDescriptor((RefElement)element);
                }
            } else if (node instanceof ProblemDescriptionNode) {
                ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node;
                boolean isValid = problemNode.isValid() && (!problemNode.isQuickFixAppliedFromView() || problemNode.calculateIsValid());
                return isValid ? this.navigate(problemNode.getDescriptor()) : InspectionResultsViewUtil.getNavigatableForInvalidNode(problemNode);
            }
            return null;
        }

        @Nullable
        private Navigatable navigate(CommonProblemDescriptor descriptor2) {
            return InspectionResultsView.getSelectedNavigatable(descriptor2);
        }

        @Nullable
        private Navigatable getOpenFileDescriptor(RefElement refElement) {
            PsiElement psiElement = refElement.getPsiElement();
            if (psiElement == null) {
                return null;
            }
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            VirtualFile file2 = containingFile.getVirtualFile();
            if (file2 == null) {
                return null;
            }
            return PsiNavigationSupport.getInstance().createNavigatable(refElement.getRefManager().getProject(), file2, psiElement.getTextOffset());
        }

        private boolean hasDescriptorUnder(RefElementNode node) {
            InspectionTreeNode current = node;
            while (current != null && current.getChildCount() != 0) {
                if (!((current = current.getChildAt(0)) instanceof ProblemDescriptionNode)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTree$MyOccurrenceNavigator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTree$MyOccurrenceNavigator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isOccurrenceNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptorForNode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

