/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangesDiffCalculator {
    private static final Logger LOG = Logger.getInstance(ChangesDiffCalculator.class);

    public static List<TextRange> calculateDiff(@NotNull Document beforeDocument, @NotNull Document currentDocument) {
        if (beforeDocument == null) {
            ChangesDiffCalculator.$$$reportNull$$$0(0);
        }
        if (currentDocument == null) {
            ChangesDiffCalculator.$$$reportNull$$$0(1);
        }
        CharSequence beforeText = beforeDocument.getCharsSequence();
        CharSequence currentText = currentDocument.getCharsSequence();
        try {
            ComparisonManager manager = ComparisonManager.getInstance();
            List lineFragments = manager.compareLinesInner(beforeText, currentText, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            ArrayList<TextRange> modifiedRanges = new ArrayList<TextRange>();
            for (LineFragment lineFragment : lineFragments) {
                int fragmentStartOffset = lineFragment.getStartOffset2();
                int fragmentEndOffset = lineFragment.getEndOffset2();
                List innerFragments = lineFragment.getInnerFragments();
                if (innerFragments != null) {
                    for (DiffFragment innerFragment : innerFragments) {
                        int innerFragmentStartOffset = fragmentStartOffset + innerFragment.getStartOffset2();
                        int innerFragmentEndOffset = fragmentStartOffset + innerFragment.getEndOffset2();
                        modifiedRanges.add(ChangesDiffCalculator.calculateChangeHighlightRange(currentText, innerFragmentStartOffset, innerFragmentEndOffset));
                    }
                    continue;
                }
                modifiedRanges.add(ChangesDiffCalculator.calculateChangeHighlightRange(currentText, fragmentStartOffset, fragmentEndOffset));
            }
            return modifiedRanges;
        }
        catch (DiffTooBigException e) {
            LOG.info((Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private static TextRange calculateChangeHighlightRange(@NotNull CharSequence text2, int startOffset, int endOffset) {
        if (text2 == null) {
            ChangesDiffCalculator.$$$reportNull$$$0(2);
        }
        if (startOffset == endOffset) {
            while (startOffset < text2.length() && text2.charAt(startOffset) == ' ') {
                ++startOffset;
            }
            TextRange textRange = new TextRange(startOffset, startOffset);
            if (textRange == null) {
                ChangesDiffCalculator.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        int originalStartOffset = startOffset;
        int originalEndOffset = endOffset;
        while (endOffset < text2.length() && ChangesDiffCalculator.rangesEqual(text2, originalStartOffset, originalEndOffset, startOffset + 1, endOffset + 1)) {
            ++startOffset;
            ++endOffset;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            ChangesDiffCalculator.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static boolean rangesEqual(@NotNull CharSequence text2, int start1, int end1, int start2, int end2) {
        if (text2 == null) {
            ChangesDiffCalculator.$$$reportNull$$$0(5);
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        for (int i = start1; i < end1; ++i) {
            if (text2.charAt(i) == text2.charAt(i - start1 + start2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeDocument";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDocument";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/ChangesDiffCalculator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/ChangesDiffCalculator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateChangeHighlightRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateDiff";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangeHighlightRange";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rangesEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

