/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.credentialStore.PasswordSafeConfigurableKt;
import com.intellij.credentialStore.PasswordSafeConfigurableUi;
import com.intellij.credentialStore.PasswordSafeConfigurableUi$WhenMappings;
import com.intellij.credentialStore.PasswordSafeConfigurableUi$getComponent$;
import com.intellij.credentialStore.PasswordSafeConfigurableUi$getComponent$1$2;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.gpg.Pgp;
import com.intellij.credentialStore.gpg.PgpKey;
import com.intellij.credentialStore.kdbx.IncorrectMasterPasswordException;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.KeePassFileManager;
import com.intellij.credentialStore.keePass.MasterKeyFileStorage;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.CellKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutBuilderKt;
import com.intellij.ui.layout.LayoutBuilderWithButtonGroupProperty;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.awt.Container;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0002J\n\u0010%\u001a\u0004\u0018\u00010&H\u0002J\n\u0010'\u001a\u0004\u0018\u00010(H\u0002J\n\u0010)\u001a\u0004\u0018\u00010\u0013H\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002J\u0010\u0010-\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\b\u0010/\u001a\u00020(H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "mySettings", "(Lcom/intellij/credentialStore/PasswordSafeSettings;)V", "keePassDbFile", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "keepassRadioButton", "Ljavax/swing/JRadioButton;", "myPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "pgp", "Lcom/intellij/credentialStore/gpg/Pgp;", "getPgp", "()Lcom/intellij/credentialStore/gpg/Pgp;", "pgp$delegate", "Lkotlin/Lazy;", "pgpKeyCombo", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/credentialStore/gpg/PgpKey;", "pgpListModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "secureRandom", "Lkotlin/Lazy;", "Ljava/security/SecureRandom;", "usePgpKey", "Ljavax/swing/JCheckBox;", "apply", "", "settings", "createAndSaveKeePassDatabaseWithNewOptions", "createKeePassFileManager", "Lcom/intellij/credentialStore/keePass/KeePassFileManager;", "getComponent", "Ljavax/swing/JPanel;", "getEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "getNewDbFile", "Ljava/nio/file/Path;", "getNewDbFileAsString", "", "getNewPgpKey", "getSelectedPgpKey", "isKeepassFileLocationChanged", "", "isModified", "reset", "usePgpKeyText", "ChangeKeePassDatabaseMasterPasswordAction", "ClearKeePassDatabaseAction", "ImportKeePassDatabaseAction", "intellij.platform.credentialStore"})
public final class PasswordSafeConfigurableUi
implements ConfigurableUi<PasswordSafeSettings> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private DialogPanel myPanel;
    private JCheckBox usePgpKey;
    private ComboBox<PgpKey> pgpKeyCombo;
    private JRadioButton keepassRadioButton;
    private TextFieldWithBrowseButton keePassDbFile;
    private final CollectionComboBoxModel<PgpKey> pgpListModel;
    private final Lazy pgp$delegate;
    private final Lazy<SecureRandom> secureRandom;
    private final PasswordSafeSettings mySettings;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PasswordSafeConfigurableUi.class), "pgp", "getPgp()Lcom/intellij/credentialStore/gpg/Pgp;"))};
    }

    private final Pgp getPgp() {
        Lazy lazy = this.pgp$delegate;
        PasswordSafeConfigurableUi passwordSafeConfigurableUi = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Pgp)lazy.getValue();
    }

    public void reset(@NotNull PasswordSafeSettings settings) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            List<PgpKey> secretKeys = this.getPgp().listKeys();
            this.pgpListModel.replaceAll(secretKeys);
            JCheckBox jCheckBox = this.usePgpKey;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"usePgpKey");
            }
            jCheckBox.setText(this.usePgpKeyText());
            DialogPanel dialogPanel = this.myPanel;
            if (dialogPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myPanel");
            }
            dialogPanel.reset();
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.keePassDbFile;
            if (textFieldWithBrowseButton == null) break block3;
            String string = settings.getKeepassDb();
            if (string == null) {
                string = ((Object)PasswordSafeImplKt.getDefaultKeePassDbFile()).toString();
            }
            textFieldWithBrowseButton.setText(string);
        }
    }

    public boolean isModified(@NotNull PasswordSafeSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        DialogPanel dialogPanel = this.myPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPanel");
        }
        if (dialogPanel.isModified()) {
            return true;
        }
        if (this.keePassDbFile == null) {
            return false;
        }
        return this.isKeepassFileLocationChanged(settings);
    }

    private final boolean isKeepassFileLocationChanged(PasswordSafeSettings settings) {
        JRadioButton jRadioButton = this.keepassRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keepassRadioButton");
        }
        return jRadioButton.isSelected() && Intrinsics.areEqual((Object)this.getNewDbFileAsString(), (Object)settings.getKeepassDb()) ^ true;
    }

    public void apply(@NotNull PasswordSafeSettings settings) {
        ProviderType providerType;
        block22: {
            boolean pgpKeyChanged;
            block23: {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                PgpKey pgpKey = this.getNewPgpKey();
                pgpKeyChanged = Intrinsics.areEqual((Object)(pgpKey != null ? pgpKey.getKeyId() : null), (Object)this.mySettings.getState().getPgpKeyId()) ^ true;
                ProviderType oldProviderType = this.mySettings.getProviderType();
                DialogPanel dialogPanel = this.myPanel;
                if (dialogPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myPanel");
                }
                dialogPanel.apply();
                providerType = this.mySettings.getProviderType();
                PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
                if (passwordSafe == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
                }
                ((PasswordSafeImpl)passwordSafe).closeCurrentStore$intellij_platform_credentialStore(false, providerType != ProviderType.MEMORY_ONLY);
                PasswordSafe passwordSafe2 = PasswordSafe.Companion.getInstance();
                if (passwordSafe2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
                }
                PasswordSafeImpl passwordSafe3 = (PasswordSafeImpl)passwordSafe2;
                if (oldProviderType == providerType) break block23;
                switch (PasswordSafeConfigurableUi$WhenMappings.$EnumSwitchMapping$0[providerType.ordinal()]) {
                    case 1: {
                        break block22;
                    }
                    case 2: {
                        try {
                            CredentialStore store = PasswordSafeImplKt.createPersistentCredentialStore();
                            if (store == null) {
                                throw (Throwable)new ConfigurationException("Internal error, no available credential store implementation.");
                            }
                            passwordSafe3.setCurrentProvider$intellij_platform_credentialStore(store);
                            Unit unit = Unit.INSTANCE;
                            break block22;
                        }
                        catch (UnsatisfiedLinkError e) {
                            CredentialStoreKt.getLOG().warn((Throwable)e);
                            if (SystemInfo.isLinux) {
                                throw (Throwable)new ConfigurationException("Package libsecret-1-0 is not installed (to install: sudo apt-get install libsecret-1-0 gnome-keyring).");
                            }
                            throw (Throwable)new ConfigurationException(e.getMessage());
                        }
                    }
                    case 3: {
                        this.createAndSaveKeePassDatabaseWithNewOptions(settings);
                        break block22;
                    }
                    default: {
                        throw (Throwable)new ConfigurationException("Unknown provider type: " + (Object)((Object)providerType));
                    }
                }
            }
            if (this.isKeepassFileLocationChanged(settings)) {
                this.createAndSaveKeePassDatabaseWithNewOptions(settings);
            } else if (providerType == ProviderType.KEEPASS && pgpKeyChanged) {
                try {
                    Unit unit;
                    KeePassFileManager keePassFileManager = this.createKeePassFileManager();
                    if (keePassFileManager != null) {
                        keePassFileManager.saveMasterKeyToApplyNewEncryptionSpec();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (ConfigurationException e) {
                    throw (Throwable)e;
                }
                catch (Exception e) {
                    CredentialStoreKt.getLOG().error((Throwable)e);
                    throw (Throwable)new ConfigurationException("Internal error: " + e.getMessage());
                }
            }
        }
        if (providerType == ProviderType.KEEPASS) {
            KeePassFileManager keePassFileManager = this.createKeePassFileManager();
            if (keePassFileManager != null) {
                Path path = PasswordSafeImplKt.getDefaultKeePassDbFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"getDefaultKeePassDbFile()");
                keePassFileManager.setCustomMasterPasswordIfNeeded(path);
            }
        }
        settings.setProviderType(providerType);
    }

    private final void createAndSaveKeePassDatabaseWithNewOptions(PasswordSafeSettings settings) {
        Path path = this.getNewDbFile();
        if (path == null) {
            throw (Throwable)new ConfigurationException("KeePass database path is empty.");
        }
        Path newDbFile = path;
        if (PathKt.isDirectory((Path)newDbFile)) {
            throw (Throwable)new ConfigurationException("KeePass database file is directory.");
        }
        if (!StringsKt.endsWith$default((String)((Object)newDbFile.getFileName()).toString(), (String)".kdbx", (boolean)false, (int)2, null)) {
            throw (Throwable)new ConfigurationException("KeePass database file should ends with \".kdbx\".");
        }
        settings.setKeepassDb(((Object)newDbFile).toString());
        try {
            Path path2 = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"getDefaultMasterPasswordFile()");
            new KeePassFileManager(newDbFile, path2, this.getEncryptionSpec(), this.secureRandom).useExisting();
        }
        catch (IncorrectMasterPasswordException e) {
            throw (Throwable)new ConfigurationException("Master password for KeePass database is not correct (\"Clear\" can be used to reset database).");
        }
        catch (Exception e) {
            CredentialStoreKt.getLOG().error((Throwable)e);
            throw (Throwable)new ConfigurationException("Internal error: " + e.getMessage());
        }
    }

    private final Path getNewDbFile() {
        Path path;
        String string = this.getNewDbFileAsString();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    private final String getNewDbFileAsString() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.keePassDbFile;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwNpe();
        }
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keePassDbFile!!.text");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (boolean)false, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JPanel getComponent() {
        DialogPanel dialogPanel;
        Row row$iv;
        void constraints$iv;
        LayoutBuilder builder$iv;
        LCFlags[] lCFlagsArray = new LCFlags[]{};
        PasswordSafeConfigurableUi passwordSafeConfigurableUi = this;
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder((!ArraysKt.contains((Object[])constraints$iv, (Object)LCFlags.disableMagic) ? 1 : 0) != 0);
        boolean bl = false;
        LayoutBuilder this_$iv = $this$panel;
        JLabel label$iv = null;
        boolean separated$iv = false;
        boolean $i$f$row = false;
        Row $this$row = row$iv = this_$iv.getBuilder().newRow(label$iv, this_$iv.getButtonGroup(), separated$iv);
        boolean bl2 = false;
        Cell.label$default((Cell)$this$row, (String)"Save passwords:", (int)0, null, null, (boolean)false, (int)30, null);
        $this$panel.buttonGroup((KMutableProperty0)new PasswordSafeConfigurableUi$getComponent$1$2(this.mySettings), (Function1)new Function1<LayoutBuilderWithButtonGroupProperty<ProviderType>, Unit>(this){
            final /* synthetic */ PasswordSafeConfigurableUi this$0;
            {
                this.this$0 = passwordSafeConfigurableUi;
                super(1);
            }

            public final void invoke(@NotNull LayoutBuilderWithButtonGroupProperty<ProviderType> $this$buttonGroup) {
                Row row$iv;
                FileChooserDescriptor fileChooserDescriptor2;
                Row this_$iv;
                Row row$iv2;
                Row $this$row;
                Row row$iv3;
                boolean $i$f$row;
                boolean separated$iv;
                JLabel label$iv;
                LayoutBuilderWithButtonGroupProperty<ProviderType> this_$iv2;
                Intrinsics.checkParameterIsNotNull($this$buttonGroup, (String)"$receiver");
                if (SystemInfo.isLinux || MacOsKeychainLibraryKt.isMacOsCredentialStoreSupported()) {
                    this_$iv2 = $this$buttonGroup;
                    label$iv = null;
                    separated$iv = false;
                    $i$f$row = false;
                    $this$row = row$iv3 = this_$iv2.getBuilder().newRow(label$iv, this_$iv2.getButtonGroup(), separated$iv);
                    boolean bl = false;
                    $this$buttonGroup.radioButton($this$row, "In native Keychain", (Object)((Object)ProviderType.KEYCHAIN));
                }
                this_$iv2 = $this$buttonGroup;
                label$iv = null;
                separated$iv = false;
                $i$f$row = false;
                $this$row = row$iv3 = this_$iv2.getBuilder().newRow(label$iv, this_$iv2.getButtonGroup(), separated$iv);
                boolean bl = false;
                PasswordSafeConfigurableUi.access$setKeepassRadioButton$p(this.this$0, (JRadioButton)$this$buttonGroup.radioButton($this$row, "In KeePass", (Object)((Object)ProviderType.KEEPASS)).getComponent());
                Row row = $this$row;
                String label$iv2 = "Database:";
                boolean $i$f$row2 = false;
                Row $this$row2 = row$iv2 = this_$iv.createRow(label$iv2);
                boolean bl2 = false;
                FileChooserDescriptor fileChooserDescriptor3 = fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withFileFilter((Condition)getComponent.1.3.2.1.fileChooserDescriptor.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor3, (String)"fileChooserDescriptor");
                PasswordSafeConfigurableUi.access$setKeePassDbFile$p(this.this$0, Cell.textFieldWithBrowseButton$default((Cell)$this$row2, (String)"KeePass Database File", null, null, (FileChooserDescriptor)fileChooserDescriptor3, (Function1)getComponent.1.3.2.1.1.INSTANCE, (String)(SystemInfo.isWindows ? null : "Stored using weak encryption. It is recommended to store on encrypted volume for additional security."), (int)6, null));
                $this$row2.gearButton(new AnAction[]{(AnAction)this.this$0.new ClearKeePassDatabaseAction(), (AnAction)this.this$0.new ImportKeePassDatabaseAction(), (AnAction)this.this$0.new ChangeKeePassDatabaseMasterPasswordAction()});
                this_$iv = $this$row;
                boolean $i$f$row3 = false;
                Row $this$row3 = row$iv = this_$iv.createRow(null);
                boolean bl3 = false;
                Row this_$iv3 = $this$row3;
                boolean isVerticalFlow$iv = false;
                boolean $i$f$cell = false;
                this_$iv3.setCellMode(true, isVerticalFlow$iv);
                Cell $this$cell = (Cell)this_$iv3;
                boolean bl4 = false;
                PasswordSafeConfigurableUi.access$setUsePgpKey$p(this.this$0, (JCheckBox)Cell.checkBox$default((Cell)$this$cell, (String)PasswordSafeConfigurableUi.access$usePgpKeyText(this.this$0), (Function0)((Function0)new Function0<Boolean>(this, $this$buttonGroup){
                    final /* synthetic */ getComponent$$inlined$panel$lambda$1 this$0;
                    final /* synthetic */ LayoutBuilderWithButtonGroupProperty $this_buttonGroup$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$this_buttonGroup$inlined = layoutBuilderWithButtonGroupProperty;
                        super(0);
                    }

                    public final boolean invoke() {
                        return !PasswordSafeConfigurableUi.access$getPgpListModel$p(this.this$0.this$0).isEmpty() && PasswordSafeConfigurableUi.access$getMySettings$p(this.this$0.this$0).getState().getPgpKeyId() != null;
                    }
                }), (Function1)((Function1)new Function1<Boolean, Unit>(this, $this$buttonGroup){
                    final /* synthetic */ getComponent$$inlined$panel$lambda$1 this$0;
                    final /* synthetic */ LayoutBuilderWithButtonGroupProperty $this_buttonGroup$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$this_buttonGroup$inlined = layoutBuilderWithButtonGroupProperty;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        if (!it) {
                            PasswordSafeConfigurableUi.access$getMySettings$p(this.this$0.this$0).getState().setPgpKeyId(null);
                        }
                    }
                }), null, (int)8, null).getComponent());
                PasswordSafeConfigurableUi.access$setPgpKeyCombo$p(this.this$0, (ComboBox)$this$cell.comboBox((ComboBoxModel)PasswordSafeConfigurableUi.access$getPgpListModel$p(this.this$0), (Function0)new Function0<PgpKey>(this, $this$buttonGroup){
                    final /* synthetic */ getComponent$$inlined$panel$lambda$1 this$0;
                    final /* synthetic */ LayoutBuilderWithButtonGroupProperty $this_buttonGroup$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$this_buttonGroup$inlined = layoutBuilderWithButtonGroupProperty;
                        super(0);
                    }

                    @Nullable
                    public final PgpKey invoke() {
                        PgpKey pgpKey = PasswordSafeConfigurableUi.access$getSelectedPgpKey(this.this$0.this$0);
                        if (pgpKey == null) {
                            List list = PasswordSafeConfigurableUi.access$getPgpListModel$p(this.this$0.this$0).getItems();
                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"pgpListModel.items");
                            pgpKey = (PgpKey)CollectionsKt.firstOrNull((List)list);
                        }
                        return pgpKey;
                    }
                }, (Function1)new Function1<PgpKey, Unit>(this, $this$buttonGroup){
                    final /* synthetic */ getComponent$$inlined$panel$lambda$1 this$0;
                    final /* synthetic */ LayoutBuilderWithButtonGroupProperty $this_buttonGroup$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$this_buttonGroup$inlined = layoutBuilderWithButtonGroupProperty;
                        super(1);
                    }

                    public final void invoke(@Nullable PgpKey it) {
                        String string;
                        PasswordSafeSettings.PasswordSafeOptions passwordSafeOptions = PasswordSafeConfigurableUi.access$getMySettings$p(this.this$0.this$0).getState();
                        if (PasswordSafeConfigurableUi.access$getUsePgpKey$p(this.this$0.this$0).isSelected()) {
                            PgpKey pgpKey = it;
                            string = pgpKey != null ? pgpKey.getKeyId() : null;
                        } else {
                            string = null;
                        }
                        passwordSafeOptions.setPgpKeyId(string);
                    }
                }, GrowPolicy.MEDIUM_TEXT, (ListCellRenderer)CellKt.listCellRenderer((Function4)getComponent.1.3.2.2.1.5.INSTANCE)).enableIf(ComponentPredicateKt.getSelected((AbstractButton)PasswordSafeConfigurableUi.access$getUsePgpKey$p(this.this$0))).getComponent());
                this_$iv3.setCellMode(false, isVerticalFlow$iv);
                this_$iv2 = $this$buttonGroup;
                label$iv = null;
                separated$iv = false;
                $i$f$row = false;
                $this$row = row$iv3 = this_$iv2.getBuilder().newRow(label$iv, this_$iv2.getButtonGroup(), separated$iv);
                boolean bl5 = false;
                $this$buttonGroup.radioButton($this$row, "Do not save, forget passwords after restart", (Object)((Object)ProviderType.MEMORY_ONLY));
            }
        });
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
        panel$iv.setPreferredFocusedComponent(builder$iv.getBuilder().getPreferredFocusedComponent());
        panel$iv.setValidateCallbacks(builder$iv.getBuilder().getValidateCallbacks());
        panel$iv.setApplyCallbacks(builder$iv.getBuilder().getApplyCallbacks());
        panel$iv.setResetCallbacks(builder$iv.getBuilder().getResetCallbacks());
        panel$iv.setModifiedCallbacks(builder$iv.getBuilder().isModifiedCallbacks());
        passwordSafeConfigurableUi.myPanel = dialogPanel = panel$iv;
        DialogPanel dialogPanel2 = this.myPanel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPanel");
        }
        return (JPanel)dialogPanel2;
    }

    private final String usePgpKeyText() {
        String prefix = "Protect master password using PGP key";
        return this.pgpListModel.isEmpty() ? prefix + " (No keys configured)" : prefix + ':';
    }

    private final PgpKey getSelectedPgpKey() {
        PgpKey pgpKey;
        Object v2;
        block3: {
            String string = this.mySettings.getState().getPgpKeyId();
            if (string == null) {
                return null;
            }
            String currentKeyId = string;
            List list = this.pgpListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"pgpListModel.items");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PgpKey it = (PgpKey)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKeyId(), (Object)currentKeyId)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((pgpKey = (PgpKey)v2) == null) {
            List list = this.pgpListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"pgpListModel.items");
            pgpKey = (PgpKey)CollectionsKt.firstOrNull((List)list);
        }
        return pgpKey;
    }

    private final KeePassFileManager createKeePassFileManager() {
        Path path = this.getNewDbFile();
        if (path == null) {
            return null;
        }
        Path path2 = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"getDefaultMasterPasswordFile()");
        return new KeePassFileManager(path, path2, this.getEncryptionSpec(), this.secureRandom);
    }

    private final EncryptionSpec getEncryptionSpec() {
        PgpKey pgpKey = this.getNewPgpKey();
        return pgpKey == null ? new EncryptionSpec(EncryptionSupportKt.getDefaultEncryptionType(), null) : new EncryptionSpec(EncryptionType.PGP_KEY, pgpKey.getKeyId());
    }

    private final PgpKey getNewPgpKey() {
        Object object;
        ComboBox<PgpKey> comboBox = this.pgpKeyCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pgpKeyCombo");
        }
        if (!((object = comboBox.getSelectedItem()) instanceof PgpKey)) {
            object = null;
        }
        return (PgpKey)object;
    }

    public PasswordSafeConfigurableUi(@NotNull PasswordSafeSettings mySettings) {
        Intrinsics.checkParameterIsNotNull((Object)mySettings, (String)"mySettings");
        this.mySettings = mySettings;
        this.pgpListModel = new CollectionComboBoxModel();
        this.pgp$delegate = LazyKt.lazy((Function0)pgp.2.INSTANCE);
        this.secureRandom = LazyKt.lazy((Function0)secureRandom.1.INSTANCE);
    }

    public static final /* synthetic */ JRadioButton access$getKeepassRadioButton$p(PasswordSafeConfigurableUi $this) {
        JRadioButton jRadioButton = $this.keepassRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keepassRadioButton");
        }
        return jRadioButton;
    }

    public static final /* synthetic */ void access$setKeepassRadioButton$p(PasswordSafeConfigurableUi $this, JRadioButton jRadioButton) {
        $this.keepassRadioButton = jRadioButton;
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getKeePassDbFile$p(PasswordSafeConfigurableUi $this) {
        return $this.keePassDbFile;
    }

    public static final /* synthetic */ void access$setKeePassDbFile$p(PasswordSafeConfigurableUi $this, TextFieldWithBrowseButton textFieldWithBrowseButton) {
        $this.keePassDbFile = textFieldWithBrowseButton;
    }

    public static final /* synthetic */ JCheckBox access$getUsePgpKey$p(PasswordSafeConfigurableUi $this) {
        JCheckBox jCheckBox = $this.usePgpKey;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usePgpKey");
        }
        return jCheckBox;
    }

    public static final /* synthetic */ void access$setUsePgpKey$p(PasswordSafeConfigurableUi $this, JCheckBox jCheckBox) {
        $this.usePgpKey = jCheckBox;
    }

    public static final /* synthetic */ String access$usePgpKeyText(PasswordSafeConfigurableUi $this) {
        return $this.usePgpKeyText();
    }

    public static final /* synthetic */ CollectionComboBoxModel access$getPgpListModel$p(PasswordSafeConfigurableUi $this) {
        return $this.pgpListModel;
    }

    public static final /* synthetic */ PasswordSafeSettings access$getMySettings$p(PasswordSafeConfigurableUi $this) {
        return $this.mySettings;
    }

    public static final /* synthetic */ ComboBox access$getPgpKeyCombo$p(PasswordSafeConfigurableUi $this) {
        ComboBox<PgpKey> comboBox = $this.pgpKeyCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pgpKeyCombo");
        }
        return comboBox;
    }

    public static final /* synthetic */ void access$setPgpKeyCombo$p(PasswordSafeConfigurableUi $this, ComboBox comboBox) {
        $this.pgpKeyCombo = comboBox;
    }

    public static final /* synthetic */ PgpKey access$getSelectedPgpKey(PasswordSafeConfigurableUi $this) {
        return $this.getSelectedPgpKey();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ClearKeePassDatabaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "e", "intellij.platform.credentialStore"})
    private final class ClearKeePassDatabaseAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                MessageDialogBuilder messageDialogBuilder = MessageDialogBuilder.yesNo((String)"Clear Passwords", (String)"Are you sure want to remove all passwords?").yesText("Remove Passwords");
                Intrinsics.checkExpressionValueIsNotNull((Object)messageDialogBuilder, (String)"MessageDialogBuilder.yes\u2026sText(\"Remove Passwords\")");
                if (!((MessageDialogBuilder.YesNo)messageDialogBuilder).isYes()) {
                    return;
                }
                PasswordSafeConfigurableKt.access$closeCurrentStore();
                CredentialStoreKt.getLOG().info("Passwords cleared", (Throwable)new Error());
                KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.this.createKeePassFileManager();
                if (keePassFileManager == null) break block1;
                keePassFileManager.clear();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            Path path = PasswordSafeConfigurableUi.this.getNewDbFile();
            presentation.setEnabled(path != null ? PathKt.exists((Path)path) : false);
        }

        public ClearKeePassDatabaseAction() {
            super("Clear");
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ImportKeePassDatabaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.credentialStore"})
    private final class ImportKeePassDatabaseAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            PasswordSafeConfigurableKt.access$closeCurrentStore();
            FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withFileFilter((Condition)actionPerformed.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor2, (String)"FileChooserDescriptorFac\u2026dsWith(\".kdbx\")\n        }");
            LayoutBuilderKt.chooseFile((FileChooserDescriptor)fileChooserDescriptor2, (AnActionEvent)event, (Function1)((Function1)new Function1<VirtualFile, Unit>(this, event){
                final /* synthetic */ ImportKeePassDatabaseAction this$0;
                final /* synthetic */ AnActionEvent $event;

                public final void invoke(@NotNull VirtualFile it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.access$createKeePassFileManager(this.this$0.PasswordSafeConfigurableUi.this);
                        if (keePassFileManager == null) break block0;
                        Path path = Paths.get(it.getPath(), new String[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(it.path)");
                        keePassFileManager.import(path, this.$event);
                    }
                }
                {
                    this.this$0 = importKeePassDatabaseAction;
                    this.$event = anActionEvent;
                    super(1);
                }
            }));
        }

        public ImportKeePassDatabaseAction() {
            super("Import");
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ChangeKeePassDatabaseMasterPasswordAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "e", "intellij.platform.credentialStore"})
    private final class ChangeKeePassDatabaseMasterPasswordAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            PasswordSafeConfigurableKt.access$closeCurrentStore();
            KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.this.createKeePassFileManager();
            if (keePassFileManager != null) {
                if (KeePassFileManager.askAndSetMasterKey$default(keePassFileManager, event, null, 2, null)) {
                    Presentation presentation = this.getTemplatePresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
                    presentation.setText("Change Master Password");
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(PasswordSafeConfigurableUi.this.getNewDbFileAsString() != null);
        }

        public ChangeKeePassDatabaseMasterPasswordAction() {
            StringBuilder stringBuilder = new StringBuilder();
            Path path = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"getDefaultMasterPasswordFile()");
            super(stringBuilder.append(new MasterKeyFileStorage(path).isAutoGenerated() ? "Set" : "Change").append(" Master Password").toString());
        }
    }
}

