/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.FuzzyMap;
import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.IStringConverterInstanceFactory;
import com.beust.jcommander.IVariableArity;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.StringKey;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.converters.DefaultListConverter;
import com.beust.jcommander.converters.EnumConverter;
import com.beust.jcommander.converters.IParameterSplitter;
import com.beust.jcommander.converters.NoConverter;
import com.beust.jcommander.converters.StringConverter;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.beust.jcommander.internal.DefaultConverterFactory;
import com.beust.jcommander.internal.JDK6Console;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.beust.jcommander.internal.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;

public class JCommander {
    public static final String DEBUG_PROPERTY = "jcommander.debug";
    private Map<FuzzyMap.IKey, ParameterDescription> descriptions;
    private List<Object> objects = Lists.newArrayList();
    private MainParameter mainParameter = null;
    private Map<Parameterized, ParameterDescription> requiredFields = Maps.newHashMap();
    private Map<Parameterized, ParameterDescription> fields = Maps.newHashMap();
    private Map<ProgramName, JCommander> commands = Maps.newLinkedHashMap();
    private Map<FuzzyMap.IKey, ProgramName> aliasMap = Maps.newLinkedHashMap();
    private String parsedCommand;
    private String parsedAlias;
    private ProgramName programName;
    private boolean helpWasSpecified;
    private List<String> unknownArgs = Lists.newArrayList();
    private static Console console;
    private final Options options;
    private final IVariableArity DEFAULT_VARIABLE_ARITY = new DefaultVariableArity();

    private JCommander(Options options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        this.addConverterFactory(new DefaultConverterFactory());
    }

    public JCommander() {
        this(new Options());
    }

    public JCommander(Object object) {
        this(object, (ResourceBundle)null);
    }

    public JCommander(Object object, @Nullable ResourceBundle resourceBundle) {
        this(object, resourceBundle, (String[])null);
    }

    public JCommander(Object object, @Nullable ResourceBundle resourceBundle, String ... stringArray) {
        this();
        this.addObject(object);
        if (resourceBundle != null) {
            this.setDescriptionsBundle(resourceBundle);
        }
        this.createDescriptions();
        if (stringArray != null) {
            this.parse(stringArray);
        }
    }

    @Deprecated
    public JCommander(Object object, String ... stringArray) {
        this(object);
        this.parse(stringArray);
    }

    public void setExpandAtSign(boolean bl) {
        this.options.expandAtSign = bl;
    }

    public static Console getConsole() {
        if (console == null) {
            try {
                Method method = System.class.getDeclaredMethod("console", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                console = new JDK6Console(object);
            }
            catch (Throwable throwable) {
                console = new DefaultConsole();
            }
        }
        return console;
    }

    public final void addObject(Object object) {
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                this.objects.add(t);
            }
        } else if (object.getClass().isArray()) {
            for (Object object2 : (Object[])object) {
                this.objects.add(object2);
            }
        } else {
            this.objects.add(object);
        }
    }

    public final void setDescriptionsBundle(ResourceBundle resourceBundle) {
        this.options.bundle = resourceBundle;
    }

    public void parse(String ... stringArray) {
        try {
            this.parse(true, stringArray);
        }
        catch (ParameterException parameterException) {
            parameterException.setJCommander(this);
            throw parameterException;
        }
    }

    public void parseWithoutValidation(String ... stringArray) {
        this.parse(false, stringArray);
    }

    private void parse(boolean bl, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder("Parsing \"");
        stringBuilder.append((CharSequence)this.join(stringArray).append("\"\n  with:").append((CharSequence)this.join(this.objects.toArray())));
        this.p(stringBuilder.toString());
        if (this.descriptions == null) {
            this.createDescriptions();
        }
        this.initializeDefaultValues();
        this.parseValues(this.expandArgs(stringArray), bl);
        if (bl) {
            this.validateOptions();
        }
    }

    private StringBuilder join(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder;
    }

    private void initializeDefaultValues() {
        if (this.options.defaultProvider != null) {
            for (ParameterDescription object : this.descriptions.values()) {
                this.initializeDefaultValue(object);
            }
            for (Map.Entry entry : this.commands.entrySet()) {
                ((JCommander)entry.getValue()).initializeDefaultValues();
            }
        }
    }

    private void validateOptions() {
        if (this.helpWasSpecified) {
            return;
        }
        if (!this.requiredFields.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ParameterDescription parameterDescription : this.requiredFields.values()) {
                arrayList.add("[" + String.join((CharSequence)" | ", parameterDescription.getParameter().names()) + "]");
            }
            String string = String.join((CharSequence)", ", arrayList);
            throw new ParameterException("The following " + JCommander.pluralize(this.requiredFields.size(), "option is required: ", "options are required: ") + (String)string);
        }
        if (this.mainParameter != null && this.mainParameter.description != null) {
            int n;
            Object object;
            ParameterDescription parameterDescription = this.mainParameter.description;
            if (parameterDescription.getParameter().required() && !parameterDescription.isAssigned()) {
                throw new ParameterException("Main parameters are required (\"" + parameterDescription.getDescription() + "\")");
            }
            int n2 = parameterDescription.getParameter().arity();
            if (n2 != -1 && List.class.isAssignableFrom((object = parameterDescription.getParameterized().get(this.mainParameter.object)).getClass()) && (n = ((List)object).size()) != n2) {
                throw new ParameterException("There should be exactly " + n2 + " main parameters but " + n + " were found");
            }
        }
    }

    private static String pluralize(int n, String string, String string2) {
        return n == 1 ? string : string2;
    }

    private String[] expandArgs(String[] stringArray) {
        String[] stringArray2;
        List<String> list = Lists.newArrayList();
        for (String string2 : stringArray) {
            if (string2.startsWith("@") && this.options.expandAtSign) {
                stringArray2 = string2.substring(1);
                list.addAll(this.readFile((String)stringArray2));
                continue;
            }
            stringArray2 = this.expandDynamicArg(string2);
            list.addAll((Collection<String>)stringArray2);
        }
        List list2 = Lists.newArrayList();
        for (String string : list) {
            if (this.isOption(string)) {
                String string2;
                string2 = this.getSeparatorFor(string);
                if (!" ".equals(string2)) {
                    for (String string3 : stringArray2 = string.split("[" + string2 + "]", 2)) {
                        list2.add(string3);
                    }
                    continue;
                }
                list2.add(string);
                continue;
            }
            list2.add(string);
        }
        return list2.toArray(new String[list2.size()]);
    }

    private List<String> expandDynamicArg(String string) {
        for (ParameterDescription parameterDescription : this.descriptions.values()) {
            if (!parameterDescription.isDynamicParameter()) continue;
            for (String string2 : parameterDescription.getParameter().names()) {
                if (!string.startsWith(string2) || string.equals(string2)) continue;
                return Arrays.asList(string2, string.substring(string2.length()));
            }
        }
        return Arrays.asList(string);
    }

    private boolean matchArg(String string, FuzzyMap.IKey iKey) {
        String string2;
        ParameterDescription parameterDescription;
        String string3;
        String string4 = string3 = this.options.caseSensitiveOptions ? iKey.getName() : iKey.getName().toLowerCase();
        return this.options.allowAbbreviatedOptions ? string3.startsWith(string) : ((parameterDescription = this.descriptions.get(iKey)) != null ? (!" ".equals(string2 = this.getSeparatorFor(string)) ? string.startsWith(string3) : string3.equals(string)) : string3.equals(string));
    }

    private boolean isOption(String string) {
        if (this.options.acceptUnknownOptions) {
            return true;
        }
        String string2 = this.options.caseSensitiveOptions ? string : string.toLowerCase();
        for (FuzzyMap.IKey iKey : this.descriptions.keySet()) {
            if (!this.matchArg(string2, iKey)) continue;
            return true;
        }
        for (FuzzyMap.IKey iKey : this.commands.keySet()) {
            if (!this.matchArg(string2, iKey)) continue;
            return true;
        }
        return false;
    }

    private ParameterDescription getPrefixDescriptionFor(String string) {
        for (Map.Entry<FuzzyMap.IKey, ParameterDescription> entry : this.descriptions.entrySet()) {
            if (!string.startsWith(entry.getKey().getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    private ParameterDescription getDescriptionFor(String string) {
        return this.getPrefixDescriptionFor(string);
    }

    private String getSeparatorFor(String string) {
        Parameters parameters;
        ParameterDescription parameterDescription = this.getDescriptionFor(string);
        if (parameterDescription != null && (parameters = parameterDescription.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return parameters.separators();
        }
        return " ";
    }

    private List<String> readFile(String string) {
        List<String> list = Lists.newArrayList();
        try (BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(string, new String[0]), this.options.atFileCharset);){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || string2.trim().startsWith("#")) continue;
                list.add(string2);
            }
        }
        catch (IOException iOException) {
            throw new ParameterException("Could not read file " + string + ": " + iOException);
        }
        return list;
    }

    private static String trim(String string) {
        String string2 = string.trim();
        if (string2.startsWith("\"") && string2.endsWith("\"") && string2.length() > 1) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    private void createDescriptions() {
        this.descriptions = Maps.newHashMap();
        for (Object object : this.objects) {
            this.addDescription(object);
        }
    }

    private void addDescription(Object object) {
        Class<?> clazz = object.getClass();
        List<Parameterized> list = Parameterized.parseArg(object);
        for (Parameterized parameterized : list) {
            Object object2;
            WrappedParameter wrappedParameter = parameterized.getWrappedParameter();
            if (wrappedParameter != null && wrappedParameter.getParameter() != null) {
                object2 = wrappedParameter.getParameter();
                Object object3 = object2;
                if (object3.names().length == 0) {
                    this.p("Found main parameter:" + parameterized);
                    if (this.mainParameter != null) {
                        throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.mainParameter + " and " + parameterized);
                    }
                    this.mainParameter = new MainParameter();
                    this.mainParameter.parameterized = parameterized;
                    this.mainParameter.object = object;
                    this.mainParameter.annotation = (Parameter)object3;
                    this.mainParameter.description = new ParameterDescription(object, (Parameter)object3, parameterized, this.options.bundle, this);
                    continue;
                }
                ParameterDescription parameterDescription = new ParameterDescription(object, (Parameter)object3, parameterized, this.options.bundle, this);
                for (String string : object3.names()) {
                    if (this.descriptions.containsKey(new StringKey(string))) {
                        throw new ParameterException("Found the option " + string + " multiple times");
                    }
                    this.p("Adding description for " + string);
                    this.fields.put(parameterized, parameterDescription);
                    this.descriptions.put(new StringKey(string), parameterDescription);
                    if (!object3.required()) continue;
                    this.requiredFields.put(parameterized, parameterDescription);
                }
                continue;
            }
            if (parameterized.getDelegateAnnotation() != null) {
                object2 = parameterized.get(object);
                if (object2 == null) {
                    throw new ParameterException("Delegate field '" + parameterized.getName() + "' cannot be null.");
                }
                this.addDescription(object2);
                continue;
            }
            if (wrappedParameter == null || wrappedParameter.getDynamicParameter() == null) continue;
            object2 = wrappedParameter.getDynamicParameter();
            for (String string : object2.names()) {
                if (this.descriptions.containsKey(string)) {
                    throw new ParameterException("Found the option " + string + " multiple times");
                }
                this.p("Adding description for " + string);
                ParameterDescription parameterDescription = new ParameterDescription(object, (DynamicParameter)object2, parameterized, this.options.bundle, this);
                this.fields.put(parameterized, parameterDescription);
                this.descriptions.put(new StringKey(string), parameterDescription);
                if (!object2.required()) continue;
                this.requiredFields.put(parameterized, parameterDescription);
            }
        }
    }

    private void initializeDefaultValue(ParameterDescription parameterDescription) {
        for (String string : parameterDescription.getParameter().names()) {
            String string2 = this.options.defaultProvider.getDefaultValueFor(string);
            if (string2 == null) continue;
            this.p("Initializing " + string + " with default value:" + string2);
            parameterDescription.addValue(string2, true);
            this.requiredFields.remove(parameterDescription.getParameterized());
            return;
        }
    }

    private void parseValues(String[] stringArray, boolean bl) {
        int n;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length && !bl2; i += n) {
            Object object;
            Class<?> clazz;
            Object object2;
            String object3;
            String string = stringArray[i];
            stringArray[i] = object3 = JCommander.trim(string);
            this.p("Parsing arg: " + object3);
            JCommander jCommander = this.findCommandByAlias(string);
            n = 1;
            if (!bl3 && !"--".equals(object3) && this.isOption(object3) && jCommander == null) {
                object2 = this.findParameterDescription(object3);
                if (object2 != null) {
                    if (((ParameterDescription)object2).getParameter().password()) {
                        n = this.processPassword(stringArray, i, (ParameterDescription)object2, bl);
                        continue;
                    }
                    if (((ParameterDescription)object2).getParameter().variableArity()) {
                        n = this.processVariableArity(stringArray, i, (ParameterDescription)object2, bl);
                        continue;
                    }
                    clazz = ((ParameterDescription)object2).getParameterized().getType();
                    if ((clazz == Boolean.TYPE || clazz == Boolean.class) && ((ParameterDescription)object2).getParameter().arity() == -1) {
                        object = (Boolean)((ParameterDescription)object2).getParameterized().get(((ParameterDescription)object2).getObject());
                        ((ParameterDescription)object2).addValue(((Boolean)object).booleanValue() ? "false" : "true");
                        this.requiredFields.remove(((ParameterDescription)object2).getParameterized());
                    } else {
                        n = this.processFixedArity(stringArray, i, (ParameterDescription)object2, bl, clazz);
                    }
                    if (!((ParameterDescription)object2).isHelp()) continue;
                    this.helpWasSpecified = true;
                    continue;
                }
                if (this.options.acceptUnknownOptions) {
                    this.unknownArgs.add(string);
                    ++i;
                    while (i < stringArray.length && !this.isOption(stringArray[i])) {
                        this.unknownArgs.add(stringArray[i++]);
                    }
                    n = 0;
                    continue;
                }
                throw new ParameterException("Unknown option: " + (String)string);
            }
            if ("--".equals(string) && !bl3) {
                bl3 = true;
                continue;
            }
            if (this.commands.isEmpty()) {
                Class<? extends IParameterValidator>[] classArray;
                Type type;
                this.initMainParameterValue(string);
                object2 = object3;
                clazz = object2;
                object = this.mainParameter.parameterized.getGenericType();
                if (object instanceof ParameterizedType && (type = (classArray = (Class<? extends IParameterValidator>[])object).getActualTypeArguments()[0]) instanceof Class) {
                    clazz = this.convertValue(this.mainParameter.parameterized, (Class)type, null, (String)object2);
                }
                classArray = this.mainParameter.annotation.validateWith();
                int n2 = classArray.length;
                for (int j = 0; j < n2; ++j) {
                    Class<? extends IParameterValidator> clazz2 = classArray[j];
                    ParameterDescription.validateParameter(this.mainParameter.description, clazz2, "Default", object2);
                }
                this.mainParameter.description.setAssigned(true);
                this.mainParameter.addValue(clazz);
                continue;
            }
            if (jCommander == null && bl) {
                throw new MissingCommandException("Expected a command, got " + (String)string, string);
            }
            if (jCommander == null) continue;
            this.parsedCommand = jCommander.programName.name;
            this.parsedAlias = string;
            jCommander.parse(bl, this.subArray(stringArray, i + 1));
            bl2 = true;
        }
        for (ParameterDescription parameterDescription : this.descriptions.values()) {
            if (!parameterDescription.isAssigned()) continue;
            this.fields.get(parameterDescription.getParameterized()).setAssigned(true);
        }
    }

    private final int determineArity(String[] stringArray, int n, ParameterDescription parameterDescription, IVariableArity iVariableArity) {
        List list = Lists.newArrayList();
        for (int i = n + 1; i < stringArray.length; ++i) {
            list.add(stringArray[i]);
        }
        return iVariableArity.processVariableArity(parameterDescription.getParameter().names()[0], list.toArray(new String[0]));
    }

    private int processPassword(String[] stringArray, int n, ParameterDescription parameterDescription, boolean bl) {
        int n2 = this.determineArity(stringArray, n, parameterDescription, this.DEFAULT_VARIABLE_ARITY);
        if (n2 == 0) {
            char[] cArray = this.readPassword(parameterDescription.getDescription(), parameterDescription.getParameter().echoInput());
            parameterDescription.addValue(new String(cArray));
            this.requiredFields.remove(parameterDescription.getParameterized());
            return 1;
        }
        if (n2 == 1) {
            return this.processFixedArity(stringArray, n, parameterDescription, bl, List.class, 1);
        }
        throw new ParameterException("Password parameter must have at most 1 argument.");
    }

    private int processVariableArity(String[] stringArray, int n, ParameterDescription parameterDescription, boolean bl) {
        Object object = parameterDescription.getObject();
        IVariableArity iVariableArity = !(object instanceof IVariableArity) ? this.DEFAULT_VARIABLE_ARITY : (IVariableArity)object;
        int n2 = this.determineArity(stringArray, n, parameterDescription, iVariableArity);
        int n3 = this.processFixedArity(stringArray, n, parameterDescription, bl, List.class, n2);
        return n3;
    }

    private int processFixedArity(String[] stringArray, int n, ParameterDescription parameterDescription, boolean bl, Class<?> clazz) {
        int n2 = parameterDescription.getParameter().arity();
        int n3 = n2 != -1 ? n2 : 1;
        return this.processFixedArity(stringArray, n, parameterDescription, bl, clazz, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processFixedArity(String[] stringArray, int n, ParameterDescription parameterDescription, boolean bl, Class<?> clazz, int n2) {
        int n3 = n;
        String string = stringArray[n3];
        if (n2 == 0 && (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz))) {
            Boolean bl2 = (Boolean)parameterDescription.getParameterized().get(parameterDescription.getObject());
            parameterDescription.addValue(bl2 != false ? "false" : "true");
            this.requiredFields.remove(parameterDescription.getParameterized());
            return n2 + 1;
        } else {
            if (n2 == 0) {
                throw new ParameterException("Expected a value after parameter " + string);
            }
            if (n3 >= stringArray.length - 1) throw new ParameterException("Expected a value after parameter " + string);
            int n4 = "--".equals(stringArray[n3 + 1]) ? 1 : 0;
            Object object = null;
            if (n3 + n2 >= stringArray.length) throw new ParameterException("Expected " + n2 + " values after " + string);
            for (int i = 1; i <= n2; ++i) {
                String string2 = JCommander.trim(stringArray[n3 + i + n4]);
                object = parameterDescription.addValue(string, string2, false, bl, i - 1);
                this.requiredFields.remove(parameterDescription.getParameterized());
            }
            if (object != null && bl) {
                parameterDescription.validateValueParameter(string, object);
            }
            n3 += n2 + n4;
        }
        return n2 + 1;
    }

    private char[] readPassword(String string, boolean bl) {
        JCommander.getConsole().print(string + ": ");
        return JCommander.getConsole().readPassword(bl);
    }

    private String[] subArray(String[] stringArray, int n) {
        int n2 = stringArray.length - n;
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    private void initMainParameterValue(String string) {
        if (this.mainParameter == null) {
            throw new ParameterException("Was passed main parameter '" + string + "' but no main parameter was defined in your arg class");
        }
        Object object = this.mainParameter.parameterized.get(this.mainParameter.object);
        Class<?> clazz = this.mainParameter.parameterized.getType();
        if (List.class.isAssignableFrom(clazz)) {
            List list = object == null ? Lists.newArrayList() : (List)object;
            if (this.mainParameter.firstTimeMainParameter) {
                list.clear();
                this.mainParameter.firstTimeMainParameter = false;
            }
            this.mainParameter.multipleValue = list;
            this.mainParameter.parameterized.set(this.mainParameter.object, list);
        }
    }

    public String getMainParameterDescription() {
        if (this.descriptions == null) {
            this.createDescriptions();
        }
        return this.mainParameter.annotation != null ? this.mainParameter.annotation.description() : null;
    }

    public void setProgramName(String string) {
        this.setProgramName(string, new String[0]);
    }

    public String getProgramName() {
        return this.programName == null ? null : this.programName.getName();
    }

    public void setProgramName(String string, String ... stringArray) {
        this.programName = new ProgramName(string, Arrays.asList(stringArray));
    }

    public void usage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(string, stringBuilder);
        JCommander.getConsole().println(stringBuilder.toString());
    }

    public void usage(String string, StringBuilder stringBuilder) {
        this.usage(string, stringBuilder, "");
    }

    public void usage(String string, StringBuilder stringBuilder, String string2) {
        String string3 = this.getCommandDescription(string);
        JCommander jCommander = this.findCommandByAlias(string);
        if (string3 != null) {
            stringBuilder.append(string2).append(string3);
            stringBuilder.append("\n");
        }
        jCommander.usage(stringBuilder, string2);
    }

    public String getCommandDescription(String string) {
        JCommander jCommander = this.findCommandByAlias(string);
        if (jCommander == null) {
            throw new ParameterException("Asking description for unknown command: " + string);
        }
        Object object = jCommander.getObjects().get(0);
        Parameters parameters = object.getClass().getAnnotation(Parameters.class);
        ResourceBundle resourceBundle = null;
        String string2 = null;
        if (parameters != null) {
            String string3;
            string2 = parameters.commandDescription();
            String string4 = parameters.resourceBundle();
            resourceBundle = !"".equals(string4) ? ResourceBundle.getBundle(string4, Locale.getDefault()) : this.options.bundle;
            if (resourceBundle != null && !"".equals(string3 = parameters.commandDescriptionKey())) {
                string2 = this.getI18nString(resourceBundle, string3, parameters.commandDescription());
            }
        }
        return string2;
    }

    private String getI18nString(ResourceBundle resourceBundle, String string, String string2) {
        String string3 = resourceBundle != null ? resourceBundle.getString(string) : null;
        return string3 != null ? string3 : string2;
    }

    public void usage() {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(stringBuilder);
        JCommander.getConsole().println(stringBuilder.toString());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void usage(StringBuilder stringBuilder) {
        this.usage(stringBuilder, "");
    }

    public void usage(StringBuilder stringBuilder, String string) {
        Object object;
        Object object2;
        if (this.descriptions == null) {
            this.createDescriptions();
        }
        boolean bl = !this.commands.isEmpty();
        boolean bl2 = !this.descriptions.isEmpty();
        int n = 6;
        int n2 = string.length() + n;
        String string2 = this.programName != null ? this.programName.getDisplayName() : "<main class>";
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(string).append("Usage: ").append(string2);
        if (bl2) {
            stringBuilder2.append(" [options]");
        }
        if (bl) {
            stringBuilder2.append(string).append(" [command] [command options]");
        }
        if (this.mainParameter != null && this.mainParameter.description != null) {
            stringBuilder2.append(" ").append(this.mainParameter.description.getDescription());
        }
        this.wrapDescription(stringBuilder, n2, stringBuilder2.toString());
        stringBuilder.append("\n");
        int n3 = 0;
        List<Object> list = Lists.newArrayList();
        for (ParameterDescription object3 : this.fields.values()) {
            if (object3.getParameter().hidden()) continue;
            list.add(object3);
            int n4 = object3.getNames().length() + 2;
            if (n4 <= n3) continue;
            n3 = n4;
        }
        Collections.sort(list, this.getParameterDescriptionComparator());
        if (list.size() > 0) {
            stringBuilder.append(string).append("  Options:\n");
        }
        for (ParameterDescription parameterDescription : list) {
            WrappedParameter wrappedParameter = parameterDescription.getParameter();
            stringBuilder.append(string).append("  " + (wrappedParameter.required() ? "* " : "  ") + parameterDescription.getNames() + "\n");
            this.wrapDescription(stringBuilder, n2, this.s(n2) + parameterDescription.getDescription());
            object2 = parameterDescription.getDefault();
            if (parameterDescription.isDynamicParameter()) {
                stringBuilder.append("\n" + this.s(n2)).append("Syntax: " + wrappedParameter.names()[0] + "key" + wrappedParameter.getAssignment() + "value");
            }
            if (object2 != null && !parameterDescription.isHelp()) {
                object = Strings.isStringEmpty(object2.toString()) ? "<empty string>" : object2.toString();
                stringBuilder.append("\n" + this.s(n2)).append("Default: " + (String)(wrappedParameter.password() ? "********" : object));
            }
            if (((Class)(object = parameterDescription.getParameterized().getType())).isEnum()) {
                stringBuilder.append("\n" + this.s(n2)).append("Possible Values: " + EnumSet.allOf(object));
            }
            stringBuilder.append("\n");
        }
        if (bl) {
            stringBuilder.append(string + "  Commands:\n");
            for (Map.Entry entry : this.commands.entrySet()) {
                Object object3 = ((JCommander)entry.getValue()).getObjects().get(0);
                object2 = object3.getClass().getAnnotation(Parameters.class);
                if (object2 != null && object2.hidden()) continue;
                object = (ProgramName)entry.getKey();
                String string3 = ((ProgramName)object).getDisplayName();
                String string4 = this.getCommandDescription(((ProgramName)object).getName());
                this.wrapDescription(stringBuilder, n2 + n, string + "    " + string3 + "      " + string4);
                stringBuilder.append("\n");
                JCommander jCommander = this.findCommandByAlias(((ProgramName)object).getName());
                jCommander.usage(stringBuilder, string + "      ");
                stringBuilder.append("\n");
            }
        }
    }

    private Comparator<? super ParameterDescription> getParameterDescriptionComparator() {
        return this.options.parameterDescriptionComparator;
    }

    public void setParameterDescriptionComparator(Comparator<? super ParameterDescription> comparator) {
        this.options.parameterDescriptionComparator = comparator;
    }

    public void setColumnSize(int n) {
        this.options.columnSize = n;
    }

    public int getColumnSize() {
        return this.options.columnSize;
    }

    private void wrapDescription(StringBuilder stringBuilder, int n, String string) {
        int n2 = this.getColumnSize();
        String[] stringArray = string.split(" ");
        int n3 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() > n2 || n3 + 1 + string2.length() <= n2) {
                stringBuilder.append(string2);
                n3 += string2.length();
                if (i == stringArray.length - 1) continue;
                stringBuilder.append(" ");
                ++n3;
                continue;
            }
            stringBuilder.append("\n").append(this.s(n)).append(string2).append(" ");
            n3 = n + 1 + string2.length();
        }
    }

    public List<ParameterDescription> getParameters() {
        return new ArrayList<ParameterDescription>(this.fields.values());
    }

    public ParameterDescription getMainParameterValue() {
        return this.mainParameter.description;
    }

    private void p(String string) {
        if (this.options.verbose > 0 || System.getProperty(DEBUG_PROPERTY) != null) {
            JCommander.getConsole().println("[JCommander] " + string);
        }
    }

    public void setDefaultProvider(IDefaultProvider iDefaultProvider) {
        this.options.defaultProvider = iDefaultProvider;
    }

    public void addConverterFactory(final IStringConverterFactory iStringConverterFactory) {
        this.addConverterInstanceFactory(new IStringConverterInstanceFactory(){

            @Override
            public IStringConverter<?> getConverterInstance(Parameter parameter, Class<?> clazz, String string) {
                Class<IStringConverter<?>> clazz2 = iStringConverterFactory.getConverter(clazz);
                try {
                    if (string == null) {
                        string = parameter.names().length > 0 ? parameter.names()[0] : "[Main class]";
                    }
                    return clazz2 != null ? (IStringConverter)JCommander.instantiateConverter(string, clazz2) : null;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                    throw new ParameterException(reflectiveOperationException);
                }
            }
        });
    }

    public void addConverterInstanceFactory(IStringConverterInstanceFactory iStringConverterInstanceFactory) {
        this.options.converterInstanceFactories.add(0, iStringConverterInstanceFactory);
    }

    private IStringConverter<?> findConverterInstance(Parameter parameter, Class<?> clazz, String string) {
        for (IStringConverterInstanceFactory iStringConverterInstanceFactory : this.options.converterInstanceFactories) {
            IStringConverter<?> iStringConverter = iStringConverterInstanceFactory.getConverterInstance(parameter, clazz, string);
            if (iStringConverter == null) continue;
            return iStringConverter;
        }
        return null;
    }

    public Object convertValue(final Parameterized parameterized, Class clazz, String string, String string2) {
        Parameter parameter = parameterized.getParameter();
        if (parameter == null) {
            return string2;
        }
        if (string == null) {
            string = parameter.names().length > 0 ? parameter.names()[0] : "[Main class]";
        }
        IStringConverter<String> iStringConverter = null;
        if (clazz.isAssignableFrom(List.class)) {
            iStringConverter = JCommander.tryInstantiateConverter(string, parameter.listConverter());
        }
        if (clazz.isAssignableFrom(List.class) && iStringConverter == null) {
            IParameterSplitter iParameterSplitter = JCommander.tryInstantiateConverter(null, parameter.splitter());
            iStringConverter = new DefaultListConverter(iParameterSplitter, new IStringConverter(){

                public Object convert(String string) {
                    Type type = parameterized.findFieldGenericType();
                    return JCommander.this.convertValue(parameterized, type instanceof Class ? (Class)type : String.class, null, string);
                }
            });
        }
        if (iStringConverter == null) {
            iStringConverter = JCommander.tryInstantiateConverter(string, parameter.converter());
        }
        if (iStringConverter == null) {
            iStringConverter = this.findConverterInstance(parameter, clazz, string);
        }
        if (iStringConverter == null && clazz.isEnum()) {
            iStringConverter = new EnumConverter(string, clazz);
        }
        if (iStringConverter == null) {
            iStringConverter = new StringConverter();
        }
        return iStringConverter.convert(string2);
    }

    private static <T> T tryInstantiateConverter(String string, Class<T> clazz) {
        if (clazz == NoConverter.class || clazz == null) {
            return null;
        }
        try {
            return JCommander.instantiateConverter(string, clazz);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private static <T> T instantiateConverter(String string, Class<? extends T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        for (Constructor<?> constructor3 : clazz.getDeclaredConstructors()) {
            constructor3.setAccessible(true);
            Class<?>[] classArray = constructor3.getParameterTypes();
            if (classArray.length == 1 && classArray[0].equals(String.class)) {
                constructor2 = constructor3;
                continue;
            }
            if (classArray.length != 0) continue;
            constructor = constructor3;
        }
        return constructor2 != null ? (T)constructor2.newInstance(string) : (constructor != null ? (T)constructor.newInstance(new Object[0]) : null);
    }

    public void addCommand(String string, Object object) {
        this.addCommand(string, object, new String[0]);
    }

    public void addCommand(Object object) {
        Parameters parameters = object.getClass().getAnnotation(Parameters.class);
        if (parameters != null && parameters.commandNames().length > 0) {
            for (String string : parameters.commandNames()) {
                this.addCommand(string, object);
            }
        } else {
            throw new ParameterException("Trying to add command " + object.getClass().getName() + " without specifying its names in @Parameters");
        }
    }

    public void addCommand(String string, Object object, String ... stringArray) {
        JCommander jCommander = new JCommander(this.options);
        jCommander.addObject(object);
        jCommander.createDescriptions();
        jCommander.setProgramName(string, stringArray);
        ProgramName programName = jCommander.programName;
        this.commands.put(programName, jCommander);
        this.aliasMap.put(new StringKey(string), programName);
        for (String string2 : stringArray) {
            StringKey stringKey = new StringKey(string2);
            if (((Object)stringKey).equals(string)) continue;
            ProgramName programName2 = this.aliasMap.get(stringKey);
            if (programName2 != null && !programName2.equals(programName)) {
                throw new ParameterException("Cannot set alias " + stringKey + " for " + string + " command because it has already been defined for " + programName2.name + " command");
            }
            this.aliasMap.put(stringKey, programName);
        }
    }

    public Map<String, JCommander> getCommands() {
        Map<String, JCommander> map = Maps.newLinkedHashMap();
        for (Map.Entry<ProgramName, JCommander> entry : this.commands.entrySet()) {
            map.put(entry.getKey().name, entry.getValue());
        }
        return map;
    }

    public String getParsedCommand() {
        return this.parsedCommand;
    }

    public String getParsedAlias() {
        return this.parsedAlias;
    }

    private String s(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    private ParameterDescription findParameterDescription(String string) {
        return FuzzyMap.findInMap(this.descriptions, new StringKey(string), this.options.caseSensitiveOptions, this.options.allowAbbreviatedOptions);
    }

    private JCommander findCommand(ProgramName programName) {
        return FuzzyMap.findInMap(this.commands, programName, this.options.caseSensitiveOptions, this.options.allowAbbreviatedOptions);
    }

    private ProgramName findProgramName(String string) {
        return FuzzyMap.findInMap(this.aliasMap, new StringKey(string), this.options.caseSensitiveOptions, this.options.allowAbbreviatedOptions);
    }

    private JCommander findCommandByAlias(String string) {
        ProgramName programName = this.findProgramName(string);
        if (programName == null) {
            return null;
        }
        JCommander jCommander = this.findCommand(programName);
        if (jCommander == null) {
            throw new IllegalStateException("There appears to be inconsistency in the internal command database.  This is likely a bug. Please report.");
        }
        return jCommander;
    }

    public void setVerbose(int n) {
        this.options.verbose = n;
    }

    public void setCaseSensitiveOptions(boolean bl) {
        this.options.caseSensitiveOptions = bl;
    }

    public void setAllowAbbreviatedOptions(boolean bl) {
        this.options.allowAbbreviatedOptions = bl;
    }

    public void setAcceptUnknownOptions(boolean bl) {
        this.options.acceptUnknownOptions = bl;
    }

    public List<String> getUnknownOptions() {
        return this.unknownArgs;
    }

    public void setAllowParameterOverwriting(boolean bl) {
        this.options.allowParameterOverwriting = bl;
    }

    public boolean isParameterOverwritingAllowed() {
        return this.options.allowParameterOverwriting;
    }

    public void setAtFileCharset(Charset charset) {
        this.options.atFileCharset = charset;
    }

    private static final class ProgramName
    implements FuzzyMap.IKey {
        private final String name;
        private final List<String> aliases;

        ProgramName(String string, List<String> list) {
            this.name = string;
            this.aliases = list;
        }

        @Override
        public String getName() {
            return this.name;
        }

        private String getDisplayName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name);
            if (!this.aliases.isEmpty()) {
                stringBuilder.append("(");
                Iterator<String> iterator = this.aliases.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append(")");
            }
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ProgramName programName = (ProgramName)object;
            return !(this.name == null ? programName.name != null : !this.name.equals(programName.name));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public static class Builder {
        private JCommander jCommander = new JCommander();
        private String[] args = null;

        public Builder addObject(Object object) {
            this.jCommander.addObject(object);
            return this;
        }

        public Builder resourceBundle(ResourceBundle resourceBundle) {
            this.jCommander.setDescriptionsBundle(resourceBundle);
            return this;
        }

        public Builder args(String[] stringArray) {
            this.args = stringArray;
            return this;
        }

        public Builder expandAtSign(Boolean bl) {
            this.jCommander.setExpandAtSign(bl);
            return this;
        }

        public Builder programName(String string) {
            this.jCommander.setProgramName(string);
            return this;
        }

        public Builder columnSize(int n) {
            this.jCommander.setColumnSize(n);
            return this;
        }

        public Builder defaultProvider(IDefaultProvider iDefaultProvider) {
            this.jCommander.setDefaultProvider(iDefaultProvider);
            return this;
        }

        public Builder addConverterFactory(IStringConverterFactory iStringConverterFactory) {
            this.jCommander.addConverterFactory(iStringConverterFactory);
            return this;
        }

        public Builder verbose(int n) {
            this.jCommander.setVerbose(n);
            return this;
        }

        public Builder allowAbbreviatedOptions(boolean bl) {
            this.jCommander.setAllowAbbreviatedOptions(bl);
            return this;
        }

        public Builder acceptUnknownOptions(boolean bl) {
            this.jCommander.setAcceptUnknownOptions(bl);
            return this;
        }

        public Builder allowParameterOverwriting(boolean bl) {
            this.jCommander.setAllowParameterOverwriting(bl);
            return this;
        }

        public Builder atFileCharset(Charset charset) {
            this.jCommander.setAtFileCharset(charset);
            return this;
        }

        public Builder addConverterInstanceFactory(IStringConverterInstanceFactory iStringConverterInstanceFactory) {
            this.jCommander.addConverterInstanceFactory(iStringConverterInstanceFactory);
            return this;
        }

        public Builder addCommand(Object object) {
            this.jCommander.addCommand(object);
            return this;
        }

        public Builder addCommand(String string, Object object, String ... stringArray) {
            this.jCommander.addCommand(string, object, stringArray);
            return this;
        }

        public JCommander build() {
            if (this.args != null) {
                this.jCommander.parse(this.args);
            }
            return this.jCommander;
        }
    }

    private class DefaultVariableArity
    implements IVariableArity {
        private DefaultVariableArity() {
        }

        @Override
        public int processVariableArity(String string, String[] stringArray) {
            int n;
            for (n = 0; n < stringArray.length && !JCommander.this.isOption(stringArray[n]); ++n) {
            }
            return n;
        }
    }

    private static class Options {
        private ResourceBundle bundle;
        private IDefaultProvider defaultProvider;
        private Comparator<? super ParameterDescription> parameterDescriptionComparator = new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription parameterDescription, ParameterDescription parameterDescription2) {
                Parameter parameter = parameterDescription.getParameterAnnotation();
                Parameter parameter2 = parameterDescription2.getParameterAnnotation();
                if (parameter != null && parameter.order() != -1 && parameter2 != null && parameter2.order() != -1) {
                    return Integer.compare(parameter.order(), parameter2.order());
                }
                if (parameter != null && parameter.order() != -1) {
                    return -1;
                }
                if (parameter2 != null && parameter2.order() != -1) {
                    return 1;
                }
                return parameterDescription.getLongestName().compareTo(parameterDescription2.getLongestName());
            }
        };
        private int columnSize = 79;
        private boolean acceptUnknownOptions = false;
        private boolean allowParameterOverwriting = false;
        private boolean expandAtSign = true;
        private int verbose = 0;
        private boolean caseSensitiveOptions = true;
        private boolean allowAbbreviatedOptions = false;
        private final List<IStringConverterInstanceFactory> converterInstanceFactories = new CopyOnWriteArrayList<IStringConverterInstanceFactory>();
        private Charset atFileCharset = Charset.defaultCharset();

        private Options() {
        }
    }

    static class MainParameter {
        Parameterized parameterized;
        Object object;
        private Parameter annotation;
        private ParameterDescription description;
        private List<Object> multipleValue = null;
        private Object singleValue = null;
        private boolean firstTimeMainParameter = true;

        MainParameter() {
        }

        public void addValue(Object object) {
            if (this.multipleValue != null) {
                this.multipleValue.add(object);
            } else {
                if (this.singleValue != null) {
                    throw new ParameterException("Only one main parameter allowed but found several: \"" + this.singleValue + "\" and \"" + object + "\"");
                }
                this.singleValue = object;
                this.parameterized.set(this.object, object);
            }
        }
    }
}

