/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class DarculaJBPopupComboPopup<T>
implements ComboPopup,
ItemListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
PropertyChangeListener,
AncestorListener {
    public static final String CLIENT_PROP = "ComboBox.jbPopup";
    private final JComboBox<T> myComboBox;
    private final JList<T> myProxyList;
    private ListPopupImpl myPopup;
    private boolean myJustClosedViaClick;

    public DarculaJBPopupComboPopup(@NotNull JComboBox<T> comboBox2) {
        if (comboBox2 == null) {
            DarculaJBPopupComboPopup.$$$reportNull$$$0(0);
        }
        this.myProxyList = new JBList();
        this.myComboBox = comboBox2;
        this.myProxyList.setModel(comboBox2.getModel());
        this.myComboBox.addPropertyChangeListener(this);
        this.myComboBox.addItemListener(this);
        this.myComboBox.addAncestorListener(this);
    }

    @Override
    public void show() {
        this.myJustClosedViaClick = false;
        if (this.myPopup != null) {
            if (this.myPopup.isVisible()) {
                return;
            }
            this.myPopup.cancel();
        }
        ArrayList items = new ArrayList(this.myComboBox.getModel().getSize());
        int size = this.myComboBox.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            items.add(this.myComboBox.getModel().getElementAt(i));
        }
        BaseListPopupStep step = new BaseListPopupStep<T>("", items){

            @Nullable
            public PopupStep onChosen(T selectedValue, boolean finalChoice) {
                DarculaJBPopupComboPopup.this.myComboBox.setSelectedItem(selectedValue);
                return FINAL_CHOICE;
            }

            public void canceled() {
                DarculaJBPopupComboPopup.this.myComboBox.firePopupMenuCanceled();
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(T value) {
                Component component = DarculaJBPopupComboPopup.this.myComboBox.getRenderer().getListCellRendererComponent(DarculaJBPopupComboPopup.this.myProxyList, value, -1, false, false);
                String string = component instanceof TitledSeparator || component instanceof JSeparator ? "" : (component instanceof JLabel ? ((JLabel)component).getText() : (component instanceof SimpleColoredComponent ? ((SimpleColoredComponent)component).getCharSequence(false).toString() : String.valueOf(value)));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean isSelectable(T value) {
                Component component = DarculaJBPopupComboPopup.this.myComboBox.getRenderer().getListCellRendererComponent(DarculaJBPopupComboPopup.this.myProxyList, value, -1, false, false);
                return !(component instanceof TitledSeparator) && !(component instanceof JSeparator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/darcula/ui/DarculaJBPopupComboPopup$1", "getTextFor"));
            }
        };
        step.setDefaultOptionIndex(this.myComboBox.getSelectedIndex());
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(this.myComboBox));
        this.myPopup = new ListPopupImpl(project, (ListPopupStep)step){

            @Override
            public void cancel(InputEvent e) {
                if (e instanceof MouseEvent) {
                    Point point = new RelativePoint((MouseEvent)e).getPoint((Component)DarculaJBPopupComboPopup.this.myComboBox);
                    DarculaJBPopupComboPopup.this.myJustClosedViaClick = new Rectangle(DarculaJBPopupComboPopup.this.myComboBox.getSize()).contains(point);
                }
                super.cancel(e);
            }
        };
        this.myPopup.setMaxRowCount(10);
        this.myPopup.setRequestFocus(false);
        this.myPopup.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                DarculaJBPopupComboPopup.this.myComboBox.firePopupMenuWillBecomeVisible();
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                DarculaJBPopupComboPopup.this.myComboBox.firePopupMenuWillBecomeInvisible();
                DarculaJBPopupComboPopup.this.myPopup = null;
                DarculaJBPopupComboPopup.this.myProxyList.setCellRenderer(new DefaultListCellRenderer());
                DarculaJBPopupComboPopup.this.myProxyList.setModel(DarculaJBPopupComboPopup.this.myComboBox.getModel());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaJBPopupComboPopup$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        JList list2 = this.myPopup.getList();
        this.configureList(list2);
        Border border = UIManager.getBorder("ComboPopup.border");
        if (border != null) {
            this.myPopup.getContent().setBorder(border);
        }
        this.myProxyList.setCellRenderer(list2.getCellRenderer());
        this.myProxyList.setModel(list2.getModel());
        this.myPopup.setMinimumSize(this.myComboBox.getSize());
        this.myPopup.showUnderneathOf(this.myComboBox);
    }

    protected void configureList(@NotNull JList<T> list2) {
        if (list2 == null) {
            DarculaJBPopupComboPopup.$$$reportNull$$$0(1);
        }
        list2.setFont(this.myComboBox.getFont());
        list2.setForeground(this.myComboBox.getForeground());
        list2.setBackground(this.myComboBox.getBackground());
        list2.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
        list2.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
        list2.setBorder(null);
        list2.setCellRenderer(new MyDelegateRenderer());
        list2.setFocusable(false);
        list2.setSelectionMode(0);
    }

    protected void customizeListRendererComponent(JComponent component) {
        component.setBorder((Border)JBUI.Borders.empty((int)2, (int)8));
    }

    @Override
    public void hide() {
        this.myJustClosedViaClick = false;
        if (this.myPopup == null) {
            return;
        }
        this.myPopup.cancel();
    }

    @Override
    public boolean isVisible() {
        return this.myPopup != null && this.myPopup.isVisible();
    }

    public JList getList() {
        return this.myProxyList;
    }

    @Override
    public MouseListener getMouseListener() {
        return this;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return this;
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    @Override
    public void uninstallingUI() {
        this.myComboBox.removePropertyChangeListener(this);
        this.myComboBox.removeItemListener(this);
        this.myComboBox.removeAncestorListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (("model".equals(propertyName) || "renderer".equals(propertyName) || "editable".equals(propertyName)) && this.isVisible()) {
            this.hide();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.getList()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e) || !this.myComboBox.isEnabled()) {
            return;
        }
        if (this.myComboBox.isEditable()) {
            Component comp = this.myComboBox.getEditor().getEditorComponent();
            if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                comp.requestFocus();
            }
        } else if (this.myComboBox.isRequestFocusEnabled()) {
            this.myComboBox.requestFocus();
        }
        if (this.myJustClosedViaClick) {
            this.myJustClosedViaClick = false;
            return;
        }
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        this.hide();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaJBPopupComboPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "configureList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDelegateRenderer
    implements ListCellRenderer {
        private MyDelegateRenderer() {
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = DarculaJBPopupComboPopup.this.myComboBox.getRenderer().getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            if (component instanceof JComponent && !(component instanceof JSeparator) && !(component instanceof TitledSeparator)) {
                DarculaJBPopupComboPopup.this.customizeListRendererComponent((JComponent)component);
            }
            return component;
        }
    }
}

