/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.GutterContentProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Graphics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicGutterContentProvider
extends GutterContentProvider {
    public static final String EVAL_OUT_MARKER = "\u200c";
    public static final String EVAL_IN_MARKER = "\u200c\u200c";
    protected final boolean isLineRelationshipComputable;

    public BasicGutterContentProvider() {
        this(true);
    }

    public BasicGutterContentProvider(boolean isLineRelationshipComputable) {
        this.isLineRelationshipComputable = isLineRelationshipComputable;
    }

    @Override
    public boolean hasText() {
        return false;
    }

    @Override
    @Nullable
    public String getText(int line2, @NotNull Editor editor) {
        if (editor == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Override
    @Nullable
    public String getToolTip(int line2, @NotNull Editor editor) {
        if (editor == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Override
    public void doAction(int line2, @NotNull Editor editor) {
        if (editor == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void beforeEvaluate(@NotNull Editor editor) {
        if (editor == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(3);
        }
        Document document = editor.getDocument();
        document.insertString(document.getTextLength(), (CharSequence)EVAL_IN_MARKER);
    }

    @Override
    public boolean drawIcon(int line2, @NotNull Graphics g, int y, @NotNull Editor editor) {
        int markerCount;
        if (g == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(5);
        }
        if ((markerCount = BasicGutterContentProvider.getMarkerCount(line2, editor.getDocument())) == EVAL_OUT_MARKER.length() || markerCount == EVAL_IN_MARKER.length()) {
            g.setColor((Color)JBColor.GRAY);
            g.drawString(markerCount == EVAL_IN_MARKER.length() ? ">" : "<", 3, y);
            return true;
        }
        return false;
    }

    @Override
    public final boolean isShowSeparatorLine(int line2, @NotNull Editor editor) {
        Document document;
        if (editor == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(6);
        }
        if (line2 + 1 >= (document = editor.getDocument()).getLineCount()) {
            return true;
        }
        int markerCount = BasicGutterContentProvider.getMarkerCount(line2, document);
        if (markerCount == EVAL_IN_MARKER.length()) {
            return BasicGutterContentProvider.getMarkerCount(line2 + 1, document) != EVAL_OUT_MARKER.length();
        }
        if (!this.isLineRelationshipComputable && markerCount == EVAL_OUT_MARKER.length()) {
            return BasicGutterContentProvider.getMarkerCount(line2 + 1, document) == EVAL_IN_MARKER.length();
        }
        if (!this.isLineRelationshipComputable && markerCount == 0) {
            return BasicGutterContentProvider.getMarkerCount(line2 + 1, document) != 0 || line2 != 0 && BasicGutterContentProvider.getMarkerCount(line2 - 1, document) != 0;
        }
        return this.doIsShowSeparatorLine(line2, editor, document);
    }

    protected boolean doIsShowSeparatorLine(int line2, @NotNull Editor editor, @NotNull Document document) {
        if (editor == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(7);
        }
        if (document == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(8);
        }
        return this.isLineRelationshipComputable;
    }

    private static int getMarkerCount(int line2, @NotNull Document document) {
        if (document == null) {
            BasicGutterContentProvider.$$$reportNull$$$0(9);
        }
        return StringUtil.countChars((CharSequence)document.getImmutableCharSequence(), (char)EVAL_IN_MARKER.charAt(0), (int)document.getLineStartOffset(line2), (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/console/BasicGutterContentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolTip";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeEvaluate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "drawIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowSeparatorLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doIsShowSeparatorLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getMarkerCount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

