/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedContentPanel;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffPanel;
import com.intellij.diff.tools.fragmented.UnifiedEditorHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedEditorRangeHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffViewer
extends ListenerDiffViewerBase {
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final Document myDocument;
    @NotNull
    private final UnifiedDiffPanel myPanel;
    @NotNull
    private final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final TwosideTextDiffProvider.NoIgnore myTextDiffProvider;
    @NotNull
    protected Side myMasterSide;
    @Nullable
    private ChangedBlockData myChangedBlockData;
    private final boolean[] myForceReadOnlyFlags;
    private boolean myReadOnlyLockSet;
    private boolean myDuringOnesideDocumentModification;
    private boolean myDuringTwosideDocumentModification;
    private boolean myStateIsOutOfDate;
    private boolean mySuppressEditorTyping;

    public UnifiedDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myMasterSide = Side.RIGHT;
        this.myReadOnlyLockSet = false;
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myForceReadOnlyFlags = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        boolean leftEditable = this.isEditable(Side.LEFT, false);
        boolean rightEditable = this.isEditable(Side.RIGHT, false);
        if (leftEditable && !rightEditable) {
            this.myMasterSide = Side.LEFT;
        }
        if (!leftEditable && rightEditable) {
            this.myMasterSide = Side.RIGHT;
        }
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = DiffUtil.createEditor(this.myDocument, this.myProject, true, true);
        List<JComponent> titles = DiffUtil.createTextTitles(this.myRequest, Arrays.asList(this.myEditor, this.myEditor));
        UnifiedContentPanel contentPanel = new UnifiedContentPanel(titles, this.myEditor);
        this.myPanel = new UnifiedDiffPanel(this.myProject, contentPanel, this, this.myContext);
        this.myFoldingModel = new MyFoldingModel(this.getProject(), this.myEditor, (Disposable)this);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        this.myTextDiffProvider = DiffUtil.createNoIgnoreTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, (Disposable)this);
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.RIGHT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.RIGHT, true), this.myPanel);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
        this.installTypingSupport();
        this.myPanel.setLoadingContent();
        this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications((UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
    }

    @Override
    protected void onDispose() {
        this.myFoldingModel.destroy();
        super.onDispose();
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        Side side = (Side)DiffUtil.getUserData((UserDataHolder)this.myRequest, (UserDataHolder)this.myContext, DiffUserDataKeys.MASTER_SIDE);
        if (side != null) {
            this.myMasterSide = side;
        }
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
    }

    protected void updateEditorCanBeTyped() {
        this.myEditor.setViewer(this.mySuppressEditorTyping || !this.isEditable(this.myMasterSide, true));
    }

    private void installTypingSupport() {
        if (!this.isEditable(this.myMasterSide, false)) {
            return;
        }
        this.updateEditorCanBeTyped();
        this.myEditor.getColorsScheme().setColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myDocument, (ReadonlyFragmentModificationHandler)new MyReadonlyFragmentModificationHandler());
        this.myDocument.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)this.getDocument(this.myMasterSide));
        this.myDocument.addDocumentListener((DocumentListener)new MyOnesideDocumentListener());
    }

    @Override
    @NotNull
    public List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (this.isEditable(Side.RIGHT, false)) {
            group.add(new ReplaceSelectedChangesAction(Side.LEFT, false));
            group.add(new ReplaceSelectedChangesAction(Side.RIGHT, false));
        }
        group.add((AnAction)Separator.getInstance());
        group.addAll(TextDiffViewerUtil.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        if (indicator == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(5);
        }
        try {
            indicator.checkCanceled();
            Document document1 = this.getContent1().getDocument();
            Document document2 = this.getContent2().getDocument();
            CharSequence[] texts = (CharSequence[])ReadAction.compute(() -> new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()});
            List<LineFragment> fragments = this.myTextDiffProvider.compare(texts[0], texts[1], indicator);
            DocumentContent content1 = this.getContent1();
            DocumentContent content2 = this.getContent2();
            indicator.checkCanceled();
            TwosideDocumentData data = (TwosideDocumentData)ReadAction.compute(() -> {
                indicator.checkCanceled();
                UnifiedFragmentBuilder builder2 = new UnifiedFragmentBuilder(fragments, document1, document2, this.myMasterSide);
                builder2.exec();
                indicator.checkCanceled();
                EditorHighlighter highlighter = this.buildHighlighter(this.myProject, content1, content2, texts[0], texts[1], builder2.getRanges(), builder2.getText().length());
                UnifiedEditorRangeHighlighter rangeHighlighter = new UnifiedEditorRangeHighlighter(this.myProject, document1, document2, builder2.getRanges());
                return new TwosideDocumentData(builder2, highlighter, rangeHighlighter);
            });
            UnifiedFragmentBuilder builder2 = data.getBuilder();
            LineNumberConvertor convertor1 = builder2.getConvertor1();
            LineNumberConvertor convertor2 = builder2.getConvertor2();
            List<LineRange> changedLines = builder2.getChangedLines();
            boolean isContentsEqual = builder2.isEqual();
            CombinedEditorData editorData = new CombinedEditorData(builder2.getText(), data.getHighlighter(), data.getRangeHighlighter(), convertor1.createConvertor(), convertor2.createConvertor());
            Side masterSide = builder2.getMasterSide();
            FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(changedLines, this.getFoldingModelSettings(), this.getDocument(masterSide), (LineNumberConvertor)masterSide.select((Object)convertor1, (Object)convertor2), StringUtil.countNewLines((CharSequence)builder2.getText()) + 1);
            runnable2 = this.apply(editorData, builder2.getBlocks(), convertor1, convertor2, foldingState, isContentsEqual);
        }
        catch (DiffTooBigException e) {
            Runnable runnable3 = () -> {
                this.clearDiffPresentation();
                this.myPanel.setTooBigContent();
            };
            if (runnable3 == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(7);
            }
            return runnable3;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = () -> {
                this.clearDiffPresentation();
                this.myPanel.setErrorContent();
            };
            if (runnable4 == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(8);
            }
            return runnable4;
        }
        if (runnable2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(6);
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.destroyChangedBlockData();
        this.myStateIsOutOfDate = false;
        this.mySuppressEditorTyping = false;
        this.updateEditorCanBeTyped();
    }

    protected void markSuppressEditorTyping() {
        this.mySuppressEditorTyping = true;
        this.updateEditorCanBeTyped();
    }

    protected void markStateIsOutOfDate() {
        this.myStateIsOutOfDate = true;
        this.myFoldingModel.disposeLineConvertor();
        if (this.myChangedBlockData != null) {
            for (UnifiedDiffChange diffChange : this.myChangedBlockData.getDiffChanges()) {
                diffChange.updateGutterActions();
            }
        }
    }

    @Nullable
    private EditorHighlighter buildHighlighter(@Nullable Project project, @NotNull DocumentContent content1, @NotNull DocumentContent content2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<HighlightRange> ranges2, int textLength) {
        if (content1 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(9);
        }
        if (content2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(10);
        }
        if (text1 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(12);
        }
        if (ranges2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(13);
        }
        EditorHighlighter highlighter1 = DiffUtil.initEditorHighlighter(project, content1, text1);
        EditorHighlighter highlighter2 = DiffUtil.initEditorHighlighter(project, content2, text2);
        if (highlighter1 == null && highlighter2 == null) {
            return null;
        }
        if (highlighter1 == null) {
            highlighter1 = DiffUtil.initEmptyEditorHighlighter(text1);
        }
        if (highlighter2 == null) {
            highlighter2 = DiffUtil.initEmptyEditorHighlighter(text2);
        }
        return new UnifiedEditorHighlighter(this.myDocument, highlighter1, highlighter2, ranges2, textLength);
    }

    @NotNull
    private Runnable apply(@NotNull CombinedEditorData data, @NotNull List<? extends ChangedBlock> blocks, @NotNull LineNumberConvertor convertor1, @NotNull LineNumberConvertor convertor2, @Nullable FoldingModelSupport.Data foldingState, boolean isContentsEqual) {
        if (data == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(14);
        }
        if (blocks == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(15);
        }
        if (convertor1 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(16);
        }
        if (convertor2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(17);
        }
        Runnable runnable2 = () -> {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            LineCol oldCaretPosition = LineCol.fromOffset((Document)this.myDocument, (int)this.myEditor.getCaretModel().getPrimaryCaret().getOffset());
            Pair<int[], Side> oldCaretLineTwoside = this.transferLineFromOneside(oldCaretPosition.line);
            this.clearDiffPresentation();
            if (isContentsEqual) {
                boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(this.getContents());
                boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(this.getContents());
                this.myPanel.addNotification(DiffNotifications.createEqualContents(equalCharsets, equalSeparators));
            }
            TIntFunction foldingLineConvertor = this.myFoldingModel.getLineNumberConvertor();
            TIntFunction contentConvertor1 = DiffUtil.getContentLineConvertor(this.getContent1());
            TIntFunction contentConvertor2 = DiffUtil.getContentLineConvertor(this.getContent2());
            this.myEditor.getGutterComponentEx().setLineNumberConvertor(UnifiedDiffViewer.mergeLineConverters(contentConvertor1, data.getLineConvertor1(), foldingLineConvertor), UnifiedDiffViewer.mergeLineConverters(contentConvertor2, data.getLineConvertor2(), foldingLineConvertor));
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.myDuringOnesideDocumentModification = true;
                try {
                    this.myDocument.setText(data.getText());
                }
                finally {
                    this.myDuringOnesideDocumentModification = false;
                }
            });
            if (data.getHighlighter() != null) {
                this.myEditor.setHighlighter(data.getHighlighter());
            }
            DiffUtil.setEditorCodeStyle(this.myProject, this.myEditor, this.getContent(this.myMasterSide));
            if (data.getRangeHighlighter() != null) {
                data.getRangeHighlighter().apply(this.myProject, this.myDocument);
            }
            ArrayList<UnifiedDiffChange> diffChanges = new ArrayList<UnifiedDiffChange>(blocks.size());
            for (Object block : blocks) {
                diffChanges.add(new UnifiedDiffChange(this, (ChangedBlock)block));
            }
            ArrayList<RangeMarker> guarderRangeBlocks = new ArrayList<RangeMarker>();
            if (!this.myEditor.isViewer()) {
                for (ChangedBlock block : blocks) {
                    LineRange range2 = (LineRange)this.myMasterSide.select((Object)block.getRange2(), (Object)block.getRange1());
                    if (range2.isEmpty()) continue;
                    TextRange textRange = DiffUtil.getLinesRange(this.myDocument, range2.start, range2.end);
                    guarderRangeBlocks.add(this.createGuardedBlock(textRange.getStartOffset(), textRange.getEndOffset()));
                }
                int textLength = this.myDocument.getTextLength();
                guarderRangeBlocks.add(this.createGuardedBlock(textLength, textLength));
            }
            this.myChangedBlockData = new ChangedBlockData(diffChanges, guarderRangeBlocks, convertor1, convertor2, isContentsEqual);
            int newCaretLine = this.transferLineToOneside((Side)oldCaretLineTwoside.second, ((Side)oldCaretLineTwoside.second).select((int[])oldCaretLineTwoside.first));
            this.myEditor.getCaretModel().moveToOffset(LineCol.toOffset((Document)this.myDocument, (int)newCaretLine, (int)oldCaretPosition.column));
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myStatusPanel.update();
            this.myPanel.setGoodContent();
            this.myEditor.getGutterComponentEx().revalidateMarkup();
        };
        if (runnable2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(18);
        }
        return runnable2;
    }

    @NotNull
    private RangeMarker createGuardedBlock(int start2, int end) {
        RangeMarker block = this.myDocument.createGuardedBlock(start2, end);
        block.setGreedyToLeft(true);
        block.setGreedyToRight(true);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(19);
        }
        return rangeMarker;
    }

    private static TIntFunction mergeLineConverters(@Nullable TIntFunction contentConvertor, @NotNull TIntFunction unifiedConvertor, @NotNull TIntFunction foldingConvertor) {
        if (unifiedConvertor == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(20);
        }
        if (foldingConvertor == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(21);
        }
        return DiffUtil.mergeLineConverters(DiffUtil.mergeLineConverters(contentConvertor, unifiedConvertor), foldingConvertor);
    }

    public int transferLineToOnesideStrict(@NotNull Side side, int line2) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(22);
        }
        if (this.myChangedBlockData == null) {
            return -1;
        }
        return this.myChangedBlockData.getLineNumberConvertor(side).convertInv(line2);
    }

    public int transferLineFromOnesideStrict(@NotNull Side side, int line2) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(23);
        }
        if (this.myChangedBlockData == null) {
            return -1;
        }
        return this.myChangedBlockData.getLineNumberConvertor(side).convert(line2);
    }

    public int transferLineToOneside(@NotNull Side side, int line2) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(24);
        }
        if (this.myChangedBlockData == null) {
            return line2;
        }
        return this.myChangedBlockData.getLineNumberConvertor(side).convertApproximateInv(line2);
    }

    @NotNull
    public Pair<int[], Side> transferLineFromOneside(int line2) {
        int[] lines = new int[2];
        if (this.myChangedBlockData == null) {
            lines[0] = line2;
            lines[1] = line2;
            Pair pair = Pair.create((Object)lines, (Object)this.myMasterSide);
            if (pair == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(25);
            }
            return pair;
        }
        LineNumberConvertor lineConvertor1 = this.myChangedBlockData.getLineNumberConvertor(Side.LEFT);
        LineNumberConvertor lineConvertor2 = this.myChangedBlockData.getLineNumberConvertor(Side.RIGHT);
        Side side = this.myMasterSide;
        lines[0] = lineConvertor1.convert(line2);
        lines[1] = lineConvertor2.convert(line2);
        if (lines[0] == -1 && lines[1] == -1) {
            lines[0] = lineConvertor1.convertApproximate(line2);
            lines[1] = lineConvertor2.convertApproximate(line2);
        } else if (lines[0] == -1) {
            lines[0] = lineConvertor1.convertApproximate(line2);
            side = Side.RIGHT;
        } else if (lines[1] == -1) {
            lines[1] = lineConvertor2.convertApproximate(line2);
            side = Side.LEFT;
        }
        Pair pair = Pair.create((Object)lines, (Object)side);
        if (pair == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(26);
        }
        return pair;
    }

    private void destroyChangedBlockData() {
        if (this.myChangedBlockData == null) {
            return;
        }
        for (UnifiedDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            change.destroyHighlighter();
        }
        for (RangeMarker block : this.myChangedBlockData.getGuardedRangeBlocks()) {
            this.myDocument.removeGuardedBlock(block);
        }
        this.myChangedBlockData = null;
        UnifiedEditorRangeHighlighter.erase(this.myProject, this.myDocument);
        this.myFoldingModel.destroy();
        this.myStatusPanel.update();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(27);
        }
        if (this.myDuringTwosideDocumentModification) {
            return;
        }
        this.markStateIsOutOfDate();
        this.markSuppressEditorTyping();
        this.scheduleRediff();
    }

    public void replaceChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(28);
        }
        if (sourceSide == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(29);
        }
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getStartLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    public void appendChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(30);
        }
        if (sourceSide == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(31);
        }
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        if (sourceSide.getStartLine(lineFragment) == sourceSide.getEndLine(lineFragment)) {
            return;
        }
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getEndLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(32);
        }
        return textDiffSettings;
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(33);
        }
        return settings;
    }

    @NotNull
    public Side getMasterSide() {
        Side side = this.myMasterSide;
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(34);
        }
        return side;
    }

    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = this.myEditor;
        if (editorEx == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(35);
        }
        return editorEx;
    }

    @NotNull
    protected List<? extends EditorEx> getEditors() {
        List<EditorEx> list2 = Collections.singletonList(this.myEditor);
        if (list2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(36);
        }
        return list2;
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        List list2 = this.myRequest.getContents();
        if (list2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(37);
        }
        return list2;
    }

    @NotNull
    protected DocumentContent getContent(@NotNull Side side) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(38);
        }
        DocumentContent documentContent = (DocumentContent)side.select(this.getContents());
        if (documentContent == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(39);
        }
        return documentContent;
    }

    @NotNull
    protected DocumentContent getContent1() {
        DocumentContent documentContent = this.getContent(Side.LEFT);
        if (documentContent == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(40);
        }
        return documentContent;
    }

    @NotNull
    protected DocumentContent getContent2() {
        DocumentContent documentContent = this.getContent(Side.RIGHT);
        if (documentContent == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(41);
        }
        return documentContent;
    }

    @Nullable
    protected List<UnifiedDiffChange> getDiffChanges() {
        return this.myChangedBlockData == null ? null : this.myChangedBlockData.getDiffChanges();
    }

    @NotNull
    public JComponent getComponent() {
        UnifiedDiffPanel unifiedDiffPanel = this.myPanel;
        if (unifiedDiffPanel == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(42);
        }
        return unifiedDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return this.myEditor.getContentComponent();
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(43);
        }
        return myStatusPanel;
    }

    public boolean isEditable(@NotNull Side side, boolean respectReadOnlyLock) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(44);
        }
        if (this.myReadOnlyLockSet && respectReadOnlyLock) {
            return false;
        }
        if (side.select(this.myForceReadOnlyFlags)) {
            return false;
        }
        return DiffUtil.canMakeWritable(this.getDocument(side));
    }

    @NotNull
    public Document getDocument(@NotNull Side side) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(45);
        }
        Document document = this.getContent(side).getDocument();
        if (document == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(46);
        }
        return document;
    }

    protected boolean isStateIsOutOfDate() {
        return this.myStateIsOutOfDate;
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getNavigatable(LineCol.fromCaret((Editor)this.myEditor));
    }

    @Nullable
    protected UnifiedDiffChange getCurrentChange() {
        if (this.myChangedBlockData == null) {
            return null;
        }
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        for (UnifiedDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            if (!DiffUtil.isSelectedByLine(caretLine, change.getLine1(), change.getLine2())) continue;
            return change;
        }
        return null;
    }

    @Nullable
    protected Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(47);
        }
        Pair<int[], Side> pair = this.transferLineFromOneside(position.line);
        int line1 = ((int[])pair.first)[0];
        int line2 = ((int[])pair.first)[1];
        Navigatable navigatable1 = this.getContent1().getNavigatable(new LineCol(line1, position.column));
        Navigatable navigatable2 = this.getContent2().getNavigatable(new LineCol(line2, position.column));
        if (navigatable1 == null) {
            return navigatable2;
        }
        if (navigatable2 == null) {
            return navigatable1;
        }
        return (Navigatable)((Side)pair.second).select((Object)navigatable1, (Object)navigatable2);
    }

    public boolean isContentGood() {
        return this.myPanel.isGoodContent() && this.myChangedBlockData != null;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(48);
        }
        if (request == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(49);
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        UnifiedDiffChange change;
        if (dataId == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(50);
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getCurrentChange()) != null) {
            return new LineRange(change.getLine1(), change.getLine2());
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor1";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unifiedConvertor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingConvertor";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 38: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardedBlock";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "transferLineFromOneside";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getMasterSide";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent1";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent2";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlighter";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "mergeLineConverters";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "transferLineToOnesideStrict";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "transferLineFromOnesideStrict";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "transferLineToOneside";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChange";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReadonlyFragmentModificationHandler
    implements ReadonlyFragmentModificationHandler {
        private MyReadonlyFragmentModificationHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        @NotNull
        private DisposableLineNumberConvertor myLineNumberConvertor;

        MyFoldingModel(@Nullable Project project, @NotNull EditorEx editor, @NotNull Disposable disposable) {
            if (editor == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            super(project, new EditorEx[]{editor}, disposable);
            this.myLineNumberConvertor = new DisposableLineNumberConvertor(null);
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<? extends LineRange> changedLines, @NotNull FoldingModelSupport.Settings settings, @NotNull Document document, @NotNull LineNumberConvertor lineConvertor, int lineCount) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ComparisonOperation.applyExpressionRewriter(ComparisonOperation.java:138)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:139)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.BooleanOperation.applyExpressionRewriter(BooleanOperation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:139)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.rewriteExpressions(StructuredIf.java:170)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @NotNull
        public TIntFunction getLineNumberConvertor() {
            TIntFunction tIntFunction = this.getLineConvertor(0);
            if (tIntFunction == null) {
                MyFoldingModel.$$$reportNull$$$0(5);
            }
            return tIntFunction;
        }

        public void disposeLineConvertor() {
            this.myLineNumberConvertor.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineConvertor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineNumberConvertor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createState";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DisposableLineNumberConvertor {
            @Nullable
            private volatile LineNumberConvertor myConvertor;

            private DisposableLineNumberConvertor(@Nullable LineNumberConvertor convertor) {
                this.myConvertor = convertor;
            }

            public int convert(int lineNumber) {
                LineNumberConvertor convertor = this.myConvertor;
                return convertor != null ? convertor.convert(lineNumber) : -1;
            }

            public void dispose() {
                this.myConvertor = null;
            }
        }

        private static class MyFoldingBuilder
        extends FoldingModelSupport.FoldingBuilderBase {
            @NotNull
            private final Document myDocument;
            @NotNull
            private final DisposableLineNumberConvertor myLineConvertor;

            private MyFoldingBuilder(@NotNull Document document, @NotNull DisposableLineNumberConvertor lineConvertor, int lineCount, @NotNull FoldingModelSupport.Settings settings) {
                if (document == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(0);
                }
                if (lineConvertor == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(1);
                }
                if (settings == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(2);
                }
                super(new int[]{lineCount}, settings);
                this.myDocument = document;
                this.myLineConvertor = lineConvertor;
            }

            @Override
            @Nullable
            protected FoldingModelSupport.FoldedRangeDescription getDescription(@NotNull Project project, int lineNumber, int index) {
                int masterLine;
                if (project == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(3);
                }
                if ((masterLine = this.myLineConvertor.convert(lineNumber)) == -1) {
                    return null;
                }
                return MyFoldingModel.getLineSeparatorDescription(project, this.myDocument, masterLine);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lineConvertor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel$MyFoldingBuilder";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDescription";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class MyInitialScrollHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        private MyInitialScrollHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list2 = UnifiedDiffViewer.this.getEditors();
            if (list2 == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
        }

        @Override
        public void onSlowRediff() {
        }

        @Override
        @Nullable
        protected LogicalPosition[] getCaretPositions() {
            LogicalPosition position = UnifiedDiffViewer.this.myEditor.getCaretModel().getLogicalPosition();
            Pair<int[], Side> pair = UnifiedDiffViewer.this.transferLineFromOneside(position.line);
            LogicalPosition[] carets = new LogicalPosition[]{this.getPosition(((int[])pair.first)[0], position.column), this.getPosition(((int[])pair.first)[1], position.column)};
            return carets;
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition twosidePosition = (LogicalPosition)UnifiedDiffViewer.this.myMasterSide.selectNotNull((Object[])this.myCaretPosition);
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(UnifiedDiffViewer.this.myMasterSide, twosidePosition.line);
            LogicalPosition position = new LogicalPosition(onesideLine, twosidePosition.column);
            UnifiedDiffViewer.this.myEditor.getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint(UnifiedDiffViewer.this.myEditor, this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret(UnifiedDiffViewer.this.myEditor, false);
            }
            return true;
        }

        @NotNull
        private LogicalPosition getPosition(int line2, int column) {
            if (line2 == -1) {
                LogicalPosition logicalPosition = new LogicalPosition(0, 0);
                if (logicalPosition == null) {
                    MyInitialScrollHelper.$$$reportNull$$$0(1);
                }
                return logicalPosition;
            }
            LogicalPosition logicalPosition = new LogicalPosition(line2, column);
            if (logicalPosition == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(2);
            }
            return logicalPosition;
        }

        private void doScrollToLine(@NotNull Side side, @NotNull LogicalPosition position) {
            if (side == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(3);
            }
            if (position == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(4);
            }
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(side, position.line);
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, onesideLine, position.column, false);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            this.doScrollToLine((Side)this.myScrollToLine.first, new LogicalPosition(((Integer)this.myScrollToLine.second).intValue(), 0));
            return true;
        }

        private boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            if (scrollToChangePolicy == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(5);
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            UnifiedDiffChange targetChange = scrollToChangePolicy.select(changes);
            if (targetChange == null) {
                return false;
            }
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, targetChange.getLine1(), false);
            return true;
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges());
            int line2 = this.myNavigationContext.contextMatchCheck((Iterator)changedLinesIterator);
            if (line2 == -1) {
                AllLinesIterator allLinesIterator = new AllLinesIterator(UnifiedDiffViewer.this.getContent2().getDocument());
                line2 = this.myNavigationContext.contextMatchCheck((Iterator)allLinesIterator);
            }
            if (line2 == -1) {
                return false;
            }
            this.doScrollToLine(Side.RIGHT, new LogicalPosition(line2, 0));
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scrollToChangePolicy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPosition";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "doScrollToLine";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doScrollToChange";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CombinedEditorData {
        @NotNull
        private final CharSequence myText;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;
        @NotNull
        private final TIntFunction myLineConvertor1;
        @NotNull
        private final TIntFunction myLineConvertor2;

        CombinedEditorData(@NotNull CharSequence text2, @Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter, @NotNull TIntFunction convertor1, @NotNull TIntFunction convertor2) {
            if (text2 == null) {
                CombinedEditorData.$$$reportNull$$$0(0);
            }
            if (convertor1 == null) {
                CombinedEditorData.$$$reportNull$$$0(1);
            }
            if (convertor2 == null) {
                CombinedEditorData.$$$reportNull$$$0(2);
            }
            this.myText = text2;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
            this.myLineConvertor1 = convertor1;
            this.myLineConvertor2 = convertor2;
        }

        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                CombinedEditorData.$$$reportNull$$$0(3);
            }
            return charSequence;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public UnifiedEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }

        @NotNull
        public TIntFunction getLineConvertor1() {
            TIntFunction tIntFunction = this.myLineConvertor1;
            if (tIntFunction == null) {
                CombinedEditorData.$$$reportNull$$$0(4);
            }
            return tIntFunction;
        }

        @NotNull
        public TIntFunction getLineConvertor2() {
            TIntFunction tIntFunction = this.myLineConvertor2;
            if (tIntFunction == null) {
                CombinedEditorData.$$$reportNull$$$0(5);
            }
            return tIntFunction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "convertor1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "convertor2";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$CombinedEditorData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$CombinedEditorData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineConvertor1";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineConvertor2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChangedBlockData {
        @NotNull
        private final List<UnifiedDiffChange> myDiffChanges;
        @NotNull
        private final List<RangeMarker> myGuardedRangeBlocks;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor1;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor2;
        private final boolean myIsContentsEqual;

        ChangedBlockData(@NotNull List<UnifiedDiffChange> diffChanges, @NotNull List<RangeMarker> guarderRangeBlocks, @NotNull LineNumberConvertor lineNumberConvertor1, @NotNull LineNumberConvertor lineNumberConvertor2, boolean isContentsEqual) {
            if (diffChanges == null) {
                ChangedBlockData.$$$reportNull$$$0(0);
            }
            if (guarderRangeBlocks == null) {
                ChangedBlockData.$$$reportNull$$$0(1);
            }
            if (lineNumberConvertor1 == null) {
                ChangedBlockData.$$$reportNull$$$0(2);
            }
            if (lineNumberConvertor2 == null) {
                ChangedBlockData.$$$reportNull$$$0(3);
            }
            this.myDiffChanges = diffChanges;
            this.myGuardedRangeBlocks = guarderRangeBlocks;
            this.myLineNumberConvertor1 = lineNumberConvertor1;
            this.myLineNumberConvertor2 = lineNumberConvertor2;
            this.myIsContentsEqual = isContentsEqual;
        }

        @NotNull
        public List<UnifiedDiffChange> getDiffChanges() {
            List<UnifiedDiffChange> list2 = this.myDiffChanges;
            if (list2 == null) {
                ChangedBlockData.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        public List<RangeMarker> getGuardedRangeBlocks() {
            List<RangeMarker> list2 = this.myGuardedRangeBlocks;
            if (list2 == null) {
                ChangedBlockData.$$$reportNull$$$0(5);
            }
            return list2;
        }

        @NotNull
        public LineNumberConvertor getLineNumberConvertor(@NotNull Side side) {
            if (side == null) {
                ChangedBlockData.$$$reportNull$$$0(6);
            }
            LineNumberConvertor lineNumberConvertor = (LineNumberConvertor)side.select((Object)this.myLineNumberConvertor1, (Object)this.myLineNumberConvertor2);
            if (lineNumberConvertor == null) {
                ChangedBlockData.$$$reportNull$$$0(7);
            }
            return lineNumberConvertor;
        }

        public boolean isContentsEqual() {
            return this.myIsContentsEqual;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffChanges";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "guarderRangeBlocks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineNumberConvertor1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineNumberConvertor2";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDiffChanges";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGuardedRangeBlocks";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineNumberConvertor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getLineNumberConvertor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TwosideDocumentData {
        @NotNull
        private final UnifiedFragmentBuilder myBuilder;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;

        TwosideDocumentData(@NotNull UnifiedFragmentBuilder builder2, @Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter) {
            if (builder2 == null) {
                TwosideDocumentData.$$$reportNull$$$0(0);
            }
            this.myBuilder = builder2;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        @NotNull
        public UnifiedFragmentBuilder getBuilder() {
            UnifiedFragmentBuilder unifiedFragmentBuilder = this.myBuilder;
            if (unifiedFragmentBuilder == null) {
                TwosideDocumentData.$$$reportNull$$$0(1);
            }
            return unifiedFragmentBuilder;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public UnifiedEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$TwosideDocumentData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$TwosideDocumentData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return null;
            }
            int changesCount = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges().size();
            if (changesCount == 0 && !UnifiedDiffViewer.this.myChangedBlockData.isContentsEqual()) {
                return DiffBundle.message((String)"diff.all.differences.ignored.text", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{changesCount});
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final List<? extends UnifiedDiffChange> myChanges;
        private int myIndex;

        private ChangedLinesIterator(List<? extends UnifiedDiffChange> changes) {
            if (changes == null) {
                ChangedLinesIterator.$$$reportNull$$$0(0);
            }
            this.myIndex = 0;
            this.myChanges = changes;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < this.myChanges.size();
        }

        @Override
        public void loadNextBlock() {
            LOG.assertTrue(!UnifiedDiffViewer.this.myStateIsOutOfDate);
            UnifiedDiffChange change = this.myChanges.get(this.myIndex);
            ++this.myIndex;
            LineFragment lineFragment = change.getLineFragment();
            Document document = UnifiedDiffViewer.this.getContent2().getDocument();
            CharSequence insertedText = DiffUtil.getLinesContent(document, lineFragment.getStartLine2(), lineFragment.getEndLine2());
            int lineNumber = lineFragment.getStartLine2();
            LineTokenizer tokenizer = new LineTokenizer(insertedText.toString());
            for (String line2 : tokenizer.execute()) {
                this.addLine(lineNumber, line2);
                ++lineNumber;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedLinesIterator", "<init>"));
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.ReadOnlyLockAction {
        MyReadOnlyLockAction() {
            super(UnifiedDiffViewer.this.getContext());
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            UnifiedDiffViewer.this.myReadOnlyLockSet = readOnly;
            if (UnifiedDiffViewer.this.myChangedBlockData != null) {
                for (UnifiedDiffChange unifiedDiffChange : UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    unifiedDiffChange.updateGutterActions();
                }
            }
            UnifiedDiffViewer.this.updateEditorCanBeTyped();
            this.putEditorHint(UnifiedDiffViewer.this.myEditor, readOnly && UnifiedDiffViewer.this.isEditable(UnifiedDiffViewer.this.myMasterSide, false));
        }

        @Override
        protected boolean canEdit() {
            return !UnifiedDiffViewer.this.myForceReadOnlyFlags[0] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent1().getDocument()) || !UnifiedDiffViewer.this.myForceReadOnlyFlags[1] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent2().getDocument());
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction() {
            super(UnifiedDiffViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            UnifiedDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line2) {
            if (editor == null) {
                MyOpenInEditorWithMouseAction.$$$reportNull$$$0(0);
            }
            if (editor != UnifiedDiffViewer.this.myEditor) {
                return null;
            }
            return UnifiedDiffViewer.this.getNavigatable(new LineCol(line2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyOpenInEditorWithMouseAction", "getNavigatable"));
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<UnifiedDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<UnifiedDiffChange> getChanges() {
            List list2 = ContainerUtil.notNullize(UnifiedDiffViewer.this.getDiffChanges());
            if (list2 == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = UnifiedDiffViewer.this.myEditor;
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull UnifiedDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return change.getLine1();
        }

        @Override
        protected int getEndLine(@NotNull UnifiedDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return change.getLine2();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        AppendSelectedChangesAction(Side focusedSide, boolean shortcut) {
            if (focusedSide == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText("Append");
            this.getTemplatePresentation().setIcon(DiffUtil.getArrowDownIcon(focusedSide));
        }

        @Override
        protected void apply(@NotNull List<? extends UnifiedDiffChange> changes) {
            if (changes == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (UnifiedDiffChange unifiedDiffChange : changes) {
                UnifiedDiffViewer.this.appendChange(unifiedDiffChange, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$AppendSelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        ReplaceSelectedChangesAction(Side focusedSide, boolean shortcut) {
            if (focusedSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText((String)focusedSide.select((Object)"Revert", (Object)"Accept"));
            this.getTemplatePresentation().setIcon((Icon)focusedSide.select((Object)AllIcons.Diff.Remove, (Object)AllIcons.Actions.Checked));
        }

        @Override
        protected void apply(@NotNull List<? extends UnifiedDiffChange> changes) {
            if (changes == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (UnifiedDiffChange unifiedDiffChange : changes) {
                UnifiedDiffViewer.this.replaceChange(unifiedDiffChange, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ReplaceSelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends AnAction
    implements DumbAware {
        @NotNull
        protected final Side myModifiedSide;
        protected final boolean myShortcut;

        ApplySelectedChangesActionBase(Side modifiedSide, boolean shortcut) {
            if (modifiedSide == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            this.myModifiedSide = modifiedSide;
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != UnifiedDiffViewer.this.getEditor()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true) || UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(this.isSomeChangeSelected());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<UnifiedDiffChange> selectedChanges;
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            if ((selectedChanges = this.getSelectedChanges()).isEmpty()) {
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true)) {
                return;
            }
            if (UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                return;
            }
            String title = e.getPresentation().getText() + " selected changes";
            DiffUtil.executeWriteCommand(UnifiedDiffViewer.this.getDocument(this.myModifiedSide), e.getProject(), title, () -> {
                this.apply(ContainerUtil.reverse((List)selectedChanges));
                UnifiedDiffViewer.this.scheduleRediff();
            });
        }

        protected boolean isSomeChangeSelected() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            if (changes.isEmpty()) {
                return false;
            }
            return DiffUtil.isSomeRangeSelected(UnifiedDiffViewer.this.getEditor(), (Condition<? super BitSet>)((Condition)lines -> ContainerUtil.exists((Iterable)changes, change -> this.isChangeSelected((UnifiedDiffChange)change, (BitSet)lines))));
        }

        @NotNull
        private List<UnifiedDiffChange> getSelectedChanges() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                List<UnifiedDiffChange> list2 = Collections.emptyList();
                if (list2 == null) {
                    ApplySelectedChangesActionBase.$$$reportNull$$$0(3);
                }
                return list2;
            }
            BitSet lines = DiffUtil.getSelectedLines(UnifiedDiffViewer.this.myEditor);
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            List list3 = ContainerUtil.filter(changes, change -> this.isChangeSelected((UnifiedDiffChange)change, lines));
            if (list3 == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(4);
            }
            return list3;
        }

        private boolean isChangeSelected(@NotNull UnifiedDiffChange change, @NotNull BitSet lines) {
            if (change == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(5);
            }
            if (lines == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(6);
            }
            return DiffUtil.isSelectedByLine(lines, change.getLine1(), change.getLine2());
        }

        protected abstract void apply(@NotNull List<? extends UnifiedDiffChange> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedSide";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ApplySelectedChangesActionBase";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ApplySelectedChangesActionBase";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isChangeSelected";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyOnesideDocumentListener
    implements DocumentListener {
        private MyOnesideDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyOnesideDocumentListener.$$$reportNull$$$0(0);
            }
            if (UnifiedDiffViewer.this.myDuringOnesideDocumentModification) {
                return;
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                LOG.warn("oneside beforeDocumentChange - myChangedBlockData == null");
                return;
            }
            try {
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = true;
                Document twosideDocument = UnifiedDiffViewer.this.getDocument(UnifiedDiffViewer.this.myMasterSide);
                LineCol onesideStartPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)e.getOffset());
                LineCol onesideEndPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)(e.getOffset() + e.getOldLength()));
                int line1 = onesideStartPosition.line;
                int line2 = onesideEndPosition.line + 1;
                int shift = DiffUtil.countLinesShift(e);
                int twosideStartLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideStartPosition.line);
                int twosideEndLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideEndPosition.line);
                if (twosideStartLine == -1 || twosideEndLine == -1) {
                    this.logDebugInfo(e, onesideStartPosition, onesideEndPosition, twosideStartLine, twosideEndLine);
                    UnifiedDiffViewer.this.markSuppressEditorTyping();
                    return;
                }
                int twosideStartOffset = twosideDocument.getLineStartOffset(twosideStartLine) + onesideStartPosition.column;
                int twosideEndOffset = twosideDocument.getLineStartOffset(twosideEndLine) + onesideEndPosition.column;
                twosideDocument.replaceString(twosideStartOffset, twosideEndOffset, e.getNewFragment());
                for (UnifiedDiffChange change : UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    change.processChange(line1, line2, shift);
                }
                LineNumberConvertor masterConvertor = UnifiedDiffViewer.this.myChangedBlockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide);
                LineNumberConvertor slaveConvertor = UnifiedDiffViewer.this.myChangedBlockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide.other());
                masterConvertor.handleMasterChange(line1, line2, shift, true);
                slaveConvertor.handleMasterChange(line1, line2, shift, false);
            }
            finally {
                UnifiedDiffViewer.this.markStateIsOutOfDate();
                UnifiedDiffViewer.this.scheduleRediff();
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = false;
            }
        }

        private void logDebugInfo(DocumentEvent e, LineCol onesideStartPosition, LineCol onesideEndPosition, int twosideStartLine, int twosideEndLine) {
            StringBuilder info = new StringBuilder();
            Document document1 = UnifiedDiffViewer.this.getDocument(Side.LEFT);
            Document document2 = UnifiedDiffViewer.this.getDocument(Side.RIGHT);
            info.append("==== UnifiedDiffViewer Debug Info ====");
            info.append("myMasterSide - ").append(UnifiedDiffViewer.this.myMasterSide).append('\n');
            info.append("myLeftDocument.length() - ").append(document1.getTextLength()).append('\n');
            info.append("myRightDocument.length() - ").append(document2.getTextLength()).append('\n');
            info.append("myDocument.length() - ").append(UnifiedDiffViewer.this.myDocument.getTextLength()).append('\n');
            info.append("e.getOffset() - ").append(e.getOffset()).append('\n');
            info.append("e.getNewLength() - ").append(e.getNewLength()).append('\n');
            info.append("e.getOldLength() - ").append(e.getOldLength()).append('\n');
            info.append("onesideStartPosition - ").append(onesideStartPosition).append('\n');
            info.append("onesideEndPosition - ").append(onesideEndPosition).append('\n');
            info.append("twosideStartLine - ").append(twosideStartLine).append('\n');
            info.append("twosideEndLine - ").append(twosideEndLine).append('\n');
            Pair<int[], Side> pair1 = UnifiedDiffViewer.this.transferLineFromOneside(onesideStartPosition.line);
            Pair<int[], Side> pair2 = UnifiedDiffViewer.this.transferLineFromOneside(onesideEndPosition.line);
            info.append("non-strict transferStartLine - ").append(((int[])pair1.first)[0]).append("-").append(((int[])pair1.first)[1]).append(":").append(pair1.second).append('\n');
            info.append("non-strict transferEndLine - ").append(((int[])pair2.first)[0]).append("-").append(((int[])pair2.first)[1]).append(":").append(pair2.second).append('\n');
            info.append("---- UnifiedDiffViewer Debug Info ----");
            LOG.warn(info.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyOnesideDocumentListener", "beforeDocumentChange"));
        }
    }
}

