/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u0002H\r\"\u0006\b\u0000\u0010\r\u0018\u00012\u0006\u0010\u000e\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u000fJ)\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J#\u0010\u0017\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0001H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiContentHelper;", "", "()V", "JSON_MIME_TYPE", "", "V3_DIFF_JSON_MIME_TYPE", "V3_HTML_JSON_MIME_TYPE", "V3_JSON_MIME_TYPE", "jackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJackson", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "fromJson", "T", "string", "(Ljava/lang/String;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "loadImage", "Ljava/awt/Image;", "stream", "Ljava/io/InputStream;", "readJson", "reader", "Ljava/io/Reader;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "(Ljava/io/Reader;Lcom/fasterxml/jackson/databind/JavaType;)Ljava/lang/Object;", "toJson", "content", "intellij.vcs.github"})
public final class GithubApiContentHelper {
    @NotNull
    public static final String JSON_MIME_TYPE = "application/json";
    @NotNull
    public static final String V3_JSON_MIME_TYPE = "application/vnd.github.v3+json";
    @NotNull
    public static final String V3_HTML_JSON_MIME_TYPE = "application/vnd.github.v3.html+json";
    @NotNull
    public static final String V3_DIFF_JSON_MIME_TYPE = "application/vnd.github.v3.diff+json";
    @NotNull
    private static final ObjectMapper jackson;
    public static final GithubApiContentHelper INSTANCE;

    @NotNull
    public final ObjectMapper getJackson() {
        return jackson;
    }

    public final /* synthetic */ <T> T fromJson(@NotNull String string) throws GithubJsonException {
        int $i$f$fromJson = 0;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)GithubApiContentHelper.fromJson(string, Object.class);
    }

    @JvmStatic
    public static final <T> T fromJson(@NotNull String string, @NotNull Class<T> clazz) throws GithubJsonException {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        try {
            return (T)jackson.readValue(string, clazz);
        }
        catch (JsonParseException e) {
            throw (Throwable)new GithubJsonException("Can't parse GitHub response", e);
        }
    }

    @JvmStatic
    public static final <T> T readJson(@NotNull Reader reader, @NotNull JavaType type) throws GithubJsonException {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        try {
            if (type.isTypeOrSubTypeOf(Unit.class) || type.isTypeOrSubTypeOf(Void.class)) {
                return (T)Unit.INSTANCE;
            }
            return (T)jackson.readValue(reader, type);
        }
        catch (JsonProcessingException e) {
            throw (Throwable)new GithubJsonException("Can't parse GitHub response", e);
        }
    }

    @JvmStatic
    @NotNull
    public static final String toJson(@NotNull Object content) throws GithubJsonException {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        try {
            String string = jackson.writeValueAsString(content);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jackson.writeValueAsString(content)");
            return string;
        }
        catch (JsonProcessingException e) {
            throw (Throwable)new GithubJsonException("Can't serialize GitHub request body", e);
        }
    }

    @JvmStatic
    @NotNull
    public static final Image loadImage(@NotNull InputStream stream) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        BufferedImage bufferedImage = ImageIO.read(stream);
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"ImageIO.read(stream)");
        return bufferedImage;
    }

    private GithubApiContentHelper() {
    }

    static {
        GithubApiContentHelper githubApiContentHelper;
        INSTANCE = githubApiContentHelper = new GithubApiContentHelper();
        ObjectMapper objectMapper = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")).setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper()\n    .setD\u2026toDetect.Visibility.ANY))");
        jackson = objectMapper;
    }
}

