/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRuleId;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public abstract class AbstractPatternRule
extends Rule {
    protected final Language language;
    protected final List<PatternToken> patternTokens;
    protected final Pattern regex;
    protected final int regexMark;
    protected final boolean testUnification;
    protected final boolean sentStart;
    protected final List<Match> suggestionMatches = new ArrayList<Match>();
    protected final List<Match> suggestionMatchesOutMsg = new ArrayList<Match>();
    protected final List<DisambiguationPatternRule> antiPatterns = new ArrayList<DisambiguationPatternRule>();
    protected String subId;
    protected int startPositionCorrection;
    protected int endPositionCorrection;
    protected String suggestionsOutMsg;
    protected RuleFilter filter;
    protected String filterArgs;
    protected String message;
    protected String sourceFile = null;
    private final String id;
    private final String description;
    private final boolean getUnified;
    private final boolean groupsOrUnification;

    public AbstractPatternRule(String id, String description, Language language, Pattern regex, int regexMark) {
        this(id, description, language, null, regex, regexMark, false);
    }

    public AbstractPatternRule(String id, String description, Language language, List<PatternToken> patternTokens, boolean getUnified, String message) {
        this(id, description, language, patternTokens, null, 0, getUnified);
        this.message = message;
    }

    public AbstractPatternRule(String id, String description, Language language, List<PatternToken> patternTokens, boolean getUnified) {
        this(id, description, language, patternTokens, null, 0, getUnified);
    }

    private AbstractPatternRule(String id, String description, Language language, List<PatternToken> patternTokens, Pattern regex, int regexMark, boolean getUnified) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.description = Objects.requireNonNull(description, "description ('name' in XML) cannot be null");
        this.language = Objects.requireNonNull(language, "language cannot be null");
        this.getUnified = getUnified;
        if (patternTokens == null && regex == null) {
            throw new IllegalArgumentException("patternTokens and regex cannot both be null");
        }
        if (patternTokens != null) {
            this.patternTokens = new ArrayList<PatternToken>(patternTokens);
            this.testUnification = this.initUnifier();
            boolean bl = this.sentStart = this.patternTokens.size() > 0 && this.patternTokens.get(0).isSentenceStart();
            if (!this.testUnification) {
                boolean found = false;
                for (PatternToken elem : this.patternTokens) {
                    if (!elem.hasAndGroup()) continue;
                    found = true;
                    break;
                }
                this.groupsOrUnification = found;
            } else {
                this.groupsOrUnification = true;
            }
            this.regex = null;
            this.regexMark = 0;
        } else {
            this.regex = regex;
            if (regexMark < 0) {
                throw new IllegalArgumentException("mark must be >= 0: " + regexMark);
            }
            this.regexMark = regexMark;
            this.patternTokens = null;
            this.groupsOrUnification = false;
            this.sentStart = false;
            this.testUnification = false;
        }
    }

    @Override
    public boolean supportsLanguage(Language language) {
        return language.equalsConsiderVariantsIfSpecified(this.language);
    }

    private boolean initUnifier() {
        for (PatternToken pToken : this.patternTokens) {
            if (!pToken.isUnified()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.id + "[" + this.subId + "]" + (this.sourceFile != null ? "@" + this.sourceFile : "") + ":" + this.patternTokens + ":" + this.description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getSourceFile() {
        return this.sourceFile;
    }

    void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        return null;
    }

    public final Language getLanguage() {
        return this.language;
    }

    public final void setStartPositionCorrection(int startPositionCorrection) {
        this.startPositionCorrection = startPositionCorrection;
    }

    public final int getStartPositionCorrection() {
        return this.startPositionCorrection;
    }

    public final void setEndPositionCorrection(int endPositionCorrection) {
        this.endPositionCorrection = endPositionCorrection;
    }

    public final int getEndPositionCorrection() {
        return this.endPositionCorrection;
    }

    @Override
    public String getFullId() {
        if (this.subId != null) {
            return this.id + "[" + this.subId + "]";
        }
        return this.id;
    }

    public PatternRuleId getPatternRuleId() {
        if (this.subId != null) {
            return new PatternRuleId(this.id, this.subId);
        }
        return new PatternRuleId(this.id);
    }

    public final String getSubId() {
        return this.subId;
    }

    public final void setSubId(String subId) {
        this.subId = subId;
    }

    public boolean isGroupsOrUnification() {
        return this.groupsOrUnification;
    }

    public boolean isGetUnified() {
        return this.getUnified;
    }

    public boolean isSentStart() {
        return this.sentStart;
    }

    public boolean isTestUnification() {
        return this.testUnification;
    }

    public List<PatternToken> getPatternTokens() {
        return this.patternTokens;
    }

    public final void addSuggestionMatch(Match m) {
        this.suggestionMatches.add(m);
    }

    public final void addSuggestionMatchOutMsg(Match m) {
        this.suggestionMatchesOutMsg.add(m);
    }

    List<Match> getSuggestionMatches() {
        return this.suggestionMatches;
    }

    List<Match> getSuggestionMatchesOutMsg() {
        return this.suggestionMatchesOutMsg;
    }

    @NotNull
    public final String getSuggestionsOutMsg() {
        return this.suggestionsOutMsg;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    public void setFilter(RuleFilter filter) {
        this.filter = filter;
    }

    @Nullable
    public RuleFilter getFilter() {
        return this.filter;
    }

    public void setFilterArguments(String filterArgs) {
        this.filterArgs = filterArgs;
    }

    @Nullable
    public String getFilterArguments() {
        return this.filterArgs;
    }

    public void setAntiPatterns(List<DisambiguationPatternRule> antiPatterns) {
        this.antiPatterns.addAll(antiPatterns);
    }

    @Override
    public final List<DisambiguationPatternRule> getAntiPatterns() {
        return Collections.unmodifiableList(this.antiPatterns);
    }

    String getShortMessage() {
        return "";
    }
}

