/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.CFFFont;
import com.itextpdf.text.pdf.CFFFontSubset;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectObject;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.TrueTypeFontSubSet;
import com.itextpdf.text.pdf.TrueTypeFontUnicode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class TtfUnicodeWriter {
    protected PdfWriter writer = null;

    public TtfUnicodeWriter(PdfWriter writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFont(TrueTypeFontUnicode font, PdfIndirectReference ref, Object[] params, byte[] rotbits) throws DocumentException, IOException {
        PdfIndirectReference ind_font;
        PdfIndirectObject obj;
        PdfDictionary pobj;
        Object cff;
        byte[] b;
        HashMap longTag = (HashMap)params[0];
        font.addRangeUni(longTag, true, font.subset);
        int[][] metrics = (int[][])longTag.values().toArray((T[])new int[0][]);
        Arrays.sort(metrics, font);
        if (font.cff) {
            b = font.readCffFont();
            if (font.subset || font.subsetRanges != null) {
                cff = new CFFFontSubset(new RandomAccessFileOrArray(b), longTag);
                try {
                    b = ((CFFFontSubset)cff).Process(((CFFFont)cff).getNames()[0]);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(TtfUnicodeWriter.class).error("Issue in CFF font subsetting.Subsetting was disabled", e);
                    font.setSubset(false);
                    font.addRangeUni(longTag, true, font.subset);
                    metrics = (int[][])longTag.values().toArray((T[])new int[0][]);
                    Arrays.sort(metrics, font);
                }
            }
            pobj = new BaseFont.StreamFont(b, "CIDFontType0C", font.compressionLevel);
            obj = this.writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        } else {
            if (font.subset || font.directoryOffset != 0) {
                cff = font.rf;
                synchronized (cff) {
                    TrueTypeFontSubSet sb = new TrueTypeFontSubSet(font.fileName, new RandomAccessFileOrArray(font.rf), new HashSet<Integer>(longTag.keySet()), font.directoryOffset, true, false);
                    b = sb.process();
                }
            } else {
                b = font.getFullFont();
            }
            int[] lengths = new int[]{b.length};
            pobj = new BaseFont.StreamFont(b, lengths, font.compressionLevel);
            obj = this.writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        String subsetPrefix = "";
        if (font.subset) {
            subsetPrefix = font.createSubsetPrefix();
        }
        PdfDictionary dic = font.getFontDescriptor(ind_font, subsetPrefix, null);
        obj = this.writer.addToBody(dic);
        ind_font = obj.getIndirectReference();
        pobj = font.getCIDFontType2(ind_font, subsetPrefix, (Object[])metrics);
        obj = this.writer.addToBody(pobj);
        ind_font = obj.getIndirectReference();
        pobj = font.getToUnicode((Object[])metrics);
        PdfIndirectReference toUnicodeRef = null;
        if (pobj != null) {
            obj = this.writer.addToBody(pobj);
            toUnicodeRef = obj.getIndirectReference();
        }
        pobj = font.getFontBaseType(ind_font, subsetPrefix, toUnicodeRef);
        this.writer.addToBody((PdfObject)pobj, ref);
    }
}

