/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class PasteAsPlainTextAction
extends AbstractAction {
    private MindMapController mMindMapController;
    private static Logger logger;

    public PasteAsPlainTextAction(MindMapController pMindMapController) {
        super(pMindMapController.getText("paste_as_plain_text"), null);
        this.mMindMapController = pMindMapController;
        if (logger == null) {
            logger = this.mMindMapController.getFrame().getLogger(this.getClass().getName());
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent pArg0) {
        Transferable clipboardContents = this.mMindMapController.getClipboardContents();
        if (clipboardContents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String plainText = (String)clipboardContents.getTransferData(DataFlavor.stringFlavor);
                plainText = HtmlTools.makeValidXml(plainText);
                logger.info("Pasting string " + plainText);
                MindMapNode selected = this.mMindMapController.getSelected();
                MindMapNode newNode = this.mMindMapController.addNewNode(selected, selected.getChildCount(), selected.isLeft());
                this.mMindMapController.setNodeText(newNode, plainText);
            }
            catch (UnsupportedFlavorException e) {
                Resources.getInstance().logException(e);
            }
            catch (IOException e) {
                Resources.getInstance().logException(e);
            }
        } else {
            logger.warning("String flavor not supported for transferable " + clipboardContents);
        }
    }
}

