# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ParallelRenderManager(Object):
    """
    ParallelRenderManager - An object to control parallel rendering.
    
    Superclass: Object
    
    ParallelRenderManager operates in multiple processes.  It provides
    proper renderers and render windows for performing the parallel
    rendering correctly.  It can also attach itself to render windows and
    propagate rendering events and camera views.
    
    @attention Many parallel rendering schemes do not correctly handle
    transparency. Unless otherwise documented, assume a sub class does
    not.
    
    @todo Synchronization/barrier primitives.
    
    @todo Query ranges of scalar values of objects in addition to the
    boundary in three-space
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkParallelRenderManager, obj, update, **traits)
    
    auto_image_reduction_factor = tvtk_base.false_bool_trait(desc=\
        """
        If on, the reduction_factor is automatically adjusted to best meet
        the the desired_update_rate in the current render_window based on
        metrics from the last render.
        """
    )

    def _auto_image_reduction_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutoImageReductionFactor,
                        self.auto_image_reduction_factor_)

    magnify_images = tvtk_base.true_bool_trait(desc=\
        """
        If on (the default), when the image_reduction_factor is greater
        than 1 and write_back_images is on, the image will be magnified to
        fill the entire render window.
        """
    )

    def _magnify_images_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMagnifyImages,
                        self.magnify_images_)

    parallel_rendering = tvtk_base.true_bool_trait(desc=\
        """
        Turns on/off parallel rendering.  When on (the default) the
        object responds to render events of the attached window,
        propagates the render event to other processors, and otherwise
        enables the parallel rendering process.
        """
    )

    def _parallel_rendering_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParallelRendering,
                        self.parallel_rendering_)

    render_event_propagation = tvtk_base.true_bool_trait(desc=\
        """
        Turns on/off render event propagation.  When on (the default) and
        parallel_rendering is on, process 0 will send an RMI call to all
        remote processes to perform a synchronized render.  When off,
        render must be manually called on each process.
        """
    )

    def _render_event_propagation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRenderEventPropagation,
                        self.render_event_propagation_)

    sync_render_window_renderers = tvtk_base.true_bool_trait(desc=\
        """
        By default, the state of all renderers in the root's render
        window is propagated to the rest of the processes.  In order for
        this to work, all render windows must have the same renderers in
        the same order.  If this is not the case, you can turn off the
        sync_render_window_renderers.  When this flag is off, the list of
        renderers held by this parallel render manager (initially empty)
        is synced.  You can modify the list of renderers with the
        add_renderer, remove_renderer, and remove_all_renderers methods.
        """
    )

    def _sync_render_window_renderers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSyncRenderWindowRenderers,
                        self.sync_render_window_renderers_)

    synchronize_tile_properties = tvtk_base.true_bool_trait(desc=\
        """
        When set the render manager will synchronize the tile_viewport and
        tile_scale properties. This may not be desirable in cases where
        there's some other mechanism to set the tile dimensions eg. Tile
        displays.
        """
    )

    def _synchronize_tile_properties_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSynchronizeTileProperties,
                        self.synchronize_tile_properties_)

    use_back_buffer = tvtk_base.true_bool_trait(desc=\
        """
        The default is to allow the use of the back buffer for
        compositing. If set to false, this will prevent to manager from
        swapping buffers. This allows something else (for instance
        visible_cell_selection) to control front/back buffer swapping.
        """
    )

    def _use_back_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseBackBuffer,
                        self.use_back_buffer_)

    use_compositing = tvtk_base.true_bool_trait(desc=\
        """
        This is used for tiled display rendering.  When data has been
        duplicated on all processes, then we do not need to compositing.
        Cameras and renders are still propagated though.
        """
    )

    def _use_compositing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseCompositing,
                        self.use_compositing_)

    write_back_images = tvtk_base.true_bool_trait(desc=\
        """
        If on (the default), the result of any image space manipulations
        are written back to the render window frame buffer.  If off, the
        image stored in the frame buffer may not be correct.  Either way,
        the correct frame buffer images may be read with
        ParallelRenderManager::GetPixelData.  Turning write_back_images
        off may result in a speedup if the render window is not visible
        to the user and images are read back for further processing or
        transit.
        """
    )

    def _write_back_images_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteBackImages,
                        self.write_back_images_)

    magnify_image_method = traits.Trait('nearest',
    tvtk_base.TraitRevPrefixMap({'nearest': 0, 'linear': 1}), desc=\
        """
        Sets the method used to magnify images.  Nearest simply
        replicates each pixel enough times to fill the image.  Linear
        performs linear interpolation between the pixels.
        """
    )

    def _magnify_image_method_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMagnifyImageMethod,
                        self.magnify_image_method_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Set/Get the MultiProcessController which will handle
        communications for the parallel rendering.
        """
    )

    default_render_event_propagation = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the default value used for render_event_propagation when a
        new instance of ParallelRenderManager is created. Set to true
        by default.
        """
    )

    def _default_render_event_propagation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDefaultRenderEventPropagation,
                        self.default_render_event_propagation)

    force_render_window_size = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        If force_render_window_size is set to true, the render manager will
        use the render_window_size ivar instead of getting the size from
        the render window.
        """
    )

    def _force_render_window_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetForceRenderWindowSize,
                        self.force_render_window_size)

    forced_render_window_size = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(0, 0), cols=2, desc=\
        """
        
        """
    )

    def _forced_render_window_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetForcedRenderWindowSize,
                        self.forced_render_window_size)

    image_reduction_factor = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the reduction factor (for sort-last based parallel
        renderers). The size of rendered image is divided by the
        reduction factor and then is blown up to the size of the current
        RenderWindow.  Setting higher reduction factors enables
        shorter image transfer times (which is often the bottleneck) but
        will greatly reduce image quality.  A reduction factor of 2 or
        greater should only be used for intermediate images in
        interactive applications.  A reduction factor of 1 (or less) will
        result in no change in image quality.  A parallel render manager
        may ignore the image reduction factor if it will result in little
        or no performance enhancements (eg. it does not do image space
        manipulations).
        """
    )

    def _image_reduction_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetImageReductionFactor,
                        self.image_reduction_factor)

    max_image_reduction_factor = traits.Float(16.0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _max_image_reduction_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxImageReductionFactor,
                        self.max_image_reduction_factor)

    def _get_render_window(self):
        return wrap_vtk(self._vtk_obj.GetRenderWindow())
    def _set_render_window(self, arg):
        old_val = self._get_render_window()
        self._wrap_call(self._vtk_obj.SetRenderWindow,
                        deref_vtk(arg))
        self.trait_property_changed('render_window', old_val, arg)
    render_window = traits.Property(_get_render_window, _set_render_window, desc=\
        """
        Set/Get the render_window to use for compositing. We add a start
        and end observer to the window.
        """
    )

    use_rgba = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Get/Set if all Images must use RGBA instead of RGB. By default,
        this flag is on.
        """
    )

    def _use_rgba_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseRGBA,
                        self.use_rgba)

    def _get_full_image_size(self):
        return self._vtk_obj.GetFullImageSize()
    full_image_size = traits.Property(_get_full_image_size, desc=\
        """
        
        """
    )

    def _get_image_processing_time(self):
        return self._vtk_obj.GetImageProcessingTime()
    image_processing_time = traits.Property(_get_image_processing_time, desc=\
        """
        Get rendering metrics.
        """
    )

    def get_pixel_data(self, *args):
        """
        V.get_pixel_data(UnsignedCharArray)
        C++: virtual void GetPixelData(UnsignedCharArray *data)
        V.get_pixel_data(int, int, int, int, UnsignedCharArray)
        C++: virtual void GetPixelData(int x1, int y1, int x2, int y2,
            UnsignedCharArray *data)
        The most appropriate way to retrieve full size image data after a
        render.  Will work regardless of whether write_back_images or
        magnify_image is on or off.  The data returned may be a shallow
        copy of an internal array.  Therefore, the data may be invalid
        after the next render or if the parallel_render_manager is
        destroyed.
        """
        my_args = deref_array(args, [['vtkUnsignedCharArray'], ('int', 'int', 'int', 'int', 'vtkUnsignedCharArray')])
        ret = self._wrap_call(self._vtk_obj.GetPixelData, *my_args)
        return ret

    def _get_reduced_image_size(self):
        return self._vtk_obj.GetReducedImageSize()
    reduced_image_size = traits.Property(_get_reduced_image_size, desc=\
        """
        
        """
    )

    def get_reduced_pixel_data(self, *args):
        """
        V.get_reduced_pixel_data(UnsignedCharArray)
        C++: virtual void GetReducedPixelData(UnsignedCharArray *data)
        V.get_reduced_pixel_data(int, int, int, int, UnsignedCharArray)
        C++: virtual void GetReducedPixelData(int x1, int y1, int x2,
            int y2, UnsignedCharArray *data)
        The most appropriate way to retrieve reduced size image data
        after a render.  Will work regardless of whether write_back_images
        or magnify_image is on or off.  The data returned may be a shallow
        copy of an internal array.  Therefore, the data may be invalid
        after the next render or if the parallel_render_manager is
        destroyed.
        """
        my_args = deref_array(args, [['vtkUnsignedCharArray'], ('int', 'int', 'int', 'int', 'vtkUnsignedCharArray')])
        ret = self._wrap_call(self._vtk_obj.GetReducedPixelData, *my_args)
        return ret

    def _get_render_time(self):
        return self._vtk_obj.GetRenderTime()
    render_time = traits.Property(_get_render_time, desc=\
        """
        Get rendering metrics.
        """
    )

    def add_renderer(self, *args):
        """
        V.add_renderer(Renderer)
        C++: virtual void AddRenderer(Renderer *)
        By default, the state of all renderers in the root's render
        window is propagated to the rest of the processes.  In order for
        this to work, all render windows must have the same renderers in
        the same order.  If this is not the case, you can turn off the
        sync_render_window_renderers.  When this flag is off, the list of
        renderers held by this parallel render manager (initially empty)
        is synced.  You can modify the list of renderers with the
        add_renderer, remove_renderer, and remove_all_renderers methods.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddRenderer, *my_args)
        return ret

    def check_for_abort_composite(self):
        """
        V.check_for_abort_composite() -> int
        C++: virtual int CheckForAbortComposite()"""
        ret = self._vtk_obj.CheckForAbortComposite()
        return ret
        

    def check_for_abort_render(self):
        """
        V.check_for_abort_render()
        C++: virtual void CheckForAbortRender()"""
        ret = self._vtk_obj.CheckForAbortRender()
        return ret
        

    def compute_visible_prop_bounds(self, *args):
        """
        V.compute_visible_prop_bounds(Renderer, [float, float, float,
            float, float, float])
        C++: virtual void ComputeVisiblePropBounds(Renderer *ren,
            double bounds[6])
        Calculates the bounds by gathering information from all
        processes.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ComputeVisiblePropBounds, *my_args)
        return ret

    def compute_visible_prop_bounds_rmi(self, *args):
        """
        V.compute_visible_prop_bounds_rmi(int)
        C++: virtual void ComputeVisiblePropBoundsRMI(int renderId)
        Callbacks that initialize and finish rendering and other tasks.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeVisiblePropBoundsRMI, *args)
        return ret

    def end_render(self):
        """
        V.end_render()
        C++: virtual void EndRender()
        Callbacks that initialize and finish rendering and other tasks.
        """
        ret = self._vtk_obj.EndRender()
        return ret
        

    def generic_end_render_callback(self):
        """
        V.generic_end_render_callback()
        C++: virtual void GenericEndRenderCallback()
        INTERNAL METHODS (DON NOT USE). There are internal methods made
        public so that they can be called from callback functions.
        """
        ret = self._vtk_obj.GenericEndRenderCallback()
        return ret
        

    def generic_start_render_callback(self):
        """
        V.generic_start_render_callback()
        C++: virtual void GenericStartRenderCallback()
        INTERNAL METHODS (DON NOT USE). There are internal methods made
        public so that they can be called from callback functions.
        """
        ret = self._vtk_obj.GenericStartRenderCallback()
        return ret
        

    def initialize_off_screen(self):
        """
        V.initialize_off_screen()
        C++: virtual void InitializeOffScreen()
        Make all rendering windows not viewable set as off screen
        rendering. To make all renderwindows on screen rendering again,
        call off_screen_rendering_off on all the render windows.  This class
        assumes the window on root node is the only one viewable. 
        Subclasses should change this as necessary.
        """
        ret = self._vtk_obj.InitializeOffScreen()
        return ret
        

    def initialize_pieces(self):
        """
        V.initialize_pieces()
        C++: virtual void InitializePieces()
        This method sets the piece and number of pieces for each actor
        with a polydata mapper.
        """
        ret = self._vtk_obj.InitializePieces()
        return ret
        

    def initialize_rm_is(self):
        """
        V.initialize_rm_is()
        C++: virtual void InitializeRMIs()"""
        ret = self._vtk_obj.InitializeRMIs()
        return ret
        

    def magnify_image(self, *args):
        """
        V.magnify_image(UnsignedCharArray, (int, int),
            UnsignedCharArray, (int, int), (int, int, int, int), (int,
            int, int, int))
        C++: virtual void MagnifyImage(UnsignedCharArray *fullImage,
            const int fullImageSize[2],
            UnsignedCharArray *reducedImage,
            const int reducedImageSize[2],
            const int fullImageViewport[4]=nullptr,
            const int reducedImageViewport[4]=nullptr)
        Convenience functions for magnifying images.
        """
        my_args = deref_array(args, [('vtkUnsignedCharArray', ('int', 'int'), 'vtkUnsignedCharArray', ('int', 'int'), ('int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int'))])
        ret = self._wrap_call(self._vtk_obj.MagnifyImage, *my_args)
        return ret

    def magnify_image_linear(self, *args):
        """
        V.magnify_image_linear(UnsignedCharArray, (int, int),
            UnsignedCharArray, (int, int), (int, int, int, int), (int,
            int, int, int))
        C++: static void MagnifyImageLinear(
            UnsignedCharArray *fullImage, const int fullImageSize[2],
            UnsignedCharArray *reducedImage,
            const int reducedImageSize[2],
            const int fullImageViewport[4]=nullptr,
            const int reducedImageViewport[4]=nullptr)
        Convenience functions for magnifying images.
        """
        my_args = deref_array(args, [('vtkUnsignedCharArray', ('int', 'int'), 'vtkUnsignedCharArray', ('int', 'int'), ('int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int'))])
        ret = self._wrap_call(self._vtk_obj.MagnifyImageLinear, *my_args)
        return ret

    def magnify_image_nearest(self, *args):
        """
        V.magnify_image_nearest(UnsignedCharArray, (int, int),
            UnsignedCharArray, (int, int), (int, int, int, int), (int,
            int, int, int))
        C++: static void MagnifyImageNearest(
            UnsignedCharArray *fullImage, const int fullImageSize[2],
            UnsignedCharArray *reducedImage,
            const int reducedImageSize[2],
            const int fullImageViewport[4]=nullptr,
            const int reducedImageViewport[4]=nullptr)
        Convenience functions for magnifying images.
        """
        my_args = deref_array(args, [('vtkUnsignedCharArray', ('int', 'int'), 'vtkUnsignedCharArray', ('int', 'int'), ('int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int'))])
        ret = self._wrap_call(self._vtk_obj.MagnifyImageNearest, *my_args)
        return ret

    def make_render_window(self):
        """
        V.make_render_window() -> RenderWindow
        C++: virtual RenderWindow *MakeRenderWindow()
        Builds a RenderWindow compatible with this render manager. 
        The user program is responsible for registering the render window
        with the set_render_window method and calling Delete.  It is not
        advisable to use a parallel render manager with a render window
        that was not built with this method.
        """
        ret = wrap_vtk(self._vtk_obj.MakeRenderWindow())
        return ret
        

    def make_renderer(self):
        """
        V.make_renderer() -> Renderer
        C++: virtual Renderer *MakeRenderer()
        Builds a Renderer compatible with this render manager. 
        (Should we also register it?)  The user program is responsible
        for calling Delete.  It is not advisable to use a parallel render
        manager with a renderer that was not built with this method.
        """
        ret = wrap_vtk(self._vtk_obj.MakeRenderer())
        return ret
        

    def remove_all_renderers(self):
        """
        V.remove_all_renderers()
        C++: virtual void RemoveAllRenderers()
        By default, the state of all renderers in the root's render
        window is propagated to the rest of the processes.  In order for
        this to work, all render windows must have the same renderers in
        the same order.  If this is not the case, you can turn off the
        sync_render_window_renderers.  When this flag is off, the list of
        renderers held by this parallel render manager (initially empty)
        is synced.  You can modify the list of renderers with the
        add_renderer, remove_renderer, and remove_all_renderers methods.
        """
        ret = self._vtk_obj.RemoveAllRenderers()
        return ret
        

    def remove_renderer(self, *args):
        """
        V.remove_renderer(Renderer)
        C++: virtual void RemoveRenderer(Renderer *)
        By default, the state of all renderers in the root's render
        window is propagated to the rest of the processes.  In order for
        this to work, all render windows must have the same renderers in
        the same order.  If this is not the case, you can turn off the
        sync_render_window_renderers.  When this flag is off, the list of
        renderers held by this parallel render manager (initially empty)
        is synced.  You can modify the list of renderers with the
        add_renderer, remove_renderer, and remove_all_renderers methods.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveRenderer, *my_args)
        return ret

    def render_rmi(self):
        """
        V.render_rmi()
        C++: virtual void RenderRMI()
        Callbacks that initialize and finish rendering and other tasks.
        """
        ret = self._vtk_obj.RenderRMI()
        return ret
        

    def reset_all_cameras(self):
        """
        V.reset_all_cameras()
        C++: virtual void ResetAllCameras()
        Resets the camera of each renderer contained in the render_window.
        Should only be called in the "root" process, and all remote
        processes must be processing RMIs for this method to complete.
        """
        ret = self._vtk_obj.ResetAllCameras()
        return ret
        

    def reset_camera(self, *args):
        """
        V.reset_camera(Renderer)
        C++: virtual void ResetCamera(Renderer *ren)
        Callbacks that initialize and finish rendering and other tasks.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ResetCamera, *my_args)
        return ret

    def reset_camera_clipping_range(self, *args):
        """
        V.reset_camera_clipping_range(Renderer)
        C++: virtual void ResetCameraClippingRange(Renderer *ren)
        Callbacks that initialize and finish rendering and other tasks.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ResetCameraClippingRange, *my_args)
        return ret

    def satellite_end_render(self):
        """
        V.satellite_end_render()
        C++: virtual void SatelliteEndRender()
        Callbacks that initialize and finish rendering and other tasks.
        """
        ret = self._vtk_obj.SatelliteEndRender()
        return ret
        

    def satellite_start_render(self):
        """
        V.satellite_start_render()
        C++: virtual void SatelliteStartRender()
        Callbacks that initialize and finish rendering and other tasks.
        """
        ret = self._vtk_obj.SatelliteStartRender()
        return ret
        

    def set_image_reduction_factor_for_update_rate(self, *args):
        """
        V.set_image_reduction_factor_for_update_rate(float)
        C++: virtual void SetImageReductionFactorForUpdateRate(
            double DesiredUpdateRate)
        Sets the reduction_factor based on the given desired update rate
        and the rendering metrics taken from the last time
        update_server_info was called.  Note that if auto_reduction_factor is
        on, this function is called with the desired update rate of the
        render window automatically.
        """
        ret = self._wrap_call(self._vtk_obj.SetImageReductionFactorForUpdateRate, *args)
        return ret

    def start_interactor(self):
        """
        V.start_interactor()
        C++: virtual void StartInteractor()
        Initializes the RMIs and then, if on root node, starts the
        interactor on the attached render window.  Otherwise, starts
        processing RMIs. When the interactor returns, it breaks the RMI
        listening on all other processors.
        """
        ret = self._vtk_obj.StartInteractor()
        return ret
        

    def start_render(self):
        """
        V.start_render()
        C++: virtual void StartRender()
        Callbacks that initialize and finish rendering and other tasks.
        """
        ret = self._vtk_obj.StartRender()
        return ret
        

    def start_services(self):
        """
        V.start_services()
        C++: virtual void StartServices()
        If on node other than root, starts serving RMI requests for
        parallel renders.
        """
        ret = self._vtk_obj.StartServices()
        return ret
        

    def stop_services(self):
        """
        V.stop_services()
        C++: virtual void StopServices()
        If on root node, stops the RMI processing on all service nodes.
        """
        ret = self._vtk_obj.StopServices()
        return ret
        

    def tile_windows(self, *args):
        """
        V.tile_windows(int, int, int)
        C++: void TileWindows(int xsize, int ysize, int nColumns)
        Given the x and y size of the render windows, reposition them in
        a tile of n columns.
        """
        ret = self._wrap_call(self._vtk_obj.TileWindows, *args)
        return ret

    _updateable_traits_ = \
    (('auto_image_reduction_factor', 'GetAutoImageReductionFactor'),
    ('magnify_images', 'GetMagnifyImages'), ('parallel_rendering',
    'GetParallelRendering'), ('render_event_propagation',
    'GetRenderEventPropagation'), ('sync_render_window_renderers',
    'GetSyncRenderWindowRenderers'), ('synchronize_tile_properties',
    'GetSynchronizeTileProperties'), ('use_back_buffer',
    'GetUseBackBuffer'), ('use_compositing', 'GetUseCompositing'),
    ('write_back_images', 'GetWriteBackImages'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('magnify_image_method', 'GetMagnifyImageMethod'),
    ('default_render_event_propagation',
    'GetDefaultRenderEventPropagation'), ('force_render_window_size',
    'GetForceRenderWindowSize'), ('forced_render_window_size',
    'GetForcedRenderWindowSize'), ('image_reduction_factor',
    'GetImageReductionFactor'), ('max_image_reduction_factor',
    'GetMaxImageReductionFactor'), ('use_rgba', 'GetUseRGBA'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['auto_image_reduction_factor', 'debug', 'global_warning_display',
    'magnify_images', 'parallel_rendering', 'render_event_propagation',
    'sync_render_window_renderers', 'synchronize_tile_properties',
    'use_back_buffer', 'use_compositing', 'write_back_images',
    'magnify_image_method', 'default_render_event_propagation',
    'force_render_window_size', 'forced_render_window_size',
    'image_reduction_factor', 'max_image_reduction_factor', 'use_rgba'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ParallelRenderManager, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ParallelRenderManager properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['auto_image_reduction_factor', 'magnify_images',
            'parallel_rendering', 'render_event_propagation',
            'sync_render_window_renderers', 'synchronize_tile_properties',
            'use_back_buffer', 'use_compositing', 'write_back_images'],
            ['magnify_image_method'], ['default_render_event_propagation',
            'force_render_window_size', 'forced_render_window_size',
            'image_reduction_factor', 'max_image_reduction_factor', 'use_rgba']),
            title='Edit ParallelRenderManager properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ParallelRenderManager properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

