/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.multipage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.sf.sdedit.config.PrintConfiguration;
import net.sf.sdedit.diagram.AbstractGraphicDevice;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.Strokes;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.components.Zoomable;

public class MultipagePaintDevice
extends AbstractGraphicDevice {
    private Dimension pageSize;
    private List<MultipagePanel> panels;
    private double scale;
    private PrintConfiguration properties;
    private Diagram diagram;

    public MultipagePaintDevice(PrintConfiguration properties, Dimension pageSize) {
        this.pageSize = pageSize;
        this.panels = new ArrayList<MultipagePanel>();
        this.properties = properties;
    }

    @Override
    public void initialize(Diagram diagram) {
        super.initialize(diagram);
        this.diagram = diagram;
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    private double computeScale() {
        int h = this.pageSize.height;
        int w = this.pageSize.width;
        int H = this.getHeight();
        int W = this.getWidth();
        double xscale = 1.0 * (double)w / (double)W;
        if (this.properties.isMultipage()) {
            return Math.min(1.0, xscale);
        }
        double yscale = 1.0 * (double)h / (double)H;
        if (this.properties.isFitToPage()) {
            return Math.min(xscale, yscale);
        }
        return Math.min(1.0, Math.min(xscale, yscale));
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void close(int width, int height, boolean empty) {
        super.close(width, height, empty);
        this.scale = this.computeScale();
        int numberOfPages = this.properties.isMultipage() ? (int)((double)this.getHeight() * this.scale) / this.pageSize.height + 1 : 1;
        for (int i = 0; i < numberOfPages; ++i) {
            this.panels.add(new MultipagePanel(i));
        }
    }

    public List<MultipagePanel> getPanels() {
        return this.panels;
    }

    public void announce(int height) {
        SequenceDiagram sd;
        int v0;
        int v1;
        if (this.properties.isMultipage() && (v1 = (v0 = (sd = (SequenceDiagram)this.diagram).getVerticalPosition()) + height) / this.pageSize.height > v0 / this.pageSize.height) {
            int diff = this.pageSize.height - v0 % this.pageSize.height;
            sd.extendLifelines(diff);
        }
    }

    public class MultipagePanel
    extends JPanel
    implements Zoomable<JPanel> {
        private static final long serialVersionUID = -112626883258199079L;
        private int index;
        private ZoomPane zoomPane;
        private Dimension dim;

        MultipagePanel(int index) {
            this.index = index;
            this.dim = MultipagePaintDevice.this.pageSize;
        }

        @Override
        public Dimension getSize() {
            return this.dim;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.dim;
        }

        @Override
        public int getHeight() {
            return this.dim.height;
        }

        @Override
        public int getWidth() {
            return this.dim.width;
        }

        @Override
        public void paintComponent(Graphics g) {
            int xg;
            int yg;
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setFont(MultipagePaintDevice.this.diagram.getConfiguration().getFont());
            g2d.scale(MultipagePaintDevice.this.scale, MultipagePaintDevice.this.scale);
            Rectangle clipBounds = g2d.getClipBounds();
            g2d.setColor(Color.WHITE);
            g2d.fill(clipBounds);
            Rectangle rect = null;
            int w = (int)((double)((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.width / MultipagePaintDevice.this.scale);
            int h = (int)((double)((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.height / MultipagePaintDevice.this.scale);
            if (MultipagePaintDevice.this.properties.isMultipage()) {
                int y0 = this.index * (int)((double)((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.height / MultipagePaintDevice.this.scale);
                g2d.translate(0, -y0);
                rect = new Rectangle(0, y0, w, h);
            } else if (MultipagePaintDevice.this.properties.isCenterVertically() && (yg = h - MultipagePaintDevice.this.getHeight()) > 0) {
                g2d.translate(0, yg / 2);
            }
            if (MultipagePaintDevice.this.properties.isCenterHorizontally() && (xg = w - MultipagePaintDevice.this.getWidth()) > 0) {
                g2d.translate(xg / 2, 0);
            }
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Strokes.defaultStroke());
            for (Drawable drawable : MultipagePaintDevice.this.drawables()) {
                if (rect != null && !drawable.intersects(rect)) continue;
                drawable.draw(g2d);
            }
            g2d.dispose();
        }

        @Override
        public JPanel asJComponent() {
            return this;
        }

        @Override
        public int getAbsoluteHeight() {
            return ((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.height;
        }

        @Override
        public int getAbsoluteWidth() {
            return ((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.width;
        }

        @Override
        public ZoomPane getZoomPane() {
            return this.zoomPane;
        }

        @Override
        public void setZoomPane(ZoomPane zoomPane) {
            this.zoomPane = zoomPane;
        }
    }
}

