/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.imap;

import gnu.inet.imap.IMAPConnection;
import gnu.inet.imap.MessageStatus;
import gnu.inet.imap.Pair;
import gnu.mail.providers.ReadOnlyMessage;
import gnu.mail.providers.imap.IMAPBodyPart;
import gnu.mail.providers.imap.IMAPFlags;
import gnu.mail.providers.imap.IMAPFolder;
import gnu.mail.providers.imap.IMAPMultipart;
import gnu.mail.providers.imap.IMAPMultipartDataSource;
import gnu.mail.providers.imap.IMAPStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParameterList;

public final class IMAPMessage
extends ReadOnlyMessage {
    static final String FETCH_HEADERS = "BODY.PEEK[HEADER]";
    static final String FETCH_CONTENT = "BODY.PEEK[]";
    static final String PLUS_FLAGS = "+FLAGS";
    static final String MINUS_FLAGS = "-FLAGS";
    static final int BS_CONTENT_TYPE = 0;
    static final int BS_CONTENT_SUBTYPE = 1;
    static final int BS_PARAMETERS = 2;
    static final int BS_ID = 3;
    static final int BS_DESCRIPTION = 4;
    static final int BS_ENCODING = 5;
    static final int BS_OCTETS = 6;
    static final int BS_LINES = 7;
    static final int BS_EXT_DISPOSITION = 8;
    static final int BS_EXT_LANGUAGE = 9;
    protected String internalDate = null;
    protected long uid = -1L;
    protected static final DateFormat internalDateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss zzzzz");
    protected boolean headersComplete = false;
    private IMAPMultipart multipart = null;

    IMAPMessage(IMAPFolder folder, InputStream in, int msgnum) throws MessagingException {
        super(folder, in, msgnum);
        this.flags = null;
    }

    IMAPMessage(IMAPFolder folder, int msgnum) throws MessagingException {
        super(folder, msgnum);
        this.flags = null;
    }

    void fetchFlags() throws MessagingException {
        String[] commands = new String[]{"FLAGS"};
        this.fetch(commands);
    }

    void fetchHeaders() throws MessagingException {
        String[] commands = new String[]{FETCH_HEADERS, "INTERNALDATE"};
        this.fetch(commands);
    }

    void fetchContent() throws MessagingException {
        String[] commands = new String[]{FETCH_CONTENT, "INTERNALDATE"};
        this.fetch(commands);
    }

    void fetchMultipart() throws MessagingException {
        String[] commands = new String[]{"BODYSTRUCTURE"};
        this.fetch(commands);
    }

    void fetchUID() throws MessagingException {
        String[] commands = new String[]{"UID"};
        this.fetch(commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetch(String[] commands) throws MessagingException {
        try {
            IMAPConnection connection = ((IMAPStore)this.folder.getStore()).getConnection();
            if (!this.folder.isOpen()) {
                this.folder.open(2);
            }
            int[] messages = new int[]{this.msgnum};
            IMAPConnection iMAPConnection = connection;
            synchronized (iMAPConnection) {
                MessageStatus[] ms = connection.fetch(messages, commands);
                for (int i = 0; i < ms.length; ++i) {
                    if (ms[i].getMessageNumber() != this.msgnum) continue;
                    this.update(ms[i]);
                }
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    void update(MessageStatus status) throws MessagingException {
        List code = status.getCode();
        int clen = code.size();
        for (int i = 0; i < clen; i += 2) {
            byte[] literal;
            Object item = code.get(i);
            String key = null;
            List params = Collections.EMPTY_LIST;
            if (item instanceof Pair) {
                Pair pair = (Pair)item;
                key = pair.getKey();
                params = pair.getValue();
            } else if (item instanceof String) {
                key = (String)item;
            } else {
                throw new MessagingException("Unexpected status item: " + item);
            }
            if (key == "BODY" || key == "RFC822") {
                literal = (byte[])code.get(i + 1);
                int plen = params.size();
                if (plen == 0) {
                    ByteArrayInputStream in = new ByteArrayInputStream(literal);
                    this.parse(in);
                    continue;
                }
                for (int pi = 0; pi < plen; pi += 2) {
                    ByteArrayInputStream in;
                    Object pitem = params.get(pi);
                    String pkey = null;
                    if (!(pitem instanceof String)) {
                        throw new MessagingException("Unexpected status item: " + pitem);
                    }
                    pkey = (String)pitem;
                    if (pkey == "HEADER") {
                        in = new ByteArrayInputStream(literal);
                        this.headers = this.createInternetHeaders(in);
                        this.headersComplete = true;
                        continue;
                    }
                    if (pkey == "HEADER.FIELDS") {
                        if (this.headersComplete) continue;
                        in = new ByteArrayInputStream(literal);
                        this.headers = this.createInternetHeaders(in);
                        continue;
                    }
                    throw new MessagingException("Unknown message status key: " + pkey);
                }
                continue;
            }
            if (key == "RFC822.HEADER") {
                literal = (byte[])code.get(i + 1);
                ByteArrayInputStream in = new ByteArrayInputStream(literal);
                this.headers = this.createInternetHeaders(in);
                this.headersComplete = true;
                continue;
            }
            if (key == "BODYSTRUCTURE") {
                List mlist = (List)code.get(i + 1);
                if (this.headers == null) {
                    this.headers = new InternetHeaders();
                }
                this.multipart = this.parseMultipart(mlist, (Part)this, this.headers, null);
                continue;
            }
            if (key == "ENVELOPE") continue;
            if (key == "FLAGS") {
                List fl = (List)code.get(i + 1);
                this.flags = new IMAPFlags();
                for (Object f : fl) {
                    if (f == "\\Answered") {
                        this.flags.add(Flags.Flag.ANSWERED);
                        continue;
                    }
                    if (f == "\\Deleted") {
                        this.flags.add(Flags.Flag.DELETED);
                        continue;
                    }
                    if (f == "\\Draft") {
                        this.flags.add(Flags.Flag.DRAFT);
                        continue;
                    }
                    if (f == "\\Flagged") {
                        this.flags.add(Flags.Flag.FLAGGED);
                        continue;
                    }
                    if (f == "\\Recent") {
                        this.flags.add(Flags.Flag.RECENT);
                        continue;
                    }
                    if (f == "\\Seen") {
                        this.flags.add(Flags.Flag.SEEN);
                        continue;
                    }
                    if (!(f instanceof String)) continue;
                    this.flags.add((String)f);
                }
                ((IMAPFlags)this.flags).checkpoint();
                continue;
            }
            if (key == "INTERNALDATE") {
                this.internalDate = (String)code.get(i + 1);
                continue;
            }
            if (key == "UID") {
                this.uid = Long.parseLong((String)code.get(i + 1));
                continue;
            }
            throw new MessagingException("Unknown message status key: " + key);
        }
    }

    IMAPMultipart parseMultipart(List list, Part parent, InternetHeaders parentHeaders, String baseSection) throws MessagingException {
        int len = list.size();
        if (len == 0) {
            throw new MessagingException("Empty [MIME-IMB] structure");
        }
        int offset = 0;
        Object value = list.get(offset);
        ArrayList partList = new ArrayList();
        ArrayList<Object> sectionList = new ArrayList<Object>();
        while (value instanceof List) {
            Object section = baseSection == null ? Integer.toString(offset + 1) : baseSection + "." + (offset + 1);
            partList.add(value);
            sectionList.add(section);
            value = list.get(++offset);
        }
        String subtype = this.parseAtom(value).toLowerCase();
        IMAPMultipart m = new IMAPMultipart(this, parent, subtype);
        ContentType ct = new ContentType(m.getContentType());
        for (int i = 0; i < offset; ++i) {
            List part = (List)partList.get(i);
            String section = (String)sectionList.get(i);
            m.addBodyPart((BodyPart)this.parseBodyPart(part, m, section));
        }
        if (offset < len) {
            String disposition = this.parseAtom(list.get(len - 2));
            String language = this.parseAtom(list.get(len - 1));
            if (disposition != null) {
                parentHeaders.setHeader("Content-Disposition", disposition);
            }
            if (language != null) {
                parentHeaders.setHeader("Content-Language", language);
            }
            ArrayList plist = new ArrayList();
            for (int i = offset; i < len - 2; ++i) {
                value = list.get(i);
                if (!(value instanceof List)) continue;
                plist.addAll((List)value);
            }
            if (plist.size() > 0) {
                ParameterList params = this.parseParameterList(plist);
                ct = new ContentType(ct.getPrimaryType(), subtype, params);
            }
        }
        parentHeaders.setHeader("Content-Type", ct.toString());
        return m;
    }

    IMAPBodyPart parseBodyPart(List list, IMAPMultipart parent, String section) throws MessagingException {
        String language;
        int len = list.size();
        if (len == 0) {
            throw new MessagingException("Empty [MIME-IMB] structure");
        }
        Object arg1 = list.get(0);
        if (arg1 instanceof List) {
            IMAPMultipart m;
            InternetHeaders h = new InternetHeaders();
            IMAPBodyPart part = new IMAPBodyPart(this, parent, section, h, -1, -1);
            part.multipart = m = this.parseMultipart(list, (Part)part, h, section);
            return part;
        }
        if (len < 8) {
            throw new MessagingException("Unexpected number of fields in [MIME-IMB] structure: " + list);
        }
        String type = this.parseAtom(list.get(0)).toLowerCase();
        String subtype = this.parseAtom(list.get(1)).toLowerCase();
        ParameterList params = this.parseParameterList(list.get(2));
        String id = this.parseAtom(list.get(3));
        String description = this.parseAtom(list.get(4));
        String encoding = this.parseAtom(list.get(5));
        String sizeVal = this.parseAtom(list.get(6));
        String linesVal = this.parseAtom(list.get(7));
        int size = -1;
        int lines = -1;
        try {
            if (sizeVal != null) {
                size = Integer.parseInt(sizeVal);
            }
            if (linesVal != null) {
                lines = Integer.parseInt(linesVal);
            }
        }
        catch (NumberFormatException e) {
            throw new MessagingException("Expecting number in [MIME-IMB] structure: " + list);
        }
        ContentType ct = new ContentType(type, subtype, params);
        InternetHeaders h = new InternetHeaders();
        h.setHeader("Content-Type", ct.toString());
        if (id != null) {
            h.setHeader("Content-Id", id);
        }
        if (description != null) {
            h.setHeader("Content-Description", description);
        }
        if (encoding != null) {
            h.setHeader("Content-Transfer-Encoding", encoding);
        }
        if (len > 8) {
            List d;
            Object dispositionVal = list.get(8);
            String disposition = this.parseAtom(dispositionVal);
            if (disposition != null) {
                h.setHeader("Content-Disposition", disposition);
            } else if (dispositionVal instanceof List && (d = (List)dispositionVal) != null && d.size() == 2) {
                disposition = this.parseAtom(d.get(0));
                ParameterList pl = this.parseParameterList(d.get(1));
                h.setHeader("Content-Disposition", disposition + pl.toString());
            }
        }
        if (len > 9 && (language = this.parseAtom(list.get(9))) != null) {
            h.setHeader("Content-Language", language);
        }
        return new IMAPBodyPart(this, parent, section, h, size, lines);
    }

    String parseAtom(Object value) {
        if (value instanceof String && !value.equals("NIL")) {
            return (String)value;
        }
        return null;
    }

    ParameterList parseParameterList(Object params) {
        if (params instanceof List) {
            List list = (List)params;
            int len = list.size();
            ParameterList plist = new ParameterList();
            for (int i = 0; i < len - 1; i += 2) {
                String atom;
                Object key = list.get(i);
                Object value = list.get(i + 1);
                if (!(key instanceof String) || !(value instanceof String) || (atom = this.parseAtom(value)) == null) continue;
                plist.set((String)key, atom);
            }
            return plist;
        }
        return null;
    }

    public Date getReceivedDate() throws MessagingException {
        if (this.internalDate == null && this.headers == null) {
            this.fetchHeaders();
        }
        if (this.internalDate == null) {
            return null;
        }
        try {
            return internalDateFormat.parse(this.internalDate);
        }
        catch (ParseException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public DataHandler getDataHandler() throws MessagingException {
        ContentType ct = new ContentType(this.getContentType());
        if ("multipart".equalsIgnoreCase(ct.getPrimaryType())) {
            if (this.multipart == null) {
                this.fetchMultipart();
            }
            return new DataHandler((DataSource)new IMAPMultipartDataSource(this.multipart));
        }
        if (this.content == null) {
            this.fetchContent();
        }
        return super.getDataHandler();
    }

    public Object getContent() throws MessagingException, IOException {
        ContentType ct = new ContentType(this.getContentType());
        if ("multipart".equalsIgnoreCase(ct.getPrimaryType())) {
            if (this.multipart == null) {
                this.fetchMultipart();
            }
            return this.multipart;
        }
        return super.getContent();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.content == null) {
            this.fetchContent();
        }
        return super.getContentStream();
    }

    public String[] getHeader(String name) throws MessagingException {
        String[] header;
        if (this.headers == null) {
            this.fetchHeaders();
        }
        if ((header = super.getHeader(name)) == null && !this.headersComplete) {
            this.fetchHeaders();
        }
        header = super.getHeader(name);
        return header;
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        String header;
        if (this.headers == null) {
            this.fetchHeaders();
        }
        if ((header = super.getHeader(name, delimiter)) == null && !this.headersComplete) {
            this.fetchHeaders();
        }
        header = super.getHeader(name, delimiter);
        return header;
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (!this.headersComplete) {
            this.fetchHeaders();
        }
        return super.getAllHeaders();
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (!this.headersComplete) {
            this.fetchHeaders();
        }
        return super.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        if (!this.headersComplete) {
            this.fetchHeaders();
        }
        return super.getMatchingHeaders(names);
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        if (!this.headersComplete) {
            this.fetchHeaders();
        }
        return super.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        if (!this.headersComplete) {
            this.fetchHeaders();
        }
        return super.getNonMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (!this.headersComplete) {
            this.fetchHeaders();
        }
        return super.getNonMatchingHeaderLines(names);
    }

    public Flags getFlags() throws MessagingException {
        if (this.flags == null) {
            this.fetchFlags();
        }
        return super.getFlags();
    }

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        if (this.flags == null) {
            this.fetchFlags();
        }
        return super.isSet(flag);
    }

    @Override
    public void setFlags(Flags flag, boolean set) throws MessagingException {
        if (this.flags == null) {
            this.fetchFlags();
        }
        try {
            if (set) {
                this.flags.add(flag);
            } else {
                this.flags.remove(flag);
            }
            IMAPFlags iflags = (IMAPFlags)this.flags;
            List aflagList = iflags.getAddedFlags();
            String[] aflags = new String[aflagList.size()];
            aflagList.toArray(aflags);
            List rflagList = iflags.getRemovedFlags();
            String[] rflags = new String[rflagList.size()];
            rflagList.toArray(rflags);
            if (aflags.length > 0 || rflags.length > 0) {
                IMAPStore store = (IMAPStore)this.folder.getStore();
                IMAPConnection c = store.getConnection();
                int[] messages = new int[]{this.msgnum};
                if (aflags.length > 0) {
                    c.store(messages, PLUS_FLAGS, aflags);
                }
                if (rflags.length > 0) {
                    c.store(messages, MINUS_FLAGS, rflags);
                }
                this.flags = null;
            }
        }
        catch (IOException e) {
            this.flags = null;
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public void writeTo(OutputStream msgStream) throws IOException, MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        if (this.content == null) {
            this.fetchContent();
        }
        super.writeTo(msgStream);
    }

    public void writeTo(OutputStream msgStream, String[] ignoreList) throws IOException, MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        if (this.content == null) {
            this.fetchContent();
        }
        super.writeTo(msgStream, ignoreList);
    }
}

