/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.RenderBin;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.Texture3D;
import javax.media.j3d.Texture3DRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureCubeMap;
import javax.media.j3d.TextureCubeMapRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;

abstract class TextureRetained
extends NodeComponentRetained {
    static final int ENABLE_CHANGED = 1;
    static final int COLOR_CHANGED = 2;
    static final int IMAGE_CHANGED = 4;
    static final int STATE_CHANGED = 8;
    static final int UPDATE_IMAGE = 16;
    static final int IMAGES_CHANGED = 32;
    static final int BASE_LEVEL_CHANGED = 64;
    static final int MAX_LEVEL_CHANGED = 128;
    static final int MIN_LOD_CHANGED = 256;
    static final int MAX_LOD_CHANGED = 512;
    static final int LOD_OFFSET_CHANGED = 1024;
    static final int MIN_FILTER = 0;
    static final int MAG_FILTER = 1;
    int boundaryWidth = 0;
    int boundaryModeS = 3;
    int boundaryModeT = 3;
    int minFilter = 2;
    int magFilter = 2;
    int isDirty = 65535;
    Color4f boundaryColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    int objectId = -1;
    int mipmapMode = 1;
    int format = 5;
    int width = 1;
    int height = 1;
    private boolean widthOrHeightIsNPOT = false;
    ImageComponentRetained[][] images;
    int maxLevels = 0;
    private int maxMipMapLevels = 0;
    int numFaces = 1;
    int baseLevel = 0;
    int maximumLevel = 0;
    float minimumLod = -1000.0f;
    float maximumLod = 1000.0f;
    Point3f lodOffset = null;
    private boolean useAsRaster = false;
    boolean enable = true;
    boolean userSpecifiedEnable = true;
    boolean isAlphaNeedUpdate = false;
    int numSharpenTextureFuncPts = 0;
    float[] sharpenTextureFuncPts = null;
    float[] filter4FuncPts = null;
    int anisotropicFilterMode = 0;
    float anisotropicFilterDegree = 1.0f;
    int resourceCreationMask = 0;
    int resourceUpdatedMask = 0;
    int resourceLodUpdatedMask = 0;
    int resourceInReloadList = 0;
    ArrayList[][] imageUpdateInfo;
    int[] imageUpdatePruneMask;
    private HashMap<RenderBin, Integer> textureBinRefCount = new HashMap();
    Object resourceLock = new Object();

    TextureRetained() {
    }

    private static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    void initialize(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mipmapMode = n6;
        this.format = n;
        this.width = n2;
        this.height = n4;
        this.boundaryWidth = n7;
        if (!TextureRetained.isPowerOfTwo(n2) || !TextureRetained.isPowerOfTwo(n4)) {
            this.widthOrHeightIsNPOT = true;
        }
        this.maxMipMapLevels = n3 > n5 ? n3 + 1 : n5 + 1;
        if (n6 != 1) {
            this.baseLevel = 0;
            this.maximumLevel = this.maxMipMapLevels - 1;
            this.maxLevels = this.maxMipMapLevels;
        } else {
            this.baseLevel = 0;
            this.maximumLevel = 0;
            this.maxLevels = 1;
        }
        this.images = new ImageComponentRetained[this.numFaces][this.maxLevels];
        for (int i = 0; i < this.numFaces; ++i) {
            for (int j = 0; j < this.maxLevels; ++j) {
                this.images[i][j] = null;
            }
        }
    }

    final int getFormat() {
        return this.format;
    }

    final int getWidth() {
        return this.width;
    }

    final int getHeight() {
        return this.height;
    }

    final int numMipMapLevels() {
        return this.maximumLevel - this.baseLevel + 1;
    }

    final void initBoundaryModeS(int n) {
        this.boundaryModeS = n;
    }

    final int getBoundaryModeS() {
        return this.boundaryModeS;
    }

    final void initBoundaryModeT(int n) {
        this.boundaryModeT = n;
    }

    final int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    final int getBoundaryWidth() {
        return this.boundaryWidth;
    }

    final void initMinFilter(int n) {
        this.minFilter = n;
    }

    final int getMinFilter() {
        return this.minFilter;
    }

    final void initMagFilter(int n) {
        this.magFilter = n;
    }

    final int getMagFilter() {
        return this.magFilter;
    }

    void initImage(int n, ImageComponent imageComponent) {
        this.checkImageSize(n, imageComponent);
        if (this.images == null) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureRetained0"));
        }
        if (this.source instanceof Texture2D) {
            if (imageComponent instanceof ImageComponent3D) {
                throw new IllegalArgumentException(J3dI18N.getString("Texture8"));
            }
        } else if (imageComponent instanceof ImageComponent2D) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture14"));
        }
        if (this.source.isLive()) {
            if (this.images[0][n] != null) {
                this.images[0][n].clearLive(this.refCount);
            }
            if (imageComponent != null) {
                ((ImageComponentRetained)imageComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.images[0][n] = imageComponent != null ? (ImageComponentRetained)imageComponent.retained : null;
    }

    final void checkImageSize(int n, ImageComponent imageComponent) {
        if (imageComponent != null) {
            int n2 = ((ImageComponentRetained)imageComponent.retained).width;
            int n3 = ((ImageComponentRetained)imageComponent.retained).height;
            int n4 = this.width;
            int n5 = this.height;
            for (int i = 0; i < n; ++i) {
                n4 >>= 1;
                n5 >>= 1;
            }
            if (n4 < 1) {
                n4 = 1;
            }
            if (n5 < 1) {
                n5 = 1;
            }
            if (n4 != n2 - 2 * this.boundaryWidth || n5 != n3 - 2 * this.boundaryWidth) {
                throw new IllegalArgumentException(J3dI18N.getString("TextureRetained1"));
            }
        }
    }

    final void checkSizes(ImageComponentRetained[] imageComponentRetainedArray) {
        if (imageComponentRetainedArray != null) {
            int n = this.height;
            int n2 = this.width;
            for (int i = 0; i < imageComponentRetainedArray.length; ++i) {
                int n3 = imageComponentRetainedArray[i].width;
                int n4 = imageComponentRetainedArray[i].height;
                assert (n2 == n3 - 2 * this.boundaryWidth && n == n4 - 2 * this.boundaryWidth);
                n /= 2;
                if ((n2 /= 2) < 1) {
                    n2 = 1;
                }
                if (n >= 1) continue;
                n = 1;
            }
        }
    }

    final void setImage(int n, ImageComponent imageComponent) {
        this.initImage(n, imageComponent);
        Object[] objectArray = new Object[]{new Integer(n), imageComponent, new Integer(0)};
        this.sendMessage(4, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            if (imageComponent != null && n >= this.baseLevel && n <= this.maximumLevel) {
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponent.retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.getRefImage(0) == null) {
                        this.enable = false;
                    }
                } else if (imageComponentRetained.getImageData(this.isUseAsRaster()).get() == null) {
                    this.enable = false;
                }
                if (!this.enable) {
                    this.sendMessage(1, Boolean.FALSE);
                }
            }
        }
    }

    void initImages(ImageComponent[] imageComponentArray) {
        if (imageComponentArray.length != this.maxLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        for (int i = 0; i < imageComponentArray.length; ++i) {
            this.initImage(i, imageComponentArray[i]);
        }
    }

    final void setImages(ImageComponent[] imageComponentArray) {
        int n;
        this.initImages(imageComponentArray);
        ImageComponent[] imageComponentArray2 = new ImageComponent[imageComponentArray.length];
        for (n = 0; n < imageComponentArray.length; ++n) {
            imageComponentArray2[n] = imageComponentArray[n];
        }
        Object[] objectArray = new Object[]{imageComponentArray2, new Integer(0)};
        this.sendMessage(32, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            for (n = this.baseLevel; n <= this.maximumLevel && this.enable; ++n) {
                if (imageComponentArray[n] == null) continue;
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponentArray[n].retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.getRefImage(0) != null) continue;
                    this.enable = false;
                    continue;
                }
                if (imageComponentRetained.getImageData(this.isUseAsRaster()).get() != null) continue;
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
    }

    final ImageComponent getImage(int n) {
        return this.images != null && this.images[0][n] != null ? (ImageComponent)this.images[0][n].source : null;
    }

    final ImageComponent[] getImages() {
        if (this.images == null) {
            return null;
        }
        ImageComponent[] imageComponentArray = new ImageComponent[this.images[0].length];
        for (int i = 0; i < this.images[0].length; ++i) {
            imageComponentArray[i] = this.images[0][i] != null ? (ImageComponent)this.images[0][i].source : null;
        }
        return imageComponentArray;
    }

    final void initMipMapMode(int n) {
        if (this.mipmapMode == n) {
            return;
        }
        int n2 = this.maxLevels;
        this.mipmapMode = n;
        if (n != 1) {
            this.maxLevels = this.maxMipMapLevels;
        } else {
            this.baseLevel = 0;
            this.maximumLevel = 0;
            this.maxLevels = 1;
        }
        ImageComponentRetained[][] imageComponentRetainedArray = new ImageComponentRetained[this.numFaces][this.maxLevels];
        if (n2 < this.maxLevels) {
            for (int i = 0; i < this.numFaces; ++i) {
                int n3;
                for (n3 = 0; n3 < n2; ++n3) {
                    imageComponentRetainedArray[i][n3] = this.images[i][n3];
                }
                for (n3 = n2; n3 < this.maxLevels; ++n3) {
                    imageComponentRetainedArray[i][n3] = null;
                }
            }
        } else {
            for (int i = 0; i < this.numFaces; ++i) {
                for (int j = 0; j < this.maxLevels; ++j) {
                    imageComponentRetainedArray[i][j] = this.images[i][j];
                }
            }
        }
        this.images = imageComponentRetainedArray;
    }

    final int getMipMapMode() {
        return this.mipmapMode;
    }

    final void initEnable(boolean bl) {
        this.userSpecifiedEnable = bl;
    }

    final void setEnable(boolean bl) {
        this.initEnable(bl);
        if (bl == this.enable) {
            return;
        }
        this.enable = bl;
        for (int i = 0; i < this.numFaces && this.enable; ++i) {
            for (int j = this.baseLevel; j <= this.maximumLevel && this.enable; ++j) {
                if (this.images[i][j].isByReference()) {
                    if (this.images[i][j].getRefImage(0) != null) continue;
                    this.enable = false;
                    continue;
                }
                if (this.images[i][j].getImageData(this.isUseAsRaster()).get() != null) continue;
                this.enable = false;
            }
        }
        this.sendMessage(1, this.enable ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getEnable() {
        return this.userSpecifiedEnable;
    }

    final void initBaseLevel(int n) {
        if (n < 0 || n > this.maximumLevel) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture36"));
        }
        this.baseLevel = n;
    }

    final void setBaseLevel(int n) {
        if (n == this.baseLevel) {
            return;
        }
        this.initBaseLevel(n);
        this.sendMessage(64, new Integer(n));
    }

    final int getBaseLevel() {
        return this.baseLevel;
    }

    final void initMaximumLevel(int n) {
        if (n < this.baseLevel || n >= this.maxMipMapLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture37"));
        }
        if (this.mipmapMode == 1 && n != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture48"));
        }
        this.maximumLevel = n;
    }

    final void setMaximumLevel(int n) {
        if (n == this.maximumLevel) {
            return;
        }
        this.initMaximumLevel(n);
        this.sendMessage(128, new Integer(n));
    }

    final int getMaximumLevel() {
        return this.maximumLevel;
    }

    final void initMinimumLOD(float f) {
        if (f > this.maximumLod) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture42"));
        }
        this.minimumLod = f;
    }

    final void setMinimumLOD(float f) {
        this.initMinimumLOD(f);
        this.sendMessage(256, new Float(f));
    }

    final float getMinimumLOD() {
        return this.minimumLod;
    }

    final void initMaximumLOD(float f) {
        if (f < this.minimumLod) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture42"));
        }
        this.maximumLod = f;
    }

    final void setMaximumLOD(float f) {
        this.initMaximumLOD(f);
        this.sendMessage(512, new Float(f));
    }

    final float getMaximumLOD() {
        return this.maximumLod;
    }

    final void initLodOffset(float f, float f2, float f3) {
        if (this.lodOffset == null) {
            this.lodOffset = new Point3f(f, f2, f3);
        } else {
            this.lodOffset.set(f, f2, f3);
        }
    }

    final void setLodOffset(float f, float f2, float f3) {
        this.initLodOffset(f, f2, f3);
        this.sendMessage(1024, new Point3f(f, f2, f3));
    }

    final void getLodOffset(Tuple3f tuple3f) {
        if (this.lodOffset == null) {
            tuple3f.set(0.0f, 0.0f, 0.0f);
        } else {
            tuple3f.set((Tuple3f)this.lodOffset);
        }
    }

    final void initBoundaryColor(Color4f color4f) {
        this.boundaryColor.set((Tuple4f)color4f);
    }

    final void initBoundaryColor(float f, float f2, float f3, float f4) {
        this.boundaryColor.set(f, f2, f3, f4);
    }

    final void getBoundaryColor(Color4f color4f) {
        color4f.set((Tuple4f)this.boundaryColor);
    }

    final void initAnisotropicFilterMode(int n) {
        this.anisotropicFilterMode = n;
    }

    final int getAnisotropicFilterMode() {
        return this.anisotropicFilterMode;
    }

    final void initAnisotropicFilterDegree(float f) {
        this.anisotropicFilterDegree = f;
    }

    final float getAnisotropicFilterDegree() {
        return this.anisotropicFilterDegree;
    }

    final void initSharpenTextureFunc(float[] fArray, float[] fArray2) {
        if (fArray == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = fArray.length;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != fArray.length * 2) {
                this.sharpenTextureFuncPts = new float[fArray.length * 2];
            }
            int n = 0;
            for (int i = 0; i < fArray.length; ++i) {
                this.sharpenTextureFuncPts[n++] = fArray[i];
                this.sharpenTextureFuncPts[n++] = fArray2[i];
            }
        }
    }

    final void initSharpenTextureFunc(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = point2fArray.length;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != point2fArray.length * 2) {
                this.sharpenTextureFuncPts = new float[point2fArray.length * 2];
            }
            int n = 0;
            for (int i = 0; i < point2fArray.length; ++i) {
                this.sharpenTextureFuncPts[n++] = point2fArray[i].x;
                this.sharpenTextureFuncPts[n++] = point2fArray[i].y;
            }
        }
    }

    final void initSharpenTextureFunc(float[] fArray) {
        if (fArray == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = fArray.length / 2;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != fArray.length) {
                this.sharpenTextureFuncPts = new float[fArray.length];
            }
            for (int i = 0; i < fArray.length; ++i) {
                this.sharpenTextureFuncPts[i] = fArray[i];
            }
        }
    }

    final int getSharpenTextureFuncPointsCount() {
        return this.numSharpenTextureFuncPts;
    }

    final void getSharpenTextureFunc(float[] fArray, float[] fArray2) {
        if (this.sharpenTextureFuncPts != null) {
            int n = 0;
            for (int i = 0; i < this.numSharpenTextureFuncPts; ++i) {
                fArray[i] = this.sharpenTextureFuncPts[n++];
                fArray2[i] = this.sharpenTextureFuncPts[n++];
            }
        }
    }

    final void getSharpenTextureFunc(Point2f[] point2fArray) {
        if (this.sharpenTextureFuncPts != null) {
            int n = 0;
            for (int i = 0; i < this.numSharpenTextureFuncPts; ++i) {
                point2fArray[i].x = this.sharpenTextureFuncPts[n++];
                point2fArray[i].y = this.sharpenTextureFuncPts[n++];
            }
        }
    }

    final void initFilter4Func(float[] fArray) {
        if (fArray == null) {
            this.filter4FuncPts = null;
        } else {
            if (this.filter4FuncPts == null || this.filter4FuncPts.length != fArray.length) {
                this.filter4FuncPts = new float[fArray.length];
            }
            for (int i = 0; i < fArray.length; ++i) {
                this.filter4FuncPts[i] = fArray[i];
            }
        }
    }

    final int getFilter4FuncPointsCount() {
        if (this.filter4FuncPts == null) {
            return 0;
        }
        return this.filter4FuncPts.length;
    }

    final void getFilter4Func(float[] fArray) {
        if (this.filter4FuncPts != null) {
            for (int i = 0; i < this.filter4FuncPts.length; ++i) {
                fArray[i] = this.filter4FuncPts[i];
            }
        }
    }

    final float[] getSharpenTextureFunc() {
        return this.sharpenTextureFuncPts;
    }

    final float[] getFilter4Func() {
        return this.filter4FuncPts;
    }

    @Override
    void setLive(boolean bl, int n) {
        int n2;
        int n3;
        this.enable = this.userSpecifiedEnable;
        super.doSetLive(bl, n);
        if (this.images != null) {
            for (n3 = 0; n3 < this.numFaces; ++n3) {
                for (n2 = 0; n2 < this.maxLevels; ++n2) {
                    if (this.images[n3][n2] == null) {
                        throw new IllegalArgumentException(J3dI18N.getString("TextureRetained3") + n2);
                    }
                    this.images[n3][n2].setLive(bl, n);
                }
            }
        }
        if (this.images != null) {
            for (n3 = 0; n3 < this.numFaces; ++n3) {
                this.checkSizes(this.images[n3]);
            }
        }
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 15;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(16);
        j3dMessage.args[2] = null;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        if (this.userSpecifiedEnable) {
            if (this.images != null) {
                for (n2 = 0; n2 < this.numFaces && this.enable; ++n2) {
                    for (int i = this.baseLevel; i <= this.maximumLevel && this.enable; ++i) {
                        if (this.images[n2][i].isByReference()) {
                            if (this.images[n2][i].getRefImage(0) != null) continue;
                            this.enable = false;
                            continue;
                        }
                        if (this.images[n2][i].getImageData(this.isUseAsRaster()).get() != null) continue;
                        this.enable = false;
                    }
                }
            } else {
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
        super.markAsLive();
    }

    @Override
    void clearLive(int n) {
        super.clearLive(n);
        if (this.images != null) {
            for (int i = 0; i < this.numFaces; ++i) {
                for (int j = 0; j < this.maxLevels; ++j) {
                    this.images[i][j].clearLive(n);
                    this.images[i][j].removeUser(this.mirror);
                }
            }
        }
    }

    void bindTexture(Context context, int n, boolean bl) {
        Pipeline.getPipeline().bindTexture2D(context, n, bl);
    }

    void updateTextureBoundary(Context context, int n, int n2, float f, float f2, float f3, float f4) {
        Pipeline.getPipeline().updateTexture2DBoundary(context, n, n2, f, f2, f3, f4);
    }

    void updateTextureFilterModes(Context context, int n, int n2) {
        Pipeline.getPipeline().updateTexture2DFilterModes(context, n, n2);
    }

    void updateTextureSharpenFunc(Context context, int n, float[] fArray) {
        Pipeline.getPipeline().updateTexture2DSharpenFunc(context, n, fArray);
    }

    void updateTextureFilter4Func(Context context, int n, float[] fArray) {
        Pipeline.getPipeline().updateTexture2DFilter4Func(context, n, fArray);
    }

    void updateTextureAnisotropicFilter(Context context, float f) {
        Pipeline.getPipeline().updateTexture2DAnisotropicFilter(context, f);
    }

    void updateTextureLodRange(Context context, int n, int n2, float f, float f2) {
        Pipeline.getPipeline().updateTexture2DLodRange(context, n, n2, f, f2);
    }

    void updateTextureLodOffset(Context context, float f, float f2, float f3) {
        Pipeline.getPipeline().updateTexture2DLodOffset(context, f, f2, f3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeTextureId(int n) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectId == n) {
                this.objectId = -1;
            }
        }
    }

    private boolean isEnabled(Canvas3D canvas3D) {
        if (this.widthOrHeightIsNPOT && !this.isUseAsRaster() && (canvas3D.textureExtendedFeatures & 0x8000) == 0) {
            return false;
        }
        return this.enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindTexture(Canvas3D canvas3D) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectId == -1) {
                this.objectId = Canvas3D.generateTexID(canvas3D.ctx);
            }
            canvas3D.addTextureResource(this.objectId, this);
        }
        this.bindTexture(canvas3D.ctx, this.objectId, this.isEnabled(canvas3D));
    }

    void updateTextureDimensions(Canvas3D canvas3D) {
        if (this.images[0][0] != null) {
            this.updateTextureImage(canvas3D, 0, this.maxLevels, 0, this.format, this.images[0][0].getImageFormatTypeIntValue(false), this.width, this.height, this.boundaryWidth, this.images[0][0].getImageDataTypeIntValue(), null);
        }
    }

    void updateTextureLOD(Canvas3D canvas3D) {
        if ((canvas3D.textureExtendedFeatures & 0x1000) != 0) {
            int n = 0;
            n = this.mipmapMode == 1 ? this.maxMipMapLevels : this.maximumLevel;
            this.updateTextureLodRange(canvas3D.ctx, this.baseLevel, n, this.minimumLod, this.maximumLod);
        }
        if (this.lodOffset != null && (canvas3D.textureExtendedFeatures & 0x2000) != 0) {
            this.updateTextureLodOffset(canvas3D.ctx, this.lodOffset.x, this.lodOffset.y, this.lodOffset.z);
        }
    }

    void updateTextureBoundary(Canvas3D canvas3D) {
        this.updateTextureBoundary(canvas3D.ctx, this.boundaryModeS, this.boundaryModeT, this.boundaryColor.x, this.boundaryColor.y, this.boundaryColor.z, this.boundaryColor.w);
    }

    void updateTextureFields(Canvas3D canvas3D) {
        int n = this.magFilter;
        int n2 = this.minFilter;
        if (n >= 9 && n <= 11) {
            if ((canvas3D.textureExtendedFeatures & 0x100) != 0) {
                this.updateTextureSharpenFunc(canvas3D.ctx, this.numSharpenTextureFuncPts, this.sharpenTextureFuncPts);
            } else {
                n = 3;
            }
        } else if (n >= 6 && n <= 8 && (canvas3D.textureExtendedFeatures & 0x200) == 0) {
            n = 3;
        }
        if (n2 == 12 || n == 12) {
            boolean bl = false;
            if ((canvas3D.textureExtendedFeatures & 0x400) != 0) {
                if (this.filter4FuncPts == null) {
                    bl = true;
                } else {
                    this.updateTextureFilter4Func(canvas3D.ctx, this.filter4FuncPts.length, this.filter4FuncPts);
                }
            } else {
                bl = true;
            }
            if (bl) {
                if (n2 == 12) {
                    n2 = 3;
                }
                if (n == 12) {
                    n = 3;
                }
            }
        }
        if (this.mipmapMode == 1 && (canvas3D.textureExtendedFeatures & 0x10000) == 0) {
            if (n2 == 1 || n2 == 5) {
                n2 = 3;
            } else if (n2 == 4) {
                n2 = 2;
            }
        }
        this.updateTextureFilterModes(canvas3D.ctx, n2, n);
        if ((canvas3D.textureExtendedFeatures & 0x800) != 0) {
            if (this.anisotropicFilterMode == 0) {
                this.updateTextureAnisotropicFilter(canvas3D.ctx, 1.0f);
            } else {
                this.updateTextureAnisotropicFilter(canvas3D.ctx, this.anisotropicFilterDegree);
            }
        }
        this.updateTextureBoundary(canvas3D);
    }

    void updateTextureImage(Canvas3D canvas3D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object) {
        Pipeline.getPipeline().updateTexture2DImage(canvas3D.ctx, n2, n3, n4, n5, n6, n7, n8, n9, object, this.useAutoMipMapGeneration(canvas3D));
    }

    void updateTextureSubImage(Canvas3D canvas3D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Object object) {
        Pipeline.getPipeline().updateTexture2DSubImage(canvas3D.ctx, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, object, this.useAutoMipMapGeneration(canvas3D));
    }

    void reloadTextureImage(Canvas3D canvas3D, int n, int n2, ImageComponentRetained imageComponentRetained, int n3) {
        boolean bl = this.isUseAsRaster();
        ImageComponentRetained.ImageData imageData = imageComponentRetained.getImageData(bl);
        assert (imageData != null);
        this.updateTextureImage(canvas3D, n, n3, n2, this.format, imageComponentRetained.getImageFormatTypeIntValue(bl), imageData.getWidth(), imageData.getHeight(), this.boundaryWidth, imageComponentRetained.getImageDataTypeIntValue(), imageData.get());
        if (imageData == null) {
            int n4 = 0;
            int n5 = 0;
            int n6 = imageComponentRetained.width;
            int n7 = imageComponentRetained.height;
            int n8 = imageComponentRetained.tilew;
            int n9 = imageComponentRetained.tileh;
            int n10 = n8;
            int n11 = n9;
            if (n6 < n10) {
                n10 = n6;
            }
            if (n7 < n11) {
                n11 = n7;
            }
            int n12 = n10;
            int n13 = imageComponentRetained.tilew - n10;
            int n14 = imageComponentRetained.tileh - n11;
            for (int i = 0; i < imageComponentRetained.numYTiles; ++i) {
                n4 = 0;
                n6 = this.width;
                n10 = n12;
                n13 = imageComponentRetained.tilew - n10;
                for (int j = 0; j < imageComponentRetained.numXTiles; ++j) {
                    Raster raster = ((RenderedImage)imageComponentRetained.getRefImage(0)).getTile(j, i);
                    byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
                    this.updateTextureSubImage(canvas3D, n, n2, n4, n5, this.format, imageComponentRetained.getImageFormatTypeIntValue(false), n13, n14, imageComponentRetained.tilew, n10, n11, 4096, byArray);
                    n4 += n10;
                    n13 = 0;
                    n10 = (n6 -= n10) < imageComponentRetained.tilew ? n6 : imageComponentRetained.tilew;
                }
                n5 += n11;
                n14 = 0;
                n11 = (n7 -= n11) < imageComponentRetained.tileh ? n7 : imageComponentRetained.tileh;
            }
        }
    }

    void reloadTextureSubImage(Canvas3D canvas3D, int n, int n2, ImageComponentUpdateInfo imageComponentUpdateInfo, ImageComponentRetained imageComponentRetained) {
        int n3 = imageComponentUpdateInfo.x;
        int n4 = imageComponentUpdateInfo.y;
        int n5 = imageComponentUpdateInfo.width;
        int n6 = imageComponentUpdateInfo.height;
        ImageComponentRetained.ImageData imageData = imageComponentRetained.getImageData(this.isUseAsRaster());
        if (imageData != null) {
            int n7 = n3;
            int n8 = n4;
            if (!imageComponentRetained.yUp) {
                n8 = imageComponentRetained.height - n8 - n6;
            }
            this.updateTextureSubImage(canvas3D, n, n2, n7, n8, this.format, imageComponentRetained.getImageFormatTypeIntValue(false), n7, n8, imageComponentRetained.width, n5, n6, imageComponentRetained.getImageDataTypeIntValue(), imageData.get());
        } else {
            assert (false);
            int n9 = n3;
            int n10 = n4;
            float f = (float)n9 / (float)imageComponentRetained.tilew;
            int n11 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
            f = (float)n10 / (float)imageComponentRetained.tileh;
            int n12 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
            int n13 = n11 * imageComponentRetained.tilew;
            int n14 = n12 * imageComponentRetained.tilew;
            int n15 = n13 + imageComponentRetained.tilew - n9;
            int n16 = n14 + imageComponentRetained.tileh - n10;
            if (n15 > n5) {
                n15 = n5;
            }
            if (n16 > n6) {
                n16 = n6;
            }
            int n17 = n15;
            int n18 = n5;
            int n19 = n6;
            int n20 = n9 - n13;
            int n21 = n10 - n14;
            int n22 = (n5 + n20) / imageComponentRetained.tilew;
            int n23 = (n6 + n21) / imageComponentRetained.tileh;
            if ((float)(n5 + n20) % (float)imageComponentRetained.tilew > 0.0f) {
                ++n22;
            }
            if ((float)(n6 + n21) % (float)imageComponentRetained.tileh > 0.0f) {
                ++n23;
            }
            int n24 = n3;
            int n25 = n4;
            for (int i = n12; i < n12 + n23; ++i) {
                n18 = n5;
                n15 = n17;
                n20 = n9 - n13;
                for (int j = n11; j < n11 + n22; ++j) {
                    Raster raster = ((RenderedImage)imageComponentRetained.getRefImage(0)).getTile(j, i);
                    byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
                    this.updateTextureSubImage(canvas3D, n, n2, n24, n25, this.format, imageComponentRetained.getImageFormatTypeIntValue(false), n20, n21, imageComponentRetained.tilew, n15, n16, 4096, byArray);
                    n24 += n15;
                    n20 = 0;
                    n15 = (n18 -= n15) < imageComponentRetained.tilew ? n18 : imageComponentRetained.tilew;
                }
                n25 += n16;
                n21 = 0;
                n16 = (n19 -= n16) < imageComponentRetained.tileh ? n19 : imageComponentRetained.tileh;
            }
        }
    }

    void reloadTexture(Canvas3D canvas3D) {
        int n;
        int n2;
        if ((canvas3D.textureExtendedFeatures & 0x1000) == 0) {
            n2 = 0;
            n = this.maxLevels - 1;
        } else {
            n2 = this.baseLevel;
            n = this.maximumLevel;
        }
        if (n2 != 0) {
            this.updateTextureDimensions(canvas3D);
        }
        for (int i = 0; i < this.numFaces; ++i) {
            for (int j = n2; j <= n; ++j) {
                ImageComponentRetained imageComponentRetained = this.images[i][j];
                if (imageComponentRetained == null) continue;
                imageComponentRetained.evaluateExtensions(canvas3D);
                this.reloadTextureImage(canvas3D, i, j, imageComponentRetained, this.maxLevels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTexture(Canvas3D canvas3D, int n) {
        for (int i = 0; i < this.numFaces; ++i) {
            for (int j = this.baseLevel; j <= this.maximumLevel; ++j) {
                if (this.imageUpdateInfo[i][j] == null) continue;
                for (int k = 0; k < this.imageUpdateInfo[i][j].size(); ++k) {
                    ImageComponentUpdateInfo imageComponentUpdateInfo = (ImageComponentUpdateInfo)this.imageUpdateInfo[i][j].get(k);
                    Object object = this.resourceLock;
                    synchronized (object) {
                        if ((imageComponentUpdateInfo.updateMask & n) == 0) {
                            continue;
                        }
                        imageComponentUpdateInfo.updateMask &= ~n;
                        if ((imageComponentUpdateInfo.updateMask & this.resourceCreationMask) == 0) {
                            imageComponentUpdateInfo.updateMask = 0;
                            if (this.imageUpdatePruneMask == null) {
                                this.imageUpdatePruneMask = new int[this.numFaces];
                            }
                            this.imageUpdatePruneMask[i] = 1 << j;
                        }
                    }
                    if (imageComponentUpdateInfo.entireImage) {
                        this.reloadTextureImage(canvas3D, i, j, this.images[i][j], this.maxLevels);
                        continue;
                    }
                    this.reloadTextureSubImage(canvas3D, i, j, imageComponentUpdateInfo, this.images[i][j]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadTextureSharedContext(Canvas3D canvas3D) {
        if (!this.isEnabled(canvas3D)) {
            return;
        }
        this.bindTexture(canvas3D);
        this.updateTextureFields(canvas3D);
        this.updateTextureLOD(canvas3D);
        this.reloadTexture(canvas3D);
        Object object = this.resourceLock;
        synchronized (object) {
            this.resourceCreationMask |= canvas3D.screen.renderer.rendererBit;
            this.resourceUpdatedMask |= canvas3D.screen.renderer.rendererBit;
            this.resourceLodUpdatedMask |= canvas3D.screen.renderer.rendererBit;
            this.resourceInReloadList &= ~canvas3D.screen.renderer.rendererBit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNative(Canvas3D canvas3D) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.bindTexture(canvas3D);
        if (!this.isEnabled(canvas3D)) {
            return;
        }
        if (canvas3D.useSharedCtx && canvas3D.screen.renderer.sharedCtx != null) {
            if ((this.resourceCreationMask & canvas3D.screen.renderer.rendererBit) == 0) {
                bl = true;
            } else {
                if ((this.resourceUpdatedMask & canvas3D.screen.renderer.rendererBit) == 0 && this.imageUpdateInfo != null) {
                    bl2 = true;
                }
                if ((this.resourceLodUpdatedMask & canvas3D.screen.renderer.rendererBit) == 0) {
                    bl3 = true;
                }
            }
            if (bl || bl2 || bl3) {
                canvas3D.makeCtxCurrent(canvas3D.screen.renderer.sharedCtx);
                this.bindTexture(canvas3D);
            }
        } else if ((this.resourceCreationMask & canvas3D.canvasBit) == 0) {
            bl = true;
        } else {
            if ((this.resourceUpdatedMask & canvas3D.canvasBit) == 0 && this.imageUpdateInfo != null) {
                bl2 = true;
            }
            if ((this.resourceLodUpdatedMask & canvas3D.canvasBit) == 0) {
                bl3 = true;
            }
        }
        if (bl) {
            this.updateTextureFields(canvas3D);
            this.updateTextureLOD(canvas3D);
            this.reloadTexture(canvas3D);
            if (canvas3D.useSharedCtx) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceCreationMask |= canvas3D.screen.renderer.rendererBit;
                    this.resourceUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                    this.resourceLodUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                }
            } else {
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceCreationMask |= canvas3D.canvasBit;
                    this.resourceUpdatedMask |= canvas3D.canvasBit;
                    this.resourceLodUpdatedMask |= canvas3D.canvasBit;
                }
            }
        } else if (bl3 || bl2) {
            if (bl3) {
                this.updateTextureLOD(canvas3D);
            }
            if (bl2) {
                int n = 0;
                n = canvas3D.useSharedCtx ? canvas3D.screen.renderer.rendererBit : canvas3D.canvasBit;
                this.updateTexture(canvas3D, n);
            }
            if (canvas3D.useSharedCtx) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                    this.resourceLodUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                }
            }
            Object object = this.resourceLock;
            synchronized (object) {
                this.resourceUpdatedMask |= canvas3D.canvasBit;
                this.resourceLodUpdatedMask |= canvas3D.canvasBit;
            }
        }
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this instanceof Texture3DRetained) {
                Texture3DRetained texture3DRetained = (Texture3DRetained)this;
                Texture3D texture3D = new Texture3D(texture3DRetained.mipmapMode, texture3DRetained.format, texture3DRetained.width, texture3DRetained.height, texture3DRetained.depth, texture3DRetained.boundaryWidth);
                this.mirror = (Texture3DRetained)texture3D.retained;
            } else if (this instanceof TextureCubeMapRetained) {
                TextureCubeMap textureCubeMap = new TextureCubeMap(this.mipmapMode, this.format, this.width, this.boundaryWidth);
                this.mirror = (TextureCubeMapRetained)textureCubeMap.retained;
            } else {
                Texture2D texture2D = new Texture2D(this.mipmapMode, this.format, this.width, this.height, this.boundaryWidth);
                this.mirror = (Texture2DRetained)texture2D.retained;
            }
            ((TextureRetained)this.mirror).objectId = -1;
        }
        this.initMirrorObject();
    }

    @Override
    synchronized void initMirrorObject() {
        int n;
        TextureRetained textureRetained;
        this.mirror.source = this.source;
        if (this instanceof Texture3DRetained) {
            textureRetained = (Texture3DRetained)this;
            ((Texture3DRetained)this.mirror).boundaryModeR = textureRetained.boundaryModeR;
            ((Texture3DRetained)this.mirror).depth = textureRetained.depth;
        }
        textureRetained = (TextureRetained)this.mirror;
        textureRetained.boundaryModeS = this.boundaryModeS;
        textureRetained.boundaryModeT = this.boundaryModeT;
        textureRetained.minFilter = this.minFilter;
        textureRetained.magFilter = this.magFilter;
        textureRetained.boundaryColor.set((Tuple4f)this.boundaryColor);
        textureRetained.enable = this.enable;
        textureRetained.userSpecifiedEnable = this.enable;
        textureRetained.enable = this.enable;
        textureRetained.numFaces = this.numFaces;
        textureRetained.resourceCreationMask = 0;
        textureRetained.resourceUpdatedMask = 0;
        textureRetained.resourceLodUpdatedMask = 0;
        textureRetained.resourceInReloadList = 0;
        textureRetained.baseLevel = this.baseLevel;
        textureRetained.maximumLevel = this.maximumLevel;
        textureRetained.minimumLod = this.minimumLod;
        textureRetained.maximumLod = this.maximumLod;
        textureRetained.lodOffset = this.lodOffset;
        textureRetained.numSharpenTextureFuncPts = this.numSharpenTextureFuncPts;
        if (this.sharpenTextureFuncPts == null) {
            textureRetained.sharpenTextureFuncPts = null;
        } else {
            if (textureRetained.sharpenTextureFuncPts == null || textureRetained.sharpenTextureFuncPts.length != this.sharpenTextureFuncPts.length) {
                textureRetained.sharpenTextureFuncPts = new float[this.sharpenTextureFuncPts.length];
            }
            for (n = 0; n < this.sharpenTextureFuncPts.length; ++n) {
                textureRetained.sharpenTextureFuncPts[n] = this.sharpenTextureFuncPts[n];
            }
        }
        if (this.filter4FuncPts == null) {
            textureRetained.filter4FuncPts = null;
        } else {
            if (textureRetained.filter4FuncPts == null || textureRetained.filter4FuncPts.length != this.filter4FuncPts.length) {
                textureRetained.filter4FuncPts = new float[this.filter4FuncPts.length];
            }
            for (n = 0; n < this.filter4FuncPts.length; ++n) {
                textureRetained.filter4FuncPts[n] = this.filter4FuncPts[n];
            }
        }
        textureRetained.anisotropicFilterMode = this.anisotropicFilterMode;
        textureRetained.anisotropicFilterDegree = this.anisotropicFilterDegree;
        textureRetained.maxLevels = this.maxLevels;
        if (this.images != null) {
            for (n = 0; n < this.numFaces; ++n) {
                for (int i = 0; i < this.maxLevels; ++i) {
                    textureRetained.images[n][i] = this.images[n][i];
                    if (this.images[n][i] == null) continue;
                    this.images[n][i].addUser(textureRetained);
                }
            }
        }
    }

    boolean useAutoMipMapGeneration(Canvas3D canvas3D) {
        return this.mipmapMode == 1 && (this.minFilter == 1 || this.minFilter == 4 || this.minFilter == 5) && (canvas3D.textureExtendedFeatures & 0x10000) != 0;
    }

    void pruneImageUpdateInfo() {
        for (int i = 0; i < this.numFaces; ++i) {
            for (int j = this.baseLevel; j <= this.maximumLevel; ++j) {
                if ((this.imageUpdatePruneMask[i] & 1 << j) == 0) continue;
                if (this.imageUpdateInfo[i][j] != null) {
                    for (int k = 0; k < this.imageUpdateInfo[i][j].size(); ++k) {
                        ImageComponentUpdateInfo imageComponentUpdateInfo = (ImageComponentUpdateInfo)this.imageUpdateInfo[i][j].get(k);
                        if (imageComponentUpdateInfo.updateMask != 0) continue;
                        this.imageUpdateInfo[i][j].remove(k);
                    }
                }
                int n = i;
                this.imageUpdatePruneMask[n] = this.imageUpdatePruneMask[n] & ~(1 << j);
            }
        }
    }

    void addImageUpdateInfo(int n, int n2, ImageComponentUpdateInfo imageComponentUpdateInfo) {
        if (this.imageUpdateInfo == null) {
            this.imageUpdateInfo = new ArrayList[this.numFaces][this.maxLevels];
        }
        if (this.imageUpdateInfo[n2][n] == null) {
            this.imageUpdateInfo[n2][n] = new ArrayList();
        }
        ImageComponentUpdateInfo imageComponentUpdateInfo2 = new ImageComponentUpdateInfo();
        imageComponentUpdateInfo2.entireImage = imageComponentUpdateInfo == null;
        if (imageComponentUpdateInfo2.entireImage) {
            this.imageUpdateInfo[n2][n].clear();
            if (this.imageUpdatePruneMask != null) {
                int n3 = n2;
                this.imageUpdatePruneMask[n3] = this.imageUpdatePruneMask[n3] & ~(1 << n);
            }
        } else {
            imageComponentUpdateInfo2.x = imageComponentUpdateInfo.x;
            imageComponentUpdateInfo2.y = imageComponentUpdateInfo.y;
            imageComponentUpdateInfo2.z = imageComponentUpdateInfo.z;
            imageComponentUpdateInfo2.width = imageComponentUpdateInfo.width;
            imageComponentUpdateInfo2.height = imageComponentUpdateInfo.height;
        }
        imageComponentUpdateInfo2.updateMask = this.resourceCreationMask;
        this.imageUpdateInfo[n2][n].add(imageComponentUpdateInfo2);
        if (this.imageUpdatePruneMask != null) {
            this.pruneImageUpdateInfo();
        }
    }

    void validate() {
        this.enable = true;
        for (int i = 0; i < this.numFaces && this.enable; ++i) {
            for (int j = this.baseLevel; j <= this.maximumLevel && this.enable; ++j) {
                if (this.images[i][j] != null) continue;
                this.enable = false;
            }
        }
    }

    @Override
    synchronized void updateMirrorObject(int n, Object object) {
        TextureRetained textureRetained = (TextureRetained)this.mirror;
        if ((n & 1) != 0) {
            textureRetained.enable = (Boolean)object;
        } else if ((n & 4) != 0) {
            Object[] objectArray = (Object[])object;
            int n2 = (Integer)objectArray[0];
            ImageComponent imageComponent = (ImageComponent)objectArray[1];
            int n3 = (Integer)objectArray[2];
            if (textureRetained.images[n3][n2] != null) {
                textureRetained.images[n3][n2].removeUser(this.mirror);
            }
            if (imageComponent == null) {
                textureRetained.images[n3][n2] = null;
            } else {
                textureRetained.images[n3][n2] = (ImageComponentRetained)imageComponent.retained;
                textureRetained.images[n3][n2].addUser(this.mirror);
            }
            textureRetained.resourceUpdatedMask = 0;
            textureRetained.addImageUpdateInfo(n2, n3, null);
        } else if ((n & 0x20) != 0) {
            Object[] objectArray = (Object[])object;
            ImageComponent[] imageComponentArray = (ImageComponent[])objectArray[0];
            int n4 = (Integer)objectArray[1];
            for (int i = 0; i < imageComponentArray.length; ++i) {
                if (textureRetained.images[n4][i] != null) {
                    textureRetained.images[n4][i].removeUser(this.mirror);
                }
                if (imageComponentArray[i] == null) {
                    textureRetained.images[n4][i] = null;
                    continue;
                }
                textureRetained.images[n4][i] = (ImageComponentRetained)imageComponentArray[i].retained;
                textureRetained.images[n4][i].addUser(this.mirror);
            }
            textureRetained.updateResourceCreationMask();
        } else if ((n & 0x40) != 0) {
            int n5 = (Integer)object;
            if (n5 < textureRetained.baseLevel) {
                for (int i = 0; i < this.numFaces; ++i) {
                    for (int j = n5; j < textureRetained.baseLevel; ++j) {
                        if (textureRetained.images[i][j] == null) {
                            textureRetained.enable = false;
                            continue;
                        }
                        textureRetained.addImageUpdateInfo(j, i, null);
                    }
                }
                textureRetained.baseLevel = n5;
                textureRetained.resourceUpdatedMask = 0;
            } else {
                textureRetained.baseLevel = n5;
                if (this.userSpecifiedEnable && !textureRetained.enable) {
                    textureRetained.validate();
                }
            }
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x80) != 0) {
            int n6 = (Integer)object;
            if (n6 > textureRetained.maximumLevel) {
                for (int i = 0; i < this.numFaces; ++i) {
                    for (int j = textureRetained.maximumLevel; j < n6; ++j) {
                        if (textureRetained.images[i][j] == null) {
                            textureRetained.enable = false;
                            continue;
                        }
                        textureRetained.addImageUpdateInfo(j, i, null);
                    }
                }
                textureRetained.maximumLevel = n6;
                textureRetained.resourceUpdatedMask = 0;
            } else {
                textureRetained.maximumLevel = n6;
                if (this.userSpecifiedEnable && !textureRetained.enable) {
                    textureRetained.validate();
                }
            }
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x100) != 0) {
            textureRetained.minimumLod = ((Float)object).floatValue();
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x200) != 0) {
            textureRetained.maximumLod = ((Float)object).floatValue();
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x400) != 0) {
            if (textureRetained.lodOffset == null) {
                textureRetained.lodOffset = new Point3f((Point3f)object);
            } else {
                textureRetained.lodOffset.set((Tuple3f)((Point3f)object));
            }
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x10) != 0) {
            textureRetained.updateResourceCreationMask();
        }
    }

    void notifyImageComponentImageChanged(ImageComponentRetained imageComponentRetained, ImageComponentUpdateInfo imageComponentUpdateInfo) {
        if (this.resourceCreationMask == 0) {
            if (this.imageUpdateInfo != null) {
                for (int i = 0; i < this.numFaces; ++i) {
                    for (int j = 0; j < this.maxLevels; ++j) {
                        if (this.imageUpdateInfo[i][j] == null) continue;
                        this.imageUpdateInfo[i][j].clear();
                    }
                    if (this.imageUpdatePruneMask == null) continue;
                    this.imageUpdatePruneMask[i] = 0;
                }
            }
            return;
        }
        for (int i = 0; i < this.numFaces; ++i) {
            boolean bl = false;
            for (int j = this.baseLevel; j <= this.maximumLevel && !bl; ++j) {
                if (this.images[i][j] != imageComponentRetained) continue;
                this.resourceUpdatedMask = 0;
                this.addImageUpdateInfo(j, i, imageComponentUpdateInfo);
                bl = true;
            }
        }
    }

    void updateResourceCreationMask() {
        this.resourceCreationMask = 0;
    }

    void incTextureBinRefCount(TextureBin textureBin) {
        this.setTextureBinRefCount(textureBin, this.getTextureBinRefCount(textureBin) + 1);
        for (int i = 0; i < this.numFaces; ++i) {
            for (int j = 0; j < this.maxLevels; ++j) {
                ImageComponentRetained imageComponentRetained = this.images[i][j];
                if (imageComponentRetained == null || !imageComponentRetained.isByReference() && (imageComponentRetained.source == null || !imageComponentRetained.source.getCapability(3))) continue;
                textureBin.renderBin.addNodeComponent(imageComponentRetained);
            }
        }
    }

    void decTextureBinRefCount(TextureBin textureBin) {
        this.setTextureBinRefCount(textureBin, this.getTextureBinRefCount(textureBin) - 1);
        for (int i = 0; i < this.numFaces; ++i) {
            for (int j = 0; j < this.maxLevels; ++j) {
                ImageComponentRetained imageComponentRetained = this.images[i][j];
                if (imageComponentRetained == null || !imageComponentRetained.isByReference() && (imageComponentRetained.source == null || !imageComponentRetained.source.getCapability(3))) continue;
                textureBin.renderBin.removeNodeComponent(imageComponentRetained);
            }
        }
    }

    final void sendMessage(int n, Object object) {
        ArrayList<VirtualUniverse> arrayList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 15;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 15;
            j3dMessage.universe = arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList<GeometryAtom> arrayList3 = arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    @Override
    void handleFrequencyChange(int n) {
        switch (n) {
            case 1: 
            case 7: 
            case 11: {
                this.setFrequencyChangeMask(n, n);
            }
        }
    }

    void setUseAsRaster(boolean bl) {
        this.useAsRaster = bl;
    }

    boolean isUseAsRaster() {
        return this.useAsRaster;
    }

    int getTextureBinRefCount(TextureBin textureBin) {
        Integer n = this.textureBinRefCount.get(textureBin.renderBin);
        return n == null ? 0 : n;
    }

    private void setTextureBinRefCount(TextureBin textureBin, int n) {
        if (n == 0) {
            this.textureBinRefCount.remove(textureBin.renderBin);
        } else {
            this.textureBinRefCount.put(textureBin.renderBin, new Integer(n));
        }
    }
}

