/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.TouchFilter;
import com.sun.glass.ui.monocle.TouchInput;
import com.sun.glass.ui.monocle.TouchState;

final class NearbyPointsTouchFilter
implements TouchFilter {
    private final int radius = TouchInput.getInstance().getTouchRadius();

    NearbyPointsTouchFilter() {
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public boolean filter(TouchState touchState) {
        while (this.mergeClosestPoints(touchState)) {
        }
        return false;
    }

    private boolean mergeClosestPoints(TouchState touchState) {
        int n = -1;
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < touchState.getPointCount(); ++i) {
            for (int j = i + 1; j < touchState.getPointCount(); ++j) {
                TouchState.Point point = touchState.getPoint(i);
                TouchState.Point point2 = touchState.getPoint(j);
                int n4 = point.x - point2.x;
                int n5 = point.y - point2.y;
                int n6 = n4 * n4 + n5 * n5;
                if (n6 >= n3) continue;
                n3 = n6;
                n = i;
                n2 = j;
            }
        }
        if (n3 < this.radius * this.radius) {
            TouchState.Point point = touchState.getPoint(n);
            TouchState.Point point3 = touchState.getPoint(n2);
            point.x = (point.x + point3.x) / 2;
            point.y = (point.y + point3.y) / 2;
            touchState.removePointForID(point3.id);
            return true;
        }
        return false;
    }

    @Override
    public boolean flush(TouchState touchState) {
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof NearbyPointsTouchFilter;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "NearbyPoints";
    }
}

