/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.GetFrameCommand;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import org.jetbrains.annotations.NotNull;

public class GetVariableCommand
extends GetFrameCommand {
    public static final String BY_ID = "BY_ID";
    private final String myVariableName;
    private final PyDebugValue myParent;

    public GetVariableCommand(RemoteDebugger debugger, String threadId, String frameId, PyDebugValue var) {
        super(debugger, 110, threadId, frameId);
        this.myVariableName = var.getOffset() == 0 ? GetVariableCommand.composeName(var) : var.getOffset() + "\t" + GetVariableCommand.composeName(var);
        this.myParent = var;
    }

    @NotNull
    public static String composeName(PyDebugValue var) {
        StringBuilder sb = new StringBuilder();
        for (PyDebugValue p = var; p != null; p = p.getParent()) {
            if (sb.length() > 0) {
                sb.insert(0, '\t');
            }
            if (p.getId() != null) {
                sb.insert(0, BY_ID).insert(0, '\t').insert(0, p.getId());
                break;
            }
            String tempName = p.getTempName();
            if (tempName == null) continue;
            sb.insert(0, tempName.replaceAll("\t", "@_@TAB_CHAR@_@"));
        }
        String string = sb.toString();
        if (string == null) {
            GetVariableCommand.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        if (this.myParent.getVariableLocator() != null) {
            payload.add(this.myParent.getVariableLocator().getThreadId()).add(this.myParent.getVariableLocator().getPyDBLocation());
        } else if (this.myVariableName.contains(BY_ID)) {
            payload.add(this.getThreadId()).add(this.myVariableName);
        } else {
            super.buildPayload(payload);
            payload.add(this.myVariableName);
        }
    }

    @Override
    protected PyDebugValue extend(PyDebugValue value) {
        PyDebugValue debugValue = new PyDebugValue(value);
        debugValue.setParent(this.myParent);
        debugValue.setFrameAccessor(this.myDebugProcess);
        return debugValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/GetVariableCommand", "composeName"));
    }
}

