/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.EditorConfigLanguage;
import org.editorconfig.language.formatting.EditorConfigFormattingBlock;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u000b\u001a\n \f*\u0004\u0018\u00010\n0\n*\u00060\rR\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/editorconfig/language/formatting/EditorConfigFormattingModelBuilder;", "Lcom/intellij/formatting/FormattingModelBuilder;", "()V", "createModel", "Lcom/intellij/formatting/FormattingModel;", "element", "Lcom/intellij/psi/PsiElement;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "createSpacingBuilder", "Lcom/intellij/formatting/SpacingBuilder;", "strictSpaces", "kotlin.jvm.PlatformType", "Lcom/intellij/formatting/SpacingBuilder$RuleBuilder;", "needSpace", "", "toInt", "", "intellij.editorconfig"})
public final class EditorConfigFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        SpacingBuilder spacingBuilder = this.createSpacingBuilder(settings);
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)EditorConfigLanguage.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"settings.getCommonSettings(EditorConfigLanguage)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        boolean shouldAlignSeparators = commonSettings.ALIGN_GROUP_FIELD_DECLARATIONS;
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
        EditorConfigFormattingBlock root = new EditorConfigFormattingBlock(aSTNode, spacingBuilder, shouldAlignSeparators, null, 8, null);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)element.getContainingFile(), (Block)((Block)root), (CodeStyleSettings)settings);
        Intrinsics.checkExpressionValueIsNotNull((Object)formattingModel, (String)"FormattingModelProvider.\u2026ningFile, root, settings)");
        return formattingModel;
    }

    private final SpacingBuilder createSpacingBuilder(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)EditorConfigLanguage.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"settings.getCommonSettings(EditorConfigLanguage)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        boolean beforeComma = commonSettings.SPACE_BEFORE_COMMA;
        boolean afterComma = commonSettings.SPACE_AFTER_COMMA;
        boolean beforeColon = commonSettings.SPACE_BEFORE_COLON;
        boolean afterColon = commonSettings.SPACE_AFTER_COLON;
        boolean aroundSeparator = commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS;
        SpacingBuilder.RuleBuilder ruleBuilder = new SpacingBuilder(settings, (Language)EditorConfigLanguage.INSTANCE).around(EditorConfigElementTypes.SEPARATOR);
        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder, (String)"SpacingBuilder(settings,\u2026igElementTypes.SEPARATOR)");
        SpacingBuilder.RuleBuilder ruleBuilder2 = this.strictSpaces(ruleBuilder, aroundSeparator).before(EditorConfigElementTypes.COMMA);
        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder2, (String)"SpacingBuilder(settings,\u2026ConfigElementTypes.COMMA)");
        SpacingBuilder.RuleBuilder ruleBuilder3 = this.strictSpaces(ruleBuilder2, beforeComma).after(EditorConfigElementTypes.COMMA);
        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder3, (String)"SpacingBuilder(settings,\u2026ConfigElementTypes.COMMA)");
        SpacingBuilder.RuleBuilder ruleBuilder4 = this.strictSpaces(ruleBuilder3, afterComma).around(EditorConfigElementTypes.DOT);
        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder4, (String)"SpacingBuilder(settings,\u2026orConfigElementTypes.DOT)");
        SpacingBuilder.RuleBuilder ruleBuilder5 = this.strictSpaces(ruleBuilder4, false).before(EditorConfigElementTypes.COLON);
        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder5, (String)"SpacingBuilder(settings,\u2026ConfigElementTypes.COLON)");
        SpacingBuilder.RuleBuilder ruleBuilder6 = this.strictSpaces(ruleBuilder5, beforeColon).after(EditorConfigElementTypes.COLON);
        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder6, (String)"SpacingBuilder(settings,\u2026ConfigElementTypes.COLON)");
        SpacingBuilder spacingBuilder = this.strictSpaces(ruleBuilder6, afterColon).around(EditorConfigElementTypes.LINE_COMMENT).spaces(1).around(EditorConfigElementTypes.OPTION).lineBreakInCode().around(EditorConfigElementTypes.ROOT_DECLARATION).blankLines(1).around(EditorConfigElementTypes.SECTION).blankLines(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacingBuilder, (String)"SpacingBuilder(settings,\u2026es.SECTION).blankLines(1)");
        return spacingBuilder;
    }

    private final SpacingBuilder strictSpaces(@NotNull SpacingBuilder.RuleBuilder $this$strictSpaces, boolean needSpace) {
        return $this$strictSpaces.spacing(this.toInt(needSpace), this.toInt(needSpace), 0, false, 0);
    }

    private final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }
}

