/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.navigation.History;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Component;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsLogUi
implements VcsLogUi,
Disposable {
    private static final Logger LOG = Logger.getInstance(AbstractVcsLogUi.class);
    public static final ExtensionPointName<VcsLogHighlighterFactory> LOG_HIGHLIGHTER_FACTORY_EP = ExtensionPointName.create((String)"com.intellij.logHighlighterFactory");
    @NotNull
    private final String myId;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VcsLogData myLogData;
    @NotNull
    protected final VcsLogColorManager myColorManager;
    @NotNull
    protected final VcsLog myLog;
    @NotNull
    protected final VisiblePackRefresher myRefresher;
    @NotNull
    protected final Collection<VcsLogListener> myLogListeners;
    @NotNull
    protected final VisiblePackChangeListener myVisiblePackChangeListener;
    @NotNull
    protected VisiblePack myVisiblePack;

    public AbstractVcsLogUi(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull VisiblePackRefresher refresher) {
        if (id == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(3);
        }
        this.myLogListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myId = id;
        this.myProject = logData.getProject();
        this.myLogData = logData;
        this.myRefresher = refresher;
        this.myColorManager = manager;
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        this.myLog = new VcsLogImpl(logData, this);
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myVisiblePackChangeListener = visiblePack -> UIUtil.invokeLaterIfNeeded(() -> {
            if (!Disposer.isDisposed((Disposable)this)) {
                this.setVisiblePack(visiblePack);
            }
        });
        this.myRefresher.addVisiblePackChangeListener(this.myVisiblePackChangeListener);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void requestFocus() {
        VcsLogGraphTable graphTable = this.getTable();
        if (graphTable.getRowCount() > 0) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)graphTable), true).doWhenProcessed(() -> graphTable.setRowSelectionInterval(0, 0));
        }
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        if (pack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean permGraphChanged = this.myVisiblePack.getDataPack() != pack.getDataPack();
        this.myVisiblePack = pack;
        this.onVisiblePackUpdated(permGraphChanged);
        this.fireFilterChangeEvent(this.myVisiblePack, permGraphChanged);
        this.getTable().repaint();
    }

    public void jumpToNearestCommit(@NotNull Hash hash, @NotNull VirtualFile root, boolean silently) {
        if (hash == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(6);
        }
        if (root == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(7);
        }
        this.jumpTo(hash, (model, h) -> {
            if (!this.myLogData.getStorage().containsCommit(new CommitId(h, root))) {
                return -1;
            }
            int commitIndex = this.myLogData.getCommitIndex((Hash)h, root);
            Integer rowIndex = this.myVisiblePack.getVisibleGraph().getVisibleRowIndex((Object)commitIndex);
            if (rowIndex == null) {
                rowIndex = ReachableNodesUtilKt.findVisibleAncestorRow(commitIndex, this.myVisiblePack);
            }
            return rowIndex == null ? -2 : rowIndex;
        }, (SettableFuture<? super Boolean>)SettableFuture.create(), silently);
    }

    protected abstract void onVisiblePackUpdated(boolean var1);

    @NotNull
    public abstract VcsLogGraphTable getTable();

    @NotNull
    public abstract Component getMainComponent();

    @NotNull
    public abstract VcsLogUiProperties getProperties();

    @Nullable
    public abstract History getNavigationHistory();

    @Nullable
    public abstract String getHelpId();

    @NotNull
    public VisiblePackRefresher getRefresher() {
        VisiblePackRefresher visiblePackRefresher = this.myRefresher;
        if (visiblePackRefresher == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(8);
        }
        return visiblePackRefresher;
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(9);
        }
        return vcsLogColorManager;
    }

    @NotNull
    public VcsLog getVcsLog() {
        VcsLog vcsLog = this.myLog;
        if (vcsLog == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(10);
        }
        return vcsLog;
    }

    @NotNull
    public VcsLogData getLogData() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(11);
        }
        return vcsLogData;
    }

    public void requestMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(12);
        }
        this.myRefresher.moreCommitsNeeded(onLoaded);
        this.getTable().setPaintBusy(true);
    }

    @NotNull
    public VisiblePack getDataPack() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VisiblePack visiblePack = this.myVisiblePack;
        if (visiblePack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(13);
        }
        return visiblePack;
    }

    public void jumpToRow(int row2, boolean silently) {
        this.jumpTo(row2, (model, r) -> {
            if (model.getRowCount() <= r) {
                return -1;
            }
            return r;
        }, (SettableFuture<? super Boolean>)SettableFuture.create(), silently);
    }

    @NotNull
    public ListenableFuture<Boolean> jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        if (commitHash == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(14);
        }
        if (root == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(15);
        }
        SettableFuture future = SettableFuture.create();
        this.jumpToCommit(commitHash, root, (SettableFuture<? super Boolean>)future);
        SettableFuture settableFuture = future;
        if (settableFuture == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(16);
        }
        return settableFuture;
    }

    public void jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root, @NotNull SettableFuture<? super Boolean> future) {
        if (commitHash == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(17);
        }
        if (root == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(18);
        }
        if (future == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(19);
        }
        this.jumpTo(commitHash, (model, hash) -> model.getRowOfCommit((Hash)hash, root), future);
    }

    public void jumpToCommitByPartOfHash(@NotNull String commitHash, @NotNull SettableFuture<? super Boolean> future) {
        String trimmed;
        if (commitHash == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(20);
        }
        if (future == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(21);
        }
        if (!VcsLogUtil.HASH_REGEX.matcher(trimmed = StringUtil.trim((String)commitHash, ch -> !StringUtil.containsChar((String)"()'\"`", (char)ch))).matches()) {
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, "Commit or reference '" + commitHash + "' not found", MessageType.WARNING, new NamedRunnable[0]);
            future.set((Object)false);
            return;
        }
        this.jumpTo(trimmed, GraphTableModel::getRowOfCommitByPartOfHash, future);
    }

    protected <T> void jumpTo(@NotNull T commitId, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter, @NotNull SettableFuture<? super Boolean> future) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(22);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(23);
        }
        if (future == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(24);
        }
        this.jumpTo(commitId, rowGetter, future, false);
    }

    protected <T> void jumpTo(@NotNull T commitId, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter, @NotNull SettableFuture<? super Boolean> future, boolean silently) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(25);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(26);
        }
        if (future == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(27);
        }
        if (future.isCancelled()) {
            return;
        }
        GraphTableModel model = this.getTable().getModel();
        int result2 = (Integer)rowGetter.fun((Object)model, commitId);
        if (result2 >= 0) {
            this.getTable().jumpToRow(result2);
            future.set((Object)true);
        } else if (model.canRequestMore()) {
            model.requestToLoadMore(() -> this.jumpTo(commitId, rowGetter, future, silently));
        } else if (!this.myVisiblePack.isFull()) {
            this.invokeOnChange(() -> this.jumpTo(commitId, rowGetter, future, silently));
        } else {
            if (!silently) {
                this.handleCommitNotFound(commitId, result2 == -2, rowGetter);
            }
            future.set((Object)false);
        }
    }

    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(28);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(29);
        }
        String message = AbstractVcsLogUi.getCommitNotFoundMessage(commitId, commitExists);
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.WARNING, new NamedRunnable[0]);
    }

    @NotNull
    protected static <T> String getCommitNotFoundMessage(@NotNull T commitId, boolean exists) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(30);
        }
        String string = exists ? "Commit " + AbstractVcsLogUi.getCommitPresentation(commitId) + " doesn't match the filters" : "Commit " + AbstractVcsLogUi.getCommitPresentation(commitId) + " not found";
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    protected static <T> String getCommitPresentation(@NotNull T commitId) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(32);
        }
        if (commitId instanceof Hash) {
            String string = ((Hash)commitId).toShortString();
            if (string == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (commitId instanceof String) {
            String string = VcsLogUtil.getShortHash((String)commitId);
            if (string == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(34);
            }
            return string;
        }
        String string = commitId.toString();
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(35);
        }
        return string;
    }

    protected void showWarningWithLink(@NotNull String mainText, @NotNull String linkText, final @NotNull Runnable onClick) {
        if (mainText == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(36);
        }
        if (linkText == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(37);
        }
        if (onClick == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(38);
        }
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, mainText, MessageType.WARNING, new NamedRunnable(linkText){

            public void run() {
                onClick.run();
            }
        });
    }

    public void addLogListener(@NotNull VcsLogListener listener) {
        if (listener == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.add(listener);
    }

    public void removeLogListener(@NotNull VcsLogListener listener) {
        if (listener == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.remove(listener);
    }

    protected void fireFilterChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh2) {
        if (visiblePack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(41);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (VcsLogListener listener : this.myLogListeners) {
            listener.onChange((VcsLogDataPack)visiblePack, refresh2);
        }
    }

    public void invokeOnChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(42);
        }
        this.invokeOnChange(runnable, (Condition<? super VcsLogDataPack>)Conditions.alwaysTrue());
    }

    protected void invokeOnChange(final @NotNull Runnable runnable, final @NotNull Condition<? super VcsLogDataPack> condition) {
        if (runnable == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(43);
        }
        if (condition == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(44);
        }
        this.addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                if (dataPack == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (condition.value((Object)dataPack)) {
                    runnable.run();
                    AbstractVcsLogUi.this.removeLogListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/AbstractVcsLogUi$2", "onChange"));
            }
        });
    }

    public void dispose() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        LOG.debug("Disposing VcsLogUi '" + this.myId + "'");
        this.myRefresher.removeVisiblePackChangeListener(this.myVisiblePackChangeListener);
        this.getTable().removeAllHighlighters();
        this.myVisiblePack = VisiblePack.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 7: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
            case 19: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainText";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClick";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefresher";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsLog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToCommit";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitNotFoundMessage";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "jumpToNearestCommit";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "requestMore";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "jumpToCommit";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "jumpToCommitByPartOfHash";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "jumpTo";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCommitNotFoundMessage";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCommitPresentation";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "showWarningWithLink";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addLogListener";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeLogListener";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "fireFilterChangeEvent";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

