/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.GraphChangesUtil;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraph;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraphBuilder;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearBekController
extends CascadeController {
    private static final Logger LOG = Logger.getInstance(LinearBekController.class);
    @NotNull
    private final LinearBekGraph myCompiledGraph;
    private final LinearBekGraphBuilder myLinearBekGraphBuilder;
    private final BekGraphLayout myBekGraphLayout;

    public LinearBekController(@NotNull BekBaseController controller, @NotNull PermanentGraphInfo permanentGraphInfo) {
        if (controller == null) {
            LinearBekController.$$$reportNull$$$0(0);
        }
        if (permanentGraphInfo == null) {
            LinearBekController.$$$reportNull$$$0(1);
        }
        super(controller, permanentGraphInfo);
        this.myCompiledGraph = new LinearBekGraph(this.getDelegateGraph());
        this.myBekGraphLayout = new BekGraphLayout(permanentGraphInfo.getPermanentGraphLayout(), controller.getBekIntMap());
        this.myLinearBekGraphBuilder = new LinearBekGraphBuilder(this.myCompiledGraph, this.myBekGraphLayout);
        long start = System.currentTimeMillis();
        this.myLinearBekGraphBuilder.collapseAll();
        LOG.debug("Linear bek took " + (double)(System.currentTimeMillis() - start) / 1000.0 + " sec");
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer == null) {
            LinearBekController.$$$reportNull$$$0(2);
        }
        LinearGraphController.LinearGraphAnswer linearGraphAnswer = delegateAnswer;
        if (linearGraphAnswer == null) {
            LinearBekController.$$$reportNull$$$0(3);
        }
        return linearGraphAnswer;
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        if (action == null) {
            LinearBekController.$$$reportNull$$$0(4);
        }
        if (action.getAffectedElement() != null) {
            if (action.getType() == GraphAction.Type.MOUSE_CLICK) {
                GraphElement graphElement = action.getAffectedElement().getGraphElement();
                if (graphElement instanceof GraphNode) {
                    LinearGraphController.LinearGraphAnswer answer = this.collapseNode((GraphNode)graphElement);
                    if (answer != null) {
                        return answer;
                    }
                    for (GraphEdge dottedEdge : this.getAllAdjacentDottedEdges((GraphNode)graphElement)) {
                        LinearGraphController.LinearGraphAnswer expandedAnswer = this.expandEdge(dottedEdge);
                        if (expandedAnswer == null) continue;
                        return expandedAnswer;
                    }
                } else if (graphElement instanceof GraphEdge) {
                    return this.expandEdge((GraphEdge)graphElement);
                }
            } else if (action.getType() == GraphAction.Type.MOUSE_OVER) {
                GraphElement graphElement = action.getAffectedElement().getGraphElement();
                if (graphElement instanceof GraphNode) {
                    LinearGraphController.LinearGraphAnswer answer = this.highlightNode((GraphNode)graphElement);
                    if (answer != null) {
                        return answer;
                    }
                    for (GraphEdge dottedEdge : this.getAllAdjacentDottedEdges((GraphNode)graphElement)) {
                        LinearGraphController.LinearGraphAnswer highlightAnswer = this.highlightEdge(dottedEdge);
                        if (highlightAnswer == null) continue;
                        return highlightAnswer;
                    }
                } else if (graphElement instanceof GraphEdge) {
                    return this.highlightEdge((GraphEdge)graphElement);
                }
            }
        } else {
            if (action.getType() == GraphAction.Type.BUTTON_COLLAPSE) {
                return this.collapseAll();
            }
            if (action.getType() == GraphAction.Type.BUTTON_EXPAND) {
                return this.expandAll();
            }
        }
        return null;
    }

    @NotNull
    private List<GraphEdge> getAllAdjacentDottedEdges(GraphNode graphElement) {
        List list = ContainerUtil.filter(this.myCompiledGraph.getAdjacentEdges(graphElement.getNodeIndex(), EdgeFilter.ALL), graphEdge -> graphEdge.getType() == GraphEdgeType.DOTTED);
        if (list == null) {
            LinearBekController.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private LinearGraphController.LinearGraphAnswer expandAll() {
        LinearGraphController.LinearGraphAnswer linearGraphAnswer = new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES){

            @Override
            @Nullable
            public Runnable getGraphUpdater() {
                return () -> {
                    ((LinearBekController)LinearBekController.this).myCompiledGraph.myDottedEdges.removeAll();
                    ((LinearBekController)LinearBekController.this).myCompiledGraph.myHiddenEdges.removeAll();
                };
            }
        };
        if (linearGraphAnswer == null) {
            LinearBekController.$$$reportNull$$$0(6);
        }
        return linearGraphAnswer;
    }

    @NotNull
    private LinearGraphController.LinearGraphAnswer collapseAll() {
        final LinearBekGraph.WorkingLinearBekGraph workingGraph = new LinearBekGraph.WorkingLinearBekGraph(this.myCompiledGraph);
        new LinearBekGraphBuilder(workingGraph, this.myBekGraphLayout).collapseAll();
        LinearGraphController.LinearGraphAnswer linearGraphAnswer = new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.edgesReplaced(workingGraph.getRemovedEdges(), workingGraph.getAddedEdges(), this.getDelegateGraph())){

            @Override
            @Nullable
            public Runnable getGraphUpdater() {
                return () -> workingGraph.applyChanges();
            }
        };
        if (linearGraphAnswer == null) {
            LinearBekController.$$$reportNull$$$0(7);
        }
        return linearGraphAnswer;
    }

    @Nullable
    private LinearGraphController.LinearGraphAnswer highlightNode(GraphNode node) {
        Set<LinearBekGraphBuilder.MergeFragment> toCollapse = this.collectFragmentsToCollapse(node);
        if (toCollapse.isEmpty()) {
            return null;
        }
        HashSet<Integer> toHighlight = new HashSet<Integer>();
        for (LinearBekGraphBuilder.MergeFragment fragment : toCollapse) {
            toHighlight.addAll(fragment.getAllNodes());
        }
        return LinearGraphUtils.createSelectedAnswer(this.myCompiledGraph, toHighlight);
    }

    @Nullable
    private LinearGraphController.LinearGraphAnswer highlightEdge(GraphEdge edge) {
        if (edge.getType() == GraphEdgeType.DOTTED) {
            return LinearGraphUtils.createSelectedAnswer(this.myCompiledGraph, ContainerUtil.set((Object[])new Integer[]{edge.getUpNodeIndex(), edge.getDownNodeIndex()}));
        }
        return null;
    }

    @Nullable
    private LinearGraphController.LinearGraphAnswer collapseNode(GraphNode node) {
        SortedSet<Integer> toCollapse = this.collectNodesToCollapse(node);
        if (toCollapse.isEmpty()) {
            return null;
        }
        for (Integer i : toCollapse) {
            this.myLinearBekGraphBuilder.collapseFragment(i);
        }
        return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES);
    }

    private SortedSet<Integer> collectNodesToCollapse(GraphNode node) {
        TreeSet<Integer> toCollapse = new TreeSet<Integer>(Comparator.reverseOrder());
        for (LinearBekGraphBuilder.MergeFragment f : this.collectFragmentsToCollapse(node)) {
            toCollapse.add(f.getParent());
            toCollapse.addAll(f.getTailsAndBody());
        }
        return toCollapse;
    }

    @NotNull
    private Set<LinearBekGraphBuilder.MergeFragment> collectFragmentsToCollapse(GraphNode node) {
        HashSet<LinearBekGraphBuilder.MergeFragment> result2 = new HashSet<LinearBekGraphBuilder.MergeFragment>();
        int mergesCount = 0;
        LinkedHashSet<Integer> toProcess = new LinkedHashSet<Integer>();
        toProcess.add(node.getNodeIndex());
        while (!toProcess.isEmpty()) {
            Integer i = (Integer)ContainerUtil.getFirstItem(toProcess);
            toProcess.remove(i);
            LinearBekGraphBuilder.MergeFragment fragment = this.myLinearBekGraphBuilder.getFragment(i);
            if (fragment == null) continue;
            result2.add(fragment);
            toProcess.addAll(fragment.getTailsAndBody());
            if (++mergesCount <= 10) continue;
            break;
        }
        HashSet<LinearBekGraphBuilder.MergeFragment> hashSet = result2;
        if (hashSet == null) {
            LinearBekController.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Nullable
    private LinearGraphController.LinearGraphAnswer expandEdge(GraphEdge edge) {
        if (edge.getType() == GraphEdgeType.DOTTED) {
            return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.edgesReplaced(Collections.singleton(edge), this.myCompiledGraph.expandEdge(edge), this.getDelegateGraph()));
        }
        return null;
    }

    @NotNull
    private LinearGraph getDelegateGraph() {
        LinearGraph linearGraph = this.getDelegateController().getCompiledGraph();
        if (linearGraph == null) {
            LinearBekController.$$$reportNull$$$0(9);
        }
        return linearGraph;
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        LinearBekGraph linearBekGraph = this.myCompiledGraph;
        if (linearBekGraph == null) {
            LinearBekController.$$$reportNull$$$0(10);
        }
        return linearBekGraph;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraphInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateAnswer";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/linearBek/LinearBekController";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/linearBek/LinearBekController";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "delegateGraphChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAdjacentDottedEdges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "expandAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseAll";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFragmentsToCollapse";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegateGraph";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiledGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "delegateGraphChanged";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BekGraphLayout
    implements GraphLayout {
        private final GraphLayout myGraphLayout;
        private final BekIntMap myBekIntMap;

        BekGraphLayout(GraphLayout graphLayout, BekIntMap bekIntMap) {
            this.myGraphLayout = graphLayout;
            this.myBekIntMap = bekIntMap;
        }

        @Override
        public int getLayoutIndex(int nodeIndex) {
            return this.myGraphLayout.getLayoutIndex(this.myBekIntMap.getUsualIndex(nodeIndex));
        }

        @Override
        public int getOneOfHeadNodeIndex(int nodeIndex) {
            int usualIndex = this.myGraphLayout.getOneOfHeadNodeIndex(this.myBekIntMap.getUsualIndex(nodeIndex));
            return this.myBekIntMap.getBekIndex(usualIndex);
        }

        @Override
        @NotNull
        public List<Integer> getHeadNodeIndex() {
            ArrayList<Integer> bekIndexes = new ArrayList<Integer>();
            for (int head : this.myGraphLayout.getHeadNodeIndex()) {
                bekIndexes.add(this.myBekIntMap.getBekIndex(head));
            }
            ArrayList<Integer> arrayList = bekIndexes;
            if (arrayList == null) {
                BekGraphLayout.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/linearBek/LinearBekController$BekGraphLayout", "getHeadNodeIndex"));
        }
    }
}

