/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.ui.ChangelistMoveOfferDialog;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.util.ui.ConfirmationDialog;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.LocalChangesCommitter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u0018H\u0014J\b\u0010\u001b\u001a\u00020\u0018H\u0014J\b\u0010\u001c\u001a\u00020\u0018H\u0002R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/vcs/commit/SingleChangeListCommitter;", "Lcom/intellij/vcs/commit/LocalChangesCommitter;", "project", "Lcom/intellij/openapi/project/Project;", "commitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "handlers", "", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "vcsToCommit", "Lcom/intellij/openapi/vcs/AbstractVcs;", "localHistoryActionName", "", "isDefaultChangeListFullyIncluded", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/commit/ChangeListCommitState;Lcom/intellij/openapi/vcs/changes/CommitContext;Ljava/util/List;Lcom/intellij/openapi/vcs/AbstractVcs;Ljava/lang/String;Z)V", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "getChangeList", "()Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "isSuccess", "afterRefreshChanges", "", "commit", "onFailure", "onSuccess", "updateChangeListAfterRefresh", "Companion", "intellij.platform.vcs.impl"})
public final class SingleChangeListCommitter
extends LocalChangesCommitter {
    private boolean isSuccess;
    private final ChangeListCommitState commitState;
    private final AbstractVcs<?> vcsToCommit;
    private final boolean isDefaultChangeListFullyIncluded;
    public static final Companion Companion = new Companion(null);

    private final LocalChangeList getChangeList() {
        return this.commitState.getChangeList();
    }

    @Override
    protected void commit() {
        if (this.vcsToCommit != null && this.getChanges().isEmpty()) {
            this.commit(this.vcsToCommit, this.getChanges());
        }
        super.commit();
    }

    @Override
    protected void onSuccess() {
        this.isSuccess = true;
    }

    @Override
    protected void onFailure() {
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ SingleChangeListCommitter this$0;

            public final void run() {
                ChangeListCommitState failedCommitState = new ChangeListCommitState(SingleChangeListCommitter.access$getChangeList$p(this.this$0), this.this$0.getFailedToCommitChanges(), this.this$0.getCommitMessage());
                Project project = this.this$0.getProject();
                String string = VcsBundle.message((String)"commit.dialog.failed.commit.template", (Object[])new Object[]{SingleChangeListCommitter.access$getChangeList$p(this.this$0).getName()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message(\"commit.dialog.f\u2026mplate\", changeList.name)");
                SingleChangeListCommitter.Companion.moveToFailedList(project, failedCommitState, string);
            }
            {
                this.this$0 = singleChangeListCommitter;
            }
        }, ModalityState.defaultModalityState(), this.getProject().getDisposed());
    }

    @Override
    protected void afterRefreshChanges() {
        if (this.isSuccess) {
            this.updateChangeListAfterRefresh();
        }
        super.afterRefreshChanges();
    }

    private final void updateChangeListAfterRefresh() {
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.getProject());
        String string = this.getChangeList().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"changeList.name");
        String listName = string;
        LocalChangeList localChangeList = changeListManager.findChangeList(listName);
        if (localChangeList == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"changeListManager.findCh\u2026eList(listName) ?: return");
        LocalChangeList localList = localChangeList;
        changeListManager.editChangeListData(listName, null);
        if (!localList.isDefault()) {
            changeListManager.scheduleAutomaticEmptyChangeListDeletion(localList);
        } else {
            ChangelistMoveOfferDialog dialog;
            Collection changes2 = localList.getChanges();
            if (this.getConfiguration().OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT && !changes2.isEmpty() && this.isDefaultChangeListFullyIncluded && (dialog = new ChangelistMoveOfferDialog(this.getConfiguration())).showAndGet()) {
                Project project = this.getProject();
                Collection collection = changes2;
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"changes");
                MoveChangesToAnotherListAction.Companion.askAndMove(project, collection, CollectionsKt.emptyList());
            }
        }
    }

    public SingleChangeListCommitter(@NotNull Project project, @NotNull ChangeListCommitState commitState, @NotNull CommitContext commitContext, @NotNull List<? extends CheckinHandler> handlers, @Nullable AbstractVcs<?> vcsToCommit, @NotNull String localHistoryActionName, boolean isDefaultChangeListFullyIncluded) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)commitState, (String)"commitState");
        Intrinsics.checkParameterIsNotNull((Object)commitContext, (String)"commitContext");
        Intrinsics.checkParameterIsNotNull(handlers, (String)"handlers");
        Intrinsics.checkParameterIsNotNull((Object)localHistoryActionName, (String)"localHistoryActionName");
        super(project, commitState.getChanges(), commitState.getCommitMessage(), commitContext, handlers, localHistoryActionName);
        this.commitState = commitState;
        this.vcsToCommit = vcsToCommit;
        this.isDefaultChangeListFullyIncluded = isDefaultChangeListFullyIncluded;
    }

    public static final /* synthetic */ LocalChangeList access$getChangeList$p(SingleChangeListCommitter $this) {
        return $this.getChangeList();
    }

    @JvmStatic
    public static final void moveToFailedList(@NotNull Project project, @NotNull ChangeListCommitState commitState, @NotNull String newChangeListName) {
        Companion.moveToFailedList(project, commitState, newChangeListName);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/commit/SingleChangeListCommitter$Companion;", "", "()V", "moveToFailedList", "", "project", "Lcom/intellij/openapi/project/Project;", "commitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "newChangeListName", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void moveToFailedList(@NotNull Project project, @NotNull ChangeListCommitState commitState, @NotNull String newChangeListName) {
            Change[] changeArray;
            void $this$toTypedArray$iv;
            VcsShowConfirmationOption option2;
            boolean result2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)commitState, (String)"commitState");
            Intrinsics.checkParameterIsNotNull((Object)newChangeListName, (String)"newChangeListName");
            List<Change> failedChanges = commitState.getChanges();
            Collection collection = commitState.getChangeList().getChanges();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"commitState.changeList.changes");
            if (failedChanges.containsAll(collection)) {
                return;
            }
            VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project);
            if (configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST != VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY && !(result2 = ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)(option2 = new VcsShowConfirmationOption(configuration){
                final /* synthetic */ VcsConfiguration $configuration;

                @NotNull
                public VcsShowConfirmationOption.Value getValue() {
                    VcsShowConfirmationOption.Value value = this.$configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST;
                    Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST");
                    return value;
                }

                public void setValue(@NotNull VcsShowConfirmationOption.Value value) {
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    this.$configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST = value;
                }

                public boolean isPersistent() {
                    return true;
                }
                {
                    this.$configuration = $captured_local_variable$0;
                }
            }), (Project)project, (String)VcsBundle.message((String)"commit.failed.confirm.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.failed.confirm.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()))) {
                return;
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
            ChangeListManager changeListManager2 = changeListManager;
            int index = 1;
            String failedListName = newChangeListName;
            while (changeListManager2.findChangeList(failedListName) != null) {
                failedListName = newChangeListName + " (" + ++index + ')';
            }
            LocalChangeList failedList = changeListManager2.addChangeList(failedListName, commitState.getCommitMessage());
            Collection collection2 = failedChanges;
            LocalChangeList localChangeList = failedList;
            ChangeListManager changeListManager3 = changeListManager2;
            boolean $i$f$toTypedArray = false;
            void v2 = $this$toTypedArray$iv;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v2;
            Change[] changeArray2 = thisCollection$iv.toArray(new Change[0]);
            if (changeArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Change[] changeArray3 = changeArray = changeArray2;
            changeListManager3.moveChangesTo(localChangeList, Arrays.copyOf(changeArray3, changeArray3.length));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

