/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class DefaultVcsRootChecker
extends VcsRootChecker {
    @NotNull
    private final AbstractVcs myVcs;
    private final VcsDescriptor myVcsDescriptor;

    public DefaultVcsRootChecker(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myVcsDescriptor = ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).getDescriptor(vcs.getName());
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = this.myVcs.getKeyInstanceMethod();
        if (vcsKey == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(1);
        }
        return vcsKey;
    }

    public boolean isRoot(@NotNull String path) {
        if (path == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(2);
        }
        if (this.myVcsDescriptor == null) {
            return false;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        if (file == null) {
            return false;
        }
        return this.myVcsDescriptor.probablyUnderVcs(file, false);
    }

    public boolean validateRoot(@NotNull String path) {
        if (path == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(3);
        }
        return true;
    }

    public boolean isVcsDir(@NotNull String dirName) {
        if (dirName == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(4);
        }
        if (this.myVcsDescriptor == null) {
            return false;
        }
        return this.myVcsDescriptor.matchesVcsDirPattern(dirName);
    }

    public boolean areChildrenValidMappings() {
        if (this.myVcsDescriptor == null) {
            return false;
        }
        return this.myVcsDescriptor.areChildrenValidMappings();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/DefaultVcsRootChecker";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/DefaultVcsRootChecker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVcsDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

