/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.execution.Executor;
import com.intellij.internal.statistic.eventLog.LogEventsKt;
import com.intellij.internal.statistic.eventLog.ShortcutDataProvider;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\f\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0010J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0011J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0012J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0018\u0010\u0013\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001fJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010!\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\u0005J\u001a\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010%\u001a\u00020\u0000H\u0007J\u0010\u0010&\u001a\u00020\u00002\b\u0010'\u001a\u0004\u0018\u00010\u0005J\u0010\u0010(\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010*J\u0010\u0010+\u001a\u00020\u00002\b\u0010,\u001a\u0004\u0018\u00010-J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0001J\u0010\u0010/\u001a\u00020\u00002\b\u00100\u001a\u0004\u0018\u000101J\u0010\u00102\u001a\u00020\u00002\b\u00100\u001a\u0004\u0018\u00010\u0005J\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000104J\u0006\u00105\u001a\u00020\u0000J\u0013\u00106\u001a\u00020\u000f2\b\u00107\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00108\u001a\u00020\u0005H\u0002J\b\u00109\u001a\u00020\bH\u0016J\u0010\u0010:\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0016\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005J\b\u0010>\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "", "()V", "data", "", "", "addCount", "count", "", "addCurrentFile", "language", "Lcom/intellij/lang/Language;", "addData", "key", "value", "", "", "", "", "addDataInternal", "addEnabled", "enabled", "addExecutor", "executor", "Lcom/intellij/execution/Executor;", "addFeatureContext", "context", "Lcom/intellij/internal/statistic/service/fus/collectors/FUSUsageContext;", "addInputEvent", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Ljava/awt/event/KeyEvent;", "Ljava/awt/event/MouseEvent;", "addLanguage", "id", "addLanguageInternal", "fieldName", "addOS", "addPlace", "place", "addPluginInfo", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "addProject", "project", "Lcom/intellij/openapi/project/Project;", "addValue", "addVersion", "version", "Lcom/intellij/openapi/util/Version;", "addVersionByString", "build", "", "copy", "equals", "other", "getOS", "hashCode", "isCommonPlace", "merge", "next", "prefix", "toString", "Companion", "intellij.platform.ide.impl"})
public final class FeatureUsageData {
    private Map<String, Object> data = new HashMap();
    @NotNull
    private static final List<String> platformDataKeys;
    public static final Companion Companion;

    @NotNull
    public final FeatureUsageData addFeatureContext(@Nullable FUSUsageContext context) {
        if (context != null) {
            Map<String, String> map2 = context.getData();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"context.data");
            this.data.putAll(map2);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addProject(@Nullable Project project) {
        if (project != null) {
            this.data.put("project", StatisticsUtilKt.getProjectId(project));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addVersionByString(@Nullable String version2) {
        if (version2 == null) {
            this.data.put("version", "unknown");
        } else {
            this.addVersion(Version.parseVersion((String)version2));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addVersion(@Nullable Version version2) {
        this.data.put("version", version2 != null ? "" + version2.major + '.' + version2.minor : "unknown.format");
        return this;
    }

    @Deprecated(message="Don't add OS to event data")
    @NotNull
    public final FeatureUsageData addOS() {
        this.data.put("os", this.getOS());
        return this;
    }

    private final String getOS() {
        if (SystemInfo.isWindows) {
            return "Windows";
        }
        if (SystemInfo.isMac) {
            return "Mac";
        }
        return SystemInfo.isLinux ? "Linux" : "Other";
    }

    @NotNull
    public final FeatureUsageData addPluginInfo(@Nullable PluginInfo info) {
        block0: {
            PluginInfo pluginInfo = info;
            if (pluginInfo == null) break block0;
            PluginInfo pluginInfo2 = pluginInfo;
            boolean bl = false;
            boolean bl2 = false;
            PluginInfo it = pluginInfo2;
            boolean bl3 = false;
            StatisticsUtilKt.addPluginInfoTo(info, this.data);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addLanguage(@Nullable String id) {
        block0: {
            String string = id;
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.addLanguage(Language.findLanguageByID((String)id));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addLanguage(@Nullable Language language) {
        return this.addLanguageInternal("lang", language);
    }

    @NotNull
    public final FeatureUsageData addCurrentFile(@Nullable Language language) {
        return this.addLanguageInternal("current_file", language);
    }

    private final FeatureUsageData addLanguageInternal(String fieldName, Language language) {
        block2: {
            Language language2 = language;
            if (language2 == null) break block2;
            Language language3 = language2;
            boolean bl = false;
            boolean bl2 = false;
            Language it = language3;
            boolean bl3 = false;
            PluginType type = StatisticsUtilKt.getPluginType(language.getClass());
            if (type.isSafeToReport()) {
                String string = language.getID();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"language.id");
                this.data.put(fieldName, string);
            } else {
                this.data.put(fieldName, "third.party");
            }
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull AnActionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String inputEvent = ShortcutDataProvider.getActionEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String inputEvent = ShortcutDataProvider.getKeyEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull MouseEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String inputEvent = ShortcutDataProvider.getMouseEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addPlace(@Nullable String place) {
        if (place == null) {
            return this;
        }
        String reported = "unknown";
        if (this.isCommonPlace(place)) {
            reported = place;
        } else if (ActionPlaces.isPopupPlace((String)place)) {
            reported = "popup";
        }
        this.data.put("place", reported);
        return this;
    }

    private final boolean isCommonPlace(String place) {
        return ActionPlaces.isCommonPlace((String)place) || Intrinsics.areEqual((Object)"ToolwindowPopup", (Object)place);
    }

    @NotNull
    public final FeatureUsageData addExecutor(@NotNull Executor executor) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        String string = executor.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"executor.id");
        return this.addData("executor", string);
    }

    @NotNull
    public final FeatureUsageData addValue(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return this.addDataInternal("value", value);
        }
        return this.addData("value", value.toString());
    }

    @NotNull
    public final FeatureUsageData addEnabled(boolean enabled) {
        return this.addData("enabled", enabled);
    }

    @NotNull
    public final FeatureUsageData addCount(int count) {
        return this.addData("count", count);
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, int value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, long value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, float value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.addDataInternal(key, Float.valueOf(value));
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, double value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.addDataInternal(key, value);
    }

    private final FeatureUsageData addDataInternal(String key, Object value) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode() || !platformDataKeys.contains(key)) {
            String escapedKey = LogEventsKt.escapeFieldName(key);
            this.data.put(escapedKey, value);
        }
        return this;
    }

    @NotNull
    public final Map<String, Object> build() {
        if (this.data.isEmpty()) {
            Map<String, Object> map2 = Collections.emptyMap();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.emptyMap()");
            return map2;
        }
        return this.data;
    }

    @NotNull
    public final FeatureUsageData merge(@NotNull FeatureUsageData next, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Map<String, Object> map2 = next.build();
        boolean bl = false;
        Iterator<Map.Entry<String, Object>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            String key = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value = entry2.getValue();
            String newKey = StringsKt.startsWith$default((String)key, (String)"data_", (boolean)false, (int)2, null) ? prefix + key : key;
            this.data.put(newKey, value);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData copy() {
        FeatureUsageData result2 = new FeatureUsageData();
        Map<String, Object> map2 = this.data;
        boolean bl = false;
        Iterator<Map.Entry<String, Object>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            String key = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value = entry2.getValue();
            result2.data.put(key, value);
        }
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.FeatureUsageData");
        }
        FeatureUsageData cfr_ignored_0 = (FeatureUsageData)object2;
        return !(Intrinsics.areEqual(this.data, ((FeatureUsageData)other).data) ^ true);
    }

    public int hashCode() {
        return ((Object)this.data).hashCode();
    }

    @NotNull
    public String toString() {
        return this.data.toString();
    }

    static {
        Companion = new Companion(null);
        List<String> list2 = Arrays.asList("plugin", "project", "os", "plugin_type", "lang", "current_file", "input_event", "place");
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(\n      \"pl\u2026put_event\", \"place\"\n    )");
        platformDataKeys = list2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageData$Companion;", "", "()V", "platformDataKeys", "", "", "getPlatformDataKeys", "()Ljava/util/List;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final List<String> getPlatformDataKeys() {
            return platformDataKeys;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

